/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.EcoreBuilder;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.util.DefaultEcoreBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLProcessor {
    protected EcoreBuilder ecoreBuilder;
    protected static final String XML_EXTENSION = "xml";
    protected static final String STAR_EXTENSION = "*";
    protected static final URI XML_URI = URI.createFileURI((String)"xml");
    protected Map registrations;
    protected Map loadOptions = new HashMap();
    protected Map saveOptions = new HashMap();
    protected ExtendedMetaData extendedMetaData;
    protected EPackage.Registry registry;

    protected XMLProcessor(EPackage.Registry registry) {
        this.registry = registry;
        this.extendedMetaData = this.createExtendedMetaData();
        this.ecoreBuilder = this.createEcoreBuilder();
        this.loadOptions.put("EXTENDED_META_DATA", this.extendedMetaData);
        this.loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl(true));
        this.loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        this.loadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        this.loadOptions.put("CONFIGURATION_CACHE", Boolean.TRUE);
        this.saveOptions.put("EXTENDED_META_DATA", this.extendedMetaData);
        this.saveOptions.put("USE_CACHED_LOOKUP_TABLE", new ArrayList());
        this.saveOptions.put("CONFIGURATION_CACHE", Boolean.TRUE);
    }

    public XMLProcessor() {
        this.extendedMetaData = this.createExtendedMetaData();
        this.ecoreBuilder = this.createEcoreBuilder();
        this.loadOptions.put("EXTENDED_META_DATA", this.extendedMetaData);
        this.loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl(true));
        this.loadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        this.loadOptions.put("CONFIGURATION_CACHE", Boolean.TRUE);
        this.saveOptions.put("EXTENDED_META_DATA", this.extendedMetaData);
        this.saveOptions.put("CONFIGURATION_CACHE", Boolean.TRUE);
    }

    public XMLProcessor(URI schemaURI) throws SAXException {
        this(Collections.singleton(schemaURI));
    }

    public XMLProcessor(Collection schemaURIs) throws SAXException {
        this((EPackage.Registry)new EPackageRegistryImpl());
        this.loadOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        this.loadOptions.put("USE_LEXICAL_HANDLER", Boolean.TRUE);
        this.saveOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        this.saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        try {
            Collection result = this.ecoreBuilder.generate(schemaURIs);
            Iterator i = result.iterator();
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                Iterator j = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)EcorePackage.eINSTANCE.getEPackage()).iterator();
                while (j.hasNext()) {
                    EcoreUtil.freeze((EPackage)((EPackage)j.next()));
                }
            }
        }
        catch (InvocationTargetException ie) {
            throw new SAXException((Exception)ie.getTargetException());
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    protected Map getRegistrations() {
        if (this.registrations == null) {
            HashMap<String, XMLResourceFactoryImpl> result = new HashMap<String, XMLResourceFactoryImpl>();
            result.put(STAR_EXTENSION, new XMLResourceFactoryImpl());
            this.registrations = result;
        }
        return this.registrations;
    }

    public EPackage.Registry getEPackageRegistry() {
        return this.registry;
    }

    public ExtendedMetaData getExtendedMetaData() {
        return this.extendedMetaData;
    }

    public Resource load(String systemId, Map options) throws IOException {
        ResourceSet resourceSet = this.createResourceSet();
        XMLResource resource = (XMLResource)resourceSet.createResource(URI.createURI((String)systemId));
        InputSource inputSource = new InputSource();
        inputSource.setSystemId(systemId);
        if (options != null) {
            HashMap mergedOptions = new HashMap(this.loadOptions);
            mergedOptions.putAll(options);
            resource.load(inputSource, mergedOptions);
        } else {
            resource.load(inputSource, this.loadOptions);
        }
        resourceSet.getPackageRegistry().putAll((Map)this.registry);
        return resource;
    }

    public Resource load(InputStream is, Map options) throws IOException {
        ResourceSet resourceSet = this.createResourceSet();
        Resource resource = resourceSet.createResource(XML_URI);
        if (options != null) {
            HashMap mergedOptions = new HashMap(this.loadOptions);
            mergedOptions.putAll(options);
            resource.load(is, mergedOptions);
        } else {
            resource.load(is, this.loadOptions);
        }
        resourceSet.getPackageRegistry().putAll((Map)this.registry);
        return resource;
    }

    public Resource load(InputSource inputSource, Map options) throws IOException {
        ResourceSet resourceSet = this.createResourceSet();
        XMLResource resource = (XMLResource)resourceSet.createResource(XML_URI);
        if (options != null) {
            HashMap mergedOptions = new HashMap(this.loadOptions);
            mergedOptions.putAll(options);
            resource.load(inputSource, mergedOptions);
        } else {
            resource.load(inputSource, this.loadOptions);
        }
        resourceSet.getPackageRegistry().putAll((Map)this.registry);
        return resource;
    }

    public Resource load(Node node, Map options) throws IOException {
        ResourceSet resourceSet = this.createResourceSet();
        XMLResource resource = (XMLResource)resourceSet.createResource(XML_URI);
        if (options != null) {
            HashMap mergedOptions = new HashMap(this.loadOptions);
            mergedOptions.putAll(options);
            resource.load(node, mergedOptions);
        } else {
            resource.load(node, this.loadOptions);
        }
        resourceSet.getPackageRegistry().putAll((Map)this.registry);
        return resource;
    }

    public void save(OutputStream outputStream, Resource resource, Map options) throws IOException {
        if (options != null) {
            HashMap mergedOptions = new HashMap(this.saveOptions);
            mergedOptions.putAll(options);
            resource.save(outputStream, mergedOptions);
        } else {
            resource.save(outputStream, this.saveOptions);
        }
    }

    public void save(Writer writer, Resource resource, Map options) throws IOException {
        if (options != null) {
            HashMap mergedOptions = new HashMap(this.saveOptions);
            mergedOptions.putAll(options);
            ((XMLResource)resource).save(writer, mergedOptions);
        } else {
            ((XMLResource)resource).save(writer, this.saveOptions);
        }
    }

    public void save(Document document, Resource resource, DOMHandler handler, Map options) throws IOException {
        if (options != null) {
            HashMap mergedOptions = new HashMap(this.saveOptions);
            mergedOptions.putAll(options);
            ((XMLResource)resource).save(document, mergedOptions, handler);
        } else {
            ((XMLResource)resource).save(document, this.saveOptions, handler);
        }
    }

    public String saveToString(Resource resource, Map options) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (options != null) {
            HashMap mergedOptions = new HashMap(this.saveOptions);
            mergedOptions.putAll(options);
            ((XMLResource)resource).save(os, mergedOptions);
        } else {
            ((XMLResource)resource).save(os, this.saveOptions);
        }
        return os.toString();
    }

    protected ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().putAll(this.getRegistrations());
        return resourceSet;
    }

    protected EcoreBuilder createEcoreBuilder() {
        return new DefaultEcoreBuilder(this.extendedMetaData);
    }

    protected ExtendedMetaData createExtendedMetaData() {
        if (this.registry == null) {
            this.registry = new EPackageRegistryImpl();
        }
        return new BasicExtendedMetaData(this.registry);
    }
}

