/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.operations.NamedElementOperations;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class TypeOperations
extends NamedElementOperations {
    protected TypeOperations() {
    }

    protected static void validateTypeAndBounds(Type type, int lower, int upper) {
        if (type == null) {
            throw new IllegalArgumentException(String.valueOf(type));
        }
        if (lower < 0) {
            throw new IllegalArgumentException(String.valueOf(lower));
        }
        if (upper != -1 && (upper == 0 || upper < lower)) {
            throw new IllegalArgumentException(String.valueOf(upper));
        }
    }

    protected static Property createOwnedProperty(Type type, final String name, final Type propertyType, int lower, int upper) {
        Property ownedProperty = (Property)new UMLSwitch(){

            public Object caseArtifact(Artifact artifact) {
                return artifact.createOwnedAttribute(name, propertyType);
            }

            public Object caseAssociation(Association association) {
                return association.createOwnedEnd(name, propertyType);
            }

            public Object caseAssociationClass(AssociationClass associationClass) {
                return associationClass.createOwnedAttribute(name, propertyType);
            }

            public Object caseDataType(DataType dataType) {
                return dataType.createOwnedAttribute(name, propertyType);
            }

            public Object caseInterface(Interface interface_) {
                return interface_.createOwnedAttribute(name, propertyType);
            }

            public Object caseSignal(Signal signal) {
                return signal.createOwnedAttribute(name, propertyType);
            }

            public Object caseStructuredClassifier(StructuredClassifier structuredClassifier) {
                return structuredClassifier.createOwnedAttribute(name, propertyType);
            }
        }.doSwitch((EObject)type);
        ownedProperty.setLower(lower);
        ownedProperty.setUpper(upper);
        return ownedProperty;
    }

    public static Property createOwnedAttribute(Type type, String name, Type attributeType, int lower, int upper) {
        if (TypeOperations.getOwnedAttributes(type) == null) {
            throw new UnsupportedOperationException();
        }
        if (TypeOperations.isEmpty((String)name)) {
            throw new IllegalArgumentException(String.valueOf(name));
        }
        TypeOperations.validateTypeAndBounds(attributeType, lower, upper);
        return TypeOperations.createOwnedProperty(type, name, attributeType, lower, upper);
    }

    protected static Property createAssociationEnd(Type type, Association association, boolean isNavigable, AggregationKind aggregation, String name, int lower, int upper, Type endType) {
        EList ownedAttributes = TypeOperations.getOwnedAttributes(type);
        Property associationEnd = TypeOperations.createOwnedProperty(ownedAttributes == null || !isNavigable ? association : type, name, endType, lower, upper);
        associationEnd.setAggregation(aggregation);
        if (isNavigable) {
            if (ownedAttributes == null) {
                association.getNavigableOwnedEnds().add((Object)associationEnd);
            } else {
                association.getMemberEnds().add((Object)associationEnd);
            }
        }
        return associationEnd;
    }

    public static Association createAssociation(Type type, boolean end1IsNavigable, AggregationKind end1Aggregation, String end1Name, int end1Lower, int end1Upper, Type end1Type, boolean end2IsNavigable, AggregationKind end2Aggregation, String end2Name, int end2Lower, int end2Upper) {
        TypeOperations.validateTypeAndBounds(end1Type, end1Lower, end1Upper);
        TypeOperations.validateTypeAndBounds(type, end2Lower, end2Upper);
        Package package_ = type.getNearestPackage();
        if (package_ == null) {
            throw new IllegalStateException();
        }
        if (end1Aggregation == null) {
            throw new IllegalArgumentException(String.valueOf((Object)end1Aggregation));
        }
        if (end2Aggregation == null) {
            throw new IllegalArgumentException(String.valueOf((Object)end2Aggregation));
        }
        Association association = (Association)package_.createOwnedType(null, UMLPackage.Literals.ASSOCIATION);
        TypeOperations.createAssociationEnd(type, association, end1IsNavigable, end1Aggregation, end1Name, end1Lower, end1Upper, end1Type);
        TypeOperations.createAssociationEnd(end1Type, association, end2IsNavigable, end2Aggregation, end2Name, end2Lower, end2Upper, type);
        return association;
    }

    public static EList getAssociations(Type type) {
        UniqueEList.FastCompare associations = new UniqueEList.FastCompare();
        Iterator nonNavigableInverseReferences = TypeOperations.getNonNavigableInverseReferences((EObject)type).iterator();
        while (nonNavigableInverseReferences.hasNext()) {
            Association association;
            EObject eObject;
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)nonNavigableInverseReferences.next();
            if (setting.getEStructuralFeature() != UMLPackage.Literals.TYPED_ELEMENT__TYPE || !((eObject = setting.getEObject()) instanceof Property) || (association = ((Property)eObject).getAssociation()) == null) continue;
            associations.add((Object)association);
        }
        return ECollections.unmodifiableEList((EList)associations);
    }

    public static Operation createOwnedOperation(Type type, final String name, final EList parameterNames, final EList parameterTypes, Type returnType) {
        if (TypeOperations.getOwnedOperations(type) == null) {
            throw new UnsupportedOperationException();
        }
        Operation ownedOperation = (Operation)new UMLSwitch(){

            public Object caseArtifact(Artifact artifact) {
                return artifact.createOwnedOperation(name, parameterNames, parameterTypes);
            }

            public Object caseClass(Class class_) {
                return class_.createOwnedOperation(name, parameterNames, parameterTypes);
            }

            public Object caseDataType(DataType dataType) {
                return dataType.createOwnedOperation(name, parameterNames, parameterTypes);
            }

            public Object caseInterface(Interface interface_) {
                return interface_.createOwnedOperation(name, parameterNames, parameterTypes);
            }
        }.doSwitch((EObject)type);
        if (returnType != null) {
            ownedOperation.createReturnResult(null, returnType);
        }
        return ownedOperation;
    }

    public static boolean conformsTo(Type type, Type other) {
        return false;
    }
}

