/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.stringutils;

import java.util.ArrayList;
import java.util.Iterator;
import musd.compiler.stringutils.MUSDAspectStringGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinatorStringGen {
    public static String generateDeclaration(String coordinatoImplClass) {
        StringBuffer str = new StringBuffer(100);
        str.append("import ").append("musd.runtime.lib");
        str.append(".*;\n\n\n").append("public aspect ").append("MUSDCoordinatorAspect");
        str.append("\n{\n\tdeclare precedence: ").append("MUSDCoordinatorAspect").append(", *;\n\t");
        str.append("ICoordinatorStrategy").append(" ").append("strategy").append(" = new ");
        str.append(coordinatoImplClass).append("();\n\n");
        str.append("\tprivate boolean inAfter = false;\n\tprivate boolean fromAfter = false;\n\n");
        return str.toString();
    }

    public static String generateCoordinatorPointCutDecleration() {
        return "\tpointcut MUSDMessage():";
    }

    public static String generateWrapper(String thisType, String targetType, String methodName, ArrayList<String> argsNames, ArrayList<String> argsTypes, String returnType) {
        StringBuffer str = new StringBuffer(100);
        if (returnType == null || returnType == "") {
            returnType = "void";
        }
        str.append(CoordinatorStringGen.generateWrapperOppenning(thisType, targetType, methodName, argsNames, argsTypes, returnType));
        if (!returnType.equals("void")) {
            str.append("return ");
        }
        str.append(MUSDAspectStringGen.toSmall(targetType)).append(".").append(methodName);
        str.append("(");
        str.append(CoordinatorStringGen.generateWrapperClosing(argsNames));
        return str.toString();
    }

    public static String generateConstructorWrapper(String thisType, String targetType, String methodName, ArrayList<String> argsNames, ArrayList<String> argsTypes) {
        StringBuffer str = new StringBuffer(100);
        str.append(CoordinatorStringGen.generateWrapperOppenning(thisType, targetType, methodName, argsNames, argsTypes, "void"));
        str.append(MUSDAspectStringGen.toSmall("new")).append(" ");
        str.append(targetType).append("(");
        str.append(CoordinatorStringGen.generateWrapperClosing(argsNames));
        return str.toString();
    }

    private static String generateWrapperOppenning(String thisType, String targetType, String methodName, ArrayList<String> argsNames, ArrayList<String> argsTypes, String returnType) {
        StringBuffer str = new StringBuffer(100);
        str.append("\tpublic ").append(returnType).append(" ");
        if (!thisType.equals("env")) {
            str.append(thisType).append(".");
        }
        str.append("Wrapper").append(methodName);
        str.append("(").append(targetType).append(" ").append(MUSDAspectStringGen.toSmall(targetType));
        Iterator<String> it = argsNames.iterator();
        Iterator<String> itType = argsTypes.iterator();
        while (it.hasNext()) {
            str.append(",").append(itType.next());
            str.append(" ").append(it.next());
        }
        str.append(")\n\t{\n\t\t");
        return str.toString();
    }

    private static String generateWrapperClosing(ArrayList<String> argsNames) {
        StringBuffer str = new StringBuffer(50);
        Iterator<String> it = argsNames.iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (!first) {
                str.append(",");
            }
            first = false;
            str.append(it.next());
        }
        str.append(");\n\t}\n\n");
        return str.toString();
    }

    public static String generateCoordinatorAfter() {
        StringBuffer str = new StringBuffer(80);
        str.append("\tafter (): ").append("MUSDMessage").append("()\n\t{\n");
        str.append("\t\tMUSDAspect.handlingEvent(thisJoinPoint);\n");
        str.append("\t\tif (!fromAfter) {\n\t\t\tfromAfter = true;\n\t\t\tafterImpl();\n\t\t\tfromAfter = false;\n\t\t}\n\t}\n\n\n");
        str.append("\tvoid afterImpl() \n\t{\n\t\tif (inAfter)\n\t\t\tinAfter = false;\n\t\telse inAfter = true;\n\n");
        str.append(CoordinatorStringGen.getMethodSetInit("monitoringEnabled"));
        str.append(CoordinatorStringGen.getMethodSetInit("executingEnabled"));
        str.append(CoordinatorStringGen.getMethodSetInit("coldViolation"));
        str.append(CoordinatorStringGen.getMethodSetInit("hotViolation"));
        str.append("\n");
        return str.toString();
    }

    public static String generateCoordinatorGetCutState(String aspectName) {
        StringBuffer str = new StringBuffer(80);
        str.append("\t\t").append(aspectName).append(".aspectOf().getCutState");
        str.append(CoordinatorStringGen.getMethodSets()).append(";\n");
        return str.toString();
    }

    public static String generateCoordinatorAfterSwitch() {
        StringBuffer str = new StringBuffer(50);
        str.append("\n\t\t").append("MUSDMethod").append(" ").append("MUSDm");
        str.append(" = ").append("strategy").append(".").append("chooseMethod");
        str.append(CoordinatorStringGen.getMethodSets()).append(";\n\n").append("\t\tif(").append("MUSDm");
        str.append(" != null)\n\t\t{\n\t\t\tswitch (").append("MUSDm").append(".");
        str.append("messageID").append(")\n\t\t\t{\n");
        return str.toString();
    }

    public static String generateCoordinatorCase(String thisType, String targetType, String methodName, ArrayList<String> argsType) {
        StringBuffer str = new StringBuffer(100);
        String methodConst = MUSDAspectStringGen.createMethodConstant(thisType, targetType, methodName);
        str.append("\t\t\t\tcase ").append(methodConst).append(":\n");
        str.append("\t\t\t\t ");
        if (!thisType.equals("env")) {
            str.append("((").append(MUSDAspectStringGen.upgradePrimitiveTypes(thisType));
            str.append(")").append("MUSDm");
            str.append(".").append("sourceInstance").append(").");
        }
        str.append("Wrapper").append(methodName);
        str.append("(\n\t\t\t\t\t(").append(MUSDAspectStringGen.upgradePrimitiveTypes(targetType)).append(")");
        str.append("MUSDm").append(".").append("targetInstance");
        Iterator<String> it = argsType.iterator();
        int i = 0;
        while (it.hasNext()) {
            str.append("\n\t\t\t\t\t");
            str.append(",(").append(MUSDAspectStringGen.upgradePrimitiveTypes(it.next())).append(")");
            str.append("MUSDm").append(".").append("args.get(");
            str.append(i).append(")");
            ++i;
        }
        str.append(");\n\t\t\t\tbreak;\n");
        return str.toString();
    }

    public static String generateCoordinatorCloser() {
        return "\t\t\t}\n\t\t}\n\t\tif (inAfter)\n\t\t{\n\t\t\tthis.fromAfter = false;\n\t\t\tafterImpl();\n\t\t}\n\t}\n}\n";
    }

    private static String getMethodSetInit(String kind) {
        StringBuffer str = new StringBuffer(80);
        str.append("\t\t").append("MUSDMethodSet").append(" ");
        str.append(kind).append(" = new ");
        str.append("MUSDMethodSet").append("();\n");
        return str.toString();
    }

    private static String getMethodSets() {
        StringBuffer str = new StringBuffer(80);
        str.append("(");
        str.append("monitoringEnabled").append(", ");
        str.append("executingEnabled").append(", ");
        str.append("coldViolation").append(", ");
        str.append("hotViolation").append(")");
        return str.toString();
    }
}

