/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.stringutils;

import java.util.ArrayList;
import java.util.Iterator;
import musd.compiler.lib.MUSDMessage;
import musd.compiler.stringutils.ChangeCutStringGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUSDAspectStringGen {
    public static String generateAspectLicenceWarnning(String interactionName) {
        String fileName = "MUSDAspect" + interactionName + ".aj";
        return "//  The file " + fileName + " was automatically generated using S2A 0.2 beta.\n//\t Usage of the generated code is permitted for non-commercial research and evaluation purposes..\n//\t Removing or changing the above comment is prohibited by S2A 0.2 beta license agreement.\n//\t For information see http://www.wisdom.weizmann.ac.il/~maozs/s2a/\n\n";
    }

    public static String generateCoordinatorLicenceWarnning() {
        String fileName = "MUSDCoordinatorAspect.aj";
        return "//  The file " + fileName + " was automatically generated using S2A 0.2 beta.\n//\t Usage of the generated code is permitted for non-commercial research and evaluation purposes..\n//\t Removing or changing the above comment is prohibited by S2A 0.2 beta license agreement.\n//\t For information see http://www.wisdom.weizmann.ac.il/~maozs/s2a/\n\n";
    }

    public static String generateMethodsLicenceWarnning() {
        String fileName = "MUSDMethods.java";
        return "//  The file " + fileName + " was automatically generated using S2A 0.2 beta.\n//\t Usage of the generated code is permitted for non-commercial research and evaluation purposes..\n//\t Removing or changing the above comment is prohibited by S2A 0.2 beta license agreement.\n//\t For information see http://www.wisdom.weizmann.ac.il/~maozs/s2a/\n\n";
    }

    public static String generatePackageDeclaration(String pack) {
        return "package " + pack + ";\n\n";
    }

    public static String generateImport(String imp) {
        return "import " + imp + ";\n";
    }

    public static String generateCommonImports() {
        return new String("import java.util.ArrayList;\nimport musd.runtime.lib.*;\n\n\n");
    }

    public static String generateAspectName(String interactionName) {
        return "public aspect MUSDAspect" + interactionName + " extends " + "MUSDAspect" + "\n{\n";
    }

    public static String generateOBjectInstanceConstant(String ClassName, String instanceName, int constant) {
        return "\tstatic final int " + ClassName + "_INST_" + instanceName + " = " + constant + ";\n";
    }

    public static String getConstantsRemark() {
        return "\t//Constants for instances, locations and varaibles\n";
    }

    public static String generateStaticInit(String instName, String type) {
        StringBuffer str = new StringBuffer(80);
        String objType = "MUSDEnv.getLifeLineInstance(\"" + type + "\")";
        str.append("\t\t").append(ChangeCutStringGen.getInstanceSetter(instName, objType)).append(";\n");
        return str.toString();
    }

    public static String generateExactVarsInit(String name, String value, String type) {
        StringBuffer str = new StringBuffer(80);
        String cons = MUSDAspectStringGen.generateVariableConstant(name, type);
        str.append("\t\t").append(MUSDAspectStringGen.getVarSetter(cons, value)).append(";\n");
        return str.toString();
    }

    public static String generateVariableConstantInit(String name, String type, int cons) {
        return "\tstatic final int " + MUSDAspectStringGen.generateVariableConstant(name, type) + " = " + cons + ";\n";
    }

    public static String generateVariableConstant(String name, String type) {
        return String.valueOf(type) + "_" + "arg" + "_" + name;
    }

    public static String getConstructorDecleration(String interactionName) {
        return "\tMUSDAspect" + interactionName + "()\n\t{\n";
    }

    public static String addMinimalEvent(String sender, String reciever, String methodName) {
        return "\t\taddMinimalEvent(" + MUSDAspectStringGen.createMethodConstant(sender, reciever, methodName) + ");\n";
    }

    public static String generateAddLoop(int limit) {
        return "\t\taddConstantLoop(" + limit + ");\n";
    }

    public static String generateHotCutSetter(ArrayList<String> cut) {
        StringBuffer str = new StringBuffer();
        str.append("\t\t").append("setHotCut(");
        Iterator<String> it = cut.iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            if (!isFirst) {
                str.append(",");
            }
            isFirst = false;
            str.append(it.next());
        }
        return str.append(");\n").toString();
    }

    public static String generateLastCutSetter(ArrayList<String> cut) {
        StringBuffer str = new StringBuffer();
        str.append("\t\t").append("setLastCut(");
        Iterator<String> it = cut.iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            if (!isFirst) {
                str.append(",");
            }
            isFirst = false;
            str.append(it.next());
        }
        return str.append(");\n").toString();
    }

    public static String createMethodConstant(String sender, String reciever, String methodName) {
        return "MUSDMethods." + sender + "_" + reciever + "_" + methodName;
    }

    public static String generatePointCutsRemark() {
        return "\t//Pointcuts and advices:\n";
    }

    public static String generateNumbersInit(int numberOfLifeLines, int numOfInst, int numOfVars) {
        StringBuffer str = new StringBuffer(20);
        str.append("\t\t").append("numberOfLifeLines").append(" = ").append(numberOfLifeLines);
        str.append(";\n\t\t").append("numberOfInstances").append(" = ").append(numOfInst);
        str.append(";\n\t\t").append("numberOfVariables").append(" = ").append(numOfVars).append(";\n");
        return str.toString();
    }

    public static String generatePointCut(String methodName, String targetType, String thisType, String pointCutCore, ArrayList<String> argsTypes, ArrayList<String> argsNames) {
        StringBuffer sb = new StringBuffer(300);
        StringBuffer argsBuffer = new StringBuffer(40);
        sb.append("\tpointcut ").append(thisType).append("_").append(targetType).append("_");
        sb.append(methodName).append("(");
        if (!(thisType.equals("env") || thisType.equals(targetType) || thisType.equals("User"))) {
            sb.append(thisType).append(" ").append(MUSDAspectStringGen.toSmall(thisType)).append(", ");
        }
        sb.append(targetType).append(" ").append(MUSDAspectStringGen.toSmall(targetType));
        if (argsTypes != null) {
            Iterator<String> itTypes = argsTypes.iterator();
            Iterator<String> itNames = argsNames.iterator();
            boolean first = true;
            while (itTypes.hasNext()) {
                String name = itNames.next();
                sb.append(",").append(MUSDAspectStringGen.treatPrimitive(itTypes.next())).append(" ").append(name);
                if (first) {
                    argsBuffer.append(" && args(");
                } else {
                    argsBuffer.append(",");
                }
                argsBuffer.append(name);
                first = false;
            }
            if (!first) {
                argsBuffer.append(")");
            }
        }
        sb.append("):\n\t\t").append(pointCutCore).append("\n\t\t&&").append(" target(").append(MUSDAspectStringGen.toSmall(targetType));
        if (!(thisType.equals("env") || thisType.equals("User") || thisType.equals(targetType))) {
            sb.append(") && this(").append(MUSDAspectStringGen.toSmall(thisType));
        }
        sb.append(") ").append(argsBuffer).append(";\n\n");
        return sb.toString();
    }

    public static String generateConstructorPointCut(String methodName, String thisType, String pointCutCore) {
        StringBuffer sb = new StringBuffer(300);
        StringBuffer argsBuffer = new StringBuffer(40);
        sb.append("\tpointcut ").append(thisType).append("_").append("env").append("_");
        sb.append(methodName).append("(");
        sb.append(thisType).append(" ").append(MUSDAspectStringGen.toSmall(thisType));
        sb.append("):\n\t\t").append(pointCutCore).append("\n\t\t&&");
        sb.append("this(").append(MUSDAspectStringGen.toSmall(thisType));
        sb.append(") ").append(argsBuffer).append(";\n\n");
        return sb.toString();
    }

    private static String treatPrimitive(String type) {
        if (type.equals("int")) {
            return "Object";
        }
        return type;
    }

    public static String generatePointCutCore(String methodName, String returnType, String targetType, int exeOrCall) {
        StringBuffer sb = new StringBuffer(40);
        String exCall = exeOrCall == 0 ? "call" : "execution";
        sb.append(exCall).append("(").append(returnType).append(" ").append(targetType).append(".").append(methodName).append("(..))");
        return sb.toString();
    }

    public static String generatePointCutCore(String targetType, int exeOrCall) {
        StringBuffer sb = new StringBuffer(40);
        String exCall = exeOrCall == 0 ? "call" : "execution";
        sb.append(exCall).append("(").append(targetType).append(".").append("new").append("(..))");
        return sb.toString();
    }

    public static String generateAdvice(String callerType, String targetType, String methodName, ArrayList<String> argsTypes, ArrayList<String> argsNames, boolean isConstructor) {
        String curCallerType = callerType;
        if (isConstructor) {
            curCallerType = "env";
        }
        String vars = argsTypes == null ? "null" : "args";
        StringBuffer sb = new StringBuffer(300);
        StringBuffer argsBuffer = new StringBuffer(30);
        sb.append("\tafter(");
        if (!(curCallerType.equals("env") || curCallerType.equals(targetType) || curCallerType.equals("User"))) {
            sb.append(curCallerType).append(" ").append(MUSDAspectStringGen.toSmall(curCallerType)).append(",");
        }
        sb.append(targetType).append(" ").append(MUSDAspectStringGen.toSmall(targetType));
        if (argsTypes != null) {
            Iterator<String> itTypes = argsTypes.iterator();
            Iterator<String> itNames = argsNames.iterator();
            while (itTypes.hasNext()) {
                String name = itNames.next();
                sb.append(",").append(MUSDAspectStringGen.treatPrimitive(itTypes.next())).append(" ").append(name);
                argsBuffer.append(", ").append(name);
            }
        }
        sb.append("):");
        sb.append(curCallerType).append("_").append(targetType).append("_").append(methodName).append("(");
        if (!(curCallerType.equals("env") || curCallerType.equals(targetType) || curCallerType.equals("User"))) {
            sb.append(MUSDAspectStringGen.toSmall(curCallerType)).append(",");
        }
        sb.append(MUSDAspectStringGen.toSmall(targetType)).append(argsBuffer).append(")\n\t{\n");
        if (argsTypes != null && argsTypes.size() > 0) {
            sb.append(MUSDAspectStringGen.generateMethodArgsInit()).append(MUSDAspectStringGen.getArgsInit(argsNames));
        }
        sb.append("\t\tchangeCutState(");
        sb.append(MUSDAspectStringGen.createMethodConstant(callerType, targetType, methodName)).append(",\n\t\t\t\t");
        if (curCallerType.equals("env") || curCallerType.equals("User")) {
            sb.append("null,");
        } else {
            sb.append(MUSDAspectStringGen.toSmall(curCallerType)).append(",");
        }
        sb.append(MUSDAspectStringGen.toSmall(targetType)).append(",").append(vars).append(");\n\t}\n\n");
        return sb.toString();
    }

    public static String getArgsInit(ArrayList<String> args) {
        if (args == null || args.size() == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        boolean first = true;
        for (String argName : args) {
            if (!first) {
                str.append(",");
            }
            str.append(argName);
            first = false;
        }
        str.append(");\n");
        return str.toString();
    }

    public static String generateMethodArgsInit(int number) {
        return "\t\tArrayList<Object>  args" + number + " = " + "getArgsList(";
    }

    public static String generateMethodArgsInit() {
        return "\t\tArrayList<Object> args = getArgsList(";
    }

    public static String generateConstructorAdvice(String callerType, String targetType, String methodName) {
        StringBuffer sb = new StringBuffer(300);
        sb.append("\tafter(");
        sb.append(callerType).append(" ").append(MUSDAspectStringGen.toSmall(callerType));
        sb.append("):");
        sb.append(callerType).append("_").append("env").append("_").append(methodName).append("(");
        sb.append(MUSDAspectStringGen.toSmall(callerType)).append(")\n\t{\n");
        sb.append("\t\t").append("changeCutStateConstructor(");
        sb.append(MUSDAspectStringGen.createMethodConstant(callerType, targetType, methodName)).append(",\n\t\t\t\t");
        sb.append(MUSDAspectStringGen.toSmall(callerType)).append(",");
        sb.append("null").append(",").append("null").append(");\n\t}\n\n");
        return sb.toString();
    }

    public static String generateChangeCutStateConstants(String staticInit) {
        StringBuffer str = new StringBuffer(300);
        str.append("\t// MSD Logic:\n");
        str.append("\tprotected void  changeActiveMSDCutState(int ").append("MUSDm");
        str.append(", Object ").append("sourceObject").append(", Object ");
        str.append("targetObject").append(",").append("ActiveMUSDAspect");
        str.append(" ").append("activeMUSD").append(",\n");
        str.append("\t\tArrayList args)\n").append("\t{\n").append(staticInit);
        str.append("\n\t\tboolean unification=false;");
        str.append("\n\t\tswitch (").append("MUSDm").append(")\n\t\t{\n");
        return str.toString();
    }

    public static String generateCaseForCahngeCutState(String sender, String reciever, String methodName) {
        StringBuffer str = new StringBuffer(80);
        str.append("\t\t\tcase ").append(MUSDAspectStringGen.createMethodConstant(sender, reciever, methodName)).append(":\n");
        return str.toString();
    }

    public static String toSmall(String s) {
        String s1 = s.substring(0, 1);
        return String.valueOf(s1.toLowerCase()) + s.substring(1);
    }

    public static String generateVarsEquals(String name, String type, int index) {
        StringBuffer str = new StringBuffer(80);
        String constant = MUSDAspectStringGen.generateVariableConstant(name, type);
        str.append("\n\t\t\t\t\t&& ").append("activeMUSD").append(".");
        str.append("variableEquals").append("(").append(constant).append(",");
        str.append("args.get(").append(index).append("))");
        return str.toString();
    }

    public static String generateVarsSetter(String name, String type, int index) {
        StringBuffer str = new StringBuffer(80);
        String constant = MUSDAspectStringGen.generateVariableConstant(name, type);
        str.append("\t\t\t\t\t").append("activeMUSD").append(".");
        str.append("setPrivateVariable").append("(").append(constant).append(",");
        str.append("args.get(").append(index).append("));\n");
        return str.toString();
    }

    private static String getVarSetter(String constant, String obj) {
        return "activeMUSD.setPrivateVariable(" + constant + "," + obj + ")";
    }

    public static String generateGetCutStateConst() {
        StringBuffer str = new StringBuffer(100);
        str.append("\tprotected void ").append("getActiveMUSDCutState(").append("MUSDMethodSet");
        str.append(" ME,").append("MUSDMethodSet").append(" EE,\n\t\t\t").append("MUSDMethodSet");
        str.append(" CV,").append("MUSDMethodSet").append(" HV,");
        str.append("ActiveMUSDAspect").append(" ").append("activeMUSD").append(")\n\t{\n");
        return str.toString();
    }

    public static String generateInstDecleration(String type, String name, String constant) {
        StringBuffer str = new StringBuffer(80);
        str.append("\t\t").append(type).append(" ").append(name).append(" = (").append(type);
        str.append(")").append(ChangeCutStringGen.getInstanceGetter(constant)).append(";\n");
        return str.toString();
    }

    public static String generateVariableInitForGetCutState(String type, String name) {
        StringBuffer str = new StringBuffer(80);
        String constant = MUSDAspectStringGen.generateVariableConstant(name, type);
        str.append("\t\t").append(MUSDAspectStringGen.upgradePrimitiveTypes(type)).append(" ").append("VAR");
        str.append("_").append(name).append(" = (").append(MUSDAspectStringGen.upgradePrimitiveTypes(type));
        str.append(") ").append("activeMUSD").append(".");
        str.append("getPrivateVariable").append("(").append(constant).append(");\n");
        return str.toString();
    }

    static String upgradePrimitiveTypes(String type) {
        if (type.equals("int")) {
            return "Integer";
        }
        if (type.equals("boolean")) {
            return "Boolean";
        }
        return type;
    }

    public static String generateVaraibleInitForCondEval(String type, String name) {
        StringBuffer str = new StringBuffer(80);
        String constant = MUSDAspectStringGen.generateVariableConstant(name, type);
        str.append("\t\t").append(MUSDAspectStringGen.upgradePrimitiveTypes(type)).append(" ");
        str.append(MUSDAspectStringGen.extractOriginal(name)).append(" = (").append(MUSDAspectStringGen.upgradePrimitiveTypes(type));
        str.append(") ").append("activeMUSD").append(".");
        str.append("getPrivateVariable").append("(").append(constant).append(");\n");
        return str.toString();
    }

    private static String extractOriginal(String name) {
        int i = name.indexOf("_");
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public static String getMessageCoddedName(MUSDMessage mes) {
        return String.valueOf(mes.getSender().getRepresentsType()) + mes.getReciever().getRepresentsType() + mes.getName();
    }
}

