/*
 * Decompiled with CFR 0.152.
 */
package musd.uml;

import musd.uml.UML2BasicOperations;
import org.eclipse.emf.common.util.URI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;

public class UML2ProfileOperations
extends UML2BasicOperations {
    protected static Profile createProfile(String name) {
        Profile profile = UMLFactory.eINSTANCE.createProfile();
        profile.setName(name);
        UML2ProfileOperations.out("Profile '" + profile.getQualifiedName() + "' created.");
        return profile;
    }

    protected static PrimitiveType importPrimitiveType(Package package_, String name) {
        Model uml2Library = (Model)UML2ProfileOperations.load(URI.createURI("pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"));
        PrimitiveType primitiveType = (PrimitiveType)uml2Library.getOwnedType(name);
        package_.createElementImport((PackageableElement)primitiveType);
        UML2ProfileOperations.out("Primitive type '" + primitiveType.getQualifiedName() + "' imported.");
        return primitiveType;
    }

    protected static Stereotype createStereotype(Profile profile, String name, boolean isAbstract) {
        Stereotype stereotype = profile.createOwnedStereotype(name, isAbstract);
        UML2ProfileOperations.out("Stereotype '" + stereotype.getQualifiedName() + "' created.");
        return stereotype;
    }

    protected static Class referenceMetaclass(Profile profile, String name) {
        Model uml2Metamodel = (Model)UML2ProfileOperations.load(URI.createURI("pathmap://UML_METAMODELS/UML.metamodel.uml"));
        Class metaclass = (Class)uml2Metamodel.getOwnedType(name);
        profile.createMetaclassReference((PackageableElement)metaclass);
        UML2ProfileOperations.out("Metaclass '" + metaclass.getQualifiedName() + "' referenced.");
        return metaclass;
    }

    protected static Extension createExtension(Class metaclass, Stereotype stereotype, boolean required) {
        Extension extension = stereotype.createExtension(metaclass, required);
        UML2ProfileOperations.out(String.valueOf(required ? "Required extension '" : "Extension '") + extension.getQualifiedName() + "' created.");
        return extension;
    }

    protected static void defineProfile(Profile profile) {
        profile.define();
        UML2ProfileOperations.out("Profile '" + profile.getQualifiedName() + "' defined.");
    }

    protected static void applyProfile(Package package_, Profile profile) {
        package_.applyProfile(profile);
        UML2ProfileOperations.out("Profile '" + profile.getQualifiedName() + "' applied to package '" + package_.getQualifiedName() + "'.");
    }

    protected static void applyStereotype(NamedElement namedElement, Stereotype stereotype) {
        namedElement.applyStereotype(stereotype);
        UML2ProfileOperations.out("Stereotype '" + stereotype.getQualifiedName() + "' applied to element '" + namedElement.getQualifiedName() + "'.");
    }

    public static Object getStereotypePropertyValue(NamedElement namedElement, Stereotype stereotype, Property property) {
        Object value = namedElement.getValue(stereotype, property.getName());
        UML2ProfileOperations.out("Value of stereotype property '" + property.getQualifiedName() + "' on element '" + namedElement.getQualifiedName() + "' is " + String.valueOf(value) + ".");
        return value;
    }

    protected static void setStereotypePropertyValue(NamedElement namedElement, Stereotype stereotype, Property property, Object value) {
        namedElement.setValue(stereotype, property.getName(), value);
        UML2ProfileOperations.out("Value of stereotype property '" + property.getQualifiedName() + "' on element '" + namedElement.getQualifiedName() + "' set to " + String.valueOf(value) + ".");
    }
}

