/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.uml2.common.util.UnionEObjectEList;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.internal.operations.ClassOperations;

public class ComponentOperations
extends ClassOperations {
    protected ComponentOperations() {
    }

    public static Class createOwnedClass(Component component, String name, boolean isAbstract) {
        Class ownedClass = (Class)component.createPackagedElement(name, UMLPackage.Literals.CLASS);
        ownedClass.setIsAbstract(isAbstract);
        return ownedClass;
    }

    public static Enumeration createOwnedEnumeration(Component component, String name) {
        return (Enumeration)component.createPackagedElement(name, UMLPackage.Literals.ENUMERATION);
    }

    public static PrimitiveType createOwnedPrimitiveType(Component component, String name) {
        return (PrimitiveType)component.createPackagedElement(name, UMLPackage.Literals.PRIMITIVE_TYPE);
    }

    public static Interface createOwnedInterface(Component component, String name) {
        return (Interface)component.createPackagedElement(name, UMLPackage.Literals.INTERFACE);
    }

    public static EList realizedInterfaces(Component component, Classifier classifier) {
        UniqueEList.FastCompare realizedInterfaces = new UniqueEList.FastCompare();
        Iterator clientDependencies = classifier.getClientDependencies().iterator();
        while (clientDependencies.hasNext()) {
            Dependency dependency = (Dependency)clientDependencies.next();
            if (!(dependency instanceof ComponentRealization)) continue;
            Iterator suppliers = ((InternalEList)dependency.getSuppliers()).basicIterator();
            while (suppliers.hasNext()) {
                Object supplier = suppliers.next();
                if (!(supplier instanceof Interface)) continue;
                realizedInterfaces.add(supplier);
            }
        }
        return ECollections.unmodifiableEList((EList)realizedInterfaces);
    }

    public static EList usedInterfaces(Component component, Classifier classifier) {
        UniqueEList.FastCompare usedInterfaces = new UniqueEList.FastCompare();
        Iterator clientDependencies = classifier.getClientDependencies().iterator();
        while (clientDependencies.hasNext()) {
            Dependency dependency = (Dependency)clientDependencies.next();
            if (!(dependency instanceof Usage)) continue;
            Iterator suppliers = ((InternalEList)dependency.getSuppliers()).basicIterator();
            while (suppliers.hasNext()) {
                Object supplier = suppliers.next();
                if (!(supplier instanceof Interface)) continue;
                usedInterfaces.add(supplier);
            }
        }
        return ECollections.unmodifiableEList((EList)usedInterfaces);
    }

    public static EList getRequireds(Component component) {
        UniqueEList.FastCompare requireds = new UniqueEList.FastCompare((Collection)component.usedInterfaces(component));
        Iterator realizations = component.getRealizations().iterator();
        while (realizations.hasNext()) {
            Classifier realizingClassifier = ((ComponentRealization)realizations.next()).getRealizingClassifier();
            if (realizingClassifier == null) continue;
            requireds.addAll((Collection)component.usedInterfaces(realizingClassifier));
        }
        Iterator ownedPorts = component.getOwnedPorts().iterator();
        while (ownedPorts.hasNext()) {
            requireds.addAll((Collection)((InternalEList)((Port)ownedPorts.next()).getRequireds()).basicList());
        }
        return new UnionEObjectEList((InternalEObject)component, (EStructuralFeature)UMLPackage.Literals.COMPONENT__REQUIRED, requireds.size(), requireds.toArray());
    }

    public static EList getProvideds(Component component) {
        UniqueEList.FastCompare provideds = new UniqueEList.FastCompare();
        Iterator interfaceRealizations = component.getInterfaceRealizations().iterator();
        while (interfaceRealizations.hasNext()) {
            Interface contract = (Interface)((InterfaceRealization)interfaceRealizations.next()).eGet((EStructuralFeature)UMLPackage.Literals.INTERFACE_REALIZATION__CONTRACT, false);
            if (contract == null) continue;
            provideds.add((Object)contract);
        }
        provideds.addAll((Collection)component.realizedInterfaces(component));
        Iterator realizations = component.getRealizations().iterator();
        while (realizations.hasNext()) {
            Classifier realizingClassifier = ((ComponentRealization)realizations.next()).getRealizingClassifier();
            if (realizingClassifier == null) continue;
            provideds.addAll((Collection)component.realizedInterfaces(realizingClassifier));
        }
        Iterator ownedPorts = component.getOwnedPorts().iterator();
        while (ownedPorts.hasNext()) {
            provideds.addAll((Collection)((InternalEList)((Port)ownedPorts.next()).getProvideds()).basicList());
        }
        return new UnionEObjectEList((InternalEObject)component, (EStructuralFeature)UMLPackage.Literals.COMPONENT__PROVIDED, provideds.size(), provideds.toArray());
    }
}

