/*
 * Decompiled with CFR 0.152.
 */
package msd.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import msd.compiler.MUSDInteractionsCompiler;
import msd.compiler.errors.MSDErrorHandler;
import msd.compiler.lib.MSDInteraction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.PackageableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSDModelCompiler {
    private ArrayList<MSDInteraction> interactionList;
    private ArrayList<String> toCompileInteractionNames = new ArrayList();
    private HashMap<String, String> interactionsAspects = null;
    private String MUSDMethodsConstants;
    private String coordinator;
    private boolean compileAll = false;

    public MSDModelCompiler(Model model) {
        this(model, null);
    }

    public MSDModelCompiler(Model model, String[] selectedInteractions) {
        if (selectedInteractions != null) {
            int i = 0;
            while (i < selectedInteractions.length) {
                this.toCompileInteractionNames.add(selectedInteractions[i].trim());
                ++i;
            }
        } else {
            this.compileAll = true;
        }
        this.interactionList = new ArrayList();
        EList ElementsList = model.getPackagedElements();
        for (PackageableElement pe : ElementsList) {
            if (!(pe instanceof BehavioredClassifier)) continue;
            this.handleCollaboration((BehavioredClassifier)pe);
        }
    }

    public void compileModel(String implClass, String[] importsArray, String targetPackage, boolean compositionSupport) {
        ArrayList<String> imports = new ArrayList<String>();
        int i = 0;
        while (i < importsArray.length) {
            imports.add(importsArray[i]);
            ++i;
        }
        this.compileList(implClass, imports, targetPackage, this.interactionList, compositionSupport);
    }

    private void compileList(String implClass, ArrayList<String> imports, String targetPackage, ArrayList<MSDInteraction> toCompileList, boolean compositionSupport) {
        MUSDInteractionsCompiler compiler = new MUSDInteractionsCompiler(toCompileList, compositionSupport);
        this.interactionsAspects = compiler.compileAspects(imports, targetPackage);
        this.MUSDMethodsConstants = compiler.compileMethodConstants(targetPackage);
        this.coordinator = compiler.compileCoordinator(implClass, imports, targetPackage);
    }

    public String getMUSDMethodsConstants() {
        return this.MUSDMethodsConstants;
    }

    public String getCoordinator() {
        return this.coordinator;
    }

    public HashMap<String, String> getInteractionsAspects() {
        return this.interactionsAspects;
    }

    private void handleCollaboration(BehavioredClassifier col) {
        EList list = col.getOwnedBehaviors();
        for (Object obj : list) {
            if (!(obj instanceof Interaction)) continue;
            this.handleInteraction((Interaction)obj);
        }
    }

    private void handleInteraction(Interaction inter) {
        if (this.toCompileInteractionNames != null && this.isInList(inter.getName())) {
            try {
                MSDInteraction musdInter = new MSDInteraction(inter);
                this.interactionList.add(musdInter);
            }
            catch (Exception e) {
                MSDErrorHandler.printErrorInUML2MSDPhase(inter, e);
            }
        }
    }

    private boolean isInList(String name) {
        return this.compileAll || this.toCompileInteractionNames.contains(name);
    }
}

