/*
 * Decompiled with CFR 0.152.
 */
package msd.compiler;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import msd.compiler.FilesWriter;
import msd.compiler.MSDModelCompiler;
import msd.uml.UML2AdvancedOperations;
import msd.uml.UML2ProfileOperations;
import org.eclipse.emf.common.util.URI;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;

public class MUSDCompilerApp {
    private static final String MODEL_PATH = "model";
    private static final String OUTPUT_FOLDER = "output";
    private static final String OUTPUT_PACKAGE = "output.package";
    private static final String IMPORTS = "imports";
    private static final String STRATEGY = "strategy";
    private static final String PROFILES_REASOURCE_JAR = "resourcesJar";
    private static final String PROPERTIES_FILE_NAME = "musdcompiler.properties";
    private static final String MODEL_PROPERTIES_FILE_NAME = "musdmodel.properties";
    private static final String TO_COMPILE_INTERACTIONS = "interactions";
    private static final String COMPILE_ALL = "*";
    private static final String CLEAN = "clean";
    private static final String TRUE = "true";
    private static final String COMPOSITION = "composition";
    private static String jar;
    private static String impl;
    private static String targetPackage;
    private static String outputPath;
    private static String modelPath;
    private static String clean;
    private static String composition;
    private static String[] imports;
    private static String[] toCompileInteractions;

    static {
        imports = null;
        toCompileInteractions = null;
    }

    public static void main(String[] args) {
        MUSDCompilerApp.readProperties();
        Model model = MUSDCompilerApp.loadModel();
        long t = System.currentTimeMillis();
        System.out.println("Starting compilation of: " + model.getName());
        MSDModelCompiler comp = toCompileInteractions[0].equals(COMPILE_ALL) ? new MSDModelCompiler(model) : new MSDModelCompiler(model, toCompileInteractions);
        if (clean.equals(TRUE)) {
            FilesWriter.cleanAll(outputPath);
        }
        boolean compositionSupport = composition == null ? false : Boolean.valueOf(composition);
        comp.compileModel(impl, imports, targetPackage, compositionSupport);
        FilesWriter.writeAll(comp, outputPath);
        t = System.currentTimeMillis() - t;
        System.out.println("Done. total compilation time: " + t / 1000L + " seconds and " + t % 1000L + " milliseconds");
    }

    private static Model loadModel() {
        UML2AdvancedOperations.registerResourceFactories();
        UML2ProfileOperations.registerPathmaps(URI.createURI(jar));
        UML2AdvancedOperations.createModel("epo2");
        URI uri = URI.createURI("").appendSegment(modelPath).appendFileExtension("uml");
        Package p = UML2AdvancedOperations.load(uri);
        return p.getModel();
    }

    private static void readProperties() {
        modelPath = null;
        outputPath = null;
        clean = null;
        targetPackage = null;
        impl = null;
        jar = null;
        try {
            Properties properties = new Properties();
            FileInputStream in = new FileInputStream(PROPERTIES_FILE_NAME);
            properties.load(in);
            modelPath = properties.getProperty(MODEL_PATH);
            jar = properties.getProperty(PROFILES_REASOURCE_JAR);
            impl = properties.getProperty(STRATEGY);
            String modelFile = URI.createFileURI(modelPath).trimSegments(1).appendSegment(MODEL_PROPERTIES_FILE_NAME).toFileString();
            in = new FileInputStream(modelFile);
            properties.load(in);
            targetPackage = properties.getProperty(OUTPUT_PACKAGE);
            outputPath = properties.getProperty(OUTPUT_FOLDER);
            clean = properties.getProperty(CLEAN);
            imports = properties.getProperty(IMPORTS).split(";");
            composition = properties.getProperty(COMPOSITION);
            toCompileInteractions = properties.getProperty(TO_COMPILE_INTERACTIONS).split(";");
            if (toCompileInteractions.length < 1) {
                throw new IllegalArgumentException("The should be at least one interaction to compile, (or *)");
            }
            in.close();
        }
        catch (IOException e) {
            System.out.println("Could not read properties file. Make sure there is a proper propertiesfile in the working directory");
            System.exit(1);
        }
    }
}

