/*
 * Decompiled with CFR 0.152.
 */
package msd.compiler.errors;

import msd.compiler.lib.MSDInteraction;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;

public class MSDErrorHandler {
    public static void printErrorInUML2MSDPhase(Interaction inter, Exception e) {
        System.err.println("Exception Occured while trying to convert UML interaction:\"" + inter.getName() + "\" to MSDInteraction");
        System.err.println("ExceptionDetails: " + e.getMessage());
        StackTraceElement[] ste = e.getStackTrace();
        if (ste[0].getClassName().equals("musd.compiler.lib.InteractionGraph")) {
            MSDErrorHandler.printInteractionGraphError(e);
        }
        e.printStackTrace();
    }

    private static void printInteractionGraphError(Exception e) {
        if (e instanceof NullPointerException && e.getStackTrace()[0].getMethodName().equals("getNewCutState")) {
            System.err.println("Some lifeline's name seems to be null.");
        }
    }

    public static void printErrorInAddingFragment(MSDInteraction inter, InteractionFragment fragment, Exception e) {
        MessageOccurrenceSpecification mos;
        System.err.println("Exception Occured while trying to convert UML interaction:\"" + inter.getName() + "\" to MSDInteraction");
        System.err.println("Dealing with the fragment:" + fragment.getName());
        if (fragment instanceof MessageOccurrenceSpecification && (mos = (MessageOccurrenceSpecification)fragment).getMessage() != null) {
            System.err.println("of type message. Message name was: " + mos.getMessage().getName());
        }
        System.err.println("ExceptionDetails: " + e.getMessage());
        e.printStackTrace();
    }

    public static void printErrorInMSD2Aspectphase(MSDInteraction inter, Exception e) {
        System.err.println("Exception Occured while trying to create Aspect for UML interaction:\"" + inter.getName());
        System.err.println("ExceptionDetails: " + e.getMessage());
        e.printStackTrace();
    }
}

