/*
 * Decompiled with CFR 0.152.
 */
package msd.compiler.interaction2aspect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import msd.compiler.interaction2aspect.MUSDChangeCutStateBuilder;
import msd.compiler.interaction2aspect.MessageData;
import msd.compiler.lib.MSDConstraint;
import msd.compiler.lib.MSDInteraction;
import msd.compiler.lib.MSDInteractionFragment;
import msd.compiler.lib.MUSDCombinedFragment;
import msd.compiler.lib.MUSDInteractionGuard;
import msd.compiler.stringutils.ChangeCutStringGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmidiateEventsTree {
    private ImmidiateEventsTreeNode root;
    private int constraintNumber;
    private MessageData data;
    private HashMap<Integer, String> beforeConstraintStates = new HashMap();
    private HashMap<Integer, String> afterConstraintStates = new HashMap();
    private HashMap<Integer, String> constraintsAndGuardsStringsMap;
    private HashMap<String, Integer> lineToIndexes;
    private HashMap<String, Integer> constraintReverseMap;
    private HashMap<Integer, Integer> idToStringId = new HashMap();

    public ImmidiateEventsTree(MessageData data, MUSDChangeCutStateBuilder builder) {
        this.constraintsAndGuardsStringsMap = builder.constraintsAndGuardsStringsMap;
        this.constraintReverseMap = builder.constraintReverseMap;
        this.lineToIndexes = builder.lineToIndexes;
        this.data = data;
        this.constraintNumber = builder.consNumber;
        this.root = new ImmidiateEventsTreeNode(-1, data.followingImmidiateEvents, this, false, false);
    }

    public HashMap<Integer, String> getAfterConstraintStates() {
        return this.afterConstraintStates;
    }

    public HashMap<Integer, String> getBeforeConstraintStates() {
        return this.beforeConstraintStates;
    }

    public int getStringId(int id) {
        Integer res = this.idToStringId.get(id);
        return res != null ? res : -1;
    }

    public boolean isEmpty() {
        return !this.root.hasChildren();
    }

    public int getConstraintNumber() {
        return this.constraintNumber;
    }

    public ImmidiateEventsTreeNode getRoot() {
        return this.root;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ImmidiateEventsTreeNode {
        private ArrayList<ImmidiateEventsTreeNode> children;
        private int id;
        private String nextCut;
        private ImmidiateEventsTree tree;
        private boolean isGuard;
        private boolean isLastGuard;

        public ImmidiateEventsTreeNode(int id, ArrayList<MSDInteractionFragment> list, ImmidiateEventsTree t, boolean isGuard, boolean isLastGuard) {
            this.id = id;
            this.tree = t;
            this.children = new ArrayList();
            this.isGuard = isGuard;
            this.isLastGuard = isLastGuard;
            ImmidiateEventsTree immidiateEventsTree2 = ImmidiateEventsTree.this;
            immidiateEventsTree2.constraintNumber = immidiateEventsTree2.constraintNumber + 1;
            this.setChildren(list);
        }

        public void setChildren(ArrayList<MSDInteractionFragment> list) {
            String afterCut;
            String beforeCut;
            String constraintString;
            if (list == null || list.isEmpty()) {
                return;
            }
            MSDInteractionFragment fragment = list.get(0);
            ArrayList<MSDInteractionFragment> nextList = new ArrayList<MSDInteractionFragment>(list);
            if (fragment.getType() == 1) {
                nextList.remove(0);
                constraintString = ((MSDConstraint)fragment).toString();
                Integer i = (Integer)ImmidiateEventsTree.this.constraintReverseMap.get(constraintString);
                if (i == null) {
                    i = ImmidiateEventsTree.this.constraintNumber;
                    ImmidiateEventsTree.this.constraintReverseMap.put(constraintString, i);
                }
                ImmidiateEventsTree.this.idToStringId.put(ImmidiateEventsTree.this.constraintNumber, i);
                beforeCut = ((ImmidiateEventsTree)ImmidiateEventsTree.this).data.beforeImmidiateCuts.get(fragment).getCutStateString(ImmidiateEventsTree.this.lineToIndexes);
                afterCut = ((ImmidiateEventsTree)ImmidiateEventsTree.this).data.afterImmidiateCuts.get(fragment).getCutStateString(ImmidiateEventsTree.this.lineToIndexes);
                ImmidiateEventsTree.this.beforeConstraintStates.put(ImmidiateEventsTree.this.constraintNumber, beforeCut);
                ImmidiateEventsTree.this.afterConstraintStates.put(ImmidiateEventsTree.this.constraintNumber, afterCut);
                ImmidiateEventsTree.this.constraintsAndGuardsStringsMap.put(i, constraintString);
                this.children.add(new ImmidiateEventsTreeNode(ImmidiateEventsTree.this.constraintNumber, nextList, this.tree, false, false));
            }
            if (MUSDCombinedFragment.isCombined(fragment)) {
                MUSDCombinedFragment combined = (MUSDCombinedFragment)fragment;
                this.nextCut = ((ImmidiateEventsTree)ImmidiateEventsTree.this).data.combinedToNextCut.get(combined).getCutStateString(ImmidiateEventsTree.this.lineToIndexes);
                Iterator<MUSDInteractionGuard> it = combined.getAllGuards().iterator();
                boolean isLastGuard = false;
                while (it.hasNext()) {
                    MUSDInteractionGuard guard = it.next();
                    nextList = ((ImmidiateEventsTree)ImmidiateEventsTree.this).data.guardsTofollowingImmidiateEvents.get(guard);
                    beforeCut = ((ImmidiateEventsTree)ImmidiateEventsTree.this).data.beforeImmidiateCuts.get(guard).getCutStateString(ImmidiateEventsTree.this.lineToIndexes);
                    afterCut = ((ImmidiateEventsTree)ImmidiateEventsTree.this).data.afterImmidiateCuts.get(guard).getCutStateString(ImmidiateEventsTree.this.lineToIndexes);
                    constraintString = this.getGuardString(guard);
                    Integer i = (Integer)ImmidiateEventsTree.this.constraintReverseMap.get(constraintString);
                    if (i == null) {
                        i = ImmidiateEventsTree.this.constraintNumber;
                        ImmidiateEventsTree.this.constraintReverseMap.put(constraintString, i);
                    }
                    ImmidiateEventsTree.this.idToStringId.put(ImmidiateEventsTree.this.constraintNumber, i);
                    ImmidiateEventsTree.this.beforeConstraintStates.put(ImmidiateEventsTree.this.constraintNumber, beforeCut);
                    ImmidiateEventsTree.this.afterConstraintStates.put(ImmidiateEventsTree.this.constraintNumber, afterCut);
                    ImmidiateEventsTree.this.constraintsAndGuardsStringsMap.put(i, constraintString);
                    if (!it.hasNext()) {
                        isLastGuard = true;
                    }
                    this.children.add(new ImmidiateEventsTreeNode(ImmidiateEventsTree.this.constraintNumber, nextList, this.tree, true, isLastGuard));
                }
                nextList = new ArrayList<MSDInteractionFragment>(list);
                nextList.remove(0);
                this.setChildren(nextList);
            }
        }

        private String getGuardString(MUSDInteractionGuard guard) {
            if (guard.isConstantLoopGuard()) {
                MSDInteraction inter = guard.getEnclosingInteraction();
                MUSDCombinedFragment combined = guard.getEnclosingCombinedFragment();
                int id = inter.getLoopFragmentId(combined);
                return ChangeCutStringGen.getLoopEvaluation(id);
            }
            return guard.toString();
        }

        public ArrayList<ImmidiateEventsTreeNode> getChildren() {
            return this.children;
        }

        public int getId() {
            return this.id;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public String getNextCut() {
            return this.nextCut;
        }

        public ImmidiateEventsTree getTree() {
            return this.tree;
        }

        public boolean isGuard() {
            return this.isGuard;
        }

        public boolean isLastGuard() {
            return this.isLastGuard;
        }
    }
}

