/*
 * Decompiled with CFR 0.152.
 */
package msd.compiler.interaction2aspect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import msd.compiler.interaction2aspect.MSDInteractionLogic;
import msd.compiler.interaction2aspect.MUSDChangeCutStateBuilder;
import msd.compiler.interaction2aspect.MUSDConstructorBuilder;
import msd.compiler.interaction2aspect.MUSDGetCutStateBuilder;
import msd.compiler.lib.MSDInteraction;
import msd.compiler.lib.MSDLifeline;
import msd.compiler.lib.MSDMessage;
import msd.compiler.lib.MUSDArgument;
import msd.compiler.stringutils.MUSDAspectStringGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUSDInteraction2Aspect {
    MSDInteraction interaction;
    StringBuffer staticInit;
    StringBuffer exactVarsInit;
    HashMap<String, String> varNamesToVarTypes;
    MSDInteractionLogic interactionLogic;
    HashMap<String, Integer> lineToIndexes;
    int methodNumberRange;
    int finalRange;
    private HashSet<String> pointCutCores;
    private HashSet<MUSDArgument> privateArgs;
    private HashSet<String> ownerLines;
    private HashMap<String, String> lineNamesToInstancesConst;
    private HashMap<String, String> lineNameToObjectTypes;
    private StringBuffer code;
    private String aspectName;
    private boolean compositionSupport;

    public MUSDInteraction2Aspect(MSDInteraction interaction, int methodNumberRange, ArrayList<String> imports, String targetPackage, boolean compositionSupport) {
        this.interaction = interaction;
        this.methodNumberRange = methodNumberRange;
        this.compositionSupport = compositionSupport;
        this.finalRange = methodNumberRange;
        this.lineToIndexes = this.initializeLineToIndexes(interaction.getCoveredLines());
        this.lineNamesToInstancesConst = new HashMap();
        this.varNamesToVarTypes = new HashMap();
        this.ownerLines = new HashSet();
        this.pointCutCores = new HashSet();
        this.lineNameToObjectTypes = new HashMap();
        this.privateArgs = new HashSet();
        this.aspectName = "MSDAspect" + interaction.getName();
        this.code = new StringBuffer(4500);
        this.buildAspectCode(imports, targetPackage);
    }

    private void buildAspectCode(ArrayList<String> imports, String targetPackage) {
        this.addDeclerations(imports, targetPackage);
        this.addConstants();
        this.interactionLogic = new MSDInteractionLogic(this.interaction, this.lineNamesToInstancesConst);
        this.addConstructor();
        this.addPointCuts();
        this.addChangeCutState();
        this.addGetCutState();
        this.code.append("}");
        this.code.trimToSize();
    }

    private void addDeclerations(ArrayList<String> imports, String targetPackage) {
        this.code.append(MUSDAspectStringGen.generateAspectLicenceWarnning(this.interaction.getName()));
        this.code.append(MUSDAspectStringGen.generatePackageDeclaration(targetPackage));
        Iterator<String> it = imports.iterator();
        while (it.hasNext()) {
            this.code.append(MUSDAspectStringGen.generateImport(it.next()));
        }
        this.code.append(MUSDAspectStringGen.generateCommonImports());
        this.code.append(MUSDAspectStringGen.generateAspectName(this.interaction.getName()));
    }

    private void addConstants() {
        StringBuffer instances = new StringBuffer();
        this.staticInit = new StringBuffer();
        int instanceConst = 0;
        for (MSDLifeline line : this.interaction.getCoveredLines()) {
            if (line.isEnv()) continue;
            instances.append(MUSDAspectStringGen.generateOBjectInstanceConstant(line.getRepresents(), line.getName(), instanceConst++));
            this.lineNamesToInstancesConst.put(line.getName(), String.valueOf(line.getRepresents()) + "_INST_" + line.getName());
            this.lineNameToObjectTypes.put(line.getName(), line.getRepresentsType());
            if (line.isStatic()) {
                this.staticInit.append(MUSDAspectStringGen.generateStaticInit(this.lineNamesToInstancesConst.get(line.getName()), line.getRepresentsType()));
            }
            if (!line.isIPart() || !this.ownerLines.add(line.getParentLine().getName())) continue;
            this.doConstantsForParentLine(line.getParentLine(), instances, instanceConst++);
        }
        this.code.append("\n\n").append(MUSDAspectStringGen.getConstantsRemark());
        this.code.append(instances.append("\n").toString());
        this.addPrivateVariableConstants();
    }

    private void doConstantsForParentLine(MSDLifeline parentLine, StringBuffer instances, int instanceConst) {
        instances.append(MUSDAspectStringGen.generateOBjectInstanceConstant(parentLine.getRepresents(), parentLine.getName(), instanceConst));
        this.lineNamesToInstancesConst.put(parentLine.getName(), String.valueOf(parentLine.getRepresents()) + "_INST_" + parentLine.getName());
        this.lineNameToObjectTypes.put(parentLine.getName(), parentLine.getRepresentsType());
        if (parentLine.isStatic()) {
            this.staticInit.append(MUSDAspectStringGen.generateStaticInit(this.lineNamesToInstancesConst.get(parentLine.getName()), parentLine.getRepresentsType()));
        }
    }

    private void addPrivateVariableConstants() {
        this.exactVarsInit = new StringBuffer();
        StringBuffer str = new StringBuffer(100);
        int val = 0;
        this.initPrivateArgs();
        for (MUSDArgument arg : this.privateArgs) {
            String type = this.varNamesToVarTypes.get(arg.getName());
            str.append(MUSDAspectStringGen.generateVariableConstantInit(arg.getName(), type, val++));
            if (!arg.isExact()) continue;
            this.exactVarsInit.append(MUSDAspectStringGen.generateExactVarsInit(arg.getName(), arg.getStringValue(), type));
        }
        str.append("\n");
        this.code.append(str.toString());
    }

    private void initPrivateArgs() {
        for (MSDMessage mes : this.interaction.getMessages()) {
            Iterator<MUSDArgument> it2 = mes.getArguments().iterator();
            Iterator<String> it3 = mes.getArgumentsTypes().iterator();
            while (it2.hasNext()) {
                String type = it3.next();
                MUSDArgument arg = it2.next();
                this.privateArgs.add(arg);
                this.varNamesToVarTypes.put(arg.getName(), type);
            }
        }
    }

    private void addConstructor() {
        MUSDConstructorBuilder consBuilder = new MUSDConstructorBuilder(this.interaction, this.interactionLogic, this.lineToIndexes);
        this.code.append(consBuilder.getConstructor());
    }

    private void addPointCuts() {
        this.code.append(MUSDAspectStringGen.generatePointCutsRemark());
        HashSet<String> pointCutNames = new HashSet<String>();
        for (MSDMessage mes : this.interaction.getMessages()) {
            String name = MUSDAspectStringGen.getMessageCoddedName(mes);
            if (pointCutNames.contains(name)) continue;
            pointCutNames.add(name);
            if (mes.isConstructor()) {
                String core = this.createSinglePointCut(mes, 1);
                if (mes.getSender().isEnv()) continue;
                this.createSinglePointCut(mes, 0);
                this.pointCutCores.remove(core);
                continue;
            }
            int executeOrCall = mes.getSender().isEnv() || mes.getCoveredLines().size() == 1 ? 1 : 0;
            this.createSinglePointCut(mes, executeOrCall);
        }
    }

    private String createSinglePointCut(MSDMessage mes, int executeOrCall) {
        String core;
        String returnType;
        ArrayList<String> argsNames = null;
        ArrayList<String> argsTypes = null;
        String targetType = mes.getReciever().getRepresentsType();
        String thisType = mes.getSender().getRepresentsType();
        String methodName = mes.getName();
        String string = returnType = mes.getReturnType() == null ? "void" : mes.getReturnType();
        if (mes.hasArguments()) {
            argsNames = new ArrayList<String>();
            Iterator<MUSDArgument> it = mes.getArguments().iterator();
            while (it.hasNext()) {
                argsNames.add(it.next().getName());
            }
            argsTypes = mes.getArgumentsTypes();
        }
        if (mes.isConstructor()) {
            core = this.createConstructorCore(targetType, executeOrCall);
            if (executeOrCall == 1) {
                this.code.append(MUSDAspectStringGen.generatePointCut(methodName, targetType, "env", core, argsTypes, argsNames, this.compositionSupport));
                this.code.append(MUSDAspectStringGen.generateAdvice(thisType, targetType, methodName, argsTypes, argsNames, true, this.compositionSupport));
            } else {
                this.code.append(MUSDAspectStringGen.generateConstructorPointCut(methodName, thisType, core));
                this.code.append(MUSDAspectStringGen.generateConstructorAdvice(thisType, targetType, methodName));
            }
        } else {
            core = this.createStandartCore(methodName, returnType, targetType, executeOrCall);
            this.code.append(MUSDAspectStringGen.generatePointCut(methodName, targetType, thisType, core, argsTypes, argsNames, this.compositionSupport));
            this.code.append(MUSDAspectStringGen.generateAdvice(thisType, targetType, methodName, argsTypes, argsNames, false, this.compositionSupport));
        }
        this.pointCutCores.add(core);
        return core;
    }

    private String createStandartCore(String methodName, String returnType, String targetType, int executeOrCall) {
        return MUSDAspectStringGen.generatePointCutCore(methodName, returnType, targetType, executeOrCall, this.compositionSupport);
    }

    private String createConstructorCore(String targetType, int executeOrCall) {
        return MUSDAspectStringGen.generatePointCutCore(targetType, executeOrCall);
    }

    private void addChangeCutState() {
        MUSDChangeCutStateBuilder changeCutBuilder = new MUSDChangeCutStateBuilder(this);
        this.code.append(changeCutBuilder.getChangeCutState());
    }

    private void addGetCutState() {
        MUSDGetCutStateBuilder builder = new MUSDGetCutStateBuilder(this);
        this.code.append(builder.getGetCutState());
    }

    private HashMap<String, Integer> initializeLineToIndexes(ArrayList<MSDLifeline> arr) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Iterator<MSDLifeline> it = arr.iterator();
        int i = 0;
        while (it.hasNext()) {
            map.put(it.next().getName(), new Integer(i++));
        }
        return map;
    }

    String getInstAndVarsDecleration(boolean forCondEval) {
        String type;
        StringBuffer str = new StringBuffer(300);
        for (MSDLifeline line : this.interaction.getCoveredLines()) {
            if (line.isEnv()) continue;
            type = line.getRepresentsType();
            String instanceName = line.getName();
            str.append(MUSDAspectStringGen.generateInstDecleration(type, instanceName, this.lineNamesToInstancesConst.get(instanceName)));
        }
        for (String name : this.varNamesToVarTypes.keySet()) {
            if (this.isVarNameALineName(name)) continue;
            type = this.varNamesToVarTypes.get(name);
            if (!forCondEval) {
                str.append(MUSDAspectStringGen.generateVariableInitForGetCutState(type, name));
                continue;
            }
            str.append(MUSDAspectStringGen.generateVaraibleInitForCondEval(type, name));
        }
        return str.append("\n").toString();
    }

    private boolean isVarNameALineName(String name) {
        for (MSDLifeline line : this.interaction.getCoveredLines()) {
            if (!line.getName().equals(MUSDArgument.parstRealName(name))) continue;
            return true;
        }
        return false;
    }

    public String getAspectCode() {
        return this.code.toString();
    }

    public int getFinalRange() {
        return this.finalRange;
    }

    public HashSet<String> getPointCutCores() {
        return this.pointCutCores;
    }

    public String getAspectName() {
        return this.aspectName;
    }

    public HashMap<String, String> getVarNamesToVarTypes() {
        return this.varNamesToVarTypes;
    }
}

