/*
 * Decompiled with CFR 0.152.
 */
package msd.compiler.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import msd.compiler.errors.MSDCompilerRunTimeException;
import msd.compiler.errors.MSDErrorHandler;
import msd.compiler.lib.InteractionFragmentKey;
import msd.compiler.lib.InteractionGraph;
import msd.compiler.lib.MSDConstraint;
import msd.compiler.lib.MSDInteractionFragment;
import msd.compiler.lib.MSDInteractionNode;
import msd.compiler.lib.MSDLifeline;
import msd.compiler.lib.MSDMessage;
import msd.compiler.lib.MUSDArgument;
import msd.compiler.lib.MUSDCombinedFragment;
import msd.compiler.lib.MUSDInteractionOperand;
import msd.uml.ModalProfileUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.StateInvariant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSDInteraction
extends MSDInteractionFragment {
    private static final boolean SYNC = true;
    static final String STAB = "STAB";
    private HashSet<MessageOccurrenceSpecification> alreadyProcessed;
    private HashSet<MessageOccurrenceSpecification> alreadyProcessedComposedUse;
    private ArrayList<InteractionFragmentKey> fragmentsOrderedList;
    private HashSet<MSDMessage> MUSDMessages;
    private HashSet<MSDMessage> executableMessages;
    private HashSet<MUSDArgument> privateVariables;
    private HashSet<MSDConstraint> constraints;
    private HashMap<InteractionFragmentKey, MSDInteractionFragment> interKeyToInterFragments;
    private InteractionGraph graph;
    private Stack<MUSDCombinedFragment> workingCombFragment;
    private HashMap<MUSDCombinedFragment, Integer> loopFragmentsMap;
    private int combinedCounter = 0;
    private boolean isTest;

    public MSDInteraction(Interaction inter) {
        super(inter.getName());
        this.isImmediate = true;
        Boolean isFlat = this.isFlat(inter);
        MUSDArgument.initIdentValue();
        this.MUSDMessages = new HashSet();
        this.executableMessages = new HashSet();
        this.privateVariables = new HashSet();
        this.constraints = new HashSet();
        this.alreadyProcessed = new HashSet();
        this.alreadyProcessedComposedUse = new HashSet();
        this.fragmentsOrderedList = new ArrayList();
        this.interKeyToInterFragments = new HashMap();
        this.workingCombFragment = new Stack();
        this.loopFragmentsMap = new HashMap();
        try {
            this.isTest = ModalProfileUtils.isTest((BehavioredClassifier)inter.getOwner()) || ModalProfileUtils.isTest((BehavioredClassifier)inter);
            this.coveredLifeLines = this.getInteractionLifelines(inter.getLifelines(), null);
            if (isFlat.booleanValue()) {
                this.appendInteractionsToInterKeyMap(inter.getFragments());
            } else {
                long t = System.currentTimeMillis();
                this.appendInteractionsToInterKeyMapCompVerstion(inter);
                System.out.println("Composition Algorithm for the interaction tree: " + this.name + " took: " + (System.currentTimeMillis() - t) + " millis");
            }
            this.graph = new InteractionGraph(this);
        }
        catch (MSDCompilerRunTimeException mSDCompilerRunTimeException) {
            // empty catch block
        }
    }

    private Boolean isFlat(Interaction inter) {
        Iterator it = inter.getLifelines().iterator();
        while (it.hasNext()) {
            if (((Lifeline)it.next()).getDecomposedAs() == null) continue;
            return false;
        }
        return true;
    }

    private ArrayList<MSDLifeline> getInteractionLifelines(EList lifeLines, MSDLifeline parentLine) throws MSDCompilerRunTimeException {
        ArrayList<MSDLifeline> list = new ArrayList<MSDLifeline>();
        for (Lifeline line : lifeLines) {
            if (new MSDLifeline(line).isStab()) continue;
            if (line.getDecomposedAs() == null) {
                list.add(new MSDLifeline(line, parentLine));
                continue;
            }
            if (line.getDecomposedAs().getRefersTo() == null) {
                throw new MSDCompilerRunTimeException("line's decomposition field is not nullbut it refersTo field is null", this, line);
            }
            EList decLines = line.getDecomposedAs().getRefersTo().getLifelines();
            list.addAll(this.getInteractionLifelines(decLines, new MSDLifeline(line)));
        }
        return list;
    }

    private void appendInteractionsToInterKeyMap(EList fragments) {
        for (InteractionFragment fragment : fragments) {
            try {
                this.handleFragmnet(fragment);
            }
            catch (Exception e) {
                MSDErrorHandler.printErrorInAddingFragment(this, fragment, e);
                System.exit(1);
            }
        }
    }

    private void handleFragmnet(InteractionFragment fragment) {
        boolean isExe = ModalProfileUtils.getExecutionBooleanValue((NamedElement)fragment);
        boolean isHot = ModalProfileUtils.getTemperatureBooleanValue((NamedElement)fragment);
        if (fragment instanceof StateInvariant || this.isFragmentAnAssert(fragment)) {
            this.handleStateInvariant(fragment, isHot, isExe);
            return;
        }
        if (fragment instanceof MessageOccurrenceSpecification) {
            this.handleOccurrenceSpecification((MessageOccurrenceSpecification)fragment, isHot, isExe);
        }
        if (fragment instanceof CombinedFragment) {
            this.handleCombinedFragment((CombinedFragment)fragment, isHot, isExe);
        }
        if (fragment instanceof InteractionOperand) {
            this.handleInteractionOperand((InteractionOperand)fragment);
        }
    }

    private boolean isFragmentAnAssert(InteractionFragment fragment) {
        return fragment instanceof CombinedFragment && ((CombinedFragment)fragment).getInteractionOperator().getValue() == 9;
    }

    private void handleOccurrenceSpecification(MessageOccurrenceSpecification mos, boolean isHot, boolean isExe) {
        Message mes = mos.getMessage();
        if (mes == null || !MSDMessage.isRelevantMessage(mes)) {
            return;
        }
        MSDMessage MUSDMes = new MSDMessage(mes, this.coveredLifeLines);
        isExe = ModalProfileUtils.getExecutionBooleanValue((NamedElement)mes);
        isHot = ModalProfileUtils.getTemperatureBooleanValue((NamedElement)mes);
        this.MUSDMessages.add(MUSDMes);
        if (isExe) {
            this.executableMessages.add(MUSDMes);
        }
        MessageOccurrenceSpecification twinOccurence = MUSDMes.getReceivePoint().equals(mos) ? MUSDMes.getSendPoint() : MUSDMes.getReceivePoint();
        if (!this.alreadyProcessed.contains(mos)) {
            InteractionFragmentKey key = new InteractionFragmentKey(isHot, isExe, MUSDMes.getCoveredLines());
            this.interKeyToInterFragments.put(key, MUSDMes);
            this.privateVariables.addAll(MUSDMes.getArguments());
            this.fragmentsOrderedList.add(key);
            this.alreadyProcessed.add(mos);
            this.alreadyProcessed.add(twinOccurence);
        }
    }

    private void handleStateInvariant(InteractionFragment fragment, boolean isHot, boolean isExe) {
        MSDConstraint constraint = new MSDConstraint(fragment, isExe, isHot);
        InteractionFragmentKey key = new InteractionFragmentKey(isHot, isExe, constraint.getCoveredLines());
        this.interKeyToInterFragments.put(key, constraint);
        this.constraints.add(constraint);
        this.fragmentsOrderedList.add(key);
    }

    private void handleCombinedFragment(CombinedFragment fragment, boolean isHot, boolean isExe) {
        MUSDCombinedFragment combined = new MUSDCombinedFragment(fragment, this);
        this.updateLoopMap(combined);
        this.workingCombFragment.push(combined);
        InteractionFragmentKey key = new InteractionFragmentKey(isHot, isExe, combined.getCoveredLines());
        this.interKeyToInterFragments.put(key, combined);
        this.fragmentsOrderedList.add(key);
        this.appendInteractionsToInterKeyMap(fragment.getOperands());
        this.workingCombFragment.pop();
    }

    private void handleInteractionOperand(InteractionOperand operand) {
        MUSDCombinedFragment currentComb = this.workingCombFragment.peek();
        MUSDInteractionOperand op = new MUSDInteractionOperand(operand, currentComb);
        currentComb.addOperand(op);
        this.appendInteractionsToInterKeyMap(operand.getFragments());
        this.appendSyncObject(currentComb.getCoveredLines(), op);
    }

    private void appendSyncObject(ArrayList<MSDLifeline> lines, MUSDInteractionOperand op) {
        MSDConstraint syncContraint = MSDConstraint.getSyncConstraint(lines);
        InteractionFragmentKey key = new InteractionFragmentKey(false, true, lines);
        this.interKeyToInterFragments.put(key, syncContraint);
        this.fragmentsOrderedList.add(key);
        op.setLastFragment(syncContraint);
    }

    private void updateLoopMap(MUSDCombinedFragment combined) {
        if (combined.getType() != 6) {
            return;
        }
        this.loopFragmentsMap.put(combined, this.combinedCounter++);
    }

    private void appendInteractionsToInterKeyMapCompVerstion(Interaction inter) {
        MSDInteractionNode root = new MSDInteractionNode(inter);
        this.appendConstructsToGlobalList(root, new ArrayList<InteractionFragment>(), null, 0, null, true);
    }

    private int appendConstructsToGlobalList(MSDInteractionNode node, ArrayList<InteractionFragment> upFragmentList, ArrayList<InteractionFragment> sideFragmentList, int downIndex, Lifeline decomposedLine, boolean lastDecomposedLineForUpFragment) {
        EList fragments = node.getInteraction().getFragments();
        int nextDownIndex = 0;
        int i = downIndex;
        while (i < fragments.size()) {
            EList lineList;
            InteractionFragment fragment = (InteractionFragment)fragments.get(i);
            if (!this.isIrelevantFragment(fragment) && (lineList = fragment instanceof MessageOccurrenceSpecification ? this.dealWithTwinOccurence((MessageOccurrenceSpecification)fragment) : fragment.getCovereds()) != null) {
                Iterator it = lineList.iterator();
                boolean decomposed = false;
                ArrayList<InteractionFragment> nextSideFragmentList = new ArrayList<InteractionFragment>();
                InteractionFragment upFragment = upFragmentList.size() > 0 ? this.getLastInList(upFragmentList) : null;
                String lastName = this.getLastDecomposedName(lineList, node);
                upFragmentList.add(fragment);
                while (it.hasNext()) {
                    Lifeline line = (Lifeline)it.next();
                    if (!node.isComposedLine(line)) continue;
                    boolean last = line.getName().equals(lastName);
                    nextDownIndex = this.appendConstructsToGlobalList(node.getLineChildrenNode(line), upFragmentList, nextSideFragmentList, node.getNextDownIndex(line), line, last);
                    node.setNextDownIndex(line, nextDownIndex);
                    decomposed = true;
                }
                upFragmentList.remove(upFragmentList.size() - 1);
                if (decomposed) {
                    if (decomposedLine != null && this.checkStaticUnificaiotn(fragment, upFragment, decomposedLine)) {
                        return i + 1;
                    }
                } else {
                    if (decomposedLine != null && this.checkStaticUnificaiotn(fragment, upFragment, decomposedLine)) {
                        if (!lastDecomposedLineForUpFragment) {
                            sideFragmentList.add(fragment);
                        } else {
                            MSDInteractionFragment msdFragment = this.unifyFragments(fragment, upFragmentList, sideFragmentList);
                            this.handleUnifiedFragment(msdFragment, fragment, upFragment);
                        }
                        return i + 1;
                    }
                    this.handleFragmnet(fragment);
                }
            }
            ++i;
        }
        for (Lifeline line : node.getComposedLines()) {
            if (node.getLineChildrenNode(line) == null) continue;
            this.appendConstructsToGlobalList(node.getLineChildrenNode(line), new ArrayList<InteractionFragment>(), null, node.getNextDownIndex(line), line, true);
        }
        return fragments.size();
    }

    private String getLastDecomposedName(EList lineList, MSDInteractionNode node) {
        Iterator it = lineList.iterator();
        String name = "";
        while (it.hasNext()) {
            Lifeline line = (Lifeline)it.next();
            if (!node.isComposedLine(line)) continue;
            name = line.getName();
        }
        return name;
    }

    private boolean isIrelevantFragment(InteractionFragment fragment) {
        if (fragment instanceof BehaviorExecutionSpecification) {
            return true;
        }
        return fragment instanceof MessageOccurrenceSpecification && ((MessageOccurrenceSpecification)fragment).getMessage() == null;
    }

    private EList dealWithTwinOccurence(MessageOccurrenceSpecification mos) {
        Message mes = mos.getMessage();
        if (mes == null || !MSDMessage.isRelevantMessage(mes)) {
            return null;
        }
        MSDMessage MUSDMes = new MSDMessage(mes, this.coveredLifeLines);
        MessageOccurrenceSpecification twinOccurence = MUSDMes.getReceivePoint().equals(mos) ? MUSDMes.getSendPoint() : MUSDMes.getReceivePoint();
        if (!this.alreadyProcessedComposedUse.contains(mos)) {
            EList list = mos.getCovereds();
            list.addAll(twinOccurence.getCovereds());
            this.alreadyProcessedComposedUse.add(mos);
            this.alreadyProcessedComposedUse.add(twinOccurence);
            return list;
        }
        return null;
    }

    private void handleUnifiedFragment(MSDInteractionFragment msdFragment, InteractionFragment downFragment, InteractionFragment upFragment) {
        boolean isHot = this.retreiveTemperature(downFragment, upFragment);
        boolean isExe = this.retreiveExecute(downFragment, upFragment);
        InteractionFragmentKey key = new InteractionFragmentKey(isHot, isExe, msdFragment.getCoveredLines());
        this.interKeyToInterFragments.put(key, msdFragment);
        this.fragmentsOrderedList.add(key);
        if (msdFragment.type == 0) {
            MSDMessage mes = (MSDMessage)msdFragment;
            this.MUSDMessages.add(mes);
            if (isExe) {
                this.executableMessages.add(mes);
            }
            this.privateVariables.addAll(mes.getArguments());
        }
        if (msdFragment.type == 1) {
            this.constraints.add((MSDConstraint)msdFragment);
        }
    }

    private boolean retreiveExecute(InteractionFragment downFragment, InteractionFragment upFragment) {
        if (downFragment instanceof MessageOccurrenceSpecification) {
            MessageOccurrenceSpecification downMos = (MessageOccurrenceSpecification)downFragment;
            MessageOccurrenceSpecification upMos = (MessageOccurrenceSpecification)upFragment;
            boolean downIsExe = ModalProfileUtils.getExecutionBooleanValue((NamedElement)downMos.getMessage());
            boolean upIsExe = ModalProfileUtils.getExecutionBooleanValue((NamedElement)upMos.getMessage());
            if (!upIsExe || !downIsExe) {
                // empty if block
            }
            return downIsExe;
        }
        return false;
    }

    private boolean retreiveTemperature(InteractionFragment downFragment, InteractionFragment upFragment) {
        if (downFragment instanceof MessageOccurrenceSpecification) {
            MessageOccurrenceSpecification downMos = (MessageOccurrenceSpecification)downFragment;
            MessageOccurrenceSpecification upMos = (MessageOccurrenceSpecification)upFragment;
            boolean downIsHot = ModalProfileUtils.getTemperatureBooleanValue((NamedElement)downMos.getMessage());
            boolean upIsHot = ModalProfileUtils.getTemperatureBooleanValue((NamedElement)upMos.getMessage());
            if (!upIsHot || !downIsHot) {
                // empty if block
            }
            return downIsHot;
        }
        return false;
    }

    private MSDInteractionFragment unifyFragments(InteractionFragment fragment, ArrayList<InteractionFragment> upFragmentList, ArrayList<InteractionFragment> sideFragmentList) {
        InteractionFragment upFragment = this.getLastInList(upFragmentList);
        if (fragment instanceof MessageOccurrenceSpecification && upFragment instanceof MessageOccurrenceSpecification) {
            return this.unifyMOS((MessageOccurrenceSpecification)fragment, upFragmentList, sideFragmentList);
        }
        if ((fragment instanceof StateInvariant || this.isFragmentAnAssert(fragment)) && (upFragment instanceof StateInvariant || this.isFragmentAnAssert(upFragment))) {
            return this.unifyConstraint(fragment, upFragmentList, sideFragmentList);
        }
        return null;
    }

    private MSDInteractionFragment unifyConstraint(InteractionFragment fragment, ArrayList<InteractionFragment> upFragmentList, ArrayList<InteractionFragment> sideFragmentList) {
        boolean isHot = ModalProfileUtils.getTemperatureBooleanValue((NamedElement)fragment);
        boolean isExe = ModalProfileUtils.getExecutionBooleanValue((NamedElement)fragment);
        MSDConstraint downConstraint = new MSDConstraint(fragment, isExe, isHot);
        ArrayList<InteractionFragment> relevantFragmentsList = this.getRelevantFragmentList(upFragmentList);
        ArrayList<MSDConstraint> upConstraints = this.buildConstraintsList(relevantFragmentsList, isExe, isHot);
        ArrayList<MSDConstraint> sideConstraints = this.buildConstraintsList(sideFragmentList, isExe, isHot);
        downConstraint.unifyWith(upConstraints, sideConstraints);
        return downConstraint;
    }

    private ArrayList<InteractionFragment> getRelevantFragmentList(ArrayList<InteractionFragment> list) {
        ArrayList<InteractionFragment> resList = new ArrayList<InteractionFragment>();
        InteractionFragment upFragment = list.get(list.size() - 1);
        resList.add(upFragment);
        int i = list.size() - 2;
        while (i >= 0) {
            InteractionFragment fragment = list.get(i);
            if (!this.checkConstraintsUnification(upFragment, fragment)) {
                return resList;
            }
            resList.add(fragment);
            --i;
        }
        return resList;
    }

    private ArrayList<MSDConstraint> buildConstraintsList(ArrayList<InteractionFragment> fragmentList, boolean isExe, boolean isHot) {
        ArrayList<MSDConstraint> list = new ArrayList<MSDConstraint>();
        for (InteractionFragment fragment : fragmentList) {
            list.add(new MSDConstraint(fragment, isExe, isHot));
        }
        return list;
    }

    private MSDInteractionFragment unifyMOS(MessageOccurrenceSpecification downMOS, ArrayList<InteractionFragment> upFragmentList, ArrayList<InteractionFragment> sideFragmentList) {
        MSDMessage downMes = new MSDMessage(downMOS.getMessage(), this.coveredLifeLines);
        ArrayList<MSDMessage> upList = this.getMessageList(this.getRelevantMessageList(upFragmentList));
        ArrayList<MSDMessage> sideList = this.getMessageList(sideFragmentList);
        downMes.unifyWith(upList, sideList);
        return downMes;
    }

    private ArrayList<InteractionFragment> getRelevantMessageList(ArrayList<InteractionFragment> list) {
        ArrayList<InteractionFragment> resList = new ArrayList<InteractionFragment>();
        InteractionFragment upFragment = this.getLastInList(list);
        resList.add(upFragment);
        MessageOccurrenceSpecification upMos = (MessageOccurrenceSpecification)upFragment;
        int i = list.size() - 2;
        while (i >= 0) {
            InteractionFragment fragment = list.get(i);
            if (!(fragment instanceof MessageOccurrenceSpecification)) {
                return resList;
            }
            MessageOccurrenceSpecification mos = (MessageOccurrenceSpecification)fragment;
            if (!mos.getMessage().getName().equals(upMos.getMessage().getName())) {
                return resList;
            }
            resList.add(fragment);
            --i;
        }
        return resList;
    }

    private ArrayList<MSDMessage> getMessageList(ArrayList<InteractionFragment> list) {
        ArrayList<MSDMessage> resList = new ArrayList<MSDMessage>();
        for (InteractionFragment frag : list) {
            MessageOccurrenceSpecification mos = (MessageOccurrenceSpecification)frag;
            resList.add(new MSDMessage(mos.getMessage(), this.coveredLifeLines));
        }
        return resList;
    }

    private boolean checkStaticUnificaiotn(InteractionFragment fragment, InteractionFragment upFragment, Lifeline line) {
        if (fragment instanceof MessageOccurrenceSpecification && upFragment instanceof MessageOccurrenceSpecification) {
            return this.checkOccurencesUnification((MessageOccurrenceSpecification)fragment, (MessageOccurrenceSpecification)upFragment, line);
        }
        if ((fragment instanceof StateInvariant || this.isFragmentAnAssert(fragment)) && (upFragment instanceof StateInvariant || this.isFragmentAnAssert(upFragment))) {
            return this.checkConstraintsUnification(fragment, upFragment, line);
        }
        return false;
    }

    private boolean checkOccurencesUnification(MessageOccurrenceSpecification downMOS, MessageOccurrenceSpecification upMOS, Lifeline line) {
        MSDMessage downMes = new MSDMessage(downMOS.getMessage(), this.coveredLifeLines);
        MSDMessage upMes = new MSDMessage(upMOS.getMessage(), this.coveredLifeLines);
        return downMes.checkUnificationWith(upMes, line);
    }

    private boolean checkConstraintsUnification(InteractionFragment fragment, InteractionFragment upFragment, Lifeline line) {
        boolean isHot = ModalProfileUtils.getTemperatureBooleanValue((NamedElement)fragment);
        boolean isExe = ModalProfileUtils.getExecutionBooleanValue((NamedElement)fragment);
        MSDConstraint downConstraint = new MSDConstraint(fragment, isExe, isHot);
        MSDConstraint upConstraint = new MSDConstraint(upFragment, isExe, isHot);
        return downConstraint.checkUnification(upConstraint, line);
    }

    private boolean checkConstraintsUnification(InteractionFragment fragment, InteractionFragment upFragment) {
        boolean isHot = ModalProfileUtils.getTemperatureBooleanValue((NamedElement)fragment);
        boolean isExe = ModalProfileUtils.getExecutionBooleanValue((NamedElement)fragment);
        MSDConstraint downConstraint = new MSDConstraint(fragment, isExe, isHot);
        MSDConstraint upConstraint = new MSDConstraint(upFragment, isExe, isHot);
        return downConstraint.checkUnification(upConstraint);
    }

    private InteractionFragment getLastInList(ArrayList<InteractionFragment> list) {
        return list.get(list.size() - 1);
    }

    ArrayList<InteractionFragmentKey> getFragmentsOrderedList() {
        return this.fragmentsOrderedList;
    }

    public HashSet<MSDMessage> getMessages() {
        return this.MUSDMessages;
    }

    public InteractionGraph getGraph() {
        return this.graph;
    }

    public HashMap<InteractionFragmentKey, MSDInteractionFragment> getInterKeyToInterFragments() {
        return this.interKeyToInterFragments;
    }

    public HashSet<MSDMessage> getExecutableMessages() {
        return this.executableMessages;
    }

    public HashSet<MSDConstraint> getConstraints() {
        return this.constraints;
    }

    public HashSet<MUSDArgument> getPrivateVariables() {
        return this.privateVariables;
    }

    public int getLoopFragmentId(MUSDCombinedFragment loopFragment) {
        Integer i = this.loopFragmentsMap.get(loopFragment);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public HashMap<MUSDCombinedFragment, Integer> getLoopFragmentsMap() {
        return this.loopFragmentsMap;
    }

    public boolean isTest() {
        return this.isTest;
    }
}

