/*
 * Decompiled with CFR 0.152.
 */
package msd.compiler.lib;

import java.util.HashMap;
import java.util.HashSet;
import msd.compiler.lib.MSDLifeline;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSDInteractionNode {
    private Interaction interaction;
    private HashMap<String, MSDInteractionNode> children;
    private HashMap<String, Integer> nextIndex;
    private HashSet<Lifeline> composedLines;

    public MSDInteractionNode(Interaction inter) {
        this.interaction = inter;
        this.composedLines = new HashSet();
        this.nextIndex = new HashMap();
        this.children = new HashMap();
        EList lifeLinesList = inter.getLifelines();
        for (Lifeline line : lifeLinesList) {
            this.nextIndex.put(MSDLifeline.getName(line), 0);
            if (line.getDecomposedAs() == null) {
                this.children.put(MSDLifeline.getName(line), null);
                continue;
            }
            this.composedLines.add(line);
            MSDInteractionNode child = new MSDInteractionNode(line.getDecomposedAs().getRefersTo());
            this.children.put(MSDLifeline.getName(line), child);
        }
    }

    public Interaction getInteraction() {
        return this.interaction;
    }

    public MSDInteractionNode getLineChildrenNode(Lifeline line) {
        return this.children.get(MSDLifeline.getName(line));
    }

    public boolean isComposedLine(Lifeline line) {
        return this.composedLines.contains(line);
    }

    public HashSet<Lifeline> getComposedLines() {
        return this.composedLines;
    }

    public void setNextDownIndex(Lifeline line, int val) {
        this.nextIndex.put(MSDLifeline.getName(line), val);
    }

    public int getNextDownIndex(Lifeline line) {
        return this.nextIndex.get(MSDLifeline.getName(line));
    }
}

