/*
 * Decompiled with CFR 0.152.
 */
package msd.compiler.stringutils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import msd.compiler.interaction2aspect.ImmidiateEventsTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeCutStringGen {
    private static final int MAX_CASE = 7;

    public static String getChangeCutForConstructors(String oldState, String TargetConstant, String newState, HashSet<String> finalStates, String varCheck, String varsSet, ImmidiateEventsTree tree, boolean first) {
        StringBuffer str = ChangeCutStringGen.getUnificationCheckingString(first);
        str.append(ChangeCutStringGen.getInstanceEquals(TargetConstant, "null")).append(varCheck).append(")");
        str.append(ChangeCutStringGen.getIsInCutString(oldState));
        str.append("\t\t\t\t\t\t").append(ChangeCutStringGen.getInstanceSetter(TargetConstant, "targetObject")).append(";\n");
        str.append(varsSet);
        str.append(ChangeCutStringGen.addBranchBody(newState, finalStates, tree));
        str.append("\t\t\t\t}\n");
        return str.toString();
    }

    public static String getChangeCutForSmallConstructorsSenderUnified(String newState, String sourceConstant, HashSet<String> finalStates) {
        StringBuffer str = new StringBuffer(100);
        str.append("\t\t\t\tif(");
        str.append(ChangeCutStringGen.getInstanceEquals(sourceConstant, "sourceObject")).append(")");
        str.append(ChangeCutStringGen.getIsInCutString(newState));
        str.append("\t\t\t\t\t\t");
        str.append(ChangeCutStringGen.getSetCut(newState));
        if (!finalStates.contains(newState)) {
            str.append("\t\t\t\t\t").append("\treturn;\n");
        } else {
            str.append("\t\t\t\t\t").append("\tbreak;\n");
        }
        str.append("\t\t\t\t\t}\n");
        return str.toString();
    }

    public static String getChangeCutForSmallConstructorsSenderNotUnified(String oldState, String sourceConstant, HashSet<String> finalStates) {
        StringBuffer str = new StringBuffer(100);
        str.append("\t\t\t\tif(");
        str.append("activeMSD").append(".isInCut(").append(oldState).append(")");
        str.append(")\n\t\t\t\t{\n\t\t\t\t\t");
        str.append(ChangeCutStringGen.getInstanceSetter(sourceConstant, "sourceObject"));
        str.append(";\n\t\t\t\t\t").append(ChangeCutStringGen.getSetCut(oldState));
        if (!finalStates.contains(oldState)) {
            str.append("\t\t\t\t\t").append("return;\n");
        } else {
            str.append("\t\t\t\t\t").append("\tbreak;\n");
        }
        return str.toString();
    }

    public static String getChangeCutForSrcAndTargetUni(String oldState, String sourceConstant, String TargetConstant, String newState, HashSet<String> finalStates, String varCheck, String varsSet, ImmidiateEventsTree tree, boolean first, String compositionCheck, String compositionSet) {
        StringBuffer str = ChangeCutStringGen.getUnificationCheckingString(first);
        if (!sourceConstant.equals("env")) {
            str.append(ChangeCutStringGen.getInstanceEquals(sourceConstant, "sourceObject")).append("\n\t\t\t\t\t&& ");
        }
        str.append(ChangeCutStringGen.getInstanceEquals(TargetConstant, "targetObject"));
        str.append(compositionCheck).append(varCheck).append(")");
        str.append(ChangeCutStringGen.getIsInCutString(oldState));
        str.append(varsSet).append(compositionSet);
        str.append(ChangeCutStringGen.addBranchBody(newState, finalStates, tree));
        return str.toString();
    }

    private static StringBuffer getIsInCutString(String oldState) {
        StringBuffer str = new StringBuffer(30);
        str.append("\n\t\t\t\t{\n");
        str.append("\t\t\t\t\t").append("unification=true;");
        str.append("\n\t\t\t\t\tif(").append("activeMSD").append(".isInCut(");
        str.append(oldState).append("))\n\t\t\t\t\t{\n");
        return str;
    }

    private static StringBuffer getUnificationCheckingString(boolean first) {
        StringBuffer str = new StringBuffer(100);
        String addition = first ? "\t\t\t\t" : "\t\t\t\t}\n\t\t\t\t";
        str.append(addition).append("if(");
        return str;
    }

    public static String getChangeCutForTargetUni(String oldState, String sourceConstant, String TargetConstant, String newState, HashSet<String> finalStates, String varCheck, String varsSet, ImmidiateEventsTree tree, boolean first, String compositionCheck, String compositionSet) {
        StringBuffer str = ChangeCutStringGen.getUnificationCheckingString(first);
        str.append(ChangeCutStringGen.getInstanceEquals(TargetConstant, "targetObject"));
        str.append("\n\t\t\t\t\t&& ").append(ChangeCutStringGen.getInstanceEquals(sourceConstant, "null"));
        str.append(compositionCheck).append(varCheck).append(")");
        str.append(ChangeCutStringGen.getIsInCutString(oldState));
        str.append("\t\t\t\t\t\t").append(ChangeCutStringGen.getInstanceSetter(sourceConstant, "sourceObject"));
        str.append(";\n");
        str.append(varsSet).append(compositionSet);
        str.append(ChangeCutStringGen.addBranchBody(newState, finalStates, tree));
        return str.toString();
    }

    public static String getChangeCutForSrcUni(String oldState, String sourceConstant, String TargetConstant, String newState, HashSet<String> finalStates, String varCheck, String varsSet, ImmidiateEventsTree tree, boolean first, String compositionCheck, String compositionSet) {
        StringBuffer str = ChangeCutStringGen.getUnificationCheckingString(first);
        if (!sourceConstant.equals("env")) {
            str.append(ChangeCutStringGen.getInstanceEquals(sourceConstant, "sourceObject")).append("\n\t\t\t\t\t&& ");
        }
        str.append(ChangeCutStringGen.getInstanceEquals(TargetConstant, "null"));
        str.append(compositionCheck).append(varCheck).append(")");
        str.append(ChangeCutStringGen.getIsInCutString(oldState));
        str.append("\t\t\t\t\t\t").append(ChangeCutStringGen.getInstanceSetter(TargetConstant, "targetObject")).append(";\n");
        str.append(varsSet).append(compositionSet);
        str.append(ChangeCutStringGen.addBranchBody(newState, finalStates, tree));
        return str.toString();
    }

    public static String getChangeCutNoBindings(String oldState, String sourceConstant, String TargetConstant, String newState, HashSet<String> finalStates, String varCheck, String varsSet, ImmidiateEventsTree tree, boolean first, String compositionCheck, String compositionSet) {
        StringBuffer str = ChangeCutStringGen.getUnificationCheckingString(first);
        str.append(ChangeCutStringGen.getInstanceEquals(TargetConstant, "null"));
        str.append("\n\t\t\t\t\t&& ").append(ChangeCutStringGen.getInstanceEquals(sourceConstant, "null"));
        str.append(compositionCheck).append(varCheck).append(")");
        str.append(ChangeCutStringGen.getIsInCutString(oldState));
        str.append("\t\t\t\t\t\t").append(ChangeCutStringGen.getInstanceSetter(TargetConstant, "targetObject")).append(";\n");
        if (!sourceConstant.equals(TargetConstant)) {
            str.append("\t\t\t\t\t\t").append(ChangeCutStringGen.getInstanceSetter(sourceConstant, "sourceObject")).append(";\n");
        }
        str.append(varsSet).append(compositionSet);
        str.append(ChangeCutStringGen.addBranchBody(newState, finalStates, tree));
        return str.toString();
    }

    public static String getVilationUnificationCheck(String sourceConstant, String targetConstant, String compositionCheck, String varCheck) {
        StringBuffer str = ChangeCutStringGen.getUnificationCheckingString(true);
        if (!sourceConstant.equals("env")) {
            str.append(ChangeCutStringGen.getInstanceEquals(sourceConstant, "sourceObject")).append("\n\t\t\t\t\t&& ");
        }
        str.append(ChangeCutStringGen.getInstanceEquals(targetConstant, "targetObject"));
        str.append(compositionCheck).append(varCheck).append(")");
        str.append("\n\t\t\t\t{\n\t\t\t\t\t").append("unification=true;");
        str.append("\n");
        return str.toString();
    }

    private static String addBranchBody(String newState, HashSet<String> finalStates, ImmidiateEventsTree tree) {
        StringBuffer str = new StringBuffer();
        StringBuffer ident = new StringBuffer("\t\t\t\t\t\t");
        if (!tree.isEmpty()) {
            str.append(ChangeCutStringGen.getTreeEvaluation(tree.getRoot(), ident, finalStates));
        } else {
            str.append("\t\t\t\t\t\t").append(ChangeCutStringGen.getSetCut(newState));
            if (!finalStates.contains(newState)) {
                str.append("\t\t\t\t\t").append("\treturn;\n");
            } else {
                str.append("\t\t\t\t\t").append("\tbreak;\n");
            }
        }
        str.append("\t\t\t\t\t}\n");
        return str.toString();
    }

    static String getTreeEvaluation(ImmidiateEventsTree.ImmidiateEventsTreeNode node, StringBuffer ident, HashSet<String> finalStates) {
        StringBuffer str = new StringBuffer(100);
        StringBuffer realIdent = new StringBuffer(ident);
        Iterator<ImmidiateEventsTree.ImmidiateEventsTreeNode> it = node.getChildren().iterator();
        ImmidiateEventsTree tree = node.getTree();
        int childNumber = 0;
        while (it.hasNext()) {
            ImmidiateEventsTree.ImmidiateEventsTreeNode child = it.next();
            int stringId = tree.getStringId(child.getId());
            String oldState = tree.getBeforeConstraintStates().get(child.getId());
            String newState = tree.getAfterConstraintStates().get(child.getId());
            if (childNumber == 0) {
                str.append(realIdent).append(ChangeCutStringGen.getSetCut(oldState));
            }
            str.append(ChangeCutStringGen.getConstraintExpressions(stringId, realIdent.toString()));
            str.append(realIdent).append("\t").append(ChangeCutStringGen.getSetCut(newState));
            str.append(ChangeCutStringGen.getTreeEvaluation(child, ident.append("\t"), finalStates));
            if (!child.hasChildren() && !finalStates.contains(newState)) {
                str.append(realIdent).append("\t").append("return;\n");
            } else if (finalStates.contains(newState)) {
                str.append(realIdent).append("\t").append("break;\n");
            }
            str.append(realIdent).append("}\n");
            if (child.isLastGuard()) {
                String cut = node.getNextCut();
                str.append(realIdent).append(ChangeCutStringGen.getSetCut(cut));
                if (!it.hasNext() && !finalStates.contains(cut)) {
                    str.append(realIdent).append("return;\n");
                } else if (finalStates.contains(cut)) {
                    str.append(realIdent).append("break;\n");
                }
            }
            if (!child.isGuard()) {
                str.append(realIdent).append("break;\n");
            }
            ++childNumber;
        }
        return str.toString();
    }

    private static String getSetCut(String newState) {
        StringBuffer str = new StringBuffer();
        str.append("activeMSD").append(".setCut(").append(newState).append(");\n");
        return str.toString();
    }

    private static String getConstraintExpressions(int id, String ident) {
        StringBuffer str = new StringBuffer();
        str.append(ident).append("if(").append("evaluateCondition");
        str.append("(").append(id).append(",").append("activeMSD");
        str.append("))\n").append(ident).append("{\n");
        return str.toString();
    }

    public static String generateEvaluateCondition(String inits, HashMap<Integer, String> condNumberToCondExpression, HashMap<String, ArrayList<Integer>> repetitionMap) {
        StringBuffer str = new StringBuffer(200);
        str.append("\t").append("@SuppressWarnings(\"unused\")");
        str.append("\n\tprivate boolean ").append("evaluateCondition");
        str.append("(int ").append("conditionNumber").append(",").append("ActiveMSDAspect");
        str.append(" ").append("activeMSD").append(")\n\t{\n");
        str.append(inits).append("\t\tswitch (").append("conditionNumber").append(")\n\t\t{\n");
        for (Integer i : condNumberToCondExpression.keySet()) {
            int count = 0;
            String expression = condNumberToCondExpression.get(i);
            str.append("\t\t\tcase ").append(i).append(": ");
            Iterator<Integer> repIt = repetitionMap.get(expression).iterator();
            while (repIt.hasNext()) {
                if (++count % 7 == 0) {
                    str.append("\n\t\t\t");
                }
                str.append("case ").append(repIt.next()).append(": ");
            }
            str.append("\n\t\t\t\treturn ");
            str.append(expression).append(";\n");
        }
        str.append("\t\t}\n\t\treturn false;\n\t}\n\n");
        return str.toString();
    }

    public static String generateChangeCutStateConstants() {
        StringBuffer str = new StringBuffer(300);
        str.append("\t// MSD Logic:\n");
        str.append("\tprotected void  changeActiveMSDCutState(int ").append("MSDm");
        str.append(", Object ").append("sourceObject").append(", Object ");
        str.append("targetObject").append(",").append("ActiveMSDAspect");
        str.append(" ").append("activeMSD").append(",\n");
        str.append("\t\tArrayList args)\n").append("\t{\n");
        str.append("\n\t\tboolean unification=false;");
        str.append("\n\t\tswitch (").append("MSDm").append(")\n\t\t{\n");
        return str.toString();
    }

    public static String generateChangeCutStateCloser() {
        StringBuffer str = new StringBuffer();
        str.append("\t\t\t}\n\t\tif(").append("activeMSD.checkViolation()");
        str.append(")\n\t\t\t").append("activeMSD");
        str.append(".completion();\n\t}\n\n");
        return str.toString();
    }

    public static String generateDoBindings(String inst, StringBuffer changeCutStateInits) {
        StringBuffer str = new StringBuffer(300);
        str.append("\n\t").append("@SuppressWarnings(\"unused\")").append("\n\t");
        str.append("protected void doBindings(ActiveMSDAspect activeMSD)\n").append("\t{\n");
        str.append(changeCutStateInits).append(inst).append("\t}\n\n");
        return str.toString();
    }

    public static String getLoopEvaluation(int id) {
        return "activeMSD.countLoop(" + id + ")";
    }

    static String getInstanceEquals(String cons, String obj) {
        return "activeMSD.instancesEquals(" + cons + "," + obj + ")";
    }

    static String getInstanceGetter(String constant) {
        return "activeMSD.getLineInstance(" + constant + ")";
    }

    static String getInstanceSetter(String constant, String obj) {
        return "activeMSD.setLineInstance(" + constant + "," + obj + ")";
    }

    public static String generateCheckSenderOwnerType(String type) {
        return "\n\t\t\t\t\t&& activeMSD.checkOwnerType(sourceObject," + type + ".class)";
    }

    public static String generateCheckSenderOwnerEqual(String ownerConstant) {
        return "\n\t\t\t\t\t&& activeMSD.ownerInstanceEqual(sourceObject," + ownerConstant + ")";
    }

    public static String generateCheckReceiverOwnerType(String type) {
        return "\n\t\t\t\t\t&& activeMSD.checkOwnerType(targetObject," + type + ".class)";
    }

    public static String generateCheckReceiverOwnerEqual(String ownerConstant) {
        return "\n\t\t\t\t\t&& activeMSD.ownerInstanceEqual(targetObject," + ownerConstant + ")";
    }

    public static String checkEqualsOwners() {
        return "\n\t\t\t\t\t&& activeMSD.checkEqualOwners(sourceObject,targetObject)";
    }

    public static String generateSenderOwnerSet(String bindingConstant) {
        return "\t\t\t\t\t\tactiveMSD.setLineInstance(" + bindingConstant + ",(" + "(IPart)" + "sourceObject" + ")" + ".getOwner()" + ");\n";
    }

    public static String generateReceiverOwnerSet(String bindingConstant) {
        return "\t\t\t\t\t\tactiveMSD.setLineInstance(" + bindingConstant + ",(" + "(IPart)" + "targetObject" + ")" + ".getOwner()" + ");\n";
    }
}

