/*
 * Decompiled with CFR 0.152.
 */
package msd.compiler.stringutils;

import java.util.ArrayList;
import java.util.Iterator;
import msd.compiler.stringutils.MUSDAspectStringGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinatorStringGen {
    public static String generateDeclaration(String coordinatoImplClass) {
        StringBuffer str = new StringBuffer(100);
        str.append("import ").append("msd.runtime.lib");
        str.append(".*;\n\n\n").append("public aspect ").append("MSDCoordinatorAspect");
        str.append("\n{\n\tdeclare precedence: ").append("MSDCoordinatorAspect").append(", *;\n\t");
        str.append("ICoordinatorStrategy").append(" ").append("strategy").append(" = new ");
        str.append(coordinatoImplClass).append("();\n\n");
        str.append("\tprivate boolean lock = false;\n\tprivate int counter = 0;\n\n");
        return str.toString();
    }

    public static String generateCoordinatorPointCutDecleration() {
        return "\tpointcut MSDMessage():";
    }

    public static String generateWrapper(String thisType, String targetType, String methodName, ArrayList<String> argsNames, ArrayList<String> argsTypes, String returnType) {
        StringBuffer str = new StringBuffer(100);
        if (returnType == null || returnType == "") {
            returnType = "void";
        }
        str.append(CoordinatorStringGen.generateWrapperOppenning(thisType, targetType, methodName, argsNames, argsTypes, returnType));
        if (!returnType.equals("void")) {
            str.append("return ");
        }
        str.append(MUSDAspectStringGen.toSmall(targetType)).append(".").append(methodName);
        str.append("(");
        str.append(CoordinatorStringGen.generateWrapperClosing(argsNames));
        return str.toString();
    }

    public static String generateConstructorWrapper(String thisType, String targetType, String methodName, ArrayList<String> argsNames, ArrayList<String> argsTypes) {
        StringBuffer str = new StringBuffer(100);
        str.append(CoordinatorStringGen.generateWrapperOppenning(thisType, targetType, methodName, argsNames, argsTypes, "void"));
        str.append(MUSDAspectStringGen.toSmall("new")).append(" ");
        str.append(targetType).append("(");
        str.append(CoordinatorStringGen.generateWrapperClosing(argsNames));
        return str.toString();
    }

    private static String generateWrapperOppenning(String thisType, String targetType, String methodName, ArrayList<String> argsNames, ArrayList<String> argsTypes, String returnType) {
        StringBuffer str = new StringBuffer(100);
        str.append("\tpublic ").append(returnType).append(" ");
        if (!thisType.equals("env")) {
            str.append(thisType).append(".");
        }
        str.append("Wrapper").append(methodName);
        str.append("(").append(targetType).append(" ").append(MUSDAspectStringGen.toSmall(targetType));
        Iterator<String> it = argsNames.iterator();
        Iterator<String> itType = argsTypes.iterator();
        while (it.hasNext()) {
            str.append(",").append(itType.next());
            str.append(" ").append(it.next());
        }
        str.append(")\n\t{\n\t\t");
        return str.toString();
    }

    private static String generateWrapperClosing(ArrayList<String> argsNames) {
        StringBuffer str = new StringBuffer(50);
        Iterator<String> it = argsNames.iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (!first) {
                str.append(",");
            }
            first = false;
            str.append(it.next());
        }
        str.append(");\n\t}\n\n");
        return str.toString();
    }

    public static String generateCoordinatorAfter() {
        StringBuffer str = new StringBuffer(80);
        str.append("\tafter (): ").append("MSDMessage").append("()\n\t{\n");
        str.append("\t\tMSDAspect.handlingEvent(thisJoinPoint);\n");
        str.append("\t\tcoordinate();\n");
        str.append("\t}\n\n");
        str.append("\tprivate void coordinate()\n\t{\n\t\tif (lock)\n\t\t{\n\t\t\tcounter++;\n\t\t\treturn;\n\t\t}\n\t\telse\n\t\t{\n\t\t\tlock = true;\n\t\t\tafterImpl();\n\t\t\tlock = false;\n\t\t}\n\t\tif(counter>0)\n\t\t{\n\t\t\tcounter--;\n\t\t\tcoordinate();\n\t\t}\n\t}\n\n");
        str.append("\tprivate void afterImpl() \n\t{\n");
        str.append(CoordinatorStringGen.getMethodSetInit("monitoringEnabled"));
        str.append(CoordinatorStringGen.getMethodSetInit("executingEnabled"));
        str.append(CoordinatorStringGen.getMethodSetInit("coldViolation"));
        str.append(CoordinatorStringGen.getMethodSetInit("hotViolation"));
        str.append("\n");
        return str.toString();
    }

    public static String generateCoordinatorGetCutState(String aspectName) {
        StringBuffer str = new StringBuffer(80);
        str.append("\t\t").append(aspectName).append(".aspectOf().getCutState");
        str.append(CoordinatorStringGen.getMethodSets()).append(";\n");
        return str.toString();
    }

    public static String generateCoordinatorAfterSwitch() {
        StringBuffer str = new StringBuffer(50);
        str.append("\n\t\t").append("MSDMethod").append(" ").append("MSDm");
        str.append(" = ").append("strategy").append(".").append("chooseMethod");
        str.append(CoordinatorStringGen.getMethodSets()).append(";\n\n").append("\t\tif(").append("MSDm");
        str.append(" != null)\n\t\t{\n\t\t\tswitch (").append("MSDm").append(".");
        str.append("messageID").append(")\n\t\t\t{\n");
        return str.toString();
    }

    public static String generateCoordinatorCase(String thisType, String targetType, String methodName, ArrayList<String> argsType) {
        StringBuffer str = new StringBuffer(100);
        String methodConst = MUSDAspectStringGen.createMethodConstant(thisType, targetType, methodName);
        str.append("\t\t\t\tcase ").append(methodConst).append(":\n");
        str.append("\t\t\t\t ");
        if (!thisType.equals("env")) {
            str.append("((").append(MUSDAspectStringGen.upgradePrimitiveTypes(thisType));
            str.append(")").append("MSDm");
            str.append(".").append("sourceInstance").append(").");
        }
        str.append("Wrapper").append(methodName);
        str.append("(\n\t\t\t\t\t(").append(MUSDAspectStringGen.upgradePrimitiveTypes(targetType)).append(")");
        str.append("MSDm").append(".").append("targetInstance");
        Iterator<String> it = argsType.iterator();
        int i = 0;
        while (it.hasNext()) {
            str.append("\n\t\t\t\t\t");
            str.append(",(").append(MUSDAspectStringGen.upgradePrimitiveTypes(it.next())).append(")");
            str.append("MSDm").append(".").append("args.get(");
            str.append(i).append(")");
            ++i;
        }
        str.append(");\n\t\t\t\tbreak;\n");
        return str.toString();
    }

    public static String generateCoordinatorCloser() {
        return "\t\t\t}\n\t\t}\n\t}\n}\n";
    }

    private static String getMethodSetInit(String kind) {
        StringBuffer str = new StringBuffer(80);
        str.append("\t\t").append("MSDMethodSet").append(" ");
        str.append(kind).append(" = new ");
        str.append("MSDMethodSet").append("();\n");
        return str.toString();
    }

    private static String getMethodSets() {
        StringBuffer str = new StringBuffer(80);
        str.append("(");
        str.append("monitoringEnabled").append(", ");
        str.append("executingEnabled").append(", ");
        str.append("coldViolation").append(", ");
        str.append("hotViolation").append(")");
        return str.toString();
    }
}

