/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.examples.rssnewsticker;

import il.ac.wis.cs.s2a.examples.rssnewsticker.NewsTickerApp;
import il.ac.wis.cs.s2a.examples.rssnewsticker.rssutils.RSSItem;
import il.ac.wis.cs.s2a.examples.rssnewsticker.rssutils.RSSList;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import javax.swing.JPanel;

public abstract class RSSDisplay
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    static final int MAX_SIZE = 100;
    static final Cursor HAND = new Cursor(12);
    static final Cursor DEFAULT = new Cursor(0);
    static final int WIDTH = 500;
    static final int HEIGHT = 25;
    String browserPath = NewsTickerApp.browserPath;
    int xx;
    int ntext;
    int text_width;
    int fontsize;
    int mouse_x;
    int mouse_y;
    int selected;
    String[] captions = new String[100];
    String[] url = new String[100];
    Font font;
    FontMetrics fm;
    Color fgcolor;
    Color bgcolor;
    Color accolor;
    Image offscrImg;
    Graphics offscr;

    public RSSDisplay() {
        this.fontsize = this.getFont().getSize();
        this.fgcolor = Color.white;
        this.bgcolor = Color.black;
        this.accolor = Color.green;
        this.font = new Font("Times Roman", 0, 12);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setCaptions(RSSList list) {
        this.offscrImg = this.createImage(this.getWidth(), this.getHeight());
        this.offscr = this.offscrImg.getGraphics();
        this.fm = this.offscr.getFontMetrics(this.font);
        this.xx = 0;
        this.text_width = 0;
        this.ntext = 0;
        Iterator<RSSItem> it = list.getIterator();
        while (it.hasNext()) {
            RSSItem item = it.next();
            this.captions[this.ntext] = item.getTitle();
            this.url[this.ntext] = item.getLink().toString();
            this.text_width += this.fm.stringWidth(this.captions[this.ntext]) + 20;
            ++this.ntext;
        }
        this.mouse_x = this.mouse_y = -this.text_width;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void move() {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (arg0.getButton() == 3) {
            return;
        }
        if (this.selected != -1 && this.url[this.selected] != null) {
            try {
                String[] cmd = new String[]{this.browserPath, this.url[this.selected]};
                Runtime.getRuntime().exec(cmd);
            }
            catch (Exception e) {
                System.out.println(e.toString());
                System.out.println(e.getMessage());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.mouse_x = evt.getX();
        this.mouse_y = evt.getY();
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.mouse_x = evt.getX();
        this.mouse_y = evt.getY();
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.mouse_x = evt.getX();
        this.mouse_y = evt.getY();
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.mouse_x = arg0.getX();
        this.mouse_y = arg0.getY();
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.mouse_x = arg0.getX();
        this.mouse_y = arg0.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouse_x = e.getX();
        this.mouse_y = e.getY();
    }
}

