/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.examples.rssnewsticker.rssutils;

import il.ac.wis.cs.s2a.examples.rssnewsticker.rssutils.RSSItem;
import il.ac.wis.cs.s2a.examples.rssnewsticker.rssutils.RSSList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;

public class RSSParser {
    public static RSSList getRSSItemList(String address) {
        ArrayList<String> lineList = new ArrayList<String>();
        RSSList resultList = null;
        try {
            String line;
            URL url = new URL(address);
            URLConnection c = url.openConnection();
            c.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(c.getInputStream()));
            while ((line = reader.readLine()) != null) {
                lineList.add(line);
            }
            lineList.trimToSize();
            resultList = RSSParser.parseFeed(lineList);
        }
        catch (MalformedURLException e) {
            System.err.println("Malformed URL Error: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("IO Error: " + e.getMessage());
        }
        return resultList;
    }

    static RSSList parseFeed(ArrayList<String> lineList) throws IOException {
        RSSList outputList = new RSSList();
        boolean title = false;
        boolean isItem = false;
        boolean firstItem = false;
        Iterator<String> it = lineList.iterator();
        String item = "";
        while (it.hasNext()) {
            String line = it.next();
            if (isItem || line.toLowerCase().contains("<item>")) {
                firstItem = true;
                isItem = true;
                int closeIndex = line.toLowerCase().indexOf("</item>");
                if (closeIndex >= 0) {
                    item = String.valueOf(item) + line.substring(0, closeIndex);
                    line = line.substring(closeIndex + 1);
                    isItem = false;
                    outputList.add(RSSItem.parseItem(item.trim()));
                    item = "";
                    continue;
                }
                isItem = true;
                item = String.valueOf(item) + line;
                continue;
            }
            if (firstItem || title || !line.toLowerCase().contains("<title>")) continue;
            int begin = line.toLowerCase().indexOf("<title>");
            int end = line.toLowerCase().indexOf("</title>");
            if (begin < 0 || end < 0) {
                throw new IOException("Error parsing title of the RSS feed");
            }
            String currentTitle = line.substring(begin + 7, end).replace("|", "#");
            outputList.setTitle(currentTitle);
            title = true;
        }
        return outputList;
    }
}

