/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.examples.phonebook.model;

import il.ac.wis.cs.s2a.examples.phonebook.model.PhoneBookModel;
import il.ac.wis.cs.s2a.runtime.lib.IPart;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class DBConnector
implements IPart {
    private String searchResult = null;
    private Hashtable<String, String> phoneBook = null;
    private String name;
    private PhoneBookModel owner;
    private static final String RECORD_FILE = "resources\\phoneBook.txt";
    private static final String RECORD_SEPARATOR = "_|_";

    DBConnector(PhoneBookModel model) {
        this.owner = model;
        this.phoneBook = new Hashtable();
        this.readRecords();
    }

    public void addAnEntry(String number) {
        this.phoneBook.put(this.name, number);
    }

    public void searchPhoneNumber(String name) {
        this.searchResult = this.phoneBook.get(name);
    }

    public String getSearchResult() {
        return this.searchResult;
    }

    private void readRecords() {
        try {
            File recordFile = new File(RECORD_FILE);
            if (!recordFile.createNewFile()) {
                BufferedReader in = new BufferedReader(new FileReader(recordFile));
                String record = in.readLine();
                while (record != null && record.length() != 0) {
                    int separatorIndex = record.indexOf(RECORD_SEPARATOR);
                    if (separatorIndex != -1) {
                        String name = record.substring(0, separatorIndex);
                        String number = record.substring(separatorIndex + RECORD_SEPARATOR.length());
                        this.phoneBook.put(name, number);
                    }
                    record = in.readLine();
                }
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeRecords() {
        try {
            FileOutputStream out = new FileOutputStream(RECORD_FILE);
            PrintStream p = new PrintStream(out);
            Enumeration<String> e = this.phoneBook.keys();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                String number = this.phoneBook.get(name);
                String newRecord = String.valueOf(name) + RECORD_SEPARATOR + number;
                p.println(newRecord);
            }
            p.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveAll() {
        this.writeRecords();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    public void standBy() {
        System.out.println("data base is standingBy");
    }

    public void closeConnection() {
        System.out.println("data base is closed");
    }
}

