/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.runtime.lib;

import il.ac.wis.cs.s2a.runtime.lib.MSDAspect;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;

@Aspect
public class MSDMonitor {
    private static final String PROPERTIES_FILE_NAME = "resources/musdmonitor.properties";
    private static final String MONITOR_LEVEL = "monitorLevel";
    private static final String MONITOR_OUTPUT = "monitorOutput";
    private static final String TO_MONITOR_INTERACTIONS = "interactions";
    private static final String APPEND = "append";
    private static final String HOT = "Hot";
    private static final String COLD = "Cold";
    private static final String VIOLATION = "Violation";
    private static final String COMPLETION = "Completion";
    private static int monitorLevel;
    private static long eventNumber;
    private static String monitorOutput;
    private static PrintWriter out;
    private static String[] toMonitorInterations;
    private static boolean append;
    private static boolean eventFlag;
    private static ArrayList<String> cutStrings;
    private static ArrayList<String> bindingStrings;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MSDMonitor ajc$perSingletonInstance;

    static {
        try {
            monitorLevel = 0;
            eventNumber = 0L;
            append = true;
            eventFlag = false;
            bindingStrings = new ArrayList();
            MSDMonitor.ajc$perSingletonInstance = new MSDMonitor();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    MSDMonitor() {
        File file = new File(PROPERTIES_FILE_NAME);
        if (file.isFile()) {
            Properties properties = new Properties();
            try {
                FileInputStream in = new FileInputStream(PROPERTIES_FILE_NAME);
                properties.load(in);
                monitorLevel = Integer.parseInt(properties.getProperty(MONITOR_LEVEL));
                monitorOutput = properties.getProperty(MONITOR_OUTPUT);
                toMonitorInterations = properties.getProperty(TO_MONITOR_INTERACTIONS).split(";");
                String appendString = properties.getProperty(APPEND);
                if (appendString != null && appendString.trim().equals("false")) {
                    append = false;
                }
                out = new PrintWriter(new FileWriter(monitorOutput, append));
            }
            catch (NumberFormatException e) {
                monitorLevel = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isInteractionLogged(String interName) {
        if (toMonitorInterations == null || toMonitorInterations.length == 0) {
            return false;
        }
        if (toMonitorInterations[0].equals("*")) {
            return true;
        }
        String s = this.getInteractionName(interName);
        int i = 0;
        while (i < toMonitorInterations.length) {
            if (toMonitorInterations[i].trim().equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getInteractionName(String name) {
        int last = name.lastIndexOf(".");
        if (last == -1) {
            return name;
        }
        return name.substring(last + ".MUSDAspect".length() - 1);
    }

    @Pointcut(value="(execution(il.ac.wis.cs.s2a.runtime.lib.MSDAspect.new(..)) && (target(musdAspect) && if(void java.lang.Object.if_())))", argNames="musdAspect")
    /* synthetic */ void ajc$pointcut$$aspectStaticCreation$bcb(MSDAspect musdAspect) {
    }

    @After(value="aspectStaticCreation(musdAspect)", argNames="musdAspect")
    public void ajc$after$il_ac_wis_cs_s2a_runtime_lib_MSDMonitor$1$cd0c23d5(MSDAspect musdAspect) {
        String name = musdAspect.getClass().getName();
        if (this.isInteractionLogged(name)) {
            // empty if block
        }
    }

    @Pointcut(value="(execution(il.ac.wis.cs.s2a.runtime.lib.MSDAspect$ActiveMSDAspect.new(..)) && (target(activeMUSD) && if(void java.lang.Object.if_())))", argNames="activeMUSD")
    /* synthetic */ void ajc$pointcut$$activeAspectCreation$d37(MSDAspect.ActiveMSDAspect activeMUSD) {
    }

    @After(value="activeAspectCreation(activeMUSD)", argNames="activeMUSD")
    public void ajc$after$il_ac_wis_cs_s2a_runtime_lib_MSDMonitor$2$6c8c455f(MSDAspect.ActiveMSDAspect activeMUSD, JoinPoint thisJoinPoint) {
        String name = activeMUSD.getOwner().getClass().getName();
        if (this.isInteractionLogged(name)) {
            Integer num = (Integer)thisJoinPoint.getArgs()[1];
            long id = activeMUSD.getId();
            StringBuffer str = new StringBuffer();
            str.append(name).append("[").append(id).append("] (0");
            int i = 1;
            while (i < num) {
                str.append(",0");
                ++i;
            }
            str.append(")");
        }
    }

    @Pointcut(value="(execution(void il.ac.wis.cs.s2a.runtime.lib.MSDAspect$ActiveMSDAspect._setCut(..)) && (args(setLocations) && (target(activeMUSD) && if(void java.lang.Object.if_()))))", argNames="setLocations,activeMUSD")
    /* synthetic */ void ajc$pointcut$$setCut$1009(ArrayList<Integer> setLocations, MSDAspect.ActiveMSDAspect activeMUSD) {
    }

    @After(value="setCut(setLocations, activeMUSD)", argNames="setLocations,activeMUSD")
    public void ajc$after$il_ac_wis_cs_s2a_runtime_lib_MSDMonitor$3$efca0fd2(ArrayList<Integer> setLocations, MSDAspect.ActiveMSDAspect activeMUSD) {
        boolean isHot = activeMUSD.getOwner().isHotCut(setLocations);
        String name = activeMUSD.getOwner().getClass().getName();
        if (this.isInteractionLogged(name)) {
            if (!eventFlag) {
                cutStrings = new ArrayList();
                cutStrings.addAll(bindingStrings);
                bindingStrings = new ArrayList();
                ++eventNumber;
                eventFlag = true;
            }
            long id = activeMUSD.getId();
            StringBuffer str = new StringBuffer();
            Iterator<Integer> it = setLocations.iterator();
            str.append(name).append("[").append(id).append("] (");
            boolean first = true;
            while (it.hasNext()) {
                if (first) {
                    str.append(it.next());
                } else {
                    str.append(",").append(it.next());
                }
                first = false;
            }
            String mode = isHot ? HOT : COLD;
            str.append(") ").append(mode);
            this.outChangeCut(str.toString());
        }
    }

    @Pointcut(value="(execution(void il.ac.wis.cs.s2a.runtime.lib.MSDAspect$ActiveMSDAspect.completion()) && (target(activeMUSD) && if(void java.lang.Object.if_())))", argNames="activeMUSD")
    /* synthetic */ void ajc$pointcut$$activeCompleted$14c1(MSDAspect.ActiveMSDAspect activeMUSD) {
    }

    @After(value="activeCompleted(activeMUSD)", argNames="activeMUSD")
    public void ajc$after$il_ac_wis_cs_s2a_runtime_lib_MSDMonitor$4$3cd82f47(MSDAspect.ActiveMSDAspect activeMUSD) {
        boolean isViolation;
        String name = activeMUSD.getOwner().getClass().getName();
        boolean bl = isViolation = !activeMUSD.isCurrentCutLast();
        if (this.isInteractionLogged(name)) {
            long id = activeMUSD.getId();
            StringBuffer str = new StringBuffer();
            String exitMode = isViolation ? VIOLATION : COMPLETION;
            str.append(name).append("[").append(id).append("] " + exitMode);
            this.outCompletion(str.toString());
        }
    }

    @Pointcut(value="(execution(void il.ac.wis.cs.s2a.runtime.lib.MSDAspect.handlingEvent(..)) && args(joinPoint))", argNames="joinPoint")
    /* synthetic */ void ajc$pointcut$$eventFlag$1758(JoinPoint joinPoint) {
    }

    @After(value="eventFlag(joinPoint)", argNames="joinPoint")
    public void ajc$after$il_ac_wis_cs_s2a_runtime_lib_MSDMonitor$5$88a0efa5(JoinPoint joinPoint) {
        if (eventFlag) {
            Object[] args;
            out.print("E: " + System.currentTimeMillis() + " " + eventNumber + ": " + joinPoint.getSignature().toString() + " ");
            Object[] objectArray = args = joinPoint.getArgs();
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                out.print(obj + " ");
                ++n2;
            }
            out.println();
            for (String str : cutStrings) {
                out.println(str);
            }
            out.flush();
            eventFlag = false;
        }
    }

    @Pointcut(value="(execution(void setLineInstance(..)) && (args(index, lifeline) && target(activeMSD)))", argNames="index,lifeline,activeMSD")
    /* synthetic */ void ajc$pointcut$$binding$1975(Object index, Object lifeline, MSDAspect.ActiveMSDAspect activeMSD) {
    }

    @Around(value="binding(_index, lifeline, activeMSD)", argNames="_index,lifeline,activeMSD,ajc$aroundClosure")
    public void ajc$around$il_ac_wis_cs_s2a_runtime_lib_MSDMonitor$6$ad9778bf(Object _index, Object lifeline, MSDAspect.ActiveMSDAspect activeMSD, AroundClosure ajc$aroundClosure) {
        int index = (Integer)_index;
        String name = activeMSD.getOwner().getClass().getName();
        long id = activeMSD.getId();
        boolean firstBindingFlag = activeMSD.instancesEquals(index, null);
        object2 = Conversions.voidValue((Object)ajc$aroundClosure.run(new Object[]{_index, lifeline, activeMSD}));
        if (this.isInteractionLogged(name) && firstBindingFlag && lifeline != null) {
            StringBuffer str = new StringBuffer();
            index = (Integer)_index;
            str.append(name).append("[").append(id).append("] ");
            str.append("lifeline " + index + " <- " + lifeline);
            this.outBindings(str.toString());
        }
    }

    private void outChangeCut(String s) {
        StringBuffer str = new StringBuffer();
        str.append("C: " + s);
        cutStrings.add(str.toString());
    }

    private void outCompletion(String s) {
        StringBuffer str = new StringBuffer();
        str.append("F: " + s);
        cutStrings.add(str.toString());
    }

    private void outBindings(String s) {
        StringBuffer str = new StringBuffer();
        str.append("B: " + s);
        bindingStrings.add(str.toString());
    }

    public static final boolean ajc$if_32(MSDAspect musdAspect) {
        return monitorLevel > 0;
    }

    public static final boolean ajc$if_33(MSDAspect.ActiveMSDAspect activeMUSD) {
        return monitorLevel > 0;
    }

    public static final boolean ajc$if_34(ArrayList<Integer> setLocations, MSDAspect.ActiveMSDAspect activeMUSD) {
        return monitorLevel > 0;
    }

    public static final boolean ajc$if_35(MSDAspect.ActiveMSDAspect activeMUSD) {
        return monitorLevel > 0;
    }

    public static MSDMonitor aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("il_ac_wis_cs_s2a_runtime_lib_MSDMonitor", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

