/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.common.log;

import il.ac.wis.cs.common.Utils;
import il.ac.wis.cs.common.log.PerformanceLevel;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.xml.DOMConfigurator;

public class Logger
extends org.apache.log4j.Logger {
    private static boolean configurationLoaded = false;

    public Logger(String name) {
        super(name);
    }

    public void performanceInfo(String message) {
        if (this.repository.isDisabled(39990)) {
            return;
        }
        if (PerformanceLevel.PERFORMANCE.isGreaterOrEqual((Priority)this.getEffectiveLevel())) {
            this.forcedLog(Category.class.getName(), (Priority)PerformanceLevel.PERFORMANCE, message, null);
        }
    }

    public static Logger getLocalLogger(Class cls) {
        Logger.loadLogConfiguration();
        LoggerFactory factory = new LoggerFactory(){

            public org.apache.log4j.Logger makeNewLoggerInstance(String name) {
                return new Logger(name);
            }
        };
        return (Logger)org.apache.log4j.Logger.getLogger((String)cls.toString(), (LoggerFactory)factory);
    }

    public static void loadLogConfiguration() {
        if (configurationLoaded) {
            return;
        }
        Properties properties = new Properties();
        try {
            FileInputStream in = new FileInputStream(Utils.getPropertiesFilePath());
            properties.load(in);
            DOMConfigurator.configure((String)properties.getProperty(Utils.getLogConfigPropertyName()));
            in.close();
            configurationLoaded = true;
        }
        catch (IOException e) {
            System.out.println("Could not read properties file " + Utils.getPropertiesFilePath() + ". Make sure there is a proper properties" + " file in the working directory");
        }
    }

    public static boolean isConfigurationLoaded() {
        return configurationLoaded;
    }
}

