/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.common.uml2;

import il.ac.wis.cs.common.log.Logger;
import il.ac.wis.cs.common.uml2.UML2AdvancedOperations;
import il.ac.wis.cs.common.uml2.UML2ProfileOperations;
import org.eclipse.emf.common.util.URI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class ProfileModalImp
extends UML2ProfileOperations {
    static Logger logger = Logger.getLocalLogger(ProfileModalImp.class);
    public static final String PROFILE_NAME = "modal";
    public static final String MODAL_STEREOTYPE_NAME = "Modes";
    public static final String LIFELINE_MODAL_STEREOTYPE_NAME = "LifeLineModes";
    public static final String TESTING_STEREOTYPE_NAME = "TestModes";
    public static final String MODAL_STEREOTYPE_FULLNAME = "modal::Modes";
    public static final String LIFELINE_MODAL_STEREOTYPE_FULLNAME = "modal::LifeLineModes";
    public static final String TESTING_STEREOTYPE_NAME_FULLNAME = "modal::TestModes";
    public static final String TEMERATURE_ENUMERATION_NAME = "TemperatureKind";
    public static final String EXECUTION_ENUMERATION_NAME = "ExecutionKind";
    public static final String COLD_LITERAL_NAME = "Cold";
    public static final String HOT_LITERAL_NAME = "Hot";
    public static final String MONITORED_LITERAL_NAME = "Monitored";
    public static final String EXECUTE_LITERAL_NAME = "Execute";
    public static final String TEMPERATURE_PROPERTY_NAME = "temperature";
    public static final String EXECUTION_PROPERTY_NAME = "execution";
    public static final String ENVIRONMENT_PROPERTY_NAME = "isEnvironment";
    public static final String SYSTEM_PROPERTY_NAME = "isSystem";
    public static final String TESTING_PROPERTY_NAME = "isTesting";
    public static final String PROFILE_FILE_NAME = "msdprofileV4.0";

    public static Profile createMUSDProfile() {
        Profile modalProfile = ProfileModalImp.createProfile(PROFILE_NAME);
        PrimitiveType booleanPrimitiveType = ProfileModalImp.importPrimitiveType((Package)modalProfile, "Boolean");
        Enumeration temperatureEnumeration = UML2AdvancedOperations.createEnumeration((Package)modalProfile, TEMERATURE_ENUMERATION_NAME);
        Enumeration monitorEnumeration = UML2AdvancedOperations.createEnumeration((Package)modalProfile, EXECUTION_ENUMERATION_NAME);
        EnumerationLiteral cold = UML2AdvancedOperations.createEnumerationLiteral(temperatureEnumeration, COLD_LITERAL_NAME);
        UML2AdvancedOperations.createEnumerationLiteral(temperatureEnumeration, HOT_LITERAL_NAME);
        EnumerationLiteral monitor = UML2AdvancedOperations.createEnumerationLiteral(monitorEnumeration, MONITORED_LITERAL_NAME);
        UML2AdvancedOperations.createEnumerationLiteral(monitorEnumeration, EXECUTE_LITERAL_NAME);
        Stereotype modalStereotype = ProfileModalImp.createStereotype(modalProfile, MODAL_STEREOTYPE_NAME, false);
        Stereotype lifeLineStereotype = ProfileModalImp.createStereotype(modalProfile, LIFELINE_MODAL_STEREOTYPE_NAME, false);
        Stereotype testStereotype = ProfileModalImp.createStereotype(modalProfile, TESTING_STEREOTYPE_NAME, false);
        Property temperatureProperty = UML2AdvancedOperations.createAttribute((Class)modalStereotype, TEMPERATURE_PROPERTY_NAME, (Type)temperatureEnumeration, 1, 1);
        Property monitoredProperty = UML2AdvancedOperations.createAttribute((Class)modalStereotype, EXECUTION_PROPERTY_NAME, (Type)monitorEnumeration, 1, 1);
        temperatureProperty.setDefaultValue(cold.getSpecification());
        monitoredProperty.setDefaultValue(monitor.getSpecification());
        Property environmentProperty = UML2AdvancedOperations.createAttribute((Class)lifeLineStereotype, ENVIRONMENT_PROPERTY_NAME, (Type)booleanPrimitiveType, 1, 1);
        Property systemProperty = UML2AdvancedOperations.createAttribute((Class)lifeLineStereotype, SYSTEM_PROPERTY_NAME, (Type)booleanPrimitiveType, 1, 1);
        environmentProperty.setBooleanDefaultValue(Boolean.FALSE.booleanValue());
        systemProperty.setBooleanDefaultValue(Boolean.FALSE.booleanValue());
        Property testingProperty = UML2AdvancedOperations.createAttribute((Class)testStereotype, TESTING_PROPERTY_NAME, (Type)booleanPrimitiveType, 1, 1);
        testingProperty.setBooleanDefaultValue(Boolean.FALSE.booleanValue());
        Class interactionFragmentMetaclass = ProfileModalImp.referenceMetaclass(modalProfile, UMLPackage.Literals.INTERACTION_FRAGMENT.getName());
        Class messageMetaClass = ProfileModalImp.referenceMetaclass(modalProfile, UMLPackage.Literals.MESSAGE.getName());
        Class lifeLineMetaClass = ProfileModalImp.referenceMetaclass(modalProfile, UMLPackage.Literals.LIFELINE.getName());
        Class interactionMetaClass = ProfileModalImp.referenceMetaclass(modalProfile, UMLPackage.Literals.INTERACTION.getName());
        Class behavioredClassifierMetaClass = ProfileModalImp.referenceMetaclass(modalProfile, UMLPackage.Literals.BEHAVIORED_CLASSIFIER.getName());
        ProfileModalImp.createExtension(interactionFragmentMetaclass, modalStereotype, true);
        ProfileModalImp.createExtension(messageMetaClass, modalStereotype, true);
        ProfileModalImp.createExtension(lifeLineMetaClass, lifeLineStereotype, true);
        ProfileModalImp.createExtension(interactionMetaClass, testStereotype, true);
        ProfileModalImp.createExtension(behavioredClassifierMetaClass, testStereotype, true);
        ProfileModalImp.defineProfile(modalProfile);
        return modalProfile;
    }

    public static void main(String[] args) {
        ProfileModalImp.registerResourceFactories();
        ProfileModalImp.registerPathmaps(URI.createURI((String)args[0]));
        logger.info("Creating profile...");
        Profile modalProfile = ProfileModalImp.createMUSDProfile();
        logger.info("Saving profile...");
        ProfileModalImp.save((Package)modalProfile, URI.createURI((String)"").appendSegment(PROFILE_FILE_NAME).appendFileExtension("profile.uml"));
    }
}

