/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.examples.rssnewsticker.rssutils;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class RSSItem {
    private String title;
    private URL link;
    private String description;
    private Date time;

    public RSSItem(URL link, String title, String description, Date time) {
        this.title = title;
        this.link = link;
        this.description = description;
        this.time = time;
    }

    public String getTitle() {
        return this.title;
    }

    public URL getLink() {
        return this.link;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getTimestamp() {
        return this.time;
    }

    static RSSItem parseItem(String item) {
        RSSItem parsedItem = null;
        try {
            Date timestamp = null;
            String lowerCase = item.toLowerCase();
            int beginTag = lowerCase.indexOf("<title>");
            int endTag = lowerCase.indexOf("</title>");
            String title = item.substring(beginTag + 7, endTag);
            beginTag = lowerCase.indexOf("<link>");
            endTag = lowerCase.indexOf("</link>");
            URL link = new URL(item.substring(beginTag + 6, endTag));
            beginTag = lowerCase.indexOf("<description>");
            endTag = lowerCase.indexOf("</description>");
            String description = item.substring(beginTag + 13, endTag);
            beginTag = lowerCase.indexOf("<pubdate>");
            endTag = lowerCase.indexOf("</pubdate>");
            if (beginTag >= 0 && endTag >= 0) {
                SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
                timestamp = dateFormatter.parse(item.substring(beginTag + 9, endTag));
            }
            parsedItem = new RSSItem(link, title, description, timestamp);
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage());
        }
        catch (ParseException pe) {
            System.err.println("Invalid date format in timestamp" + pe.getMessage());
        }
        return parsedItem;
    }
}

