/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler;

import il.ac.wis.cs.common.log.Logger;
import il.ac.wis.cs.s2a.compiler.MSDModelCompiler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class FilesWriter {
    static Logger logger = Logger.getLocalLogger(FilesWriter.class);
    public static final String ASPECT_EXTENSION = ".aj";
    public static final String METHODS_FILE_NAME = "MSDMethods";
    public static final String JAVA_EXTENSION = ".java";
    public static final String COORDINATOR_NAME = "MSDCoordinatorAspect";

    public static void writeAll(MSDModelCompiler compiledModel, String path) {
        try {
            PrintWriter out;
            File file = new File(path);
            if (!file.isDirectory()) {
                boolean success = new File(path).mkdirs();
                if (!success) {
                    logger.error("Could Not Create the output directory. Check privileges");
                    throw new IOException("Could Not Create the output directory , check privileges");
                }
                logger.info("Output directory was created: " + path);
            }
            for (String aspectName : compiledModel.getInteractionsAspects().keySet()) {
                String aspectCode = compiledModel.getInteractionsAspects().get(aspectName);
                out = new PrintWriter(new FileWriter(String.valueOf(path) + aspectName + ASPECT_EXTENSION));
                out.println(aspectCode);
                out.flush();
                out.close();
            }
            out = new PrintWriter(new FileWriter(String.valueOf(path) + METHODS_FILE_NAME + JAVA_EXTENSION));
            String methods = compiledModel.getMUSDMethodsConstants();
            out.println(methods);
            out.flush();
            out.close();
            out = new PrintWriter(new FileWriter(String.valueOf(path) + COORDINATOR_NAME + ASPECT_EXTENSION));
            String coordinator = compiledModel.getCoordinator();
            out.println(coordinator);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            logger.error("Failed writting to output file: " + e.getMessage());
            System.out.print(e.getStackTrace());
        }
    }

    public static void cleanAll(String folder) {
        File dir = folder.endsWith("\\") ? new File(folder.substring(0, folder.length() - 1)) : new File(folder);
        if (!FilesWriter.deleteDir(dir)) {
            logger.error("Failed to clean output directory: " + folder + ". Check privileges.");
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = FilesWriter.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }
}

