/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler;

import il.ac.wis.cs.common.log.Logger;
import il.ac.wis.cs.s2a.compiler.MUSDInteractions2Coordinator;
import il.ac.wis.cs.s2a.compiler.errors.MSDErrorHandler;
import il.ac.wis.cs.s2a.compiler.interaction2aspect.MUSDInteraction2Aspect;
import il.ac.wis.cs.s2a.compiler.lib.MSDInteraction;
import il.ac.wis.cs.s2a.compiler.lib.MSDMessage;
import il.ac.wis.cs.s2a.compiler.stringutils.MUSDAspectStringGen;
import il.ac.wis.cs.s2a.compiler.stringutils.MethodsConstantsStringGen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MUSDInteractionsCompiler {
    static Logger logger = Logger.getLocalLogger(MUSDInteractionsCompiler.class);
    private ArrayList<MSDInteraction> interactionList;
    private HashSet<String> pointCutCore;
    private HashSet<MSDMessage> executableMessages;
    private ArrayList<String> aspectNames;
    private HashMap<String, String> varNamesToVarTypes;
    private boolean compositionSupport;

    public MUSDInteractionsCompiler(ArrayList<MSDInteraction> interactionList, boolean compositionSupport) {
        this.interactionList = interactionList;
        this.compositionSupport = compositionSupport;
        this.pointCutCore = new HashSet();
        this.executableMessages = new HashSet();
        this.varNamesToVarTypes = new HashMap();
        this.aspectNames = new ArrayList();
    }

    public HashMap<String, String> compileAspects(ArrayList<String> imports, String targetPackage) {
        HashMap<String, String> map = new HashMap<String, String>();
        int range = 0;
        for (MSDInteraction inter : this.interactionList) {
            try {
                long startTime = System.currentTimeMillis();
                MUSDInteraction2Aspect inter2Aspect = new MUSDInteraction2Aspect(inter, range, imports, targetPackage, this.compositionSupport);
                String aspectCode = inter2Aspect.getAspectCode();
                this.pointCutCore.addAll(inter2Aspect.getPointCutCores());
                this.executableMessages.addAll(inter.getExecutableMessages());
                if (!inter.isTest()) {
                    this.aspectNames.add(inter2Aspect.getAspectName());
                }
                range = inter2Aspect.getFinalRange() + 1;
                this.varNamesToVarTypes.putAll(inter2Aspect.getVarNamesToVarTypes());
                map.put(inter2Aspect.getAspectName(), aspectCode);
                logger.performanceInfo("Time it took to create \"" + inter.getName() + "\" aspect code: " + (System.currentTimeMillis() - startTime) + " milliseconds");
            }
            catch (Exception e) {
                MSDErrorHandler.printErrorInMSD2Aspectphase(inter, e);
            }
        }
        return map;
    }

    public String compileMethodConstants(String targetPackage) {
        StringBuffer str = new StringBuffer(300);
        Iterator<MSDInteraction> it = this.interactionList.iterator();
        str.append(MUSDAspectStringGen.generateMethodsLicenceWarnning());
        str.append(MUSDAspectStringGen.generatePackageDeclaration(targetPackage));
        str.append(MethodsConstantsStringGen.generateMUSDMethodsClass());
        HashSet<MSDMessage> set = new HashSet<MSDMessage>();
        while (it.hasNext()) {
            set.addAll(it.next().getMessages());
        }
        str.append(this.generateMethodsConstants(set));
        str.append("}\n");
        return str.toString();
    }

    public String compileCoordinator(String implClass, ArrayList<String> imports, String targetPack) {
        return new MUSDInteractions2Coordinator(this.aspectNames, implClass, this.pointCutCore, this.executableMessages, imports, targetPack, this.varNamesToVarTypes).getCode();
    }

    private String generateMethodsConstants(HashSet<MSDMessage> messages) {
        StringBuffer str = new StringBuffer(100);
        HashSet<String> constants = new HashSet<String>();
        Iterator<MSDMessage> it = messages.iterator();
        int number = 0;
        while (it.hasNext()) {
            String methodName;
            String receiverType;
            MSDMessage mes = it.next();
            String senderType = mes.getSender().getRepresentsType();
            String constant = MethodsConstantsStringGen.generateMethodConstForMethodsClass(senderType, receiverType = mes.getReciever().getRepresentsType(), methodName = mes.getName());
            if (constants.contains(constant)) continue;
            str.append(MethodsConstantsStringGen.generateMethodForMethodsClass(constant, number++));
            constants.add(constant);
        }
        return str.toString();
    }
}

