/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler.interaction2aspect;

import il.ac.wis.cs.s2a.compiler.interaction2aspect.ImmidiateEventsTree;
import il.ac.wis.cs.s2a.compiler.interaction2aspect.MUSDInteraction2Aspect;
import il.ac.wis.cs.s2a.compiler.interaction2aspect.MessageData;
import il.ac.wis.cs.s2a.compiler.lib.CutState;
import il.ac.wis.cs.s2a.compiler.lib.MSDMessage;
import il.ac.wis.cs.s2a.compiler.lib.MUSDArgument;
import il.ac.wis.cs.s2a.compiler.stringutils.ChangeCutStringGen;
import il.ac.wis.cs.s2a.compiler.stringutils.MUSDAspectStringGen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MUSDChangeCutStateBuilder {
    int consNumber = 0;
    HashMap<String, Integer> lineToIndexes;
    HashMap<Integer, String> constraintsAndGuardsStringsMap;
    HashMap<String, Integer> constraintReverseMap;
    private MUSDInteraction2Aspect inter2Aspect;
    private HashMap<String, String> varNamesToVarTypes;
    private HashSet<String> finalStates;

    public MUSDChangeCutStateBuilder(MUSDInteraction2Aspect inter2Aspect) {
        this.inter2Aspect = inter2Aspect;
        this.lineToIndexes = inter2Aspect.lineToIndexes;
        this.varNamesToVarTypes = inter2Aspect.varNamesToVarTypes;
        this.constraintsAndGuardsStringsMap = new HashMap();
        this.constraintReverseMap = new HashMap();
        this.finalStates = this.stateToStrings(inter2Aspect.interactionLogic.getFinalStates());
    }

    public String getChangeCutState() {
        HashSet<String> bodies = new HashSet<String>();
        HashSet<String> uniViolationBodies = new HashSet<String>();
        StringBuffer code = new StringBuffer(1000);
        code.append(ChangeCutStringGen.generateChangeCutStateConstants());
        HashSet<String> casesName = new HashSet<String>();
        for (MSDMessage mes : this.inter2Aspect.interaction.getMessages()) {
            bodies.clear();
            uniViolationBodies.clear();
            String caseName = MUSDAspectStringGen.getMessageCoddedName(mes);
            if (!casesName.add(caseName)) continue;
            code.append(MUSDAspectStringGen.generateCaseForCahngeCutState(mes.getSender().getRepresentsType(), mes.getReciever().getRepresentsType(), mes.getName()));
            boolean first = true;
            for (MessageData data : (ArrayList)this.inter2Aspect.interactionLogic.get(MUSDAspectStringGen.getMessageCoddedName(mes))) {
                String body = this.getCodeForBranch(data, first);
                if (this.isOneLineNull(data)) {
                    String vioBody = this.getUnificationCheckForViolations(data);
                    uniViolationBodies.add(vioBody);
                }
                first = false;
                if (!bodies.add(body)) continue;
                code.append(body);
            }
            if (!uniViolationBodies.isEmpty()) {
                code.append("\t\t\t\t}\n");
            }
            boolean vioFirst = true;
            for (String violationCheck : uniViolationBodies) {
                if (!vioFirst) {
                    code.append("\t\t\t\t}\n");
                }
                vioFirst = false;
                code.append(violationCheck);
            }
            code.append("\t\t\t\t}\n\t\t\t\t").append("if(!unification)//No unification...").append("\n\t\t\t\t\treturn;");
            code.append("\n\t\t\t\tbreak;\n\n");
        }
        code.append(ChangeCutStringGen.generateChangeCutStateCloser());
        code.append(this.getEvaluteConstraints());
        code.append(this.getDoBindings());
        return code.toString();
    }

    private String getUnificationCheckForViolations(MessageData data) {
        String compositionCheck = this.getCompositionCheck(data);
        String varsCheck = this.getVarsCheckString(data);
        return ChangeCutStringGen.getVilationUnificationCheck(data.senderBindingConstant, data.receiverBindingConstant, compositionCheck, varsCheck);
    }

    private boolean isOneLineNull(MessageData data) {
        return !data.isSenderBound && !data.realMessage.getSender().isEnv() || !data.isReceiverBound && !data.realMessage.getReciever().isEnv();
    }

    private String getDoBindings() {
        StringBuffer changeCutStateInits = this.inter2Aspect.staticInit.append(this.inter2Aspect.exactVarsInit);
        return ChangeCutStringGen.generateDoBindings(this.inter2Aspect.getInstAndVarsDecleration(true), changeCutStateInits);
    }

    private String getCodeForBranch(MessageData data, boolean first) {
        StringBuffer str = new StringBuffer(200);
        String oldStateString = data.oldState.getCutStateString(this.lineToIndexes);
        String newStateString = data.newState.getCutStateString(this.lineToIndexes);
        ImmidiateEventsTree tree = new ImmidiateEventsTree(data, this);
        this.consNumber = tree.getConstraintNumber();
        String varsCheck = this.getVarsCheckString(data);
        String varsSets = this.getVarsSetsString(data);
        String compositionCheck = this.getCompositionCheck(data);
        String compositionSet = this.getCompositionSet(data);
        if (data.realMessage.isConstructor()) {
            str.append(ChangeCutStringGen.getChangeCutForConstructors(oldStateString, data.receiverBindingConstant, newStateString, this.finalStates, varsCheck, varsSets, tree, first));
            if (!data.realMessage.getSender().isEnv() && data.isSenderBound) {
                str.append(ChangeCutStringGen.getChangeCutForSmallConstructorsSenderUnified(newStateString, data.senderBindingConstant, this.finalStates));
            }
            if (!data.realMessage.getSender().isEnv() && !data.isSenderBound) {
                str.append(ChangeCutStringGen.getChangeCutForSmallConstructorsSenderNotUnified(newStateString, data.senderBindingConstant, this.finalStates));
            }
            return str.toString();
        }
        if ((data.isReceiverBound || data.receiverBindingConstant.equals("env")) && data.isSenderBound) {
            str.append(ChangeCutStringGen.getChangeCutForSrcAndTargetUni(oldStateString, data.senderBindingConstant, data.receiverBindingConstant, newStateString, this.finalStates, varsCheck, varsSets, tree, first, compositionCheck, compositionSet));
            return str.toString();
        }
        if (data.isSenderBound || data.senderBindingConstant.equals("env")) {
            str.append(ChangeCutStringGen.getChangeCutForSrcUni(oldStateString, data.senderBindingConstant, data.receiverBindingConstant, newStateString, this.finalStates, varsCheck, varsSets, tree, first, compositionCheck, compositionSet));
            return str.toString();
        }
        if (data.isReceiverBound) {
            str.append(ChangeCutStringGen.getChangeCutForTargetUni(oldStateString, data.senderBindingConstant, data.receiverBindingConstant, newStateString, this.finalStates, varsCheck, varsSets, tree, first, compositionCheck, compositionSet));
            return str.toString();
        }
        str.append(ChangeCutStringGen.getChangeCutNoBindings(oldStateString, data.senderBindingConstant, data.receiverBindingConstant, newStateString, this.finalStates, varsCheck, varsSets, tree, first, compositionCheck, compositionSet));
        return str.toString();
    }

    private String getVarsCheckString(MessageData data) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        for (MUSDArgument arg : data.realMessage.getArguments()) {
            boolean isBounded = data.varNamesToBindingState.get(arg.getName());
            if (isBounded) {
                str.append(MUSDAspectStringGen.generateVarsEquals(arg.getName(), this.varNamesToVarTypes.get(arg.getName()), i));
            }
            ++i;
        }
        return str.toString();
    }

    private String getCompositionCheck(MessageData data) {
        StringBuffer str = new StringBuffer();
        boolean newSenderOwner = false;
        if (!data.isSenderBound && data.isSenderIPart) {
            if (data.isSenderOwnerBound) {
                str.append(ChangeCutStringGen.generateCheckSenderOwnerEqual(data.senderOwnerBindingConstant));
            } else {
                str.append(ChangeCutStringGen.generateCheckSenderOwnerType(data.senderOwnerType));
                newSenderOwner = true;
            }
        }
        if (!data.isReceiverBound && data.isReceiverIPart) {
            if (data.isReceiverOwnerBound) {
                str.append(ChangeCutStringGen.generateCheckReceiverOwnerEqual(data.receiverOwnerBindingConstant));
            } else {
                str.append(ChangeCutStringGen.generateCheckReceiverOwnerType(data.receiverOwnerType));
                if (newSenderOwner && data.receiverOwnerBindingConstant.equals(data.senderOwnerBindingConstant)) {
                    str.append(ChangeCutStringGen.checkEqualsOwners());
                }
            }
        }
        return str.toString();
    }

    private String getCompositionSet(MessageData data) {
        StringBuffer str = new StringBuffer();
        boolean newSenderOwner = false;
        if (!data.isSenderBound && data.isSenderIPart && !data.isSenderOwnerBound) {
            str.append(ChangeCutStringGen.generateSenderOwnerSet(data.senderOwnerBindingConstant));
            newSenderOwner = true;
        }
        if (!(data.isReceiverBound || !data.isReceiverIPart || data.isReceiverOwnerBound || newSenderOwner && data.receiverOwnerBindingConstant.equals(data.senderOwnerBindingConstant))) {
            str.append(ChangeCutStringGen.generateReceiverOwnerSet(data.senderOwnerBindingConstant));
        }
        return str.toString();
    }

    private String getVarsSetsString(MessageData data) {
        StringBuffer str = new StringBuffer();
        Iterator<MUSDArgument> it = data.realMessage.getArguments().iterator();
        int i = 0;
        while (it.hasNext()) {
            MUSDArgument arg = it.next();
            boolean isBounded = data.varNamesToBindingState.get(arg.getName());
            if (!isBounded) {
                str.append(MUSDAspectStringGen.generateVarsSetter(arg.getName(), this.varNamesToVarTypes.get(arg.getName()), i));
            }
            ++i;
        }
        return str.toString();
    }

    private String getEvaluteConstraints() {
        HashMap<String, ArrayList<Integer>> repetitionMap = new HashMap<String, ArrayList<Integer>>();
        HashMap<Integer, String> reducedMap = new HashMap<Integer, String>();
        for (int i : this.constraintsAndGuardsStringsMap.keySet()) {
            String constraint = this.constraintsAndGuardsStringsMap.get(i);
            ArrayList<Integer> stringList = repetitionMap.get(constraint);
            if (stringList == null) {
                reducedMap.put(i, constraint);
                stringList = new ArrayList();
                repetitionMap.put(constraint, stringList);
                continue;
            }
            stringList.add(i);
        }
        return ChangeCutStringGen.generateEvaluateCondition(this.inter2Aspect.getInstAndVarsDecleration(true), reducedMap, repetitionMap);
    }

    private HashSet<String> stateToStrings(HashSet<CutState> states) {
        HashSet<String> resSet = new HashSet<String>();
        for (CutState state : states) {
            resSet.add(state.getCutStateString(this.lineToIndexes));
        }
        return resSet;
    }
}

