/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler.lib;

import il.ac.wis.cs.s2a.compiler.lib.MSDInteractionFragment;
import il.ac.wis.cs.s2a.compiler.lib.MSDLifeline;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionConstraint;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.StateInvariant;

public class MSDConstraint
extends MSDInteractionFragment {
    private ArrayList<String> expressions;
    private boolean isHot;
    private boolean isExecute;

    public MSDConstraint(InteractionFragment fragment, boolean isExecute, boolean isHot) {
        super(fragment);
        this.isHot = isHot;
        this.isExecute = isExecute;
        this.isImmediate = true;
        this.type = 1;
        if (fragment instanceof StateInvariant) {
            this.initStateInvariant((StateInvariant)fragment);
        } else {
            this.initAssertFragment((CombinedFragment)fragment);
        }
    }

    public void initStateInvariant(StateInvariant state) {
        Constraint con = state.getInvariant();
        this.expressions = new ArrayList();
        OpaqueExpression opaque = (OpaqueExpression)con.getSpecification();
        Iterator it1 = opaque.getBodies().iterator();
        while (it1.hasNext()) {
            this.expressions.add((String)it1.next());
        }
    }

    public void initAssertFragment(CombinedFragment fragment) {
        InteractionOperand operand = (InteractionOperand)fragment.getOperands().get(0);
        InteractionConstraint con = operand.getGuard();
        this.expressions = new ArrayList();
        OpaqueExpression opaque = (OpaqueExpression)con.getSpecification();
        Iterator it1 = opaque.getBodies().iterator();
        while (it1.hasNext()) {
            this.expressions.add((String)it1.next());
        }
    }

    private MSDConstraint(ArrayList<MSDLifeline> lines) {
        this.coveredLifeLines = lines;
        this.type = 1;
        this.expressions = new ArrayList();
    }

    public ArrayList<String> getExpression() {
        return this.expressions;
    }

    public boolean isHotFalseConstraint() {
        if (!this.isHot) {
            return false;
        }
        Iterator<String> it = this.expressions.iterator();
        while (it.hasNext()) {
            if (!it.next().equalsIgnoreCase("false")) continue;
            return true;
        }
        return false;
    }

    public boolean isHot() {
        return this.isHot;
    }

    public boolean isExecute() {
        return this.isExecute;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(20);
        Iterator<String> it = this.expressions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String exp = it.next();
            if (!first) {
                str.append(" && ").append(exp);
                continue;
            }
            str.append(exp);
        }
        return str.toString();
    }

    public static MSDConstraint getSyncConstraint(ArrayList<MSDLifeline> lines) {
        MSDConstraint cons = new MSDConstraint(lines);
        cons.name = "SYNC";
        cons.expressions.add("true");
        return cons;
    }

    public boolean checkUnification(MSDConstraint upConstraint, Lifeline upLine) {
        if (!upConstraint.coveredLifeLines.contains(new MSDLifeline(upLine))) {
            return false;
        }
        if (upConstraint.coveredLifeLines.size() > 1) {
            int lifeLineNumber = this.getRelevantLifelineNum(upLine.getDecomposedAs().getRefersTo());
            if (this.coveredLifeLines.size() < lifeLineNumber) {
                return false;
            }
        }
        if (this.expressions.size() != upConstraint.expressions.size()) {
            return false;
        }
        int i = 0;
        while (i < this.expressions.size()) {
            if (!this.expressions.get(i).trim().equals(upConstraint.expressions.get(i).trim())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean checkUnification(MSDConstraint upConstraint) {
        if (this.expressions.size() != upConstraint.expressions.size()) {
            return false;
        }
        int i = 0;
        while (i < this.expressions.size()) {
            if (!this.expressions.get(i).trim().equals(upConstraint.expressions.get(i).trim())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int getRelevantLifelineNum(Interaction inter) {
        int res = 0;
        Iterator it = inter.getLifelines().iterator();
        while (it.hasNext()) {
            MSDLifeline line = new MSDLifeline((Lifeline)it.next());
            if (line.isStab() || line.isEnv()) continue;
            ++res;
        }
        return res;
    }

    public void unifyWith(MSDConstraint upConstraint, MSDLifeline upLine) {
        for (MSDLifeline line : upConstraint.coveredLifeLines) {
            if (line.equals(upLine)) continue;
            this.coveredLifeLines.add(line);
        }
    }

    public void unifyWith(ArrayList<MSDConstraint> upCons, ArrayList<MSDConstraint> sideCons) {
        this.addAllRelevantLines(upCons);
        this.addAllRelevantLines(sideCons);
    }

    private void addAllRelevantLines(ArrayList<MSDConstraint> list) {
        for (MSDConstraint cons : list) {
            for (MSDLifeline line : cons.getCoveredLines()) {
                if (line.isDecomposed() || line.isStab()) continue;
                this.coveredLifeLines.add(line);
            }
        }
    }
}

