/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler.lib;

import il.ac.wis.cs.s2a.compiler.lib.MSDInteractionFragment;
import il.ac.wis.cs.s2a.compiler.lib.MSDLifeline;
import il.ac.wis.cs.s2a.compiler.lib.MUSDArgument;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ValueSpecification;

public class MSDMessage
extends MSDInteractionFragment {
    private boolean isConstructor;
    private MSDLifeline sender;
    private MSDLifeline receiver;
    private MessageOccurrenceSpecification sendPoint;
    private MessageOccurrenceSpecification receivePoint;
    private String returnType;
    private ArrayList<MUSDArgument> arguments;
    private ArrayList<String> argumentTypes;

    public MSDMessage(Message mes, ArrayList<MSDLifeline> lifeLines) {
        this.isImmediate = false;
        this.sendPoint = (MessageOccurrenceSpecification)mes.getSendEvent();
        this.receivePoint = (MessageOccurrenceSpecification)mes.getReceiveEvent();
        this.sender = this.getLifeline((Lifeline)this.sendPoint.getCovereds().get(0), lifeLines);
        this.receiver = this.getLifeline((Lifeline)this.receivePoint.getCovereds().get(0), lifeLines);
        this.arguments = this.initArguments(mes.getArguments());
        this.type = 0;
        this.initCoverdsLifeLines();
        if (mes.getMessageSort().getValue() == 3) {
            this.name = mes.getName();
            this.isConstructor = true;
            this.returnType = this.receiver.getRepresentsType();
            this.argumentTypes = this.initArgumentsTypes(mes.getOwnedElements());
            return;
        }
        this.isConstructor = false;
        Operation operation = (Operation)mes.getSignature();
        this.name = operation.getName();
        if (operation.getReturnResult() != null && operation.getReturnResult().getType() != null) {
            this.returnType = operation.getReturnResult().getType().getName();
        }
        this.argumentTypes = this.initArgumentsTypes(operation);
    }

    private MSDLifeline getLifeline(Lifeline line, ArrayList<MSDLifeline> lifeLines) {
        String name = line.getName();
        for (MSDLifeline msdLine : lifeLines) {
            if (!msdLine.getName().equals(name)) continue;
            return msdLine;
        }
        return new MSDLifeline(line);
    }

    private ArrayList<String> initArgumentsTypes(EList list) {
        ArrayList<String> arr = new ArrayList<String>();
        for (ValueSpecification val : list) {
            if (val.getType() != null) {
                arr.add(val.getType().getName());
                continue;
            }
            arr.add(MUSDArgument.getValueSpecificationType(val));
        }
        return arr;
    }

    private ArrayList<String> initArgumentsTypes(Operation operation) {
        ArrayList<String> arr = new ArrayList<String>();
        for (Parameter par : operation.getOwnedParameters()) {
            if (par.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
            arr.add(par.getType().getName());
        }
        return arr;
    }

    private ArrayList<MUSDArgument> initArguments(EList args) {
        Iterator it = args.iterator();
        ArrayList<MUSDArgument> arr = new ArrayList<MUSDArgument>();
        while (it.hasNext()) {
            arr.add(new MUSDArgument((ValueSpecification)it.next()));
        }
        return arr;
    }

    private boolean returnTypeEqual(String res2) {
        if (this.returnType == null && res2 == null) {
            return true;
        }
        if (this.returnType == null && res2 != null) {
            return false;
        }
        if (res2 == null && this.returnType != null) {
            return false;
        }
        return this.returnType.equals(res2);
    }

    private boolean paramsTypeEqual(ArrayList<String> parametersType2) {
        if (this.argumentTypes.size() != parametersType2.size()) {
            return false;
        }
        Iterator<String> it1 = this.argumentTypes.iterator();
        Iterator<String> it2 = parametersType2.iterator();
        while (it1.hasNext()) {
            if (it1.next().equals(it2.next())) continue;
            return false;
        }
        return true;
    }

    private boolean exactParamsValueEqual(ArrayList<MUSDArgument> args2) {
        if (this.arguments.size() != args2.size()) {
            return false;
        }
        Iterator<MUSDArgument> it1 = this.arguments.iterator();
        Iterator<MUSDArgument> it2 = args2.iterator();
        while (it1.hasNext()) {
            MUSDArgument arg1 = it1.next();
            MUSDArgument arg2 = it2.next();
            if (!arg1.isExact() && !arg2.isExact()) continue;
            if (arg1.isExact() && !arg2.isExact()) {
                return false;
            }
            if (arg2.isExact() && !arg1.isExact()) {
                return false;
            }
            if (arg1.equals(arg2)) continue;
            return false;
        }
        return true;
    }

    private void initCoverdsLifeLines() {
        this.coveredLifeLines = new ArrayList();
        this.coveredLifeLines.add(this.sender);
        if (!this.sender.equals(this.receiver)) {
            this.coveredLifeLines.add(this.receiver);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof MSDMessage)) {
            return false;
        }
        MSDMessage mes = (MSDMessage)o;
        return this.name.equals(mes.name) && this.sender.getRepresentsType().equals(mes.sender.getRepresentsType()) && this.receiver.getRepresentsType().equals(mes.receiver.getRepresentsType()) && this.isConstructor == mes.isConstructor && this.returnTypeEqual(mes.returnType) && this.paramsTypeEqual(mes.getArgumentsTypes()) && this.exactParamsValueEqual(mes.getArguments());
    }

    public ArrayList<MUSDArgument> getArguments() {
        return this.arguments;
    }

    public ArrayList<String> getArgumentsTypes() {
        return this.argumentTypes;
    }

    public MessageOccurrenceSpecification getSendPoint() {
        return this.sendPoint;
    }

    public MessageOccurrenceSpecification getReceivePoint() {
        return this.receivePoint;
    }

    public MSDLifeline getSender() {
        return this.sender;
    }

    public MSDLifeline getReciever() {
        return this.receiver;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean hasArguments() {
        return !this.arguments.isEmpty();
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static boolean isRelevantMessage(Message mes) {
        int sort = mes.getMessageSort().getValue();
        return sort != 5 && sort != 2;
    }

    public boolean checkUnificationWith(MSDMessage upMes, Lifeline line) {
        return this.name.equals(upMes.name) && this.isConstructor == upMes.isConstructor && this.returnTypeEqual(upMes.returnType) && this.paramsTypeEqual(upMes.getArgumentsTypes()) && this.exactParamsValueUnificationEqual(upMes.getArguments()) && this.checkUnifiedTypes(this.sender, upMes.sender, line) && this.checkUnifiedTypes(this.receiver, upMes.receiver, line);
    }

    private boolean checkUnifiedTypes(MSDLifeline downLine, MSDLifeline upLine, Lifeline line) {
        if (downLine.isStab()) {
            return true;
        }
        MSDLifeline msdLine = new MSDLifeline(line);
        if (upLine.getRepresentsType().equals(msdLine.getRepresentsType())) {
            return true;
        }
        return upLine.getRepresentsType().equals(downLine.getRepresentsType());
    }

    private boolean exactParamsValueUnificationEqual(ArrayList<MUSDArgument> upArgs) {
        if (this.arguments.size() != upArgs.size()) {
            return false;
        }
        Iterator<MUSDArgument> it1 = this.arguments.iterator();
        Iterator<MUSDArgument> it2 = upArgs.iterator();
        while (it1.hasNext()) {
            MUSDArgument downArg = it1.next();
            MUSDArgument upArg = it2.next();
            if (!downArg.isExact() && !upArg.isExact() || downArg.isExact() && !upArg.isExact()) continue;
            if (upArg.isExact() && !downArg.isExact()) {
                return false;
            }
            if (downArg.equals(upArg)) continue;
            return false;
        }
        return true;
    }

    public void unifyWith(MSDMessage upMes) {
        this.sendPoint = this.sender.isStab() ? upMes.sendPoint : this.sendPoint;
        this.receivePoint = this.receiver.isStab() ? upMes.receivePoint : this.receivePoint;
        this.sender = this.sender.isStab() ? upMes.sender : this.sender;
        this.receiver = this.receiver.isStab() ? upMes.receiver : this.receiver;
        this.initCoverdsLifeLines();
        this.isConstructor = this.receiver.isStab() ? upMes.isConstructor : this.isConstructor;
        this.returnType = this.receiver.isStab() ? upMes.returnType : this.returnType;
        this.argumentTypes = this.receiver.isStab() ? upMes.argumentTypes : this.argumentTypes;
    }

    public void unifyWith(ArrayList<MSDMessage> upList, ArrayList<MSDMessage> sideList) {
        if (!this.sender.isStab() && !this.receiver.isStab()) {
            return;
        }
        if (!sideList.isEmpty()) {
            this.unifyWith(sideList.get(0));
            sideList.remove(sideList.size() - 1);
            this.unifyWith(upList, sideList);
            return;
        }
        this.unifyWith(upList.get(0));
        upList.remove(upList.size() - 1);
        this.unifyWith(upList, sideList);
    }

    public boolean localUniEquals(MSDMessage mes) {
        return this.name.equals(mes.name) && this.isConstructor == mes.isConstructor && this.returnTypeEqual(mes.returnType) && this.paramsTypeEqual(mes.getArgumentsTypes());
    }

    public String toString() {
        return this.name;
    }
}

