/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler.lib;

import il.ac.wis.cs.common.uml2.UML2ProfileOperations;
import il.ac.wis.cs.s2a.compiler.lib.MSDInteraction;
import il.ac.wis.cs.s2a.compiler.lib.MSDInteractionFragment;
import il.ac.wis.cs.s2a.compiler.lib.MUSDCombinedFragment;
import il.ac.wis.cs.s2a.compiler.lib.MUSDInteractionOperand;
import java.util.ArrayList;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.InteractionConstraint;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class MUSDInteractionGuard
extends MSDInteractionFragment {
    private ArrayList<String> expressions;
    private MUSDInteractionOperand enclosingOperand;
    private int loopsNumber = -1;
    private boolean isConstantLoopGuard = false;

    public MUSDInteractionGuard(InteractionConstraint cons, MUSDInteractionOperand op) {
        this.isImmediate = true;
        this.name = cons.getName() != null ? cons.getName() : "";
        this.type = 3;
        this.enclosingOperand = op;
        this.expressions = new ArrayList();
        this.coveredLifeLines = op.getCoveredLines();
        this.updateExpressionsUsingGuardSttereoTypes(cons);
    }

    private void updateExpressionsUsingGuardSttereoTypes(InteractionConstraint cons) {
        String s = "";
        if (cons.getSpecification() != null) {
            if (cons.getSpecification().getAppliedStereotypes() != null && cons.getSpecification().getAppliedStereotypes().size() > 0) {
                Stereotype stereo = (Stereotype)cons.getSpecification().getAppliedStereotypes().get(0);
                Property p = stereo.getAttribute("body", null);
                s = (String)UML2ProfileOperations.getStereotypePropertyValue((NamedElement)cons.getSpecification(), stereo, p);
                this.expressions.add(s);
            } else {
                if (cons.getSpecification() instanceof Expression) {
                    Expression oe = (Expression)cons.getSpecification();
                    s = (String)((OpaqueExpression)oe.getOwnedElements().get(0)).getBodies().get(0);
                    this.expressions.add(s);
                }
                if (cons.getSpecification() instanceof OpaqueExpression) {
                    s = (String)((OpaqueExpression)cons.getSpecification()).getBodies().get(0);
                    this.expressions.add(s);
                }
            }
        } else if (cons.getMinint() != null) {
            this.loopsNumber = cons.getMinint().integerValue();
            this.isConstantLoopGuard = true;
        }
    }

    public String toString() {
        if (!this.expressions.isEmpty()) {
            return this.expressions.get(0);
        }
        if (!this.isConstantLoopGuard) {
            return "true";
        }
        return "LOOP";
    }

    public ArrayList<String> getExpression() {
        return this.expressions;
    }

    public MUSDInteractionOperand getEnclosingOperand() {
        return this.enclosingOperand;
    }

    public int getLoopsNumber() {
        return this.loopsNumber;
    }

    public MSDInteraction getEnclosingInteraction() {
        return this.enclosingOperand.getEnclosingCombinedFragment().getEnclosingInteraction();
    }

    public MUSDCombinedFragment getEnclosingCombinedFragment() {
        return this.enclosingOperand.getEnclosingCombinedFragment();
    }

    public boolean isConstantLoopGuard() {
        return this.isConstantLoopGuard;
    }
}

