/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler;

import il.ac.wis.cs.common.log.Logger;
import il.ac.wis.cs.common.uml2.UML2AdvancedOperations;
import il.ac.wis.cs.common.uml2.UML2ProfileOperations;
import il.ac.wis.cs.s2a.compiler.FilesWriter;
import il.ac.wis.cs.s2a.compiler.MSDModelCompiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.emf.common.util.URI;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;

public class MUSDCompilerApp {
    static Logger logger = Logger.getLocalLogger(MUSDCompilerApp.class);
    private static final String MODEL_PATH = "model";
    private static final String OUTPUT_FOLDER = "output";
    private static final String OUTPUT_PACKAGE = "output.package";
    private static final String IMPORTS = "imports";
    private static final String STRATEGY = "strategy";
    private static final String PROFILES_REASOURCE_JAR = "resourcesJar";
    private static final String PROPERTIES_FILE_NAME = "s2aCompiler.properties";
    private static final String MODEL_PROPERTIES_FILE_NAME = "musdmodel.properties";
    private static final String TO_COMPILE_INTERACTIONS = "interactions";
    private static final String COMPILE_ALL = "*";
    private static final String CLEAN = "clean";
    private static final String TRUE = "true";
    private static final String COMPOSITION = "composition";
    private static String jar;
    private static String impl;
    private static String targetPackage;
    private static String outputPath;
    private static String modelPath;
    private static String clean;
    private static String composition;
    private static String[] imports;
    private static String[] toCompileInteractions;

    static {
        imports = null;
        toCompileInteractions = null;
    }

    public static void main(String[] args) {
        MUSDCompilerApp.readProperties();
        logger.info("Start loading the model " + modelPath);
        long startTime = System.currentTimeMillis();
        Model model = null;
        try {
            model = MUSDCompilerApp.loadModel();
        }
        catch (Throwable e) {
            logger.fatal("loadModel failed.", e);
            return;
        }
        logger.performanceInfo("Total model loading time: " + (System.currentTimeMillis() - startTime) + " milliseconds");
        long t = System.currentTimeMillis();
        logger.info("Starting compilation of: " + model.getName());
        MSDModelCompiler comp = toCompileInteractions[0].equals(COMPILE_ALL) ? new MSDModelCompiler(model) : new MSDModelCompiler(model, toCompileInteractions);
        if (clean.equals(TRUE)) {
            FilesWriter.cleanAll(outputPath);
        }
        boolean compositionSupport = composition == null ? false : Boolean.valueOf(composition);
        comp.compileModel(impl, imports, targetPackage, compositionSupport);
        FilesWriter.writeAll(comp, outputPath);
        t = System.currentTimeMillis() - t;
        logger.performanceInfo("Total compilation time: " + t / 1000L + " seconds and " + t % 1000L + " milliseconds");
    }

    public static String getPropertiesFilePath() {
        return PROPERTIES_FILE_NAME;
    }

    private static Model loadModel() {
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long usedMemSizeBeforeModelLoad = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        UML2AdvancedOperations.registerResourceFactories();
        UML2ProfileOperations.registerPathmaps(URI.createURI((String)jar));
        UML2AdvancedOperations.createModel(MUSDCompilerApp.getModelName(modelPath));
        URI uri = URI.createURI((String)"").appendSegment(modelPath).appendFileExtension("uml");
        if (uri == null) {
            logger.error("Failed creating URI from modelPath. modelPath is: " + modelPath);
        }
        Package p = UML2AdvancedOperations.load(uri);
        long usedMemSizeAfterModelLoad = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        File modelFile = new File(uri.path());
        logger.performanceInfo("model file size is: " + modelFile.length() / 1024L + "KB");
        logger.performanceInfo("Estimated Size of the model object in memory is: " + (usedMemSizeAfterModelLoad - usedMemSizeBeforeModelLoad) / 1024L + "KB");
        return p.getModel();
    }

    private static String getModelName(String modelPath) {
        if (modelPath == null || "".equals(modelPath)) {
            return "";
        }
        return new File(modelPath).getName();
    }

    private static void readProperties() {
        logger.info("Loading properties file s2aCompiler.properties");
        modelPath = null;
        outputPath = null;
        clean = null;
        targetPackage = null;
        impl = null;
        jar = null;
        try {
            Properties properties = new Properties();
            FileInputStream in = new FileInputStream(PROPERTIES_FILE_NAME);
            properties.load(in);
            modelPath = properties.getProperty(MODEL_PATH);
            if (modelPath == null || "".equals(modelPath)) {
                logger.error("\"model\" property must exist in s2aCompiler.properties file and point to a valid model location");
            }
            if ((jar = properties.getProperty(PROFILES_REASOURCE_JAR)) == null || "".equals(jar)) {
                logger.error("\"resourcesJar\" property must exist in s2aCompiler.properties file and point to a valid jar location");
            }
            impl = properties.getProperty(STRATEGY);
            String modelFile = URI.createFileURI((String)modelPath).trimSegments(1).appendSegment(MODEL_PROPERTIES_FILE_NAME).toFileString();
            in = new FileInputStream(modelFile);
            properties.load(in);
            targetPackage = properties.getProperty(OUTPUT_PACKAGE);
            outputPath = properties.getProperty(OUTPUT_FOLDER);
            clean = properties.getProperty(CLEAN);
            imports = properties.getProperty(IMPORTS).split(";");
            composition = properties.getProperty(COMPOSITION);
            toCompileInteractions = properties.getProperty(TO_COMPILE_INTERACTIONS).split(";");
            if (toCompileInteractions.length < 1) {
                logger.error("There should be at least one interaction to compile, (or *).");
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            logger.fatal("File was not found: " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            logger.fatal("Invalid properties file. Make sure there is a proper propertiesfile in the working directory.");
            System.exit(1);
        }
    }
}

