/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler.errors;

import il.ac.wis.cs.common.log.Logger;
import il.ac.wis.cs.s2a.compiler.lib.MSDInteraction;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;

public class MSDErrorHandler {
    static Logger logger = Logger.getLocalLogger(MSDErrorHandler.class);

    public static void printErrorInUML2MSDPhase(Interaction inter, Exception e) {
        logger.error("Exception Occured while trying to convert UML interaction:\"" + inter.getName() + "\" to MSDInteraction");
        logger.error("ExceptionDetails: " + e.getMessage());
        StackTraceElement[] ste = e.getStackTrace();
        if (ste[0].getClassName().equals("musd.compiler.lib.InteractionGraph")) {
            MSDErrorHandler.printInteractionGraphError(e);
        }
        e.printStackTrace();
    }

    private static void printInteractionGraphError(Exception e) {
        if (e instanceof NullPointerException && e.getStackTrace()[0].getMethodName().equals("getNewCutState")) {
            logger.error("Some lifeline's name seems to be null.");
        }
    }

    public static void printErrorInAddingFragment(MSDInteraction inter, InteractionFragment fragment, Exception e) {
        MessageOccurrenceSpecification mos;
        logger.error("Exception Occured while trying to convert UML interaction:\"" + inter.getName() + "\" to MSDInteraction");
        logger.error("Dealing with the fragment:" + fragment.getName());
        if (fragment instanceof MessageOccurrenceSpecification && (mos = (MessageOccurrenceSpecification)fragment).getMessage() != null) {
            logger.error("of type message. Message name was: " + mos.getMessage().getName());
        }
        System.err.println("ExceptionDetails: " + e.getMessage());
        e.printStackTrace();
    }

    public static void printErrorInMSD2Aspectphase(MSDInteraction inter, Exception e) {
        logger.error("Exception Occured while trying to create Aspect for UML interaction:\"" + inter.getName());
        logger.error("ExceptionDetails: " + e.getMessage());
        e.printStackTrace();
    }
}

