/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler.interaction2aspect;

import il.ac.wis.cs.s2a.compiler.interaction2aspect.MessageData;
import il.ac.wis.cs.s2a.compiler.lib.CutState;
import il.ac.wis.cs.s2a.compiler.lib.InteractionFragmentKey;
import il.ac.wis.cs.s2a.compiler.lib.MSDInteraction;
import il.ac.wis.cs.s2a.compiler.lib.MSDInteractionFragment;
import il.ac.wis.cs.s2a.compiler.lib.MSDLifeline;
import il.ac.wis.cs.s2a.compiler.lib.MSDMessage;
import il.ac.wis.cs.s2a.compiler.lib.MUSDArgument;
import il.ac.wis.cs.s2a.compiler.lib.MUSDCombinedFragment;
import il.ac.wis.cs.s2a.compiler.lib.StateNode;
import il.ac.wis.cs.s2a.compiler.stringutils.MUSDAspectStringGen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MSDInteractionLogic
extends HashMap<String, ArrayList<MessageData>> {
    private static final long serialVersionUID = 1L;
    static int i = 0;
    private MSDInteraction interaction;
    private StateNode tempNode;
    private HashSet<CutState> hotCutStates;
    private HashMap<CutState, ArrayList<MessageData>> cutToEnabledMessages;
    private HashMap<String, String> lineNamesToInstancesConst;
    private HashSet<CutState> finalStates;
    private HashSet<StateNode> visited;

    MSDInteractionLogic(MSDInteraction inter, HashMap<String, String> lineNamesToInstancesConst) {
        this.interaction = inter;
        this.visited = new HashSet();
        this.finalStates = new HashSet();
        this.lineNamesToInstancesConst = lineNamesToInstancesConst;
        this.hotCutStates = new HashSet();
        this.cutToEnabledMessages = new HashMap();
        StateNode root = inter.getGraph().getRoot();
        HashMap<String, Boolean> lifeLinesBindingState = this.initLifeLineBindings();
        HashMap<String, Boolean> variablesBindingState = this.initVariablesBindings();
        this.createMessageRecords(root, lifeLinesBindingState, variablesBindingState);
    }

    private void createMessageRecords(StateNode node, HashMap<String, Boolean> lifeLinesBindingState, HashMap<String, Boolean> variablesBindingState) {
        if (this.visited.contains(node)) {
            return;
        }
        this.visited.add(node);
        InteractionFragmentKey constraintKey = null;
        HashMap<String, Boolean> nextLifeLinesBindingState = new HashMap<String, Boolean>(lifeLinesBindingState);
        HashMap<String, Boolean> nextVariablesBindingState = new HashMap<String, Boolean>(variablesBindingState);
        if (node.isHot()) {
            this.hotCutStates.add(node.getCutState());
        }
        if ((constraintKey = this.getConstraintChildren(node)) != null) {
            this.createMessageRecords(node.getChild(constraintKey), nextLifeLinesBindingState, nextVariablesBindingState);
            return;
        }
        for (InteractionFragmentKey key : node.getChildren().keySet()) {
            nextLifeLinesBindingState = new HashMap<String, Boolean>(lifeLinesBindingState);
            nextVariablesBindingState = new HashMap<String, Boolean>(variablesBindingState);
            MSDInteractionFragment fragment = this.getFragment(key);
            if (fragment.getType() == 0) {
                MSDMessage mes = (MSDMessage)fragment;
                StateNode nextNode = node.getChild(key);
                MessageData data = new MessageData(node.getCutState(), mes, key.isHot(), key.isExecute());
                this.setLifelineBindings(lifeLinesBindingState, data, mes, nextLifeLinesBindingState);
                this.setBindingsConstants(data, mes);
                this.handleMessageArgsBinding(data, mes, nextVariablesBindingState);
                data.followingImmidiateEvents = this.getFollowingImmidiateEvents(data, nextNode, new HashSet<StateNode>());
                data.newState = this.tempNode.getCutState();
                if (this.tempNode.getChildren().isEmpty()) {
                    this.finalStates.add(this.tempNode.getCutState());
                }
                this.addToDataList(mes, data);
                this.addCutToMessagesCutMap(data.oldState, data);
            }
            this.createMessageRecords(node.getChild(key), nextLifeLinesBindingState, nextVariablesBindingState);
        }
    }

    private ArrayList<MSDInteractionFragment> getFollowingImmidiateEvents(MessageData data, StateNode node, HashSet<StateNode> localVisited) {
        ArrayList<MSDInteractionFragment> arr = new ArrayList<MSDInteractionFragment>();
        if (localVisited.contains(node)) {
            return arr;
        }
        HashSet<StateNode> nextVisited = new HashSet<StateNode>(localVisited);
        nextVisited.add(node);
        this.tempNode = node;
        InteractionFragmentKey key = this.getConstraintChildren(node);
        if (key != null) {
            MSDInteractionFragment fragment = this.getFragment(key);
            arr.add(fragment);
            data.beforeImmidiateCuts.put(fragment, node.getCutState());
            data.afterImmidiateCuts.put(fragment, node.getChildrenState(key));
            arr.addAll(this.getFollowingImmidiateEvents(data, node.getChild(key), nextVisited));
            return arr;
        }
        if (node.getComb2guardList().isEmpty()) {
            return arr;
        }
        for (MUSDCombinedFragment combined : node.getComb2guardList().keySet()) {
            arr.add(combined);
            data.combinedToNextCut.put(combined, node.getCombinedNextCut());
            Iterator<InteractionFragmentKey> keyIt = node.getCombGuardList(combined).iterator();
            while (keyIt.hasNext()) {
                nextVisited = new HashSet<StateNode>(localVisited);
                nextVisited.add(node);
                InteractionFragmentKey guardKey = keyIt.next();
                MSDInteractionFragment fragment = this.getFragment(guardKey);
                data.beforeImmidiateCuts.put(fragment, node.getCutState());
                data.afterImmidiateCuts.put(fragment, node.getChildrenState(guardKey));
                data.guardsTofollowingImmidiateEvents.put(fragment, this.getFollowingImmidiateEvents(data, node.getChild(guardKey), nextVisited));
            }
            if (combined.getType() == 6) continue;
            arr.addAll(this.getFollowingImmidiateEvents(data, node.getCombinedNextNode(), nextVisited));
        }
        return arr;
    }

    private HashMap<String, Boolean> initVariablesBindings() {
        HashMap<String, Boolean> variablesBindingState = new HashMap<String, Boolean>();
        for (MUSDArgument arg : this.interaction.getPrivateVariables()) {
            if (arg.isExact()) {
                variablesBindingState.put(arg.getName(), true);
                continue;
            }
            variablesBindingState.put(arg.getName(), false);
        }
        return variablesBindingState;
    }

    private HashMap<String, Boolean> initLifeLineBindings() {
        HashMap<String, Boolean> lifeLinesBindingState = new HashMap<String, Boolean>();
        for (MSDLifeline line : this.interaction.getCoveredLines()) {
            if (line.isStatic() || line.isEnv()) {
                lifeLinesBindingState.put(line.getName(), true);
            } else {
                lifeLinesBindingState.put(line.getName(), false);
            }
            MSDLifeline parentLifeline = line.getParentLine();
            if (parentLifeline == null) continue;
            boolean isBound = parentLifeline.isStatic() || parentLifeline.isEnv();
            lifeLinesBindingState.put(parentLifeline.getName(), isBound);
        }
        return lifeLinesBindingState;
    }

    private InteractionFragmentKey getConstraintChildren(StateNode node) {
        Iterator<InteractionFragmentKey> it2 = node.getChildren().keySet().iterator();
        InteractionFragmentKey key = null;
        while (it2.hasNext()) {
            key = it2.next();
            MSDInteractionFragment fragment = this.getFragment(key);
            if (fragment.getType() != 1) continue;
            return key;
        }
        return null;
    }

    private void addToDataList(MSDMessage mes, MessageData data) {
        ArrayList<MessageData> dataList = (ArrayList<MessageData>)this.get(MUSDAspectStringGen.getMessageCoddedName(mes));
        if (dataList == null) {
            dataList = new ArrayList<MessageData>();
            this.put(MUSDAspectStringGen.getMessageCoddedName(mes), dataList);
        } else {
            Iterator it = dataList.iterator();
            while (it.hasNext()) {
                if (!data.equals(it.next())) continue;
                return;
            }
        }
        dataList.add(data);
    }

    private void addCutToMessagesCutMap(CutState state, MessageData data) {
        ArrayList<MessageData> arr = this.cutToEnabledMessages.get(state);
        if (arr == null) {
            arr = new ArrayList();
            this.cutToEnabledMessages.put(state, arr);
        }
        arr.add(data);
    }

    private void handleMessageArgsBinding(MessageData data, MSDMessage mes, HashMap<String, Boolean> bindingState) {
        String name = null;
        for (MUSDArgument arg : mes.getArguments()) {
            name = arg.getName();
            boolean isBound = bindingState.get(name) == null ? false : bindingState.get(name);
            data.varNamesToBindingState.put(name, isBound);
            bindingState.put(name, true);
        }
    }

    private void setBindingsConstants(MessageData data, MSDMessage mes) {
        data.senderBindingConstant = mes.getSender().isEnv() ? "env" : this.lineNamesToInstancesConst.get(mes.getSender().getName());
        data.receiverBindingConstant = mes.getReciever().isEnv() ? "env" : this.lineNamesToInstancesConst.get(mes.getReciever().getName());
        if (mes.getSender().isIPart()) {
            data.senderOwnerBindingConstant = this.lineNamesToInstancesConst.get(mes.getSender().getParentLine().getName());
        }
        if (mes.getReciever().isIPart()) {
            data.receiverOwnerBindingConstant = this.lineNamesToInstancesConst.get(mes.getReciever().getParentLine().getName());
        }
    }

    private void setLifelineBindings(HashMap<String, Boolean> lifeLinesBindingState, MessageData data, MSDMessage mes, HashMap<String, Boolean> nextLifeLinesBindingState) {
        String ownerName;
        data.isSenderBound = lifeLinesBindingState.get(mes.getSender().getName());
        data.isReceiverBound = lifeLinesBindingState.get(mes.getReciever().getName());
        nextLifeLinesBindingState.put(mes.getSender().getName(), true);
        nextLifeLinesBindingState.put(mes.getReciever().getName(), true);
        if (mes.getReciever().isIPart()) {
            ownerName = mes.getReciever().getParentLine().getName();
            data.isReceiverOwnerBound = lifeLinesBindingState.get(ownerName);
            nextLifeLinesBindingState.put(ownerName, true);
        }
        if (mes.getSender().isIPart()) {
            ownerName = mes.getSender().getParentLine().getName();
            data.isSenderOwnerBound = lifeLinesBindingState.get(ownerName);
            nextLifeLinesBindingState.put(ownerName, true);
        }
    }

    private MSDInteractionFragment getFragment(InteractionFragmentKey key) {
        return this.interaction.getInterKeyToInterFragments().get(key);
    }

    public HashSet<CutState> getHotCutStates() {
        return this.hotCutStates;
    }

    public HashMap<CutState, ArrayList<MessageData>> getCutToEnabledMessages() {
        return this.cutToEnabledMessages;
    }

    public HashSet<CutState> getFinalStates() {
        return this.finalStates;
    }
}

