/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler.interaction2aspect;

import il.ac.wis.cs.s2a.compiler.interaction2aspect.MSDInteractionLogic;
import il.ac.wis.cs.s2a.compiler.lib.CutState;
import il.ac.wis.cs.s2a.compiler.lib.InteractionFragmentKey;
import il.ac.wis.cs.s2a.compiler.lib.MSDInteraction;
import il.ac.wis.cs.s2a.compiler.lib.MSDInteractionFragment;
import il.ac.wis.cs.s2a.compiler.lib.MSDLifeline;
import il.ac.wis.cs.s2a.compiler.lib.MSDMessage;
import il.ac.wis.cs.s2a.compiler.lib.MUSDCombinedFragment;
import il.ac.wis.cs.s2a.compiler.lib.StateNode;
import il.ac.wis.cs.s2a.compiler.stringutils.MUSDAspectStringGen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MUSDConstructorBuilder {
    private HashMap<String, Integer> lineToIndexes;
    private MSDInteractionLogic interactionLogic;
    private MSDInteraction interaction;

    public MUSDConstructorBuilder(MSDInteraction inter, MSDInteractionLogic logic, HashMap<String, Integer> lineToIndexes) {
        this.interaction = inter;
        this.interactionLogic = logic;
        this.lineToIndexes = lineToIndexes;
    }

    public String getConstructor() {
        StringBuffer code = new StringBuffer(200);
        code.append(MUSDAspectStringGen.getConstructorDecleration(this.interaction.getName()));
        code.append(this.getAddMinimalEvents());
        code.append(this.getHotCutsSetters());
        code.append(this.getLastCutSetter());
        code.append(this.getLoopSettings());
        code.append(this.getNumberOfsInit());
        code.append("\t}\n\n");
        return code.toString();
    }

    private String getLastCutSetter() {
        StringBuffer code = new StringBuffer(40);
        Iterator<CutState> it = this.interactionLogic.getFinalStates().iterator();
        ArrayList<String> cut = new ArrayList<String>(this.interaction.getNumberOfLifeLines());
        int i = 0;
        while (i < this.interaction.getNumberOfLifeLines()) {
            cut.add(null);
            ++i;
        }
        while (it.hasNext()) {
            CutState cutState = it.next();
            for (String name : cutState.keySet()) {
                String loc = String.valueOf(cutState.get(name));
                int index = this.lineToIndexes.get(name);
                cut.set(index, loc);
            }
            code.append(MUSDAspectStringGen.generateLastCutSetter(cut));
        }
        return code.toString();
    }

    private String getLoopSettings() {
        StringBuffer str = new StringBuffer();
        for (MUSDCombinedFragment comb : this.interaction.getLoopFragmentsMap().keySet()) {
            if (!comb.getFirstGuard().isConstantLoopGuard()) continue;
            int limit = comb.getFirstGuard().getLoopsNumber();
            str.append(MUSDAspectStringGen.generateAddLoop(limit));
        }
        return str.toString();
    }

    private String getHotCutsSetters() {
        StringBuffer code = new StringBuffer(40);
        Iterator<CutState> it = this.interactionLogic.getHotCutStates().iterator();
        ArrayList<String> cut = new ArrayList<String>(this.interaction.getNumberOfLifeLines());
        int i = 0;
        while (i < this.interaction.getNumberOfLifeLines()) {
            cut.add(null);
            ++i;
        }
        while (it.hasNext()) {
            CutState cutState = it.next();
            for (String name : cutState.keySet()) {
                String loc = String.valueOf(cutState.get(name));
                int index = this.lineToIndexes.get(name);
                cut.set(index, loc);
            }
            code.append(MUSDAspectStringGen.generateHotCutSetter(cut));
        }
        return code.toString();
    }

    private String getNumberOfsInit() {
        HashSet<String> parentsNames = new HashSet<String>();
        StringBuffer code = new StringBuffer(40);
        int numberOfinstances = 0;
        int numberOfLifeLines = this.interaction.getNumberOfLifeLines();
        for (MSDLifeline line : this.interaction.getCoveredLines()) {
            numberOfinstances += this.getLinePathlength(line, parentsNames);
        }
        int varsNum = this.interaction.getPrivateVariables().size();
        code.append(MUSDAspectStringGen.generateNumbersInit(numberOfLifeLines, numberOfinstances, varsNum));
        return code.toString();
    }

    private int getLinePathlength(MSDLifeline line, HashSet<String> parentsNames) {
        if (line.isEnv()) {
            return 0;
        }
        if (!line.isIPart()) {
            return 1;
        }
        if (parentsNames.add(line.getParentLine().getName())) {
            return 1 + this.getLinePathlength(line.getParentLine(), parentsNames);
        }
        return 1;
    }

    private String getAddMinimalEvents() {
        StringBuffer code = new StringBuffer(40);
        HashMap<InteractionFragmentKey, StateNode> minimalEventsMap = this.interaction.getGraph().getRoot().getChildren();
        for (InteractionFragmentKey key : minimalEventsMap.keySet()) {
            MSDInteractionFragment musdFragment = this.getFragment(key);
            if (musdFragment.getType() != 0) {
                throw new IllegalArgumentException("Interaction: " + this.interaction.getName() + " A Constraint can not be a minimal event (yet..)");
            }
            MSDMessage mes = (MSDMessage)this.getFragment(key);
            code.append(MUSDAspectStringGen.addMinimalEvent(mes.getSender().getRepresentsType(), mes.getReciever().getRepresentsType(), mes.getName()));
        }
        return code.toString();
    }

    private MSDInteractionFragment getFragment(InteractionFragmentKey key) {
        return this.interaction.getInterKeyToInterFragments().get(key);
    }
}

