/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler.interaction2aspect;

import il.ac.wis.cs.s2a.compiler.interaction2aspect.MSDInteractionLogic;
import il.ac.wis.cs.s2a.compiler.interaction2aspect.MUSDInteraction2Aspect;
import il.ac.wis.cs.s2a.compiler.interaction2aspect.MessageData;
import il.ac.wis.cs.s2a.compiler.lib.CutState;
import il.ac.wis.cs.s2a.compiler.lib.MSDConstraint;
import il.ac.wis.cs.s2a.compiler.lib.MSDInteractionFragment;
import il.ac.wis.cs.s2a.compiler.lib.MSDLifeline;
import il.ac.wis.cs.s2a.compiler.lib.MSDMessage;
import il.ac.wis.cs.s2a.compiler.lib.MUSDArgument;
import il.ac.wis.cs.s2a.compiler.stringutils.GetCutStateStringGen;
import il.ac.wis.cs.s2a.compiler.stringutils.MUSDAspectStringGen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MUSDGetCutStateBuilder {
    private final int MAX_ADD = 7;
    private MUSDInteraction2Aspect inter2Aspect;
    private MSDInteractionLogic interactionLogic;
    private HashMap<MessageData, Integer> messageDataToGeneratedMethodsNum;
    private HashMap<String, Integer> lineToIndexes;
    private HashMap<String, Integer> methodsToNumber;

    public MUSDGetCutStateBuilder(MUSDInteraction2Aspect inter2Aspect) {
        this.inter2Aspect = inter2Aspect;
        this.interactionLogic = inter2Aspect.interactionLogic;
        this.lineToIndexes = inter2Aspect.lineToIndexes;
        this.messageDataToGeneratedMethodsNum = new HashMap();
        this.methodsToNumber = new HashMap();
    }

    String getGetCutState() {
        StringBuffer code = new StringBuffer(1000);
        code.append(MUSDAspectStringGen.generateGetCutStateConst());
        code.append(this.inter2Aspect.getInstAndVarsDecleration(false));
        code.append(this.getMethodDeclerations());
        code.append(this.getIsInCutIfs());
        return code.toString();
    }

    private String getMethodDeclerations() {
        StringBuffer str = new StringBuffer(100);
        int methodNumber = this.inter2Aspect.methodNumberRange;
        boolean isSenderEnv = false;
        boolean hasArgs = false;
        for (String mesName : this.interactionLogic.keySet()) {
            for (MessageData data : (ArrayList)this.interactionLogic.get(mesName)) {
                String sender = data.realMessage.getSender().getName();
                String receiver = data.realMessage.getReciever().getName();
                String senderType = data.realMessage.getSender().getRepresentsType();
                String receiverType = data.realMessage.getReciever().getRepresentsType();
                isSenderEnv = data.realMessage.getSender().isEnv();
                hasArgs = data.realMessage.hasArguments();
                if (hasArgs) {
                    str.append(this.getMethodArguments(data.realMessage, methodNumber));
                }
                int num = hasArgs ? methodNumber : -1;
                String methodAssignment = GetCutStateStringGen.generateMUSDMethodDecleration(sender, receiver, data.isExecute, data.realMessage.getName(), isSenderEnv, senderType, receiverType, num);
                Integer realMethodNumber = this.methodsToNumber.get(methodAssignment);
                if (realMethodNumber == null) {
                    this.methodsToNumber.put(methodAssignment, methodNumber);
                    realMethodNumber = methodNumber;
                    str.append(GetCutStateStringGen.generateMUSDMethodAssignment(methodNumber, methodAssignment));
                }
                this.messageDataToGeneratedMethodsNum.put(data, realMethodNumber);
                ++methodNumber;
            }
        }
        this.inter2Aspect.finalRange = methodNumber - 1;
        return str.append("\n").toString();
    }

    private String getMethodArguments(MSDMessage mes, int number) {
        StringBuffer str = new StringBuffer(80);
        ArrayList<String> argsNames = new ArrayList<String>();
        for (MUSDArgument arg : mes.getArguments()) {
            if (this.isVarNameALifeLineName(arg.getOriginalName())) {
                argsNames.add(arg.getOriginalName());
                continue;
            }
            argsNames.add("VAR_" + arg.getName());
        }
        if (argsNames.size() > 0) {
            str.append(MUSDAspectStringGen.generateMethodArgsInit(number));
            str.append(MUSDAspectStringGen.getArgsInit(argsNames));
        }
        return str.toString();
    }

    private boolean isVarNameALifeLineName(String originalName) {
        for (MSDLifeline line : this.inter2Aspect.interaction.getCoveredLines()) {
            if (!line.getName().equals(originalName)) continue;
            return true;
        }
        return false;
    }

    private String getIsInCutIfs() {
        ArrayList cutList = new ArrayList(this.interactionLogic.getCutToEnabledMessages().keySet());
        Collections.sort(cutList);
        StringBuffer str = new StringBuffer(400);
        for (CutState cut : cutList) {
            str.append(this.generateIfIsInCutBlock(cut));
        }
        str.append("\t}\n");
        return str.toString();
    }

    private String generateIfIsInCutBlock(CutState cut) {
        StringBuffer str = new StringBuffer(100);
        str.append(GetCutStateStringGen.generateIfIsInCutForGetCutState(cut.getCutStateString(this.lineToIndexes)));
        HashSet<String> enabledMethodsConstants = new HashSet<String>();
        HashSet<String> forbiddenMethodsConstants = new HashSet<String>();
        HashSet<MessageData> forbiddenMethodsData = new HashSet<MessageData>();
        HashSet<MessageData> enabledMethodsData = new HashSet<MessageData>();
        HashSet<String> methodConstants = new HashSet<String>();
        for (MessageData data : this.interactionLogic.getCutToEnabledMessages().get(cut)) {
            int number = this.messageDataToGeneratedMethodsNum.get(data);
            String methodConstant = GetCutStateStringGen.generateMethodName(number);
            if (methodConstants.add(methodConstant)) {
                if (data.isExecute) {
                    str.append(GetCutStateStringGen.generateExecuteEnable(methodConstant));
                } else {
                    str.append(GetCutStateStringGen.generateMonitoredEnable(methodConstant));
                }
            }
            if (this.isForbbidenMessage(data)) {
                forbiddenMethodsConstants.add(methodConstant);
                forbiddenMethodsData.add(data);
                continue;
            }
            enabledMethodsConstants.add(methodConstant);
            enabledMethodsData.add(data);
        }
        if (cut.isHot()) {
            this.appendHotViolations(this.messageDataToGeneratedMethodsNum.keySet(), str, enabledMethodsConstants, enabledMethodsData);
        } else {
            this.appendColdViolations(str, enabledMethodsConstants, forbiddenMethodsConstants, enabledMethodsData);
            this.appendHotViolations(forbiddenMethodsData, str, null, null);
        }
        str.append("\t\t\t\treturn;\n\t\t}\n");
        return str.toString();
    }

    private void appendHotViolations(Set<MessageData> set, StringBuffer str, HashSet<String> enabledMethodsConstants, HashSet<MessageData> enabledMethodsData) {
        HashSet<String> allReadyProcessed = new HashSet<String>();
        int mod = 0;
        for (MessageData data : set) {
            int num = this.messageDataToGeneratedMethodsNum.get(data);
            String constant = GetCutStateStringGen.generateMethodName(num);
            if (!allReadyProcessed.add(constant) || this.isMethodEnabled(data, constant, enabledMethodsConstants, enabledMethodsData)) continue;
            this.addHotViolation(str, mod++, constant);
        }
        this.addViolationCloser(str, mod);
    }

    private boolean isMethodEnabled(MessageData data, String constant, HashSet<String> enabledMethodsConstants, HashSet<MessageData> enabledMethodsData) {
        if (enabledMethodsConstants == null) {
            return false;
        }
        if (enabledMethodsConstants.contains(constant)) {
            return true;
        }
        for (MessageData enabledData : enabledMethodsData) {
            if (!data.realMessage.localUniEquals(enabledData.realMessage)) continue;
            return true;
        }
        return false;
    }

    private void appendColdViolations(StringBuffer str, HashSet<String> methodsConstants, HashSet<String> forbiddenConstants, HashSet<MessageData> enabledMethodsData) {
        Iterator<MessageData> it = this.messageDataToGeneratedMethodsNum.keySet().iterator();
        HashSet<String> allReadyProcessed = new HashSet<String>();
        int mod = 0;
        while (it.hasNext()) {
            MessageData data = it.next();
            int num = this.messageDataToGeneratedMethodsNum.get(data);
            String constant = GetCutStateStringGen.generateMethodName(num);
            if (!allReadyProcessed.add(constant) || forbiddenConstants.contains(constant) || this.isMethodEnabled(data, constant, methodsConstants, enabledMethodsData)) continue;
            this.addColdViolation(str, mod++, constant);
        }
        this.addViolationCloser(str, mod);
    }

    private void addHotViolation(StringBuffer str, int mod, String violation) {
        if (mod % 8 == 0) {
            str.append(GetCutStateStringGen.generateHVopening(violation));
        } else {
            str.append(GetCutStateStringGen.generateCVHVConcatenating(violation));
        }
        if ((mod + 1) % 8 == 0) {
            str.append(GetCutStateStringGen.generateCVHVCloser());
        }
    }

    private void addColdViolation(StringBuffer str, int mod, String violation) {
        if (mod % 8 == 0) {
            str.append(GetCutStateStringGen.generateCVopening(violation));
        } else {
            str.append(GetCutStateStringGen.generateCVHVConcatenating(violation));
        }
        if ((mod + 1) % 8 == 0) {
            str.append(GetCutStateStringGen.generateCVHVCloser());
        }
    }

    private void addViolationCloser(StringBuffer str, int mod) {
        if (mod > 0 && mod % 8 != 0) {
            str.append(GetCutStateStringGen.generateCVHVCloser());
        }
    }

    private boolean isForbbidenMessage(MessageData data) {
        for (MSDInteractionFragment fragment : data.followingImmidiateEvents) {
            MSDConstraint constraint;
            if (fragment.getType() != 1 || !(constraint = (MSDConstraint)fragment).isHotFalseConstraint()) continue;
            return true;
        }
        return false;
    }
}

