/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler.lib;

import il.ac.wis.cs.common.log.Logger;
import il.ac.wis.cs.s2a.compiler.lib.CombinedObject;
import il.ac.wis.cs.s2a.compiler.lib.CutState;
import il.ac.wis.cs.s2a.compiler.lib.InteractionFragmentKey;
import il.ac.wis.cs.s2a.compiler.lib.MSDConstraint;
import il.ac.wis.cs.s2a.compiler.lib.MSDInteraction;
import il.ac.wis.cs.s2a.compiler.lib.MSDInteractionFragment;
import il.ac.wis.cs.s2a.compiler.lib.MSDLifeline;
import il.ac.wis.cs.s2a.compiler.lib.MSDMessage;
import il.ac.wis.cs.s2a.compiler.lib.MUSDArgument;
import il.ac.wis.cs.s2a.compiler.lib.MUSDCombinedFragment;
import il.ac.wis.cs.s2a.compiler.lib.MUSDInteractionGuard;
import il.ac.wis.cs.s2a.compiler.lib.StateNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;

public class InteractionGraph {
    static Logger logger = Logger.getLocalLogger(InteractionGraph.class);
    protected MSDInteraction refferedInteraction;
    protected ArrayList<InteractionFragmentKey> fragmentOrderedList;
    protected StateNode root;
    protected HashMap<InteractionFragmentKey, CutState> keyToEnabledProjectedCutState;
    private HashMap<CutState, StateNode> cutToNodesMap;

    protected InteractionGraph() {
    }

    public InteractionGraph(MSDInteraction interaction) {
        this.refferedInteraction = interaction;
        this.fragmentOrderedList = interaction.getFragmentsOrderedList();
        this.keyToEnabledProjectedCutState = this.processListOfFragments();
        this.cutToNodesMap = new HashMap();
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long usedMemSizeBeforeGraphCreation = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long t = System.currentTimeMillis();
        this.root = this.createStateNode(new HashSet<InteractionFragmentKey>(), new CutState(this.refferedInteraction.getCoveredLines()), null, new Stack<CombinedObject>(), "");
        interaction.logInfo();
        logger.performanceInfo("Building the graph for interaction \"" + interaction.getName() + "\" took " + (System.currentTimeMillis() - t) + " milliseconds");
        long usedMemSizeAfterGraphCreation = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        logger.performanceInfo("Estimated size of graph of interaction \"" + interaction.getName() + "\" in memory is: " + (usedMemSizeAfterGraphCreation - usedMemSizeBeforeGraphCreation) / 1024L + "KB");
    }

    protected HashMap<InteractionFragmentKey, CutState> processListOfFragments() {
        HashMap<InteractionFragmentKey, CutState> map = new HashMap<InteractionFragmentKey, CutState>();
        CutState curCut = new CutState(this.refferedInteraction.getCoveredLines());
        for (InteractionFragmentKey key : this.fragmentOrderedList) {
            CutState newCut = this.getNewCutState(key, curCut);
            map.put(key, newCut);
        }
        return map;
    }

    private CutState getNewCutState(InteractionFragmentKey key, CutState allCut) {
        CutState newCut = new CutState();
        Iterator<MSDLifeline> it = key.getCoveredLifelines().iterator();
        while (it.hasNext()) {
            String name = it.next().getName();
            int i = (Integer)allCut.get(name);
            newCut.put(name, new Integer(++i));
            allCut.put(name, new Integer(i));
        }
        return newCut;
    }

    protected boolean isViolation(InteractionFragmentKey key, CutState cutState) {
        CutState newCut = this.keyToEnabledProjectedCutState.get(key);
        boolean equals = true;
        for (String name : newCut.keySet()) {
            int new_;
            int old = (Integer)cutState.get(name);
            if (old != (new_ = ((Integer)newCut.get(name)).intValue())) {
                equals = false;
            }
            if (new_ - old >= 0 && new_ - old <= 1) continue;
            return true;
        }
        return equals;
    }

    protected StateNode createStateNode(HashSet<InteractionFragmentKey> occuredInterKeys, CutState cutState, StateNode parent, Stack<CombinedObject> combindObjectStack, String ident) {
        StateNode curNode = new StateNode(cutState, parent);
        this.cutToNodesMap.put(cutState, curNode);
        HashSet<InteractionFragmentKey> enabledEvents = this.getEnabledEvents(occuredInterKeys, cutState);
        if (enabledEvents.isEmpty()) {
            return curNode;
        }
        for (InteractionFragmentKey key : enabledEvents) {
            HashSet<InteractionFragmentKey> tempOccuredInterKeys = new HashSet<InteractionFragmentKey>(occuredInterKeys);
            tempOccuredInterKeys.add(key);
            this.updateNodeTemperature(key, curNode);
            if (MUSDCombinedFragment.isCombined(this.getFragment(key))) {
                this.buildCombinedFragmentSection(key, combindObjectStack, curNode, tempOccuredInterKeys, String.valueOf(ident) + "\t");
                continue;
            }
            if (!combindObjectStack.isEmpty() && combindObjectStack.peek().isKeyLastInCurOperand(key)) {
                this.handleLastOperandsEvent(key, curNode, combindObjectStack.peek(), tempOccuredInterKeys);
                continue;
            }
            CutState nextCut = this.getNextCutState(key, cutState);
            StateNode tempNode = this.createStateNode(tempOccuredInterKeys, nextCut, curNode, combindObjectStack, String.valueOf(ident) + "\t");
            curNode.addChild(key, tempNode);
        }
        return curNode;
    }

    private void handleLastOperandsEvent(InteractionFragmentKey key, StateNode currentNode, CombinedObject comb, HashSet<InteractionFragmentKey> occuredKeys) {
        CutState nextCut = this.getNextCutState(key, currentNode.getCutState());
        StateNode dummyNode = new StateNode(nextCut, currentNode);
        comb.lastCut = nextCut;
        comb.dummyNodes.add(dummyNode);
        comb.putInDummyToOccurMap(dummyNode, occuredKeys);
        currentNode.addDummyChild(dummyNode, key);
    }

    private void buildCombinedFragmentSection(InteractionFragmentKey key, Stack<CombinedObject> combinedObjectStack, StateNode currentNode, HashSet<InteractionFragmentKey> occuredInterKeys, String ident) {
        CutState nextCut;
        MUSDCombinedFragment combined = (MUSDCombinedFragment)this.getFragment(key);
        CombinedObject combinedObject = new CombinedObject(this.refferedInteraction, combined, this.getNextCutState(key, currentNode.getCutState()));
        combinedObjectStack.push(combinedObject);
        ArrayList<MUSDInteractionGuard> guardList = combined.getAllGuards();
        currentNode.addCombinedFragment(combined);
        for (MUSDInteractionGuard guard : guardList) {
            InteractionFragmentKey guardKey = new InteractionFragmentKey(false, true, combined.getCoveredLines());
            this.putFragment(guardKey, guard);
            currentNode.addCombinedFragmentGuard(combined, guardKey);
            nextCut = this.updateCut(combinedObject, currentNode.getCutState(), combinedObject.getLastCut());
            StateNode nextNode = this.createStateNode(occuredInterKeys, nextCut, currentNode, combinedObjectStack, String.valueOf(ident) + "\t");
            currentNode.addChild(guardKey, nextNode);
            combinedObject.nextOperand();
            combinedObject.setFirstNode(nextNode);
        }
        combinedObjectStack.pop();
        int last = combinedObject.dummyNodes.size() - 1;
        CutState lastCut = combinedObject.dummyNodes.get(last).getCutState();
        this.handleDummyNode(combinedObject, combinedObjectStack, ident);
        combinedObject.realLastNode = this.handleDummyNode(combinedObject, combinedObjectStack, ident);
        nextCut = this.updateCut(combinedObject, currentNode.getCutState(), lastCut);
        currentNode.setCombinedNextCut(nextCut);
        currentNode.setCombinedNextNode(combinedObject.getRealLastNode());
        if (this.getFragment((InteractionFragmentKey)key).type == 6) {
            this.handleLastLoopNode(combinedObject);
        }
    }

    private StateNode handleDummyNode(CombinedObject combObject, Stack<CombinedObject> combinedObjectStack, String ident) {
        ArrayList<StateNode> list = combObject.dummyNodes;
        StateNode newNode = null;
        for (StateNode node : list) {
            StateNode parent = node.getParent();
            InteractionFragmentKey key = parent.getDummyKey(node);
            CutState nextCut = this.updateCut(combObject, node.getCutState(), combObject.getLastCut());
            HashSet<InteractionFragmentKey> occuredKeys = combObject.getOccuredInterKey(node);
            newNode = this.createStateNode(occuredKeys, nextCut, parent, combinedObjectStack, ident);
            parent.addChild(key, newNode);
        }
        return newNode;
    }

    private CutState updateCut(CombinedObject combObject, CutState currentCutState, CutState lastCut) {
        if (lastCut == null) {
            return new CutState();
        }
        CutState state = new CutState(currentCutState);
        for (MSDLifeline line : combObject.currentCombFragment.getCoveredLines()) {
            if (lastCut.get(line.getName()) == null) continue;
            state.put(line.getName(), (Integer)lastCut.get(line.getName()));
        }
        return state;
    }

    private void handleLastLoopNode(CombinedObject object) {
        MUSDCombinedFragment combined = object.currentCombFragment;
        MUSDInteractionGuard guard = combined.getAllGuards().get(0);
        InteractionFragmentKey guardKey = new InteractionFragmentKey(false, true, combined.getCoveredLines());
        this.putFragment(guardKey, guard);
        StateNode lastNode = object.realLastNode;
        lastNode.addCombinedFragment(combined);
        lastNode.addCombinedFragmentGuard(combined, guardKey);
        lastNode.addChild(guardKey, object.getFirstNode());
        lastNode.setCombinedNextCut(object.getRealLastCutState());
        lastNode.setCombinedNextNode(object.getRealLastNode());
    }

    private void updateNodeTemperature(InteractionFragmentKey key, StateNode node) {
        if (key.isHot()) {
            node.setHot(true);
        }
        if (key.isExecute()) {
            node.setExecute(true);
        }
    }

    private CutState getNextCutState(InteractionFragmentKey key, CutState cutState) {
        CutState tempCut = new CutState(cutState);
        Iterator<MSDLifeline> it = key.getCoveredLifelines().iterator();
        while (it.hasNext()) {
            String name = it.next().getName();
            int state = (Integer)cutState.get(name);
            tempCut.put(name, new Integer(++state));
        }
        return tempCut;
    }

    protected HashSet<InteractionFragmentKey> getEnabledEvents(HashSet<InteractionFragmentKey> occuredInterKeys, CutState cutState) {
        HashSet<InteractionFragmentKey> min = new HashSet<InteractionFragmentKey>(this.fragmentOrderedList);
        for (InteractionFragmentKey key : this.fragmentOrderedList) {
            if (!occuredInterKeys.contains(key) && !this.isViolation(key, cutState)) continue;
            min.remove(key);
        }
        return min;
    }

    private MSDInteractionFragment getFragment(InteractionFragmentKey key) {
        return this.refferedInteraction.getInterKeyToInterFragments().get(key);
    }

    private void putFragment(InteractionFragmentKey key, MSDInteractionFragment frag) {
        this.refferedInteraction.getInterKeyToInterFragments().put(key, frag);
    }

    public StateNode getRoot() {
        return this.root;
    }

    public void printGraph() {
        System.out.println("Printing Graph for interaction:" + this.refferedInteraction.getName() + "\n");
        StateNode root = this.root;
        HashMap<StateNode, Integer> isVisited = new HashMap<StateNode, Integer>();
        this.printSubGraph(root, isVisited, "");
        System.out.println("\n\n\n\n\n\n");
    }

    private void printSubGraph(StateNode node, HashMap<StateNode, Integer> isVisited, String ident) {
        this.printNode(ident, node);
        HashMap<InteractionFragmentKey, StateNode> map = node.getChildren();
        int i = -1;
        if (isVisited.get(node) != null) {
            i = isVisited.get(node);
        }
        isVisited.put(node, ++i);
        if (map == null || map.isEmpty()) {
            System.out.println("****** End Of one Sub Trace;****************");
            return;
        }
        Iterator<InteractionFragmentKey> it = map.keySet().iterator();
        ident = String.valueOf(ident) + "    ";
        while (it.hasNext()) {
            InteractionFragmentKey key = it.next();
            StateNode curNode = map.get(key);
            this.printInterKey(key);
            if (isVisited.get(curNode) != null && isVisited.get(curNode) >= 1) continue;
            this.printSubGraph(curNode, isVisited, ident);
        }
    }

    private void printInterKey(InteractionFragmentKey key) {
        StringBuffer str = new StringBuffer();
        MSDInteractionFragment interFrag = this.getFragment(key);
        if (interFrag.getType() == 0) {
            str.append("Method named: ");
            MSDMessage mes = (MSDMessage)this.getFragment(key);
            str.append(String.valueOf(mes.getName()) + " sender is:" + mes.getSender().getName() + ". reciever is: " + mes.getReciever().getName());
            if (mes.hasArguments()) {
                Iterator<Object> it = mes.getArguments().iterator();
                int j = 0;
                while (it.hasNext()) {
                    str.append(" arg").append(j).append(": ");
                    str.append(((MUSDArgument)it.next()).getStringValue());
                    ++j;
                }
            }
        }
        if (interFrag.getType() == 1) {
            str.append("Constraint: ");
            MSDConstraint con = (MSDConstraint)this.getFragment(key);
            str.append(", expressions: ");
            for (String s : con.getExpression()) {
                str.append(String.valueOf(s) + " ");
            }
            Iterator<MSDLifeline> it2 = con.getCoveredLines().iterator();
            str.append(". covered lifeLines: ");
            while (it2.hasNext()) {
                str.append(String.valueOf(it2.next().getName()) + " , ");
            }
        }
        if (interFrag.type == 3) {
            str.append("GuardCondition: ");
            MUSDInteractionGuard guard = (MUSDInteractionGuard)this.getFragment(key);
            str.append(",expressions: ");
            for (String s : guard.getExpression()) {
                str.append(String.valueOf(s) + " ");
            }
            Iterator<MSDLifeline> it2 = guard.getCoveredLines().iterator();
            str.append(". the guard covers: ");
            while (it2.hasNext()) {
                str.append(String.valueOf(it2.next().getName()) + " , ");
            }
        }
        System.out.println(str.toString());
    }

    private void printNode(String ident, StateNode node) {
        StringBuffer str = new StringBuffer("node cut state:  ");
        for (String s : node.getCutState().keySet()) {
            Integer i = (Integer)node.getCutState().get(s);
            str.append(" " + s + " is in cut: " + i + " ");
        }
        System.out.println(String.valueOf(ident) + str.toString());
    }

    public void printList(String id, HashSet<InteractionFragmentKey> set) {
        this.printList(id, new ArrayList<InteractionFragmentKey>(set));
    }

    public void printList(String id, ArrayList<InteractionFragmentKey> list) {
        Iterator<InteractionFragmentKey> it = list.iterator();
        System.out.print(id);
        while (it.hasNext()) {
            InteractionFragmentKey key = it.next();
            this.printInterKey(key);
            CutState state = this.keyToEnabledProjectedCutState.get(key);
            System.out.println(" state is: " + state);
        }
    }

    public ArrayList<InteractionFragmentKey> getFragmentOrderedList() {
        return this.fragmentOrderedList;
    }
}

