/*
 * Decompiled with CFR 0.152.
 */
package il.ac.wis.cs.s2a.compiler.lib;

import il.ac.wis.cs.common.uml2.ModalProfileUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Lifeline;

public class MSDLifeline {
    public static final String ENV = "env";
    private MSDLifeline parentLine = null;
    private String name;
    private String represents;
    private String representsType;
    private boolean isEnv;
    private boolean isStab;
    private boolean isStatic;
    private boolean isDecomposed;

    public MSDLifeline(Lifeline line) {
        this.name = MSDLifeline.getName(line).trim();
        this.isStatic = ModalProfileUtils.isSystem(line);
        this.isEnv = ModalProfileUtils.isEnvironment(line);
        this.represents = line.getRepresents().getType().getName();
        this.representsType = this.isEnv ? ENV : line.getRepresents().getType().getName();
        this.isStab = line.getRepresents().getType().getName().equals("STAB");
        this.isDecomposed = line.getDecomposedAs() != null;
    }

    public MSDLifeline(Lifeline line, MSDLifeline parent) {
        this(line);
        this.parentLine = parent;
    }

    public boolean isDecomposed() {
        return this.isDecomposed;
    }

    public boolean isStab() {
        return this.isStab;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isEnv() {
        return this.isEnv;
    }

    public String getName() {
        return this.name;
    }

    public String getRepresents() {
        return this.represents;
    }

    public String getRepresentsType() {
        return this.representsType;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        MSDLifeline line = (MSDLifeline)o;
        return this.isStatic == line.isStatic && this.isEnv == line.isEnv && this.name.equals(line.name) && this.represents.equals(line.represents) && this.representsType.equals(line.representsType) && this.isStab == line.isStab;
    }

    public static String getName(Lifeline line) {
        return line.getName() != null ? line.getName() : line.getRepresents().getName();
    }

    public MSDLifeline getParentLine() {
        return this.parentLine;
    }

    public boolean isIPart() {
        return this.parentLine != null;
    }

    public boolean isDecomposed(EList covereds) {
        for (Lifeline line : covereds) {
            if (!this.name.equals(line.getName()) || line.getDecomposedAs() == null) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

