/*
 * Decompiled with CFR 0.152.
 */
package pacman.classes;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import pacman.classes.GameControl;
import pacman.classes.GameModel;

class BottomCanvas
extends Canvas {
    Font m_font;
    GameModel m_gameModel;
    GameControl m_pacMan;
    Image m_offImage;
    Graphics m_offGraphics;
    Dimension m_offDim;

    public BottomCanvas(GameControl pacMan, GameModel gameModel, int width, int height) {
        this.setSize(width, height);
        this.m_gameModel = gameModel;
        this.m_pacMan = pacMan;
        this.m_font = new Font("Helvetica", 1, 18);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        if (this.m_offImage == null || this.m_offDim.width != dim.width || this.m_offDim.height != dim.height) {
            this.m_offDim = dim;
            this.m_offImage = this.createImage(this.m_offDim.width, this.m_offDim.height);
            this.m_offGraphics = this.m_offImage.getGraphics();
        }
        double pacManDiameter = this.m_offDim.height / 15;
        int x = 0;
        int y = 0;
        String stageString = "Level " + Integer.toString(this.m_gameModel.m_stage);
        this.m_offGraphics.setColor(Color.black);
        this.m_offGraphics.fillRect(0, 0, this.m_offDim.width, this.m_offDim.height);
        this.m_offGraphics.setFont(this.m_font);
        FontMetrics fm = this.m_offGraphics.getFontMetrics();
        y = fm.getAscent() + fm.getDescent();
        x = 0;
        this.m_offGraphics.setColor(Color.white);
        this.m_offGraphics.drawString(stageString, x, y);
        y += fm.getAscent() + fm.getDescent();
        this.m_offGraphics.setColor(Color.yellow);
        int i = 0;
        while (i < this.m_gameModel.m_nLives) {
            this.m_offGraphics.fillArc(x, y, (int)pacManDiameter, (int)pacManDiameter, 45, 200);
            this.m_offGraphics.fillArc(x, y, (int)pacManDiameter, (int)pacManDiameter, -45, -200);
            x = (int)((double)x + pacManDiameter * 1.5);
            ++i;
        }
        this.m_offGraphics.setColor(Color.white);
        x = 0;
        this.m_offGraphics.drawString("Use Arrow Keys", x, y += 2 * (int)pacManDiameter + fm.getAscent() + fm.getDescent());
        this.m_offGraphics.drawString("'N' for New Game", x, y += fm.getAscent() + fm.getDescent());
        this.m_offGraphics.drawString("'P' to Pause", x, y += fm.getAscent() + fm.getDescent());
        this.m_offGraphics.drawString("'A' for About", x, y += fm.getAscent() + fm.getDescent());
        y += fm.getAscent() + fm.getDescent();
        if (this.m_pacMan.m_soundMgr != null && this.m_pacMan.m_soundMgr.m_bEnabled) {
            this.m_offGraphics.drawString("'S' for No Sound", x, y);
        } else {
            this.m_offGraphics.drawString("'S' for Sound", x, y);
        }
        g.drawImage(this.m_offImage, 0, 0, this);
    }
}

