/*
 * Decompiled with CFR 0.152.
 */
package pacman.classes;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pacman.aspects.MSDAspectPacmanEatsFruit;
import pacman.aspects.MSDCoordinatorAspect;
import pacman.classes.GameModel;
import pacman.classes.GameUI;
import pacman.classes.Player;
import pacman.classes.Thing;

public class Fruit
extends Thing {
    Color m_color;
    int m_destinationX;
    int m_destinationY;
    boolean m_bAvailable;
    int m_nTicks2Show;
    int m_nTicks2Hide;
    int m_bounceCount;
    int m_nTicks2Popup;
    int m_eatenPoints;
    boolean m_bounceUp = true;
    double m_bounceY = 0.0;
    public int score = 0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    Fruit(GameModel gameModel, byte type, int startX, int startY, boolean bMiddleX) {
        super(gameModel, type, startX, startY, bMiddleX);
        this.m_deltaMax = 5;
    }

    @Override
    public void draw(GameUI gameUI, Graphics g2) {
        double fruitX = gameUI.m_gridInset + this.m_locX * gameUI.CELL_LENGTH;
        double fruitY = gameUI.m_gridInset + this.m_locY * gameUI.CELL_LENGTH;
        if (this.m_deltaLocX != 0) {
            fruitX += (double)this.m_deltaLocX * ((double)gameUI.CELL_LENGTH / ((double)this.m_deltaMax * 2.0 - 1.0));
        } else if (this.m_deltaLocY != 0) {
            fruitY += (double)this.m_deltaLocY * ((double)gameUI.CELL_LENGTH / ((double)this.m_deltaMax * 2.0 - 1.0));
        }
        if (this.m_nTicks2Popup > 0) {
            g2.setColor(Color.cyan);
            g2.setFont(this.m_gameModel.m_pacMan.m_gameUI.m_font);
            FontMetrics fm = g2.getFontMetrics();
            g2.drawString(Integer.toString(this.m_eatenPoints), (int)fruitX, (int)fruitY + fm.getAscent());
            this.m_gameModel.m_pacMan.m_gameUI.m_bRedrawAll = true;
            return;
        }
        if (!this.m_bVisible || !this.m_bAvailable) {
            return;
        }
        g2.setColor(new Color(254, 184, 4));
        g2.fillOval((int)fruitX, (int)(fruitY += Math.sin(0.017 * (double)this.m_gameModel.m_pacMan.m_globalTickCount * 25.0) * (double)gameUI.WALL1), gameUI.CELL_LENGTH, gameUI.CELL_LENGTH);
        g2.setColor(new Color(28, 232, 4));
        g2.fillRect((int)fruitX, (int)fruitY, gameUI.WALL1, gameUI.WALL1);
        g2.fillRect((int)(fruitX + (double)gameUI.WALL1), (int)(fruitY + (double)gameUI.WALL1), gameUI.WALL1, gameUI.WALL1);
        this.m_boundingBox.setBounds((int)fruitX, (int)fruitY, gameUI.CELL_LENGTH, gameUI.CELL_LENGTH);
    }

    @Override
    public void tickThing() {
        block19: {
            if (this.m_nTicks2Popup > 0) {
                --this.m_nTicks2Popup;
                if (this.m_nTicks2Popup == 0) {
                    boolean bl = false;
                    GameModel gameModel = this.m_gameModel;
                    JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, (Object)this, (Object)gameModel, Conversions.booleanObject(bl));
                    try {
                        gameModel.setPausedGame(bl);
                    }
                    finally {
                        MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
                    }
                    this.m_gameModel.m_player.setVisible(true);
                }
            }
            int prevDirection = 0;
            Point nextLocation = new Point();
            if (this.m_nTicks2Show > 0) {
                --this.m_nTicks2Show;
                if (this.m_nTicks2Show == 0) {
                    this.enterScreen();
                } else {
                    this.m_bVisible = false;
                    return;
                }
            }
            if (this.m_nTicks2Show == 0 && this.m_nTicks2Hide > 0) {
                --this.m_nTicks2Hide;
                if (this.m_nTicks2Hide == 0) {
                    this.m_bVisible = false;
                    this.m_nTicks2Show = 10000 / this.m_gameModel.m_pacMan.m_delay;
                    return;
                }
            }
            if (!this.m_bAvailable) {
                return;
            }
            if (this.m_destinationX >= 0 && this.m_destinationY >= 0) {
                if (this.m_destinationX == this.m_locX && this.m_destinationY == this.m_locY && this.m_deltaLocX == 0 && this.m_deltaLocY == 0) {
                    this.m_destinationX = -1;
                    this.m_destinationY = -1;
                    prevDirection = this.m_direction;
                } else {
                    return;
                }
            }
            this.m_direction = 0;
            while (true) {
                double randomNum;
                if ((randomNum = Math.random()) < 0.25 && prevDirection != 2 && (this.m_gameModel.m_gameState[this.m_locX][this.m_locY] & 1) == 0) {
                    if (!this.getDestination(1, this.m_locX, this.m_locY, nextLocation)) continue;
                    this.m_destinationX = nextLocation.x;
                    this.m_destinationY = nextLocation.y;
                    this.m_direction = 1;
                    break block19;
                }
                if (randomNum < 0.5 && prevDirection != 3 && (this.m_gameModel.m_gameState[this.m_locX][this.m_locY] & 2) == 0) {
                    if (!this.getDestination(4, this.m_locX, this.m_locY, nextLocation)) continue;
                    this.m_destinationX = nextLocation.x;
                    this.m_destinationY = nextLocation.y;
                    this.m_direction = (byte)4;
                    break block19;
                }
                if (randomNum < 0.75 && prevDirection != 1 && (this.m_gameModel.m_gameState[this.m_locX][this.m_locY] & 4) == 0) {
                    if (!this.getDestination(2, this.m_locX, this.m_locY, nextLocation)) continue;
                    this.m_destinationX = nextLocation.x;
                    this.m_destinationY = nextLocation.y;
                    this.m_direction = (byte)2;
                    break block19;
                }
                if (randomNum < 1.0 && prevDirection != 4 && (this.m_gameModel.m_gameState[this.m_locX][this.m_locY] & 8) == 0 && this.getDestination(3, this.m_locX, this.m_locY, nextLocation)) break;
            }
            this.m_destinationX = nextLocation.x;
            this.m_destinationY = nextLocation.y;
            this.m_direction = (byte)3;
        }
    }

    private void enterScreen() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, this, this);
        try {
            try {
                this.returnToStart();
                this.m_bVisible = true;
                this.m_nTicks2Hide = 15000 / this.m_gameModel.m_pacMan.m_delay;
            }
            finally {
                MSDAspectPacmanEatsFruit.aspectOf().ajc$after$pacman_aspects_MSDAspectPacmanEatsFruit$4$7724e6ef(this);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    @Override
    public void returnToStart() {
        super.returnToStart();
        this.m_destinationX = -1;
        this.m_destinationY = -1;
        this.m_bVisible = false;
    }

    @Override
    public int checkCollision(Player player) {
        if (!this.m_bAvailable || !this.m_bVisible) {
            return 0;
        }
        Rectangle intersectRect = this.m_boundingBox.intersection(player.m_boundingBox);
        if (!intersectRect.isEmpty()) {
            this.m_destinationX = -1;
            this.m_destinationY = -1;
            this.setVisible(false);
            this.m_bAvailable = false;
            boolean bl = true;
            GameModel gameModel = this.m_gameModel;
            JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, (Object)this, (Object)gameModel, Conversions.booleanObject(bl));
            try {
                gameModel.setPausedGame(bl);
            }
            finally {
                MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
            }
            this.m_nTicks2Popup = 500 / this.m_gameModel.m_pacMan.m_delay;
            player.setVisible(false);
            return 3;
        }
        return 0;
    }

    public void eatenByPacman() {
    }

    public void calcPlayerScore() {
        int n;
        GameModel gameModel = this.m_gameModel;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, this, gameModel);
        try {
            try {
                n = gameModel.getFruitScore();
            }
            finally {
                MSDAspectPacmanEatsFruit.aspectOf().ajc$after$pacman_aspects_MSDAspectPacmanEatsFruit$5$29990d53(this, gameModel);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
        this.m_eatenPoints = n;
        this.score = n;
        if (this.m_eatenPoints > 7500) {
            this.m_eatenPoints = 7500;
        }
    }

    public void updtePlayerScore(Player player) {
        int n = this.m_eatenPoints;
        Player player2 = player;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, (Object)this, (Object)player2, Conversions.intObject(n));
        try {
            try {
                player2.increaseScore(n);
            }
            finally {
                MSDAspectPacmanEatsFruit.aspectOf().ajc$after$pacman_aspects_MSDAspectPacmanEatsFruit$1$828a4c4b(this, player2);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    static {
        Factory factory = new Factory("Fruit.java", Class.forName("pacman.classes.Fruit"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "setPausedGame", "pacman.classes.GameModel", "boolean:", "bPaused:", "", "void"), 79);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "enterScreen", "pacman.classes.Fruit", "", "", "", "void"), 185);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "setPausedGame", "pacman.classes.GameModel", "boolean:", "bPaused:", "", "void"), 218);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getFruitScore", "pacman.classes.GameModel", "", "", "", "int"), 234);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "increaseScore", "pacman.classes.Player", "int:", "points:", "", "void"), 243);
    }
}

