/*
 * Decompiled with CFR 0.152.
 */
package pacman.classes;

import java.awt.Color;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pacman.aspects.MSDAspectPowerUpEaten;
import pacman.aspects.MSDCoordinatorAspect;
import pacman.classes.Fruit;
import pacman.classes.GameControl;
import pacman.classes.Ghost;
import pacman.classes.Player;
import pacman.classes.Thing;

public class GameModel {
    static final int GS_NORTH = 1;
    static final int GS_EAST = 2;
    static final int GS_SOUTH = 4;
    static final int GS_WEST = 8;
    static final int GS_FOOD = 16;
    static final int GS_POWERUP = 32;
    static final int PAL_BEND_TOPLEFT = 64;
    static final int PAL_BEND_BOTTOMLEFT = 128;
    static final int PAL_BEND_BOTTOMRIGHT = 256;
    static final int PAL_BEND_TOPRIGHT = 512;
    static final int PAL_EDGE_TOP = 1024;
    static final int PAL_EDGE_LEFT = 4096;
    static final int PAL_EDGE_BOTTOM = 8192;
    static final int PAL_EDGE_RIGHT = 16384;
    static final int PAL_LINE_HORIZ = 32768;
    static final int PAL_LINE_VERT = 65536;
    static final int STATE_START = 0;
    static final int STATE_DEADPACMAN = 1;
    public static final int STATE_GAMEOVER = 2;
    public static final int STATE_LEVELCOMPLETE = 3;
    static final int STATE_PLAYING = 4;
    public static final int STATE_BEGIN_PLAY = 5;
    public static final int STATE_DEAD_PLAY = 6;
    static final int STATE_NEWGAME = 7;
    static final int STATE_PAUSED = 8;
    static final int STATE_INTRO = 9;
    static final int STATE_ABOUT = 10;
    int[][] m_gameState;
    int m_gameSizeX;
    int m_gameSizeY;
    int m_stage;
    public int m_state = 9;
    int m_pausedState;
    Thing[] m_things;
    Ghost[] m_ghosts;
    Player m_player;
    GameControl m_pacMan;
    Fruit m_fruit;
    public int m_highScore = 10000;
    int m_nextFreeUp = 10000;
    int m_doorLocX = 13;
    int m_doorLocY = 12;
    int m_nTicksPowerup;
    int m_nTicks2LevelComp = 0;
    int m_nTicks2BeginPlay = 0;
    int m_readyY = 17;
    boolean m_bPlayStartClip = true;
    boolean m_bStartClipPlayed = false;
    int m_nTicks2DeadPlay;
    int m_nOrigTicksPerSecond;
    int m_nLives = 2;
    int m_eatGhostPoints = 200;
    int m_totalFoodCount = 0;
    int m_currentFoodCount = 0;
    int m_nTicks2Backoff;
    boolean m_bIntroInited = false;
    int m_nTicks2AboutShow = 0;
    int m_nTicks2GameOver = 0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    GameModel(GameControl pacMan) {
        this.m_pacMan = pacMan;
        this.m_stage = 1;
        this.m_player = new Player(this, 0, 13, 23, true);
        this.m_ghosts = new Ghost[4];
        this.m_ghosts[0] = new Ghost(this, 1, 13, 11, true, Color.red, 0);
        this.m_ghosts[1] = new Ghost(this, 1, 12, 14, false, Color.pink, 2000);
        this.m_ghosts[2] = new Ghost(this, 1, 13, 14, true, Color.cyan, 4000);
        this.m_ghosts[3] = new Ghost(this, 1, 15, 14, false, Color.orange, 6000);
        this.m_fruit = new Fruit(this, 2, 13, 17, true);
        this.m_gameSizeX = 28;
        this.m_gameSizeY = 31;
        this.m_gameState = new int[this.m_gameSizeX][this.m_gameSizeY];
        this.fillThingArray();
    }

    public static boolean hasNorthWall(short gameCell) {
        return (gameCell & 1) != 0;
    }

    public static boolean hasEastWall(short gameCell) {
        return (gameCell & 2) != 0;
    }

    public static boolean hasSouthWall(short gameCell) {
        return (gameCell & 4) != 0;
    }

    public static boolean hasWestWall(short gameCell) {
        return (gameCell & 8) != 0;
    }

    public void fillThingArray() {
        int thingsLength = this.m_ghosts.length + 2;
        this.m_things = new Thing[thingsLength];
        this.m_things[0] = this.m_player;
        this.m_things[1] = this.m_fruit;
        this.m_things[2] = this.m_ghosts[0];
        this.m_things[3] = this.m_ghosts[1];
        this.m_things[4] = this.m_ghosts[2];
        this.m_things[5] = this.m_ghosts[3];
    }

    public void completeGameState() {
        short gameState = 0;
        int x = 0;
        while (x < this.m_gameSizeX / 2) {
            int y = 0;
            while (y < this.m_gameSizeY) {
                if ((this.m_gameState[x][y] & 1) != 0) {
                    gameState = (short)(gameState | 1);
                }
                if ((this.m_gameState[x][y] & 4) != 0) {
                    gameState = (short)(gameState | 4);
                }
                if ((this.m_gameState[x][y] & 8) != 0) {
                    gameState = (short)(gameState | 2);
                }
                if ((this.m_gameState[x][y] & 2) != 0) {
                    gameState = (short)(gameState | 8);
                }
                if ((this.m_gameState[x][y] & 0x10) != 0) {
                    gameState = (short)(gameState | 0x10);
                }
                if ((this.m_gameState[x][y] & 0x20) != 0) {
                    gameState = (short)(gameState | 0x20);
                }
                int[] nArray = this.m_gameState[this.m_gameSizeX - x - 1];
                int n = y++;
                nArray[n] = nArray[n] | gameState;
                gameState = 0;
            }
            ++x;
        }
    }

    public void setPausedGame(boolean bPaused) {
        int i = 0;
        while (i < this.m_things.length) {
            this.m_things[i].setPaused(bPaused);
            ++i;
        }
    }

    public void setVisibleThings(boolean bVisible) {
        int i = 0;
        while (i < this.m_things.length) {
            this.m_things[i].setVisible(bVisible);
            ++i;
        }
    }

    public void eatPowerup() {
        int i = 0;
        while (i < this.m_ghosts.length) {
            this.m_pacMan.updateGohstOnPowerup(this.m_ghosts[i]);
            this.m_ghosts[i].pacmanAtePowerup1();
            if (!this.m_ghosts[i].m_bEaten) {
                this.m_ghosts[i].m_nTicks2Flee = this.m_nTicksPowerup;
                if (!(this.m_ghosts[i].m_destinationX == this.m_doorLocX && this.m_ghosts[i].m_destinationY == this.m_doorLocY + 2 && this.m_ghosts[i].m_direction == 2 || this.m_ghosts[i].m_destinationX == this.m_doorLocX && this.m_ghosts[i].m_destinationY == this.m_doorLocY - 1 && this.m_ghosts[i].m_direction == 1)) {
                    this.m_ghosts[i].m_destinationX = -1;
                    this.m_ghosts[i].m_destinationY = -1;
                }
            }
            ++i;
        }
        this.resetGhostPoints();
    }

    private void resetGhostPoints() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        try {
            try {
                this.m_eatGhostPoints = 200;
            }
            finally {
                MSDAspectPowerUpEaten.aspectOf().ajc$after$pacman_aspects_MSDAspectPowerUpEaten$4$54707167(this);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    public int getTotalFoodCount() {
        int foodCount = 0;
        int x = 0;
        while (x < this.m_gameSizeX) {
            int y = 0;
            while (y < this.m_gameSizeY) {
                if ((this.m_gameState[x][y] & 0x10) != 0) {
                    ++foodCount;
                }
                if ((this.m_gameState[x][y] & 0x20) != 0) {
                    ++foodCount;
                }
                ++y;
            }
            ++x;
        }
        return foodCount;
    }

    public void loadNextLevel() {
        this.m_state = 5;
        ++this.m_stage;
        switch (this.m_stage % 10) {
            case 1: 
            case 2: {
                this.loadPacManMaze();
                this.m_pacMan.m_gameUI.m_wallColor = Color.blue;
                this.m_pacMan.m_gameUI.m_wallAltColor = Color.white;
                break;
            }
            case 3: 
            case 4: {
                this.loadMsPacManMaze1();
                this.m_pacMan.m_gameUI.m_wallColor = Color.red;
                this.m_pacMan.m_gameUI.m_wallAltColor = Color.white;
                break;
            }
            case 5: 
            case 6: {
                this.loadMsPacManMaze2();
                this.m_pacMan.m_gameUI.m_wallColor = new Color(0, 255, 0);
                this.m_pacMan.m_gameUI.m_wallAltColor = Color.white;
                break;
            }
            case 7: 
            case 8: {
                this.loadMsPacManMaze3();
                this.m_pacMan.m_gameUI.m_wallColor = Color.cyan;
                this.m_pacMan.m_gameUI.m_wallAltColor = Color.white;
                break;
            }
            case 0: 
            case 9: {
                this.loadMsPacManMaze4();
                this.m_pacMan.m_gameUI.m_wallColor = Color.magenta;
                this.m_pacMan.m_gameUI.m_wallAltColor = Color.white;
            }
        }
        this.loadGhostHideout();
        int ticksPerSecond = this.m_stage > 10 ? 62 + this.m_stage - 10 : 35 + (this.m_stage - 1) * 3;
        this.m_pacMan.setTicksPerSec(ticksPerSecond);
        this.m_nTicksPowerup = this.m_stage > 10 ? 1000 / this.m_pacMan.m_delay : (10000 - (this.m_stage - 1) * 1000) / this.m_pacMan.m_delay;
        int i = 0;
        while (i < this.m_things.length) {
            this.m_things[i].returnToStart();
            ++i;
        }
        boolean bl = false;
        GameModel gameModel = this;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)gameModel, Conversions.booleanObject(bl));
        try {
            gameModel.setVisibleThings(bl);
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
        this.m_totalFoodCount = this.getTotalFoodCount();
        this.m_currentFoodCount = 0;
        this.m_fruit.m_bAvailable = true;
        this.m_fruit.m_nTicks2Show = 15000 / this.m_pacMan.m_delay;
        this.m_nTicks2Backoff = 20000 / this.m_pacMan.m_delay;
    }

    public void newGame() {
        this.m_stage = 0;
        this.m_nLives = 2;
        this.m_player.livesNumber = 2;
        this.m_bPlayStartClip = true;
        this.m_bStartClipPlayed = false;
        GameModel gameModel = this;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, gameModel);
        try {
            gameModel.loadNextLevel();
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
        boolean bl = false;
        GameModel gameModel2 = this;
        JoinPoint joinPoint2 = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)gameModel2, Conversions.booleanObject(bl));
        try {
            gameModel2.setVisibleThings(bl);
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint2);
        }
        this.m_currentFoodCount = 0;
        this.m_player.m_score = 0;
        this.m_nextFreeUp = 10000;
    }

    public void initIntro() {
        this.loadIntroMaze();
        this.m_stage = 1;
        this.m_bPlayStartClip = true;
        int i = 0;
        while (i < this.m_things.length) {
            this.m_things[i].returnToStart();
            ++i;
        }
        i = 0;
        while (i < this.m_ghosts.length) {
            this.m_ghosts[i].m_bInsideRoom = false;
            this.m_ghosts[i].m_nTicks2Exit = 0;
            this.m_ghosts[i].m_deltaLocX = 0;
            this.m_ghosts[i].m_deltaLocY = 0;
            this.m_ghosts[i].m_direction = (byte)3;
            this.m_ghosts[i].m_lastLocX = 0;
            this.m_ghosts[i].m_lastLocY = 0;
            ++i;
        }
        this.m_ghosts[0].m_locX = 27;
        this.m_ghosts[0].m_locY = 10;
        this.m_ghosts[1].m_locX = 27;
        this.m_ghosts[1].m_locY = 12;
        this.m_ghosts[2].m_locX = 27;
        this.m_ghosts[2].m_locY = 14;
        this.m_ghosts[3].m_locX = 27;
        this.m_ghosts[3].m_locY = 16;
        this.m_fruit.m_bAvailable = false;
        this.m_fruit.m_lastLocX = -1;
        this.m_fruit.m_lastLocY = -1;
        this.m_player.m_locX = 0;
        this.m_player.m_locY = 19;
        this.m_player.m_lastLocX = -1;
        this.m_player.m_lastLocY = -1;
        this.m_player.m_deltaLocX = 0;
        this.m_player.m_deltaLocY = 0;
        this.m_player.m_direction = (byte)4;
        this.m_player.m_requestedDirection = (byte)4;
        boolean bl = false;
        GameModel gameModel = this;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, (Object)this, (Object)gameModel, Conversions.booleanObject(bl));
        try {
            gameModel.setVisibleThings(bl);
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
        boolean bl2 = true;
        GameModel gameModel2 = this;
        JoinPoint joinPoint2 = Factory.makeJP(ajc$tjp_5, (Object)this, (Object)gameModel2, Conversions.booleanObject(bl2));
        try {
            gameModel2.setPausedGame(bl2);
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint2);
        }
        this.m_currentFoodCount = 0;
    }

    public void restartGame() {
        --this.m_nLives;
        int i = 0;
        while (i < this.m_things.length) {
            this.m_things[i].returnToStart();
            ++i;
        }
        boolean bl = false;
        GameModel gameModel = this;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, (Object)this, (Object)gameModel, Conversions.booleanObject(bl));
        try {
            gameModel.setVisibleThings(bl);
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    public void loadPacManMaze() {
        this.m_gameState[0][0] = 5382;
        this.m_gameState[0][1] = 69637;
        this.m_gameState[0][2] = 69637;
        this.m_gameState[0][3] = 69637;
        this.m_gameState[0][4] = 69637;
        this.m_gameState[0][5] = 69637;
        this.m_gameState[0][6] = 69637;
        this.m_gameState[0][7] = 69637;
        this.m_gameState[0][8] = 69637;
        this.m_gameState[0][9] = 12803;
        this.m_gameState[0][10] = 1;
        this.m_gameState[0][11] = 0;
        this.m_gameState[0][12] = 4;
        this.m_gameState[0][13] = 33794;
        this.m_gameState[0][14] = 5;
        this.m_gameState[0][15] = 40962;
        this.m_gameState[0][16] = 1;
        this.m_gameState[0][17] = 0;
        this.m_gameState[0][18] = 4;
        this.m_gameState[0][19] = 5382;
        this.m_gameState[0][20] = 69637;
        this.m_gameState[0][21] = 69637;
        this.m_gameState[0][22] = 69637;
        this.m_gameState[0][23] = 69637;
        this.m_gameState[0][24] = 4615;
        this.m_gameState[0][25] = 4359;
        this.m_gameState[0][26] = 69637;
        this.m_gameState[0][27] = 69637;
        this.m_gameState[0][28] = 69637;
        this.m_gameState[0][29] = 69637;
        this.m_gameState[0][30] = 12803;
        this.m_gameState[1][0] = 33802;
        this.m_gameState[1][1] = 25;
        this.m_gameState[1][2] = 26;
        this.m_gameState[1][3] = 42;
        this.m_gameState[1][4] = 26;
        this.m_gameState[1][5] = 24;
        this.m_gameState[1][6] = 26;
        this.m_gameState[1][7] = 26;
        this.m_gameState[1][8] = 28;
        this.m_gameState[1][9] = 40970;
        this.m_gameState[1][10] = 1;
        this.m_gameState[1][11] = 0;
        this.m_gameState[1][12] = 4;
        this.m_gameState[1][13] = 33802;
        this.m_gameState[1][14] = 5;
        this.m_gameState[1][15] = 40970;
        this.m_gameState[1][16] = 1;
        this.m_gameState[1][17] = 0;
        this.m_gameState[1][18] = 4;
        this.m_gameState[1][19] = 33802;
        this.m_gameState[1][20] = 25;
        this.m_gameState[1][21] = 26;
        this.m_gameState[1][22] = 26;
        this.m_gameState[1][23] = 44;
        this.m_gameState[1][24] = 32782;
        this.m_gameState[1][25] = 32779;
        this.m_gameState[1][26] = 25;
        this.m_gameState[1][27] = 26;
        this.m_gameState[1][28] = 26;
        this.m_gameState[1][29] = 28;
        this.m_gameState[1][30] = 40970;
        this.m_gameState[2][0] = 33802;
        this.m_gameState[2][1] = 21;
        this.m_gameState[2][2] = 262;
        this.m_gameState[2][3] = 65541;
        this.m_gameState[2][4] = 515;
        this.m_gameState[2][5] = 21;
        this.m_gameState[2][6] = 262;
        this.m_gameState[2][7] = 515;
        this.m_gameState[2][8] = 21;
        this.m_gameState[2][9] = 40970;
        this.m_gameState[2][10] = 1;
        this.m_gameState[2][11] = 0;
        this.m_gameState[2][12] = 4;
        this.m_gameState[2][13] = 33802;
        this.m_gameState[2][14] = 5;
        this.m_gameState[2][15] = 40970;
        this.m_gameState[2][16] = 1;
        this.m_gameState[2][17] = 0;
        this.m_gameState[2][18] = 4;
        this.m_gameState[2][19] = 33802;
        this.m_gameState[2][20] = 21;
        this.m_gameState[2][21] = 262;
        this.m_gameState[2][22] = 515;
        this.m_gameState[2][23] = 21;
        this.m_gameState[2][24] = 140;
        this.m_gameState[2][25] = 73;
        this.m_gameState[2][26] = 21;
        this.m_gameState[2][27] = 262;
        this.m_gameState[2][28] = 515;
        this.m_gameState[2][29] = 21;
        this.m_gameState[2][30] = 40970;
        this.m_gameState[3][0] = 33802;
        this.m_gameState[3][1] = 21;
        this.m_gameState[3][2] = 32778;
        this.m_gameState[3][3] = 13;
        this.m_gameState[3][4] = 32778;
        this.m_gameState[3][5] = 21;
        this.m_gameState[3][6] = 32782;
        this.m_gameState[3][7] = 32779;
        this.m_gameState[3][8] = 21;
        this.m_gameState[3][9] = 40970;
        this.m_gameState[3][10] = 1;
        this.m_gameState[3][11] = 0;
        this.m_gameState[3][12] = 4;
        this.m_gameState[3][13] = 33802;
        this.m_gameState[3][14] = 5;
        this.m_gameState[3][15] = 40970;
        this.m_gameState[3][16] = 1;
        this.m_gameState[3][17] = 0;
        this.m_gameState[3][18] = 4;
        this.m_gameState[3][19] = 33802;
        this.m_gameState[3][20] = 21;
        this.m_gameState[3][21] = 32782;
        this.m_gameState[3][22] = 32779;
        this.m_gameState[3][23] = 19;
        this.m_gameState[3][24] = 26;
        this.m_gameState[3][25] = 26;
        this.m_gameState[3][26] = 20;
        this.m_gameState[3][27] = 32782;
        this.m_gameState[3][28] = 32779;
        this.m_gameState[3][29] = 21;
        this.m_gameState[3][30] = 40970;
        this.m_gameState[4][0] = 33802;
        this.m_gameState[4][1] = 21;
        this.m_gameState[4][2] = 32778;
        this.m_gameState[4][3] = 7;
        this.m_gameState[4][4] = 32778;
        this.m_gameState[4][5] = 21;
        this.m_gameState[4][6] = 32782;
        this.m_gameState[4][7] = 32779;
        this.m_gameState[4][8] = 21;
        this.m_gameState[4][9] = 40970;
        this.m_gameState[4][10] = 3;
        this.m_gameState[4][11] = 2;
        this.m_gameState[4][12] = 6;
        this.m_gameState[4][13] = 33802;
        this.m_gameState[4][14] = 5;
        this.m_gameState[4][15] = 40970;
        this.m_gameState[4][16] = 3;
        this.m_gameState[4][17] = 2;
        this.m_gameState[4][18] = 6;
        this.m_gameState[4][19] = 33802;
        this.m_gameState[4][20] = 21;
        this.m_gameState[4][21] = 32782;
        this.m_gameState[4][22] = 143;
        this.m_gameState[4][23] = 65543;
        this.m_gameState[4][24] = 65543;
        this.m_gameState[4][25] = 515;
        this.m_gameState[4][26] = 21;
        this.m_gameState[4][27] = 32782;
        this.m_gameState[4][28] = 32779;
        this.m_gameState[4][29] = 21;
        this.m_gameState[4][30] = 40970;
        this.m_gameState[5][0] = 33802;
        this.m_gameState[5][1] = 21;
        this.m_gameState[5][2] = 140;
        this.m_gameState[5][3] = 65541;
        this.m_gameState[5][4] = 73;
        this.m_gameState[5][5] = 21;
        this.m_gameState[5][6] = 140;
        this.m_gameState[5][7] = 73;
        this.m_gameState[5][8] = 21;
        this.m_gameState[5][9] = 140;
        this.m_gameState[5][10] = 69637;
        this.m_gameState[5][11] = 69637;
        this.m_gameState[5][12] = 69637;
        this.m_gameState[5][13] = 73;
        this.m_gameState[5][14] = 5;
        this.m_gameState[5][15] = 140;
        this.m_gameState[5][16] = 69637;
        this.m_gameState[5][17] = 69637;
        this.m_gameState[5][18] = 69637;
        this.m_gameState[5][19] = 73;
        this.m_gameState[5][20] = 21;
        this.m_gameState[5][21] = 140;
        this.m_gameState[5][22] = 65549;
        this.m_gameState[5][23] = 65549;
        this.m_gameState[5][24] = 65549;
        this.m_gameState[5][25] = 73;
        this.m_gameState[5][26] = 21;
        this.m_gameState[5][27] = 32782;
        this.m_gameState[5][28] = 32779;
        this.m_gameState[5][29] = 21;
        this.m_gameState[5][30] = 40970;
        this.m_gameState[6][0] = 33802;
        this.m_gameState[6][1] = 17;
        this.m_gameState[6][2] = 26;
        this.m_gameState[6][3] = 26;
        this.m_gameState[6][4] = 26;
        this.m_gameState[6][5] = 16;
        this.m_gameState[6][6] = 26;
        this.m_gameState[6][7] = 26;
        this.m_gameState[6][8] = 18;
        this.m_gameState[6][9] = 26;
        this.m_gameState[6][10] = 26;
        this.m_gameState[6][11] = 26;
        this.m_gameState[6][12] = 26;
        this.m_gameState[6][13] = 26;
        this.m_gameState[6][14] = 16;
        this.m_gameState[6][15] = 26;
        this.m_gameState[6][16] = 26;
        this.m_gameState[6][17] = 26;
        this.m_gameState[6][18] = 26;
        this.m_gameState[6][19] = 26;
        this.m_gameState[6][20] = 16;
        this.m_gameState[6][21] = 26;
        this.m_gameState[6][22] = 26;
        this.m_gameState[6][23] = 24;
        this.m_gameState[6][24] = 26;
        this.m_gameState[6][25] = 26;
        this.m_gameState[6][26] = 22;
        this.m_gameState[6][27] = 32782;
        this.m_gameState[6][28] = 32779;
        this.m_gameState[6][29] = 21;
        this.m_gameState[6][30] = 40970;
        this.m_gameState[7][0] = 33802;
        this.m_gameState[7][1] = 21;
        this.m_gameState[7][2] = 262;
        this.m_gameState[7][3] = 65541;
        this.m_gameState[7][4] = 515;
        this.m_gameState[7][5] = 21;
        this.m_gameState[7][6] = 262;
        this.m_gameState[7][7] = 65543;
        this.m_gameState[7][8] = 65543;
        this.m_gameState[7][9] = 65543;
        this.m_gameState[7][10] = 65543;
        this.m_gameState[7][11] = 65543;
        this.m_gameState[7][12] = 65543;
        this.m_gameState[7][13] = 515;
        this.m_gameState[7][14] = 5;
        this.m_gameState[7][15] = 262;
        this.m_gameState[7][16] = 65543;
        this.m_gameState[7][17] = 65543;
        this.m_gameState[7][18] = 65543;
        this.m_gameState[7][19] = 515;
        this.m_gameState[7][20] = 21;
        this.m_gameState[7][21] = 262;
        this.m_gameState[7][22] = 515;
        this.m_gameState[7][23] = 21;
        this.m_gameState[7][24] = 262;
        this.m_gameState[7][25] = 65543;
        this.m_gameState[7][26] = 65543;
        this.m_gameState[7][27] = 79;
        this.m_gameState[7][28] = 32779;
        this.m_gameState[7][29] = 21;
        this.m_gameState[7][30] = 40970;
        this.m_gameState[8][0] = 33802;
        this.m_gameState[8][1] = 21;
        this.m_gameState[8][2] = 32778;
        this.m_gameState[8][3] = 13;
        this.m_gameState[8][4] = 32778;
        this.m_gameState[8][5] = 21;
        this.m_gameState[8][6] = 140;
        this.m_gameState[8][7] = 65549;
        this.m_gameState[8][8] = 65549;
        this.m_gameState[8][9] = 527;
        this.m_gameState[8][10] = 271;
        this.m_gameState[8][11] = 65549;
        this.m_gameState[8][12] = 65549;
        this.m_gameState[8][13] = 73;
        this.m_gameState[8][14] = 5;
        this.m_gameState[8][15] = 140;
        this.m_gameState[8][16] = 65549;
        this.m_gameState[8][17] = 65549;
        this.m_gameState[8][18] = 65549;
        this.m_gameState[8][19] = 73;
        this.m_gameState[8][20] = 21;
        this.m_gameState[8][21] = 32782;
        this.m_gameState[8][22] = 32779;
        this.m_gameState[8][23] = 21;
        this.m_gameState[8][24] = 140;
        this.m_gameState[8][25] = 65549;
        this.m_gameState[8][26] = 65549;
        this.m_gameState[8][27] = 527;
        this.m_gameState[8][28] = 32779;
        this.m_gameState[8][29] = 21;
        this.m_gameState[8][30] = 40970;
        this.m_gameState[9][0] = 33802;
        this.m_gameState[9][1] = 21;
        this.m_gameState[9][2] = 32778;
        this.m_gameState[9][3] = 5;
        this.m_gameState[9][4] = 32778;
        this.m_gameState[9][5] = 17;
        this.m_gameState[9][6] = 26;
        this.m_gameState[9][7] = 26;
        this.m_gameState[9][8] = 28;
        this.m_gameState[9][9] = 32782;
        this.m_gameState[9][10] = 32779;
        this.m_gameState[9][11] = 9;
        this.m_gameState[9][12] = 10;
        this.m_gameState[9][13] = 10;
        this.m_gameState[9][14] = 2;
        this.m_gameState[9][15] = 10;
        this.m_gameState[9][16] = 10;
        this.m_gameState[9][17] = 8;
        this.m_gameState[9][18] = 10;
        this.m_gameState[9][19] = 10;
        this.m_gameState[9][20] = 20;
        this.m_gameState[9][21] = 32782;
        this.m_gameState[9][22] = 32779;
        this.m_gameState[9][23] = 17;
        this.m_gameState[9][24] = 26;
        this.m_gameState[9][25] = 26;
        this.m_gameState[9][26] = 28;
        this.m_gameState[9][27] = 32782;
        this.m_gameState[9][28] = 32779;
        this.m_gameState[9][29] = 21;
        this.m_gameState[9][30] = 40970;
        this.m_gameState[10][0] = 33802;
        this.m_gameState[10][1] = 21;
        this.m_gameState[10][2] = 32778;
        this.m_gameState[10][3] = 7;
        this.m_gameState[10][4] = 32778;
        this.m_gameState[10][5] = 21;
        this.m_gameState[10][6] = 262;
        this.m_gameState[10][7] = 515;
        this.m_gameState[10][8] = 21;
        this.m_gameState[10][9] = 32782;
        this.m_gameState[10][10] = 32779;
        this.m_gameState[10][11] = 5;
        this.m_gameState[10][12] = 262;
        this.m_gameState[10][13] = 81925;
        this.m_gameState[10][14] = 81925;
        this.m_gameState[10][15] = 81925;
        this.m_gameState[10][16] = 515;
        this.m_gameState[10][17] = 5;
        this.m_gameState[10][18] = 262;
        this.m_gameState[10][19] = 515;
        this.m_gameState[10][20] = 21;
        this.m_gameState[10][21] = 32782;
        this.m_gameState[10][22] = 32779;
        this.m_gameState[10][23] = 21;
        this.m_gameState[10][24] = 262;
        this.m_gameState[10][25] = 515;
        this.m_gameState[10][26] = 21;
        this.m_gameState[10][27] = 32782;
        this.m_gameState[10][28] = 32779;
        this.m_gameState[10][29] = 21;
        this.m_gameState[10][30] = 40970;
        this.m_gameState[11][0] = 33802;
        this.m_gameState[11][1] = 21;
        this.m_gameState[11][2] = 140;
        this.m_gameState[11][3] = 65541;
        this.m_gameState[11][4] = 73;
        this.m_gameState[11][5] = 21;
        this.m_gameState[11][6] = 32782;
        this.m_gameState[11][7] = 32779;
        this.m_gameState[11][8] = 21;
        this.m_gameState[11][9] = 140;
        this.m_gameState[11][10] = 73;
        this.m_gameState[11][11] = 5;
        this.m_gameState[11][12] = 40970;
        this.m_gameState[11][13] = 9;
        this.m_gameState[11][14] = 8;
        this.m_gameState[11][15] = 12;
        this.m_gameState[11][16] = 33802;
        this.m_gameState[11][17] = 5;
        this.m_gameState[11][18] = 32782;
        this.m_gameState[11][19] = 32779;
        this.m_gameState[11][20] = 21;
        this.m_gameState[11][21] = 140;
        this.m_gameState[11][22] = 73;
        this.m_gameState[11][23] = 21;
        this.m_gameState[11][24] = 32782;
        this.m_gameState[11][25] = 32779;
        this.m_gameState[11][26] = 21;
        this.m_gameState[11][27] = 140;
        this.m_gameState[11][28] = 73;
        this.m_gameState[11][29] = 21;
        this.m_gameState[11][30] = 40970;
        this.m_gameState[12][0] = 33802;
        this.m_gameState[12][1] = 19;
        this.m_gameState[12][2] = 26;
        this.m_gameState[12][3] = 26;
        this.m_gameState[12][4] = 26;
        this.m_gameState[12][5] = 20;
        this.m_gameState[12][6] = 32782;
        this.m_gameState[12][7] = 32779;
        this.m_gameState[12][8] = 19;
        this.m_gameState[12][9] = 10;
        this.m_gameState[12][10] = 10;
        this.m_gameState[12][11] = 4;
        this.m_gameState[12][12] = 40970;
        this.m_gameState[12][13] = 1;
        this.m_gameState[12][14] = 0;
        this.m_gameState[12][15] = 4;
        this.m_gameState[12][16] = 33802;
        this.m_gameState[12][17] = 5;
        this.m_gameState[12][18] = 32782;
        this.m_gameState[12][19] = 32779;
        this.m_gameState[12][20] = 19;
        this.m_gameState[12][21] = 26;
        this.m_gameState[12][22] = 26;
        this.m_gameState[12][23] = 20;
        this.m_gameState[12][24] = 32782;
        this.m_gameState[12][25] = 32779;
        this.m_gameState[12][26] = 19;
        this.m_gameState[12][27] = 26;
        this.m_gameState[12][28] = 26;
        this.m_gameState[12][29] = 20;
        this.m_gameState[12][30] = 40970;
        this.m_gameState[13][0] = 1166;
        this.m_gameState[13][1] = 65543;
        this.m_gameState[13][2] = 65543;
        this.m_gameState[13][3] = 65543;
        this.m_gameState[13][4] = 515;
        this.m_gameState[13][5] = 21;
        this.m_gameState[13][6] = 32782;
        this.m_gameState[13][7] = 143;
        this.m_gameState[13][8] = 65543;
        this.m_gameState[13][9] = 65543;
        this.m_gameState[13][10] = 515;
        this.m_gameState[13][11] = 5;
        this.m_gameState[13][12] = 40970;
        this.m_gameState[13][13] = 1;
        this.m_gameState[13][14] = 0;
        this.m_gameState[13][15] = 4;
        this.m_gameState[13][16] = 33802;
        this.m_gameState[13][17] = 5;
        this.m_gameState[13][18] = 32782;
        this.m_gameState[13][19] = 143;
        this.m_gameState[13][20] = 65543;
        this.m_gameState[13][21] = 65543;
        this.m_gameState[13][22] = 515;
        this.m_gameState[13][23] = 21;
        this.m_gameState[13][24] = 32782;
        this.m_gameState[13][25] = 143;
        this.m_gameState[13][26] = 65543;
        this.m_gameState[13][27] = 65543;
        this.m_gameState[13][28] = 515;
        this.m_gameState[13][29] = 21;
        this.m_gameState[13][30] = 40970;
        this.m_gameState[14][0] = 1294;
        this.m_gameState[14][1] = 65549;
        this.m_gameState[14][2] = 65549;
        this.m_gameState[14][3] = 65549;
        this.m_gameState[14][4] = 73;
        this.m_gameState[14][5] = 21;
        this.m_gameState[14][6] = 32782;
        this.m_gameState[14][7] = 271;
        this.m_gameState[14][8] = 65549;
        this.m_gameState[14][9] = 65549;
        this.m_gameState[14][10] = 73;
        this.m_gameState[14][11] = 5;
        this.m_gameState[14][12] = 40970;
        this.m_gameState[14][13] = 1;
        this.m_gameState[14][14] = 0;
        this.m_gameState[14][15] = 4;
        this.m_gameState[14][16] = 33802;
        this.m_gameState[14][17] = 5;
        this.m_gameState[14][18] = 32782;
        this.m_gameState[14][19] = 271;
        this.m_gameState[14][20] = 65549;
        this.m_gameState[14][21] = 65549;
        this.m_gameState[14][22] = 73;
        this.m_gameState[14][23] = 21;
        this.m_gameState[14][24] = 32782;
        this.m_gameState[14][25] = 271;
        this.m_gameState[14][26] = 65549;
        this.m_gameState[14][27] = 65549;
        this.m_gameState[14][28] = 73;
        this.m_gameState[14][29] = 21;
        this.m_gameState[14][30] = 40970;
        this.m_gameState[15][0] = 33802;
        this.m_gameState[15][1] = 25;
        this.m_gameState[15][2] = 26;
        this.m_gameState[15][3] = 26;
        this.m_gameState[15][4] = 26;
        this.m_gameState[15][5] = 20;
        this.m_gameState[15][6] = 32782;
        this.m_gameState[15][7] = 32779;
        this.m_gameState[15][8] = 25;
        this.m_gameState[15][9] = 10;
        this.m_gameState[15][10] = 10;
        this.m_gameState[15][11] = 4;
        this.m_gameState[15][12] = 40970;
        this.m_gameState[15][13] = 1;
        this.m_gameState[15][14] = 0;
        this.m_gameState[15][15] = 4;
        this.m_gameState[15][16] = 33802;
        this.m_gameState[15][17] = 5;
        this.m_gameState[15][18] = 32782;
        this.m_gameState[15][19] = 32779;
        this.m_gameState[15][20] = 25;
        this.m_gameState[15][21] = 26;
        this.m_gameState[15][22] = 26;
        this.m_gameState[15][23] = 20;
        this.m_gameState[15][24] = 32782;
        this.m_gameState[15][25] = 32779;
        this.m_gameState[15][26] = 25;
        this.m_gameState[15][27] = 26;
        this.m_gameState[15][28] = 26;
        this.m_gameState[15][29] = 20;
        this.m_gameState[15][30] = 40970;
        this.m_gameState[16][0] = 33802;
        this.m_gameState[16][1] = 21;
        this.m_gameState[16][2] = 262;
        this.m_gameState[16][3] = 65541;
        this.m_gameState[16][4] = 515;
        this.m_gameState[16][5] = 21;
        this.m_gameState[16][6] = 32782;
        this.m_gameState[16][7] = 32779;
        this.m_gameState[16][8] = 21;
        this.m_gameState[16][9] = 262;
        this.m_gameState[16][10] = 515;
        this.m_gameState[16][11] = 5;
        this.m_gameState[16][12] = 40970;
        this.m_gameState[16][13] = 3;
        this.m_gameState[16][14] = 2;
        this.m_gameState[16][15] = 6;
        this.m_gameState[16][16] = 33802;
        this.m_gameState[16][17] = 5;
        this.m_gameState[16][18] = 32782;
        this.m_gameState[16][19] = 32779;
        this.m_gameState[16][20] = 21;
        this.m_gameState[16][21] = 262;
        this.m_gameState[16][22] = 515;
        this.m_gameState[16][23] = 21;
        this.m_gameState[16][24] = 32782;
        this.m_gameState[16][25] = 32779;
        this.m_gameState[16][26] = 21;
        this.m_gameState[16][27] = 262;
        this.m_gameState[16][28] = 515;
        this.m_gameState[16][29] = 21;
        this.m_gameState[16][30] = 40970;
        this.m_gameState[17][0] = 33802;
        this.m_gameState[17][1] = 21;
        this.m_gameState[17][2] = 32778;
        this.m_gameState[17][3] = 13;
        this.m_gameState[17][4] = 32778;
        this.m_gameState[17][5] = 21;
        this.m_gameState[17][6] = 140;
        this.m_gameState[17][7] = 73;
        this.m_gameState[17][8] = 21;
        this.m_gameState[17][9] = 32782;
        this.m_gameState[17][10] = 32779;
        this.m_gameState[17][11] = 5;
        this.m_gameState[17][12] = 140;
        this.m_gameState[17][13] = 69637;
        this.m_gameState[17][14] = 69637;
        this.m_gameState[17][15] = 69637;
        this.m_gameState[17][16] = 73;
        this.m_gameState[17][17] = 5;
        this.m_gameState[17][18] = 140;
        this.m_gameState[17][19] = 73;
        this.m_gameState[17][20] = 21;
        this.m_gameState[17][21] = 32782;
        this.m_gameState[17][22] = 32779;
        this.m_gameState[17][23] = 21;
        this.m_gameState[17][24] = 140;
        this.m_gameState[17][25] = 73;
        this.m_gameState[17][26] = 21;
        this.m_gameState[17][27] = 32782;
        this.m_gameState[17][28] = 32779;
        this.m_gameState[17][29] = 21;
        this.m_gameState[17][30] = 40970;
        this.m_gameState[18][0] = 33802;
        this.m_gameState[18][1] = 21;
        this.m_gameState[18][2] = 32778;
        this.m_gameState[18][3] = 5;
        this.m_gameState[18][4] = 32778;
        this.m_gameState[18][5] = 17;
        this.m_gameState[18][6] = 26;
        this.m_gameState[18][7] = 26;
        this.m_gameState[18][8] = 22;
        this.m_gameState[18][9] = 32782;
        this.m_gameState[18][10] = 32779;
        this.m_gameState[18][11] = 3;
        this.m_gameState[18][12] = 10;
        this.m_gameState[18][13] = 10;
        this.m_gameState[18][14] = 8;
        this.m_gameState[18][15] = 10;
        this.m_gameState[18][16] = 10;
        this.m_gameState[18][17] = 2;
        this.m_gameState[18][18] = 10;
        this.m_gameState[18][19] = 10;
        this.m_gameState[18][20] = 20;
        this.m_gameState[18][21] = 32782;
        this.m_gameState[18][22] = 32779;
        this.m_gameState[18][23] = 17;
        this.m_gameState[18][24] = 26;
        this.m_gameState[18][25] = 26;
        this.m_gameState[18][26] = 22;
        this.m_gameState[18][27] = 32782;
        this.m_gameState[18][28] = 32779;
        this.m_gameState[18][29] = 21;
        this.m_gameState[18][30] = 40970;
        this.m_gameState[19][0] = 33802;
        this.m_gameState[19][1] = 21;
        this.m_gameState[19][2] = 32778;
        this.m_gameState[19][3] = 7;
        this.m_gameState[19][4] = 32778;
        this.m_gameState[19][5] = 21;
        this.m_gameState[19][6] = 262;
        this.m_gameState[19][7] = 65543;
        this.m_gameState[19][8] = 65543;
        this.m_gameState[19][9] = 79;
        this.m_gameState[19][10] = 143;
        this.m_gameState[19][11] = 65543;
        this.m_gameState[19][12] = 65543;
        this.m_gameState[19][13] = 515;
        this.m_gameState[19][14] = 5;
        this.m_gameState[19][15] = 262;
        this.m_gameState[19][16] = 65543;
        this.m_gameState[19][17] = 65543;
        this.m_gameState[19][18] = 65543;
        this.m_gameState[19][19] = 515;
        this.m_gameState[19][20] = 21;
        this.m_gameState[19][21] = 32782;
        this.m_gameState[19][22] = 32779;
        this.m_gameState[19][23] = 21;
        this.m_gameState[19][24] = 262;
        this.m_gameState[19][25] = 65543;
        this.m_gameState[19][26] = 65543;
        this.m_gameState[19][27] = 79;
        this.m_gameState[19][28] = 32779;
        this.m_gameState[19][29] = 21;
        this.m_gameState[19][30] = 40970;
        this.m_gameState[20][0] = 33802;
        this.m_gameState[20][1] = 21;
        this.m_gameState[20][2] = 140;
        this.m_gameState[20][3] = 65541;
        this.m_gameState[20][4] = 73;
        this.m_gameState[20][5] = 21;
        this.m_gameState[20][6] = 140;
        this.m_gameState[20][7] = 65549;
        this.m_gameState[20][8] = 65549;
        this.m_gameState[20][9] = 65549;
        this.m_gameState[20][10] = 65549;
        this.m_gameState[20][11] = 65549;
        this.m_gameState[20][12] = 65549;
        this.m_gameState[20][13] = 73;
        this.m_gameState[20][14] = 5;
        this.m_gameState[20][15] = 140;
        this.m_gameState[20][16] = 65549;
        this.m_gameState[20][17] = 65549;
        this.m_gameState[20][18] = 65549;
        this.m_gameState[20][19] = 73;
        this.m_gameState[20][20] = 21;
        this.m_gameState[20][21] = 140;
        this.m_gameState[20][22] = 73;
        this.m_gameState[20][23] = 21;
        this.m_gameState[20][24] = 140;
        this.m_gameState[20][25] = 65549;
        this.m_gameState[20][26] = 65549;
        this.m_gameState[20][27] = 527;
        this.m_gameState[20][28] = 32779;
        this.m_gameState[20][29] = 21;
        this.m_gameState[20][30] = 40970;
        this.m_gameState[21][0] = 33802;
        this.m_gameState[21][1] = 17;
        this.m_gameState[21][2] = 26;
        this.m_gameState[21][3] = 26;
        this.m_gameState[21][4] = 26;
        this.m_gameState[21][5] = 16;
        this.m_gameState[21][6] = 26;
        this.m_gameState[21][7] = 26;
        this.m_gameState[21][8] = 24;
        this.m_gameState[21][9] = 26;
        this.m_gameState[21][10] = 26;
        this.m_gameState[21][11] = 26;
        this.m_gameState[21][12] = 26;
        this.m_gameState[21][13] = 26;
        this.m_gameState[21][14] = 16;
        this.m_gameState[21][15] = 26;
        this.m_gameState[21][16] = 26;
        this.m_gameState[21][17] = 26;
        this.m_gameState[21][18] = 26;
        this.m_gameState[21][19] = 26;
        this.m_gameState[21][20] = 16;
        this.m_gameState[21][21] = 26;
        this.m_gameState[21][22] = 26;
        this.m_gameState[21][23] = 18;
        this.m_gameState[21][24] = 26;
        this.m_gameState[21][25] = 26;
        this.m_gameState[21][26] = 28;
        this.m_gameState[21][27] = 32782;
        this.m_gameState[21][28] = 32779;
        this.m_gameState[21][29] = 21;
        this.m_gameState[21][30] = 40970;
        this.m_gameState[22][0] = 33802;
        this.m_gameState[22][1] = 21;
        this.m_gameState[22][2] = 262;
        this.m_gameState[22][3] = 65541;
        this.m_gameState[22][4] = 515;
        this.m_gameState[22][5] = 21;
        this.m_gameState[22][6] = 262;
        this.m_gameState[22][7] = 515;
        this.m_gameState[22][8] = 21;
        this.m_gameState[22][9] = 262;
        this.m_gameState[22][10] = 81925;
        this.m_gameState[22][11] = 81925;
        this.m_gameState[22][12] = 81925;
        this.m_gameState[22][13] = 515;
        this.m_gameState[22][14] = 5;
        this.m_gameState[22][15] = 262;
        this.m_gameState[22][16] = 81925;
        this.m_gameState[22][17] = 81925;
        this.m_gameState[22][18] = 81925;
        this.m_gameState[22][19] = 515;
        this.m_gameState[22][20] = 21;
        this.m_gameState[22][21] = 262;
        this.m_gameState[22][22] = 65543;
        this.m_gameState[22][23] = 65543;
        this.m_gameState[22][24] = 65543;
        this.m_gameState[22][25] = 515;
        this.m_gameState[22][26] = 21;
        this.m_gameState[22][27] = 32782;
        this.m_gameState[22][28] = 32779;
        this.m_gameState[22][29] = 21;
        this.m_gameState[22][30] = 40970;
        this.m_gameState[23][0] = 33802;
        this.m_gameState[23][1] = 21;
        this.m_gameState[23][2] = 32778;
        this.m_gameState[23][3] = 13;
        this.m_gameState[23][4] = 32778;
        this.m_gameState[23][5] = 21;
        this.m_gameState[23][6] = 32782;
        this.m_gameState[23][7] = 32779;
        this.m_gameState[23][8] = 21;
        this.m_gameState[23][9] = 40970;
        this.m_gameState[23][10] = 9;
        this.m_gameState[23][11] = 8;
        this.m_gameState[23][12] = 12;
        this.m_gameState[23][13] = 33802;
        this.m_gameState[23][14] = 5;
        this.m_gameState[23][15] = 40970;
        this.m_gameState[23][16] = 9;
        this.m_gameState[23][17] = 8;
        this.m_gameState[23][18] = 12;
        this.m_gameState[23][19] = 33802;
        this.m_gameState[23][20] = 21;
        this.m_gameState[23][21] = 32782;
        this.m_gameState[23][22] = 271;
        this.m_gameState[23][23] = 65549;
        this.m_gameState[23][24] = 65549;
        this.m_gameState[23][25] = 73;
        this.m_gameState[23][26] = 21;
        this.m_gameState[23][27] = 32782;
        this.m_gameState[23][28] = 32779;
        this.m_gameState[23][29] = 21;
        this.m_gameState[23][30] = 40970;
        this.m_gameState[24][0] = 33802;
        this.m_gameState[24][1] = 21;
        this.m_gameState[24][2] = 32778;
        this.m_gameState[24][3] = 7;
        this.m_gameState[24][4] = 32778;
        this.m_gameState[24][5] = 21;
        this.m_gameState[24][6] = 32782;
        this.m_gameState[24][7] = 32779;
        this.m_gameState[24][8] = 21;
        this.m_gameState[24][9] = 40970;
        this.m_gameState[24][10] = 1;
        this.m_gameState[24][11] = 0;
        this.m_gameState[24][12] = 4;
        this.m_gameState[24][13] = 33802;
        this.m_gameState[24][14] = 5;
        this.m_gameState[24][15] = 40970;
        this.m_gameState[24][16] = 1;
        this.m_gameState[24][17] = 0;
        this.m_gameState[24][18] = 4;
        this.m_gameState[24][19] = 33802;
        this.m_gameState[24][20] = 21;
        this.m_gameState[24][21] = 32782;
        this.m_gameState[24][22] = 32779;
        this.m_gameState[24][23] = 25;
        this.m_gameState[24][24] = 26;
        this.m_gameState[24][25] = 26;
        this.m_gameState[24][26] = 20;
        this.m_gameState[24][27] = 32782;
        this.m_gameState[24][28] = 32779;
        this.m_gameState[24][29] = 21;
        this.m_gameState[24][30] = 40970;
        this.m_gameState[25][0] = 33802;
        this.m_gameState[25][1] = 21;
        this.m_gameState[25][2] = 140;
        this.m_gameState[25][3] = 65541;
        this.m_gameState[25][4] = 73;
        this.m_gameState[25][5] = 21;
        this.m_gameState[25][6] = 140;
        this.m_gameState[25][7] = 73;
        this.m_gameState[25][8] = 21;
        this.m_gameState[25][9] = 40970;
        this.m_gameState[25][10] = 1;
        this.m_gameState[25][11] = 0;
        this.m_gameState[25][12] = 4;
        this.m_gameState[25][13] = 33802;
        this.m_gameState[25][14] = 5;
        this.m_gameState[25][15] = 40970;
        this.m_gameState[25][16] = 1;
        this.m_gameState[25][17] = 0;
        this.m_gameState[25][18] = 4;
        this.m_gameState[25][19] = 33802;
        this.m_gameState[25][20] = 21;
        this.m_gameState[25][21] = 140;
        this.m_gameState[25][22] = 73;
        this.m_gameState[25][23] = 21;
        this.m_gameState[25][24] = 262;
        this.m_gameState[25][25] = 515;
        this.m_gameState[25][26] = 21;
        this.m_gameState[25][27] = 140;
        this.m_gameState[25][28] = 73;
        this.m_gameState[25][29] = 21;
        this.m_gameState[25][30] = 40970;
        this.m_gameState[26][0] = 33802;
        this.m_gameState[26][1] = 19;
        this.m_gameState[26][2] = 26;
        this.m_gameState[26][3] = 42;
        this.m_gameState[26][4] = 26;
        this.m_gameState[26][5] = 18;
        this.m_gameState[26][6] = 26;
        this.m_gameState[26][7] = 26;
        this.m_gameState[26][8] = 22;
        this.m_gameState[26][9] = 40970;
        this.m_gameState[26][10] = 1;
        this.m_gameState[26][11] = 0;
        this.m_gameState[26][12] = 4;
        this.m_gameState[26][13] = 33802;
        this.m_gameState[26][14] = 5;
        this.m_gameState[26][15] = 40970;
        this.m_gameState[26][16] = 1;
        this.m_gameState[26][17] = 0;
        this.m_gameState[26][18] = 4;
        this.m_gameState[26][19] = 33802;
        this.m_gameState[26][20] = 19;
        this.m_gameState[26][21] = 26;
        this.m_gameState[26][22] = 26;
        this.m_gameState[26][23] = 38;
        this.m_gameState[26][24] = 32782;
        this.m_gameState[26][25] = 32779;
        this.m_gameState[26][26] = 19;
        this.m_gameState[26][27] = 26;
        this.m_gameState[26][28] = 26;
        this.m_gameState[26][29] = 22;
        this.m_gameState[26][30] = 40970;
        this.m_gameState[27][0] = 17548;
        this.m_gameState[27][1] = 81925;
        this.m_gameState[27][2] = 81925;
        this.m_gameState[27][3] = 81925;
        this.m_gameState[27][4] = 81925;
        this.m_gameState[27][5] = 81925;
        this.m_gameState[27][6] = 81925;
        this.m_gameState[27][7] = 81925;
        this.m_gameState[27][8] = 81925;
        this.m_gameState[27][9] = 24649;
        this.m_gameState[27][10] = 1;
        this.m_gameState[27][11] = 0;
        this.m_gameState[27][12] = 4;
        this.m_gameState[27][13] = 33800;
        this.m_gameState[27][14] = 5;
        this.m_gameState[27][15] = 40968;
        this.m_gameState[27][16] = 1;
        this.m_gameState[27][17] = 0;
        this.m_gameState[27][18] = 4;
        this.m_gameState[27][19] = 17548;
        this.m_gameState[27][20] = 81925;
        this.m_gameState[27][21] = 81925;
        this.m_gameState[27][22] = 81925;
        this.m_gameState[27][23] = 81925;
        this.m_gameState[27][24] = 16461;
        this.m_gameState[27][25] = 16525;
        this.m_gameState[27][26] = 81925;
        this.m_gameState[27][27] = 81925;
        this.m_gameState[27][28] = 81925;
        this.m_gameState[27][29] = 81925;
        this.m_gameState[27][30] = 24649;
    }

    public void loadMsPacManMaze2() {
        this.m_gameState[0][0] = 5382;
        this.m_gameState[0][1] = 69637;
        this.m_gameState[0][2] = 69637;
        this.m_gameState[0][3] = 69637;
        this.m_gameState[0][4] = 69637;
        this.m_gameState[0][5] = 69637;
        this.m_gameState[0][6] = 69637;
        this.m_gameState[0][7] = 69637;
        this.m_gameState[0][8] = 69637;
        this.m_gameState[0][9] = 12803;
        this.m_gameState[0][10] = 1;
        this.m_gameState[0][11] = 4;
        this.m_gameState[0][12] = 33794;
        this.m_gameState[0][13] = 5;
        this.m_gameState[0][14] = 32774;
        this.m_gameState[0][15] = 32771;
        this.m_gameState[0][16] = 5;
        this.m_gameState[0][17] = 40962;
        this.m_gameState[0][18] = 1;
        this.m_gameState[0][19] = 0;
        this.m_gameState[0][20] = 0;
        this.m_gameState[0][21] = 4;
        this.m_gameState[0][22] = 5382;
        this.m_gameState[0][23] = 69637;
        this.m_gameState[0][24] = 69637;
        this.m_gameState[0][25] = 69637;
        this.m_gameState[0][26] = 69637;
        this.m_gameState[0][27] = 69637;
        this.m_gameState[0][28] = 69637;
        this.m_gameState[0][29] = 69637;
        this.m_gameState[0][30] = 12803;
        this.m_gameState[1][0] = 33802;
        this.m_gameState[1][1] = 25;
        this.m_gameState[1][2] = 26;
        this.m_gameState[1][3] = 42;
        this.m_gameState[1][4] = 26;
        this.m_gameState[1][5] = 26;
        this.m_gameState[1][6] = 26;
        this.m_gameState[1][7] = 26;
        this.m_gameState[1][8] = 28;
        this.m_gameState[1][9] = 40970;
        this.m_gameState[1][10] = 3;
        this.m_gameState[1][11] = 6;
        this.m_gameState[1][12] = 33802;
        this.m_gameState[1][13] = 5;
        this.m_gameState[1][14] = 32782;
        this.m_gameState[1][15] = 32779;
        this.m_gameState[1][16] = 5;
        this.m_gameState[1][17] = 40970;
        this.m_gameState[1][18] = 3;
        this.m_gameState[1][19] = 2;
        this.m_gameState[1][20] = 2;
        this.m_gameState[1][21] = 6;
        this.m_gameState[1][22] = 33802;
        this.m_gameState[1][23] = 25;
        this.m_gameState[1][24] = 26;
        this.m_gameState[1][25] = 26;
        this.m_gameState[1][26] = 26;
        this.m_gameState[1][27] = 42;
        this.m_gameState[1][28] = 26;
        this.m_gameState[1][29] = 28;
        this.m_gameState[1][30] = 40970;
        this.m_gameState[2][0] = 33802;
        this.m_gameState[2][1] = 21;
        this.m_gameState[2][2] = 262;
        this.m_gameState[2][3] = 65543;
        this.m_gameState[2][4] = 65543;
        this.m_gameState[2][5] = 65543;
        this.m_gameState[2][6] = 65543;
        this.m_gameState[2][7] = 515;
        this.m_gameState[2][8] = 21;
        this.m_gameState[2][9] = 140;
        this.m_gameState[2][10] = 69637;
        this.m_gameState[2][11] = 69637;
        this.m_gameState[2][12] = 73;
        this.m_gameState[2][13] = 5;
        this.m_gameState[2][14] = 32782;
        this.m_gameState[2][15] = 32779;
        this.m_gameState[2][16] = 5;
        this.m_gameState[2][17] = 140;
        this.m_gameState[2][18] = 69637;
        this.m_gameState[2][19] = 69637;
        this.m_gameState[2][20] = 69637;
        this.m_gameState[2][21] = 69637;
        this.m_gameState[2][22] = 73;
        this.m_gameState[2][23] = 21;
        this.m_gameState[2][24] = 262;
        this.m_gameState[2][25] = 65543;
        this.m_gameState[2][26] = 65543;
        this.m_gameState[2][27] = 65543;
        this.m_gameState[2][28] = 515;
        this.m_gameState[2][29] = 21;
        this.m_gameState[2][30] = 40970;
        this.m_gameState[3][0] = 33802;
        this.m_gameState[3][1] = 21;
        this.m_gameState[3][2] = 140;
        this.m_gameState[3][3] = 65549;
        this.m_gameState[3][4] = 65549;
        this.m_gameState[3][5] = 65549;
        this.m_gameState[3][6] = 527;
        this.m_gameState[3][7] = 32779;
        this.m_gameState[3][8] = 17;
        this.m_gameState[3][9] = 26;
        this.m_gameState[3][10] = 26;
        this.m_gameState[3][11] = 24;
        this.m_gameState[3][12] = 10;
        this.m_gameState[3][13] = 6;
        this.m_gameState[3][14] = 32782;
        this.m_gameState[3][15] = 32779;
        this.m_gameState[3][16] = 3;
        this.m_gameState[3][17] = 10;
        this.m_gameState[3][18] = 24;
        this.m_gameState[3][19] = 26;
        this.m_gameState[3][20] = 26;
        this.m_gameState[3][21] = 26;
        this.m_gameState[3][22] = 26;
        this.m_gameState[3][23] = 20;
        this.m_gameState[3][24] = 32782;
        this.m_gameState[3][25] = 271;
        this.m_gameState[3][26] = 65549;
        this.m_gameState[3][27] = 65549;
        this.m_gameState[3][28] = 73;
        this.m_gameState[3][29] = 21;
        this.m_gameState[3][30] = 40970;
        this.m_gameState[4][0] = 33802;
        this.m_gameState[4][1] = 17;
        this.m_gameState[4][2] = 26;
        this.m_gameState[4][3] = 26;
        this.m_gameState[4][4] = 26;
        this.m_gameState[4][5] = 28;
        this.m_gameState[4][6] = 32782;
        this.m_gameState[4][7] = 32779;
        this.m_gameState[4][8] = 21;
        this.m_gameState[4][9] = 262;
        this.m_gameState[4][10] = 515;
        this.m_gameState[4][11] = 21;
        this.m_gameState[4][12] = 262;
        this.m_gameState[4][13] = 65543;
        this.m_gameState[4][14] = 79;
        this.m_gameState[4][15] = 143;
        this.m_gameState[4][16] = 65543;
        this.m_gameState[4][17] = 515;
        this.m_gameState[4][18] = 21;
        this.m_gameState[4][19] = 262;
        this.m_gameState[4][20] = 65543;
        this.m_gameState[4][21] = 65543;
        this.m_gameState[4][22] = 515;
        this.m_gameState[4][23] = 21;
        this.m_gameState[4][24] = 32782;
        this.m_gameState[4][25] = 32779;
        this.m_gameState[4][26] = 25;
        this.m_gameState[4][27] = 26;
        this.m_gameState[4][28] = 26;
        this.m_gameState[4][29] = 20;
        this.m_gameState[4][30] = 40970;
        this.m_gameState[5][0] = 33802;
        this.m_gameState[5][1] = 21;
        this.m_gameState[5][2] = 262;
        this.m_gameState[5][3] = 65541;
        this.m_gameState[5][4] = 515;
        this.m_gameState[5][5] = 21;
        this.m_gameState[5][6] = 140;
        this.m_gameState[5][7] = 73;
        this.m_gameState[5][8] = 21;
        this.m_gameState[5][9] = 32782;
        this.m_gameState[5][10] = 32779;
        this.m_gameState[5][11] = 21;
        this.m_gameState[5][12] = 140;
        this.m_gameState[5][13] = 65549;
        this.m_gameState[5][14] = 65549;
        this.m_gameState[5][15] = 65549;
        this.m_gameState[5][16] = 65549;
        this.m_gameState[5][17] = 73;
        this.m_gameState[5][18] = 21;
        this.m_gameState[5][19] = 140;
        this.m_gameState[5][20] = 65549;
        this.m_gameState[5][21] = 527;
        this.m_gameState[5][22] = 32779;
        this.m_gameState[5][23] = 21;
        this.m_gameState[5][24] = 140;
        this.m_gameState[5][25] = 73;
        this.m_gameState[5][26] = 21;
        this.m_gameState[5][27] = 262;
        this.m_gameState[5][28] = 515;
        this.m_gameState[5][29] = 21;
        this.m_gameState[5][30] = 40970;
        this.m_gameState[6][0] = 33802;
        this.m_gameState[6][1] = 21;
        this.m_gameState[6][2] = 32778;
        this.m_gameState[6][3] = 13;
        this.m_gameState[6][4] = 32778;
        this.m_gameState[6][5] = 17;
        this.m_gameState[6][6] = 26;
        this.m_gameState[6][7] = 26;
        this.m_gameState[6][8] = 22;
        this.m_gameState[6][9] = 32782;
        this.m_gameState[6][10] = 32779;
        this.m_gameState[6][11] = 19;
        this.m_gameState[6][12] = 26;
        this.m_gameState[6][13] = 26;
        this.m_gameState[6][14] = 24;
        this.m_gameState[6][15] = 26;
        this.m_gameState[6][16] = 26;
        this.m_gameState[6][17] = 26;
        this.m_gameState[6][18] = 18;
        this.m_gameState[6][19] = 26;
        this.m_gameState[6][20] = 28;
        this.m_gameState[6][21] = 32782;
        this.m_gameState[6][22] = 32779;
        this.m_gameState[6][23] = 17;
        this.m_gameState[6][24] = 26;
        this.m_gameState[6][25] = 26;
        this.m_gameState[6][26] = 22;
        this.m_gameState[6][27] = 32782;
        this.m_gameState[6][28] = 32779;
        this.m_gameState[6][29] = 21;
        this.m_gameState[6][30] = 40970;
        this.m_gameState[7][0] = 33802;
        this.m_gameState[7][1] = 21;
        this.m_gameState[7][2] = 32778;
        this.m_gameState[7][3] = 7;
        this.m_gameState[7][4] = 32778;
        this.m_gameState[7][5] = 21;
        this.m_gameState[7][6] = 262;
        this.m_gameState[7][7] = 65543;
        this.m_gameState[7][8] = 65543;
        this.m_gameState[7][9] = 79;
        this.m_gameState[7][10] = 143;
        this.m_gameState[7][11] = 65543;
        this.m_gameState[7][12] = 65543;
        this.m_gameState[7][13] = 515;
        this.m_gameState[7][14] = 5;
        this.m_gameState[7][15] = 262;
        this.m_gameState[7][16] = 65543;
        this.m_gameState[7][17] = 65543;
        this.m_gameState[7][18] = 65543;
        this.m_gameState[7][19] = 515;
        this.m_gameState[7][20] = 21;
        this.m_gameState[7][21] = 32782;
        this.m_gameState[7][22] = 32779;
        this.m_gameState[7][23] = 21;
        this.m_gameState[7][24] = 262;
        this.m_gameState[7][25] = 65543;
        this.m_gameState[7][26] = 65543;
        this.m_gameState[7][27] = 79;
        this.m_gameState[7][28] = 32779;
        this.m_gameState[7][29] = 21;
        this.m_gameState[7][30] = 40970;
        this.m_gameState[8][0] = 33802;
        this.m_gameState[8][1] = 21;
        this.m_gameState[8][2] = 140;
        this.m_gameState[8][3] = 65541;
        this.m_gameState[8][4] = 73;
        this.m_gameState[8][5] = 21;
        this.m_gameState[8][6] = 140;
        this.m_gameState[8][7] = 65549;
        this.m_gameState[8][8] = 65549;
        this.m_gameState[8][9] = 527;
        this.m_gameState[8][10] = 271;
        this.m_gameState[8][11] = 65549;
        this.m_gameState[8][12] = 65549;
        this.m_gameState[8][13] = 73;
        this.m_gameState[8][14] = 5;
        this.m_gameState[8][15] = 140;
        this.m_gameState[8][16] = 65549;
        this.m_gameState[8][17] = 65549;
        this.m_gameState[8][18] = 527;
        this.m_gameState[8][19] = 32779;
        this.m_gameState[8][20] = 21;
        this.m_gameState[8][21] = 140;
        this.m_gameState[8][22] = 73;
        this.m_gameState[8][23] = 21;
        this.m_gameState[8][24] = 140;
        this.m_gameState[8][25] = 65549;
        this.m_gameState[8][26] = 65549;
        this.m_gameState[8][27] = 527;
        this.m_gameState[8][28] = 32779;
        this.m_gameState[8][29] = 21;
        this.m_gameState[8][30] = 40970;
        this.m_gameState[9][0] = 33802;
        this.m_gameState[9][1] = 17;
        this.m_gameState[9][2] = 26;
        this.m_gameState[9][3] = 26;
        this.m_gameState[9][4] = 26;
        this.m_gameState[9][5] = 18;
        this.m_gameState[9][6] = 26;
        this.m_gameState[9][7] = 26;
        this.m_gameState[9][8] = 28;
        this.m_gameState[9][9] = 32782;
        this.m_gameState[9][10] = 32779;
        this.m_gameState[9][11] = 9;
        this.m_gameState[9][12] = 10;
        this.m_gameState[9][13] = 10;
        this.m_gameState[9][14] = 2;
        this.m_gameState[9][15] = 10;
        this.m_gameState[9][16] = 10;
        this.m_gameState[9][17] = 12;
        this.m_gameState[9][18] = 32782;
        this.m_gameState[9][19] = 32779;
        this.m_gameState[9][20] = 17;
        this.m_gameState[9][21] = 26;
        this.m_gameState[9][22] = 26;
        this.m_gameState[9][23] = 18;
        this.m_gameState[9][24] = 26;
        this.m_gameState[9][25] = 26;
        this.m_gameState[9][26] = 28;
        this.m_gameState[9][27] = 32782;
        this.m_gameState[9][28] = 32779;
        this.m_gameState[9][29] = 21;
        this.m_gameState[9][30] = 40970;
        this.m_gameState[10][0] = 33802;
        this.m_gameState[10][1] = 21;
        this.m_gameState[10][2] = 262;
        this.m_gameState[10][3] = 65543;
        this.m_gameState[10][4] = 65543;
        this.m_gameState[10][5] = 65543;
        this.m_gameState[10][6] = 65543;
        this.m_gameState[10][7] = 515;
        this.m_gameState[10][8] = 21;
        this.m_gameState[10][9] = 32782;
        this.m_gameState[10][10] = 32779;
        this.m_gameState[10][11] = 5;
        this.m_gameState[10][12] = 262;
        this.m_gameState[10][13] = 81925;
        this.m_gameState[10][14] = 81925;
        this.m_gameState[10][15] = 81925;
        this.m_gameState[10][16] = 515;
        this.m_gameState[10][17] = 5;
        this.m_gameState[10][18] = 32782;
        this.m_gameState[10][19] = 32779;
        this.m_gameState[10][20] = 5;
        this.m_gameState[10][21] = 262;
        this.m_gameState[10][22] = 65543;
        this.m_gameState[10][23] = 65543;
        this.m_gameState[10][24] = 65543;
        this.m_gameState[10][25] = 515;
        this.m_gameState[10][26] = 21;
        this.m_gameState[10][27] = 32782;
        this.m_gameState[10][28] = 32779;
        this.m_gameState[10][29] = 21;
        this.m_gameState[10][30] = 40970;
        this.m_gameState[11][0] = 33802;
        this.m_gameState[11][1] = 21;
        this.m_gameState[11][2] = 32782;
        this.m_gameState[11][3] = 271;
        this.m_gameState[11][4] = 65549;
        this.m_gameState[11][5] = 65549;
        this.m_gameState[11][6] = 65549;
        this.m_gameState[11][7] = 73;
        this.m_gameState[11][8] = 21;
        this.m_gameState[11][9] = 140;
        this.m_gameState[11][10] = 73;
        this.m_gameState[11][11] = 5;
        this.m_gameState[11][12] = 40970;
        this.m_gameState[11][13] = 9;
        this.m_gameState[11][14] = 8;
        this.m_gameState[11][15] = 12;
        this.m_gameState[11][16] = 33802;
        this.m_gameState[11][17] = 5;
        this.m_gameState[11][18] = 140;
        this.m_gameState[11][19] = 73;
        this.m_gameState[11][20] = 5;
        this.m_gameState[11][21] = 140;
        this.m_gameState[11][22] = 65549;
        this.m_gameState[11][23] = 65549;
        this.m_gameState[11][24] = 527;
        this.m_gameState[11][25] = 32779;
        this.m_gameState[11][26] = 21;
        this.m_gameState[11][27] = 140;
        this.m_gameState[11][28] = 73;
        this.m_gameState[11][29] = 21;
        this.m_gameState[11][30] = 40970;
        this.m_gameState[12][0] = 33802;
        this.m_gameState[12][1] = 21;
        this.m_gameState[12][2] = 32782;
        this.m_gameState[12][3] = 32779;
        this.m_gameState[12][4] = 25;
        this.m_gameState[12][5] = 26;
        this.m_gameState[12][6] = 26;
        this.m_gameState[12][7] = 26;
        this.m_gameState[12][8] = 18;
        this.m_gameState[12][9] = 10;
        this.m_gameState[12][10] = 10;
        this.m_gameState[12][11] = 4;
        this.m_gameState[12][12] = 40970;
        this.m_gameState[12][13] = 1;
        this.m_gameState[12][14] = 0;
        this.m_gameState[12][15] = 4;
        this.m_gameState[12][16] = 33802;
        this.m_gameState[12][17] = 1;
        this.m_gameState[12][18] = 10;
        this.m_gameState[12][19] = 10;
        this.m_gameState[12][20] = 2;
        this.m_gameState[12][21] = 10;
        this.m_gameState[12][22] = 10;
        this.m_gameState[12][23] = 12;
        this.m_gameState[12][24] = 32782;
        this.m_gameState[12][25] = 32779;
        this.m_gameState[12][26] = 17;
        this.m_gameState[12][27] = 26;
        this.m_gameState[12][28] = 26;
        this.m_gameState[12][29] = 22;
        this.m_gameState[12][30] = 40970;
        this.m_gameState[13][0] = 33802;
        this.m_gameState[13][1] = 21;
        this.m_gameState[13][2] = 32782;
        this.m_gameState[13][3] = 32779;
        this.m_gameState[13][4] = 21;
        this.m_gameState[13][5] = 262;
        this.m_gameState[13][6] = 65543;
        this.m_gameState[13][7] = 65543;
        this.m_gameState[13][8] = 65543;
        this.m_gameState[13][9] = 65543;
        this.m_gameState[13][10] = 515;
        this.m_gameState[13][11] = 5;
        this.m_gameState[13][12] = 40970;
        this.m_gameState[13][13] = 1;
        this.m_gameState[13][14] = 0;
        this.m_gameState[13][15] = 4;
        this.m_gameState[13][16] = 33802;
        this.m_gameState[13][17] = 5;
        this.m_gameState[13][18] = 262;
        this.m_gameState[13][19] = 65543;
        this.m_gameState[13][20] = 65543;
        this.m_gameState[13][21] = 65543;
        this.m_gameState[13][22] = 515;
        this.m_gameState[13][23] = 5;
        this.m_gameState[13][24] = 32782;
        this.m_gameState[13][25] = 32779;
        this.m_gameState[13][26] = 21;
        this.m_gameState[13][27] = 262;
        this.m_gameState[13][28] = 65543;
        this.m_gameState[13][29] = 65543;
        this.m_gameState[13][30] = 8267;
        this.m_gameState[14][0] = 33802;
        this.m_gameState[14][1] = 21;
        this.m_gameState[14][2] = 32782;
        this.m_gameState[14][3] = 32779;
        this.m_gameState[14][4] = 21;
        this.m_gameState[14][5] = 140;
        this.m_gameState[14][6] = 65549;
        this.m_gameState[14][7] = 65549;
        this.m_gameState[14][8] = 65549;
        this.m_gameState[14][9] = 65549;
        this.m_gameState[14][10] = 73;
        this.m_gameState[14][11] = 5;
        this.m_gameState[14][12] = 40970;
        this.m_gameState[14][13] = 1;
        this.m_gameState[14][14] = 0;
        this.m_gameState[14][15] = 4;
        this.m_gameState[14][16] = 33802;
        this.m_gameState[14][17] = 5;
        this.m_gameState[14][18] = 140;
        this.m_gameState[14][19] = 65549;
        this.m_gameState[14][20] = 65549;
        this.m_gameState[14][21] = 65549;
        this.m_gameState[14][22] = 73;
        this.m_gameState[14][23] = 5;
        this.m_gameState[14][24] = 32782;
        this.m_gameState[14][25] = 32779;
        this.m_gameState[14][26] = 21;
        this.m_gameState[14][27] = 140;
        this.m_gameState[14][28] = 65549;
        this.m_gameState[14][29] = 65549;
        this.m_gameState[14][30] = 8715;
        this.m_gameState[15][0] = 33802;
        this.m_gameState[15][1] = 21;
        this.m_gameState[15][2] = 32782;
        this.m_gameState[15][3] = 32779;
        this.m_gameState[15][4] = 19;
        this.m_gameState[15][5] = 26;
        this.m_gameState[15][6] = 26;
        this.m_gameState[15][7] = 26;
        this.m_gameState[15][8] = 24;
        this.m_gameState[15][9] = 10;
        this.m_gameState[15][10] = 10;
        this.m_gameState[15][11] = 4;
        this.m_gameState[15][12] = 40970;
        this.m_gameState[15][13] = 1;
        this.m_gameState[15][14] = 0;
        this.m_gameState[15][15] = 4;
        this.m_gameState[15][16] = 33802;
        this.m_gameState[15][17] = 1;
        this.m_gameState[15][18] = 10;
        this.m_gameState[15][19] = 10;
        this.m_gameState[15][20] = 8;
        this.m_gameState[15][21] = 10;
        this.m_gameState[15][22] = 10;
        this.m_gameState[15][23] = 6;
        this.m_gameState[15][24] = 32782;
        this.m_gameState[15][25] = 32779;
        this.m_gameState[15][26] = 17;
        this.m_gameState[15][27] = 26;
        this.m_gameState[15][28] = 26;
        this.m_gameState[15][29] = 28;
        this.m_gameState[15][30] = 40970;
        this.m_gameState[16][0] = 33802;
        this.m_gameState[16][1] = 21;
        this.m_gameState[16][2] = 32782;
        this.m_gameState[16][3] = 143;
        this.m_gameState[16][4] = 65543;
        this.m_gameState[16][5] = 65543;
        this.m_gameState[16][6] = 65543;
        this.m_gameState[16][7] = 515;
        this.m_gameState[16][8] = 21;
        this.m_gameState[16][9] = 262;
        this.m_gameState[16][10] = 515;
        this.m_gameState[16][11] = 5;
        this.m_gameState[16][12] = 40970;
        this.m_gameState[16][13] = 3;
        this.m_gameState[16][14] = 2;
        this.m_gameState[16][15] = 6;
        this.m_gameState[16][16] = 33802;
        this.m_gameState[16][17] = 5;
        this.m_gameState[16][18] = 262;
        this.m_gameState[16][19] = 515;
        this.m_gameState[16][20] = 5;
        this.m_gameState[16][21] = 262;
        this.m_gameState[16][22] = 65543;
        this.m_gameState[16][23] = 65543;
        this.m_gameState[16][24] = 79;
        this.m_gameState[16][25] = 32779;
        this.m_gameState[16][26] = 21;
        this.m_gameState[16][27] = 262;
        this.m_gameState[16][28] = 515;
        this.m_gameState[16][29] = 21;
        this.m_gameState[16][30] = 40970;
        this.m_gameState[17][0] = 33802;
        this.m_gameState[17][1] = 21;
        this.m_gameState[17][2] = 140;
        this.m_gameState[17][3] = 65549;
        this.m_gameState[17][4] = 65549;
        this.m_gameState[17][5] = 65549;
        this.m_gameState[17][6] = 65549;
        this.m_gameState[17][7] = 73;
        this.m_gameState[17][8] = 21;
        this.m_gameState[17][9] = 32782;
        this.m_gameState[17][10] = 32779;
        this.m_gameState[17][11] = 5;
        this.m_gameState[17][12] = 140;
        this.m_gameState[17][13] = 69637;
        this.m_gameState[17][14] = 69637;
        this.m_gameState[17][15] = 69637;
        this.m_gameState[17][16] = 73;
        this.m_gameState[17][17] = 5;
        this.m_gameState[17][18] = 32782;
        this.m_gameState[17][19] = 32779;
        this.m_gameState[17][20] = 5;
        this.m_gameState[17][21] = 140;
        this.m_gameState[17][22] = 65549;
        this.m_gameState[17][23] = 65549;
        this.m_gameState[17][24] = 65549;
        this.m_gameState[17][25] = 73;
        this.m_gameState[17][26] = 21;
        this.m_gameState[17][27] = 32782;
        this.m_gameState[17][28] = 32779;
        this.m_gameState[17][29] = 21;
        this.m_gameState[17][30] = 40970;
        this.m_gameState[18][0] = 33802;
        this.m_gameState[18][1] = 17;
        this.m_gameState[18][2] = 26;
        this.m_gameState[18][3] = 26;
        this.m_gameState[18][4] = 26;
        this.m_gameState[18][5] = 24;
        this.m_gameState[18][6] = 26;
        this.m_gameState[18][7] = 26;
        this.m_gameState[18][8] = 22;
        this.m_gameState[18][9] = 32782;
        this.m_gameState[18][10] = 32779;
        this.m_gameState[18][11] = 3;
        this.m_gameState[18][12] = 10;
        this.m_gameState[18][13] = 10;
        this.m_gameState[18][14] = 8;
        this.m_gameState[18][15] = 10;
        this.m_gameState[18][16] = 10;
        this.m_gameState[18][17] = 6;
        this.m_gameState[18][18] = 32782;
        this.m_gameState[18][19] = 32779;
        this.m_gameState[18][20] = 17;
        this.m_gameState[18][21] = 26;
        this.m_gameState[18][22] = 26;
        this.m_gameState[18][23] = 24;
        this.m_gameState[18][24] = 26;
        this.m_gameState[18][25] = 26;
        this.m_gameState[18][26] = 22;
        this.m_gameState[18][27] = 32782;
        this.m_gameState[18][28] = 32779;
        this.m_gameState[18][29] = 21;
        this.m_gameState[18][30] = 40970;
        this.m_gameState[19][0] = 33802;
        this.m_gameState[19][1] = 21;
        this.m_gameState[19][2] = 262;
        this.m_gameState[19][3] = 65541;
        this.m_gameState[19][4] = 515;
        this.m_gameState[19][5] = 21;
        this.m_gameState[19][6] = 262;
        this.m_gameState[19][7] = 65543;
        this.m_gameState[19][8] = 65543;
        this.m_gameState[19][9] = 79;
        this.m_gameState[19][10] = 143;
        this.m_gameState[19][11] = 65543;
        this.m_gameState[19][12] = 65543;
        this.m_gameState[19][13] = 515;
        this.m_gameState[19][14] = 5;
        this.m_gameState[19][15] = 262;
        this.m_gameState[19][16] = 65543;
        this.m_gameState[19][17] = 65543;
        this.m_gameState[19][18] = 79;
        this.m_gameState[19][19] = 32779;
        this.m_gameState[19][20] = 21;
        this.m_gameState[19][21] = 262;
        this.m_gameState[19][22] = 515;
        this.m_gameState[19][23] = 21;
        this.m_gameState[19][24] = 262;
        this.m_gameState[19][25] = 65543;
        this.m_gameState[19][26] = 65543;
        this.m_gameState[19][27] = 79;
        this.m_gameState[19][28] = 32779;
        this.m_gameState[19][29] = 21;
        this.m_gameState[19][30] = 40970;
        this.m_gameState[20][0] = 33802;
        this.m_gameState[20][1] = 21;
        this.m_gameState[20][2] = 32778;
        this.m_gameState[20][3] = 13;
        this.m_gameState[20][4] = 32778;
        this.m_gameState[20][5] = 21;
        this.m_gameState[20][6] = 140;
        this.m_gameState[20][7] = 65549;
        this.m_gameState[20][8] = 65549;
        this.m_gameState[20][9] = 527;
        this.m_gameState[20][10] = 271;
        this.m_gameState[20][11] = 65549;
        this.m_gameState[20][12] = 65549;
        this.m_gameState[20][13] = 73;
        this.m_gameState[20][14] = 5;
        this.m_gameState[20][15] = 140;
        this.m_gameState[20][16] = 65549;
        this.m_gameState[20][17] = 65549;
        this.m_gameState[20][18] = 65549;
        this.m_gameState[20][19] = 73;
        this.m_gameState[20][20] = 21;
        this.m_gameState[20][21] = 32782;
        this.m_gameState[20][22] = 32779;
        this.m_gameState[20][23] = 21;
        this.m_gameState[20][24] = 140;
        this.m_gameState[20][25] = 65549;
        this.m_gameState[20][26] = 65549;
        this.m_gameState[20][27] = 527;
        this.m_gameState[20][28] = 32779;
        this.m_gameState[20][29] = 21;
        this.m_gameState[20][30] = 40970;
        this.m_gameState[21][0] = 33802;
        this.m_gameState[21][1] = 21;
        this.m_gameState[21][2] = 32778;
        this.m_gameState[21][3] = 7;
        this.m_gameState[21][4] = 32778;
        this.m_gameState[21][5] = 17;
        this.m_gameState[21][6] = 26;
        this.m_gameState[21][7] = 26;
        this.m_gameState[21][8] = 28;
        this.m_gameState[21][9] = 32782;
        this.m_gameState[21][10] = 32779;
        this.m_gameState[21][11] = 25;
        this.m_gameState[21][12] = 26;
        this.m_gameState[21][13] = 26;
        this.m_gameState[21][14] = 18;
        this.m_gameState[21][15] = 26;
        this.m_gameState[21][16] = 26;
        this.m_gameState[21][17] = 26;
        this.m_gameState[21][18] = 24;
        this.m_gameState[21][19] = 26;
        this.m_gameState[21][20] = 22;
        this.m_gameState[21][21] = 32782;
        this.m_gameState[21][22] = 32779;
        this.m_gameState[21][23] = 17;
        this.m_gameState[21][24] = 26;
        this.m_gameState[21][25] = 26;
        this.m_gameState[21][26] = 28;
        this.m_gameState[21][27] = 32782;
        this.m_gameState[21][28] = 32779;
        this.m_gameState[21][29] = 21;
        this.m_gameState[21][30] = 40970;
        this.m_gameState[22][0] = 33802;
        this.m_gameState[22][1] = 21;
        this.m_gameState[22][2] = 140;
        this.m_gameState[22][3] = 65541;
        this.m_gameState[22][4] = 73;
        this.m_gameState[22][5] = 21;
        this.m_gameState[22][6] = 262;
        this.m_gameState[22][7] = 515;
        this.m_gameState[22][8] = 21;
        this.m_gameState[22][9] = 32782;
        this.m_gameState[22][10] = 32779;
        this.m_gameState[22][11] = 21;
        this.m_gameState[22][12] = 262;
        this.m_gameState[22][13] = 65543;
        this.m_gameState[22][14] = 65543;
        this.m_gameState[22][15] = 65543;
        this.m_gameState[22][16] = 65543;
        this.m_gameState[22][17] = 515;
        this.m_gameState[22][18] = 21;
        this.m_gameState[22][19] = 262;
        this.m_gameState[22][20] = 65543;
        this.m_gameState[22][21] = 79;
        this.m_gameState[22][22] = 32779;
        this.m_gameState[22][23] = 21;
        this.m_gameState[22][24] = 262;
        this.m_gameState[22][25] = 515;
        this.m_gameState[22][26] = 21;
        this.m_gameState[22][27] = 140;
        this.m_gameState[22][28] = 73;
        this.m_gameState[22][29] = 21;
        this.m_gameState[22][30] = 40970;
        this.m_gameState[23][0] = 33802;
        this.m_gameState[23][1] = 17;
        this.m_gameState[23][2] = 26;
        this.m_gameState[23][3] = 26;
        this.m_gameState[23][4] = 26;
        this.m_gameState[23][5] = 22;
        this.m_gameState[23][6] = 32782;
        this.m_gameState[23][7] = 32779;
        this.m_gameState[23][8] = 21;
        this.m_gameState[23][9] = 140;
        this.m_gameState[23][10] = 73;
        this.m_gameState[23][11] = 21;
        this.m_gameState[23][12] = 140;
        this.m_gameState[23][13] = 65549;
        this.m_gameState[23][14] = 527;
        this.m_gameState[23][15] = 271;
        this.m_gameState[23][16] = 65549;
        this.m_gameState[23][17] = 73;
        this.m_gameState[23][18] = 21;
        this.m_gameState[23][19] = 140;
        this.m_gameState[23][20] = 65549;
        this.m_gameState[23][21] = 65549;
        this.m_gameState[23][22] = 73;
        this.m_gameState[23][23] = 21;
        this.m_gameState[23][24] = 32782;
        this.m_gameState[23][25] = 32779;
        this.m_gameState[23][26] = 19;
        this.m_gameState[23][27] = 26;
        this.m_gameState[23][28] = 26;
        this.m_gameState[23][29] = 20;
        this.m_gameState[23][30] = 40970;
        this.m_gameState[24][0] = 33802;
        this.m_gameState[24][1] = 21;
        this.m_gameState[24][2] = 262;
        this.m_gameState[24][3] = 65543;
        this.m_gameState[24][4] = 65543;
        this.m_gameState[24][5] = 65543;
        this.m_gameState[24][6] = 79;
        this.m_gameState[24][7] = 32779;
        this.m_gameState[24][8] = 17;
        this.m_gameState[24][9] = 26;
        this.m_gameState[24][10] = 26;
        this.m_gameState[24][11] = 18;
        this.m_gameState[24][12] = 10;
        this.m_gameState[24][13] = 12;
        this.m_gameState[24][14] = 32782;
        this.m_gameState[24][15] = 32779;
        this.m_gameState[24][16] = 9;
        this.m_gameState[24][17] = 10;
        this.m_gameState[24][18] = 18;
        this.m_gameState[24][19] = 26;
        this.m_gameState[24][20] = 26;
        this.m_gameState[24][21] = 26;
        this.m_gameState[24][22] = 26;
        this.m_gameState[24][23] = 20;
        this.m_gameState[24][24] = 32782;
        this.m_gameState[24][25] = 143;
        this.m_gameState[24][26] = 65543;
        this.m_gameState[24][27] = 65543;
        this.m_gameState[24][28] = 515;
        this.m_gameState[24][29] = 21;
        this.m_gameState[24][30] = 40970;
        this.m_gameState[25][0] = 33802;
        this.m_gameState[25][1] = 21;
        this.m_gameState[25][2] = 140;
        this.m_gameState[25][3] = 65549;
        this.m_gameState[25][4] = 65549;
        this.m_gameState[25][5] = 65549;
        this.m_gameState[25][6] = 65549;
        this.m_gameState[25][7] = 73;
        this.m_gameState[25][8] = 21;
        this.m_gameState[25][9] = 262;
        this.m_gameState[25][10] = 81925;
        this.m_gameState[25][11] = 81925;
        this.m_gameState[25][12] = 515;
        this.m_gameState[25][13] = 5;
        this.m_gameState[25][14] = 32782;
        this.m_gameState[25][15] = 32779;
        this.m_gameState[25][16] = 5;
        this.m_gameState[25][17] = 262;
        this.m_gameState[25][18] = 81925;
        this.m_gameState[25][19] = 81925;
        this.m_gameState[25][20] = 81925;
        this.m_gameState[25][21] = 81925;
        this.m_gameState[25][22] = 515;
        this.m_gameState[25][23] = 21;
        this.m_gameState[25][24] = 140;
        this.m_gameState[25][25] = 65549;
        this.m_gameState[25][26] = 65549;
        this.m_gameState[25][27] = 65549;
        this.m_gameState[25][28] = 73;
        this.m_gameState[25][29] = 21;
        this.m_gameState[25][30] = 40970;
        this.m_gameState[26][0] = 33802;
        this.m_gameState[26][1] = 19;
        this.m_gameState[26][2] = 26;
        this.m_gameState[26][3] = 42;
        this.m_gameState[26][4] = 26;
        this.m_gameState[26][5] = 26;
        this.m_gameState[26][6] = 26;
        this.m_gameState[26][7] = 26;
        this.m_gameState[26][8] = 22;
        this.m_gameState[26][9] = 40970;
        this.m_gameState[26][10] = 9;
        this.m_gameState[26][11] = 12;
        this.m_gameState[26][12] = 33802;
        this.m_gameState[26][13] = 5;
        this.m_gameState[26][14] = 32782;
        this.m_gameState[26][15] = 32779;
        this.m_gameState[26][16] = 5;
        this.m_gameState[26][17] = 40970;
        this.m_gameState[26][18] = 9;
        this.m_gameState[26][19] = 8;
        this.m_gameState[26][20] = 8;
        this.m_gameState[26][21] = 12;
        this.m_gameState[26][22] = 33802;
        this.m_gameState[26][23] = 19;
        this.m_gameState[26][24] = 26;
        this.m_gameState[26][25] = 26;
        this.m_gameState[26][26] = 26;
        this.m_gameState[26][27] = 42;
        this.m_gameState[26][28] = 26;
        this.m_gameState[26][29] = 22;
        this.m_gameState[26][30] = 40970;
        this.m_gameState[27][0] = 17548;
        this.m_gameState[27][1] = 81925;
        this.m_gameState[27][2] = 81925;
        this.m_gameState[27][3] = 81925;
        this.m_gameState[27][4] = 81925;
        this.m_gameState[27][5] = 81925;
        this.m_gameState[27][6] = 81925;
        this.m_gameState[27][7] = 81925;
        this.m_gameState[27][8] = 81925;
        this.m_gameState[27][9] = 24649;
        this.m_gameState[27][10] = 1;
        this.m_gameState[27][11] = 4;
        this.m_gameState[27][12] = 33800;
        this.m_gameState[27][13] = 5;
        this.m_gameState[27][14] = 32780;
        this.m_gameState[27][15] = 32777;
        this.m_gameState[27][16] = 5;
        this.m_gameState[27][17] = 40968;
        this.m_gameState[27][18] = 1;
        this.m_gameState[27][19] = 0;
        this.m_gameState[27][20] = 0;
        this.m_gameState[27][21] = 4;
        this.m_gameState[27][22] = 17548;
        this.m_gameState[27][23] = 81925;
        this.m_gameState[27][24] = 81925;
        this.m_gameState[27][25] = 81925;
        this.m_gameState[27][26] = 81925;
        this.m_gameState[27][27] = 81925;
        this.m_gameState[27][28] = 81925;
        this.m_gameState[27][29] = 81925;
        this.m_gameState[27][30] = 24649;
    }

    void loadGhostHideout() {
        this.m_gameState[17][12] = 128;
        this.m_gameState[17][13] = 69632;
        this.m_gameState[17][14] = 69632;
        this.m_gameState[17][15] = 69632;
        this.m_gameState[17][16] = 64;
        this.m_gameState[16][16] = 33792;
        this.m_gameState[16][12] = 40960;
        this.m_gameState[13][16] = 33792;
        this.m_gameState[15][16] = 33792;
        this.m_gameState[15][12] = 40960;
        this.m_gameState[14][16] = 33792;
        this.m_gameState[14][12] = 40960;
        this.m_gameState[14][12] = 40960;
        this.m_gameState[13][12] = 40960;
        this.m_gameState[12][16] = 33792;
        this.m_gameState[12][14] = 13;
        this.m_gameState[13][14] = 5;
        this.m_gameState[13][13] = 0;
        this.m_gameState[14][14] = 5;
        this.m_gameState[15][14] = 7;
        this.m_gameState[12][12] = 40960;
        this.m_gameState[11][12] = 40960;
        this.m_gameState[11][16] = 33792;
        this.m_gameState[11][16] = 33792;
        this.m_gameState[10][12] = 256;
        this.m_gameState[10][13] = 81920;
        this.m_gameState[10][14] = 81920;
        this.m_gameState[10][15] = 81920;
        this.m_gameState[10][16] = 512;
    }

    public void loadIntroMaze() {
        this.m_gameState[0][0] = 0;
        this.m_gameState[0][1] = 0;
        this.m_gameState[0][2] = 0;
        this.m_gameState[0][3] = 0;
        this.m_gameState[0][4] = 0;
        this.m_gameState[0][5] = 0;
        this.m_gameState[0][6] = 0;
        this.m_gameState[0][7] = 0;
        this.m_gameState[0][8] = 0;
        this.m_gameState[0][9] = 0;
        this.m_gameState[0][10] = 0;
        this.m_gameState[0][11] = 0;
        this.m_gameState[0][12] = 0;
        this.m_gameState[0][13] = 0;
        this.m_gameState[0][14] = 0;
        this.m_gameState[0][15] = 0;
        this.m_gameState[0][16] = 0;
        this.m_gameState[0][17] = 4;
        this.m_gameState[0][18] = 32770;
        this.m_gameState[0][19] = 5;
        this.m_gameState[0][20] = 32770;
        this.m_gameState[0][21] = 1;
        this.m_gameState[0][22] = 0;
        this.m_gameState[0][23] = 0;
        this.m_gameState[0][24] = 0;
        this.m_gameState[0][25] = 0;
        this.m_gameState[0][26] = 0;
        this.m_gameState[0][27] = 0;
        this.m_gameState[0][28] = 0;
        this.m_gameState[0][29] = 0;
        this.m_gameState[0][30] = 0;
        this.m_gameState[1][0] = 0;
        this.m_gameState[1][1] = 0;
        this.m_gameState[1][2] = 0;
        this.m_gameState[1][3] = 0;
        this.m_gameState[1][4] = 0;
        this.m_gameState[1][5] = 0;
        this.m_gameState[1][6] = 0;
        this.m_gameState[1][7] = 0;
        this.m_gameState[1][8] = 0;
        this.m_gameState[1][9] = 0;
        this.m_gameState[1][10] = 0;
        this.m_gameState[1][11] = 0;
        this.m_gameState[1][12] = 0;
        this.m_gameState[1][13] = 0;
        this.m_gameState[1][14] = 0;
        this.m_gameState[1][15] = 0;
        this.m_gameState[1][16] = 0;
        this.m_gameState[1][17] = 4;
        this.m_gameState[1][18] = 32778;
        this.m_gameState[1][19] = 5;
        this.m_gameState[1][20] = 32778;
        this.m_gameState[1][21] = 1;
        this.m_gameState[1][22] = 0;
        this.m_gameState[1][23] = 0;
        this.m_gameState[1][24] = 0;
        this.m_gameState[1][25] = 0;
        this.m_gameState[1][26] = 0;
        this.m_gameState[1][27] = 0;
        this.m_gameState[1][28] = 0;
        this.m_gameState[1][29] = 0;
        this.m_gameState[1][30] = 0;
        this.m_gameState[2][0] = 0;
        this.m_gameState[2][1] = 0;
        this.m_gameState[2][2] = 0;
        this.m_gameState[2][3] = 0;
        this.m_gameState[2][4] = 0;
        this.m_gameState[2][5] = 0;
        this.m_gameState[2][6] = 0;
        this.m_gameState[2][7] = 0;
        this.m_gameState[2][8] = 0;
        this.m_gameState[2][9] = 0;
        this.m_gameState[2][10] = 0;
        this.m_gameState[2][11] = 0;
        this.m_gameState[2][12] = 0;
        this.m_gameState[2][13] = 0;
        this.m_gameState[2][14] = 0;
        this.m_gameState[2][15] = 0;
        this.m_gameState[2][16] = 0;
        this.m_gameState[2][17] = 4;
        this.m_gameState[2][18] = 32778;
        this.m_gameState[2][19] = 5;
        this.m_gameState[2][20] = 32778;
        this.m_gameState[2][21] = 1;
        this.m_gameState[2][22] = 0;
        this.m_gameState[2][23] = 0;
        this.m_gameState[2][24] = 0;
        this.m_gameState[2][25] = 0;
        this.m_gameState[2][26] = 0;
        this.m_gameState[2][27] = 0;
        this.m_gameState[2][28] = 0;
        this.m_gameState[2][29] = 0;
        this.m_gameState[2][30] = 0;
        this.m_gameState[3][0] = 0;
        this.m_gameState[3][1] = 0;
        this.m_gameState[3][2] = 0;
        this.m_gameState[3][3] = 0;
        this.m_gameState[3][4] = 0;
        this.m_gameState[3][5] = 0;
        this.m_gameState[3][6] = 0;
        this.m_gameState[3][7] = 0;
        this.m_gameState[3][8] = 0;
        this.m_gameState[3][9] = 0;
        this.m_gameState[3][10] = 0;
        this.m_gameState[3][11] = 0;
        this.m_gameState[3][12] = 0;
        this.m_gameState[3][13] = 0;
        this.m_gameState[3][14] = 0;
        this.m_gameState[3][15] = 0;
        this.m_gameState[3][16] = 0;
        this.m_gameState[3][17] = 4;
        this.m_gameState[3][18] = 32778;
        this.m_gameState[3][19] = 5;
        this.m_gameState[3][20] = 32778;
        this.m_gameState[3][21] = 1;
        this.m_gameState[3][22] = 0;
        this.m_gameState[3][23] = 0;
        this.m_gameState[3][24] = 0;
        this.m_gameState[3][25] = 0;
        this.m_gameState[3][26] = 0;
        this.m_gameState[3][27] = 0;
        this.m_gameState[3][28] = 0;
        this.m_gameState[3][29] = 0;
        this.m_gameState[3][30] = 0;
        this.m_gameState[4][0] = 0;
        this.m_gameState[4][1] = 0;
        this.m_gameState[4][2] = 0;
        this.m_gameState[4][3] = 0;
        this.m_gameState[4][4] = 0;
        this.m_gameState[4][5] = 0;
        this.m_gameState[4][6] = 0;
        this.m_gameState[4][7] = 0;
        this.m_gameState[4][8] = 0;
        this.m_gameState[4][9] = 0;
        this.m_gameState[4][10] = 0;
        this.m_gameState[4][11] = 0;
        this.m_gameState[4][12] = 0;
        this.m_gameState[4][13] = 0;
        this.m_gameState[4][14] = 0;
        this.m_gameState[4][15] = 0;
        this.m_gameState[4][16] = 0;
        this.m_gameState[4][17] = 4;
        this.m_gameState[4][18] = 32778;
        this.m_gameState[4][19] = 5;
        this.m_gameState[4][20] = 32778;
        this.m_gameState[4][21] = 1;
        this.m_gameState[4][22] = 0;
        this.m_gameState[4][23] = 0;
        this.m_gameState[4][24] = 0;
        this.m_gameState[4][25] = 0;
        this.m_gameState[4][26] = 0;
        this.m_gameState[4][27] = 0;
        this.m_gameState[4][28] = 0;
        this.m_gameState[4][29] = 0;
        this.m_gameState[4][30] = 0;
        this.m_gameState[5][0] = 0;
        this.m_gameState[5][1] = 0;
        this.m_gameState[5][2] = 0;
        this.m_gameState[5][3] = 0;
        this.m_gameState[5][4] = 0;
        this.m_gameState[5][5] = 0;
        this.m_gameState[5][6] = 0;
        this.m_gameState[5][7] = 0;
        this.m_gameState[5][8] = 0;
        this.m_gameState[5][9] = 0;
        this.m_gameState[5][10] = 0;
        this.m_gameState[5][11] = 0;
        this.m_gameState[5][12] = 0;
        this.m_gameState[5][13] = 0;
        this.m_gameState[5][14] = 0;
        this.m_gameState[5][15] = 0;
        this.m_gameState[5][16] = 0;
        this.m_gameState[5][17] = 4;
        this.m_gameState[5][18] = 32778;
        this.m_gameState[5][19] = 5;
        this.m_gameState[5][20] = 32778;
        this.m_gameState[5][21] = 1;
        this.m_gameState[5][22] = 0;
        this.m_gameState[5][23] = 0;
        this.m_gameState[5][24] = 0;
        this.m_gameState[5][25] = 0;
        this.m_gameState[5][26] = 0;
        this.m_gameState[5][27] = 0;
        this.m_gameState[5][28] = 0;
        this.m_gameState[5][29] = 0;
        this.m_gameState[5][30] = 0;
        this.m_gameState[6][0] = 0;
        this.m_gameState[6][1] = 0;
        this.m_gameState[6][2] = 0;
        this.m_gameState[6][3] = 0;
        this.m_gameState[6][4] = 0;
        this.m_gameState[6][5] = 0;
        this.m_gameState[6][6] = 0;
        this.m_gameState[6][7] = 0;
        this.m_gameState[6][8] = 0;
        this.m_gameState[6][9] = 0;
        this.m_gameState[6][10] = 0;
        this.m_gameState[6][11] = 0;
        this.m_gameState[6][12] = 0;
        this.m_gameState[6][13] = 0;
        this.m_gameState[6][14] = 0;
        this.m_gameState[6][15] = 0;
        this.m_gameState[6][16] = 0;
        this.m_gameState[6][17] = 4;
        this.m_gameState[6][18] = 32778;
        this.m_gameState[6][19] = 5;
        this.m_gameState[6][20] = 32778;
        this.m_gameState[6][21] = 1;
        this.m_gameState[6][22] = 0;
        this.m_gameState[6][23] = 0;
        this.m_gameState[6][24] = 0;
        this.m_gameState[6][25] = 0;
        this.m_gameState[6][26] = 0;
        this.m_gameState[6][27] = 0;
        this.m_gameState[6][28] = 0;
        this.m_gameState[6][29] = 0;
        this.m_gameState[6][30] = 0;
        this.m_gameState[7][0] = 0;
        this.m_gameState[7][1] = 0;
        this.m_gameState[7][2] = 0;
        this.m_gameState[7][3] = 0;
        this.m_gameState[7][4] = 0;
        this.m_gameState[7][5] = 0;
        this.m_gameState[7][6] = 0;
        this.m_gameState[7][7] = 0;
        this.m_gameState[7][8] = 0;
        this.m_gameState[7][9] = 0;
        this.m_gameState[7][10] = 0;
        this.m_gameState[7][11] = 0;
        this.m_gameState[7][12] = 0;
        this.m_gameState[7][13] = 0;
        this.m_gameState[7][14] = 0;
        this.m_gameState[7][15] = 0;
        this.m_gameState[7][16] = 0;
        this.m_gameState[7][17] = 4;
        this.m_gameState[7][18] = 32778;
        this.m_gameState[7][19] = 5;
        this.m_gameState[7][20] = 32778;
        this.m_gameState[7][21] = 1;
        this.m_gameState[7][22] = 0;
        this.m_gameState[7][23] = 0;
        this.m_gameState[7][24] = 0;
        this.m_gameState[7][25] = 0;
        this.m_gameState[7][26] = 0;
        this.m_gameState[7][27] = 0;
        this.m_gameState[7][28] = 0;
        this.m_gameState[7][29] = 0;
        this.m_gameState[7][30] = 0;
        this.m_gameState[8][0] = 0;
        this.m_gameState[8][1] = 0;
        this.m_gameState[8][2] = 0;
        this.m_gameState[8][3] = 0;
        this.m_gameState[8][4] = 0;
        this.m_gameState[8][5] = 0;
        this.m_gameState[8][6] = 0;
        this.m_gameState[8][7] = 0;
        this.m_gameState[8][8] = 0;
        this.m_gameState[8][9] = 0;
        this.m_gameState[8][10] = 0;
        this.m_gameState[8][11] = 0;
        this.m_gameState[8][12] = 0;
        this.m_gameState[8][13] = 0;
        this.m_gameState[8][14] = 0;
        this.m_gameState[8][15] = 0;
        this.m_gameState[8][16] = 0;
        this.m_gameState[8][17] = 4;
        this.m_gameState[8][18] = 32778;
        this.m_gameState[8][19] = 5;
        this.m_gameState[8][20] = 32778;
        this.m_gameState[8][21] = 1;
        this.m_gameState[8][22] = 0;
        this.m_gameState[8][23] = 0;
        this.m_gameState[8][24] = 0;
        this.m_gameState[8][25] = 0;
        this.m_gameState[8][26] = 0;
        this.m_gameState[8][27] = 0;
        this.m_gameState[8][28] = 0;
        this.m_gameState[8][29] = 0;
        this.m_gameState[8][30] = 0;
        this.m_gameState[9][0] = 0;
        this.m_gameState[9][1] = 0;
        this.m_gameState[9][2] = 0;
        this.m_gameState[9][3] = 0;
        this.m_gameState[9][4] = 0;
        this.m_gameState[9][5] = 0;
        this.m_gameState[9][6] = 0;
        this.m_gameState[9][7] = 0;
        this.m_gameState[9][8] = 0;
        this.m_gameState[9][9] = 0;
        this.m_gameState[9][10] = 0;
        this.m_gameState[9][11] = 0;
        this.m_gameState[9][12] = 0;
        this.m_gameState[9][13] = 0;
        this.m_gameState[9][14] = 0;
        this.m_gameState[9][15] = 0;
        this.m_gameState[9][16] = 0;
        this.m_gameState[9][17] = 4;
        this.m_gameState[9][18] = 32778;
        this.m_gameState[9][19] = 5;
        this.m_gameState[9][20] = 32778;
        this.m_gameState[9][21] = 1;
        this.m_gameState[9][22] = 0;
        this.m_gameState[9][23] = 0;
        this.m_gameState[9][24] = 0;
        this.m_gameState[9][25] = 0;
        this.m_gameState[9][26] = 0;
        this.m_gameState[9][27] = 0;
        this.m_gameState[9][28] = 0;
        this.m_gameState[9][29] = 0;
        this.m_gameState[9][30] = 0;
        this.m_gameState[10][0] = 0;
        this.m_gameState[10][1] = 0;
        this.m_gameState[10][2] = 0;
        this.m_gameState[10][3] = 0;
        this.m_gameState[10][4] = 0;
        this.m_gameState[10][5] = 0;
        this.m_gameState[10][6] = 0;
        this.m_gameState[10][7] = 0;
        this.m_gameState[10][8] = 0;
        this.m_gameState[10][9] = 0;
        this.m_gameState[10][10] = 0;
        this.m_gameState[10][11] = 0;
        this.m_gameState[10][12] = 0;
        this.m_gameState[10][13] = 0;
        this.m_gameState[10][14] = 0;
        this.m_gameState[10][15] = 0;
        this.m_gameState[10][16] = 0;
        this.m_gameState[10][17] = 4;
        this.m_gameState[10][18] = 32778;
        this.m_gameState[10][19] = 5;
        this.m_gameState[10][20] = 32778;
        this.m_gameState[10][21] = 1;
        this.m_gameState[10][22] = 0;
        this.m_gameState[10][23] = 0;
        this.m_gameState[10][24] = 0;
        this.m_gameState[10][25] = 0;
        this.m_gameState[10][26] = 0;
        this.m_gameState[10][27] = 0;
        this.m_gameState[10][28] = 0;
        this.m_gameState[10][29] = 0;
        this.m_gameState[10][30] = 0;
        this.m_gameState[11][0] = 0;
        this.m_gameState[11][1] = 0;
        this.m_gameState[11][2] = 0;
        this.m_gameState[11][3] = 0;
        this.m_gameState[11][4] = 0;
        this.m_gameState[11][5] = 0;
        this.m_gameState[11][6] = 0;
        this.m_gameState[11][7] = 0;
        this.m_gameState[11][8] = 0;
        this.m_gameState[11][9] = 0;
        this.m_gameState[11][10] = 0;
        this.m_gameState[11][11] = 0;
        this.m_gameState[11][12] = 0;
        this.m_gameState[11][13] = 0;
        this.m_gameState[11][14] = 0;
        this.m_gameState[11][15] = 0;
        this.m_gameState[11][16] = 0;
        this.m_gameState[11][17] = 4;
        this.m_gameState[11][18] = 32778;
        this.m_gameState[11][19] = 5;
        this.m_gameState[11][20] = 32778;
        this.m_gameState[11][21] = 1;
        this.m_gameState[11][22] = 0;
        this.m_gameState[11][23] = 0;
        this.m_gameState[11][24] = 0;
        this.m_gameState[11][25] = 0;
        this.m_gameState[11][26] = 0;
        this.m_gameState[11][27] = 0;
        this.m_gameState[11][28] = 0;
        this.m_gameState[11][29] = 0;
        this.m_gameState[11][30] = 0;
        this.m_gameState[12][0] = 0;
        this.m_gameState[12][1] = 0;
        this.m_gameState[12][2] = 0;
        this.m_gameState[12][3] = 0;
        this.m_gameState[12][4] = 0;
        this.m_gameState[12][5] = 0;
        this.m_gameState[12][6] = 0;
        this.m_gameState[12][7] = 0;
        this.m_gameState[12][8] = 0;
        this.m_gameState[12][9] = 0;
        this.m_gameState[12][10] = 0;
        this.m_gameState[12][11] = 0;
        this.m_gameState[12][12] = 0;
        this.m_gameState[12][13] = 0;
        this.m_gameState[12][14] = 0;
        this.m_gameState[12][15] = 0;
        this.m_gameState[12][16] = 0;
        this.m_gameState[12][17] = 4;
        this.m_gameState[12][18] = 32778;
        this.m_gameState[12][19] = 5;
        this.m_gameState[12][20] = 32778;
        this.m_gameState[12][21] = 1;
        this.m_gameState[12][22] = 0;
        this.m_gameState[12][23] = 0;
        this.m_gameState[12][24] = 0;
        this.m_gameState[12][25] = 0;
        this.m_gameState[12][26] = 0;
        this.m_gameState[12][27] = 0;
        this.m_gameState[12][28] = 0;
        this.m_gameState[12][29] = 0;
        this.m_gameState[12][30] = 0;
        this.m_gameState[13][0] = 0;
        this.m_gameState[13][1] = 0;
        this.m_gameState[13][2] = 0;
        this.m_gameState[13][3] = 0;
        this.m_gameState[13][4] = 0;
        this.m_gameState[13][5] = 0;
        this.m_gameState[13][6] = 0;
        this.m_gameState[13][7] = 0;
        this.m_gameState[13][8] = 0;
        this.m_gameState[13][9] = 0;
        this.m_gameState[13][10] = 0;
        this.m_gameState[13][11] = 0;
        this.m_gameState[13][12] = 0;
        this.m_gameState[13][13] = 0;
        this.m_gameState[13][14] = 0;
        this.m_gameState[13][15] = 0;
        this.m_gameState[13][16] = 0;
        this.m_gameState[13][17] = 4;
        this.m_gameState[13][18] = 32778;
        this.m_gameState[13][19] = 5;
        this.m_gameState[13][20] = 32778;
        this.m_gameState[13][21] = 1;
        this.m_gameState[13][22] = 0;
        this.m_gameState[13][23] = 0;
        this.m_gameState[13][24] = 0;
        this.m_gameState[13][25] = 0;
        this.m_gameState[13][26] = 0;
        this.m_gameState[13][27] = 0;
        this.m_gameState[13][28] = 0;
        this.m_gameState[13][29] = 0;
        this.m_gameState[13][30] = 0;
        this.m_gameState[14][0] = 0;
        this.m_gameState[14][1] = 0;
        this.m_gameState[14][2] = 0;
        this.m_gameState[14][3] = 0;
        this.m_gameState[14][4] = 0;
        this.m_gameState[14][5] = 0;
        this.m_gameState[14][6] = 0;
        this.m_gameState[14][7] = 0;
        this.m_gameState[14][8] = 0;
        this.m_gameState[14][9] = 0;
        this.m_gameState[14][10] = 0;
        this.m_gameState[14][11] = 0;
        this.m_gameState[14][12] = 0;
        this.m_gameState[14][13] = 0;
        this.m_gameState[14][14] = 0;
        this.m_gameState[14][15] = 0;
        this.m_gameState[14][16] = 0;
        this.m_gameState[14][17] = 4;
        this.m_gameState[14][18] = 32778;
        this.m_gameState[14][19] = 5;
        this.m_gameState[14][20] = 32778;
        this.m_gameState[14][21] = 1;
        this.m_gameState[14][22] = 0;
        this.m_gameState[14][23] = 0;
        this.m_gameState[14][24] = 0;
        this.m_gameState[14][25] = 0;
        this.m_gameState[14][26] = 0;
        this.m_gameState[14][27] = 0;
        this.m_gameState[14][28] = 0;
        this.m_gameState[14][29] = 0;
        this.m_gameState[14][30] = 0;
        this.m_gameState[15][0] = 0;
        this.m_gameState[15][1] = 0;
        this.m_gameState[15][2] = 0;
        this.m_gameState[15][3] = 0;
        this.m_gameState[15][4] = 0;
        this.m_gameState[15][5] = 0;
        this.m_gameState[15][6] = 0;
        this.m_gameState[15][7] = 0;
        this.m_gameState[15][8] = 0;
        this.m_gameState[15][9] = 0;
        this.m_gameState[15][10] = 0;
        this.m_gameState[15][11] = 0;
        this.m_gameState[15][12] = 0;
        this.m_gameState[15][13] = 0;
        this.m_gameState[15][14] = 0;
        this.m_gameState[15][15] = 0;
        this.m_gameState[15][16] = 0;
        this.m_gameState[15][17] = 4;
        this.m_gameState[15][18] = 32778;
        this.m_gameState[15][19] = 5;
        this.m_gameState[15][20] = 32778;
        this.m_gameState[15][21] = 1;
        this.m_gameState[15][22] = 0;
        this.m_gameState[15][23] = 0;
        this.m_gameState[15][24] = 0;
        this.m_gameState[15][25] = 0;
        this.m_gameState[15][26] = 0;
        this.m_gameState[15][27] = 0;
        this.m_gameState[15][28] = 0;
        this.m_gameState[15][29] = 0;
        this.m_gameState[15][30] = 0;
        this.m_gameState[16][0] = 0;
        this.m_gameState[16][1] = 0;
        this.m_gameState[16][2] = 0;
        this.m_gameState[16][3] = 0;
        this.m_gameState[16][4] = 0;
        this.m_gameState[16][5] = 0;
        this.m_gameState[16][6] = 0;
        this.m_gameState[16][7] = 0;
        this.m_gameState[16][8] = 0;
        this.m_gameState[16][9] = 0;
        this.m_gameState[16][10] = 0;
        this.m_gameState[16][11] = 0;
        this.m_gameState[16][12] = 0;
        this.m_gameState[16][13] = 0;
        this.m_gameState[16][14] = 0;
        this.m_gameState[16][15] = 0;
        this.m_gameState[16][16] = 0;
        this.m_gameState[16][17] = 4;
        this.m_gameState[16][18] = 32778;
        this.m_gameState[16][19] = 5;
        this.m_gameState[16][20] = 32778;
        this.m_gameState[16][21] = 1;
        this.m_gameState[16][22] = 0;
        this.m_gameState[16][23] = 0;
        this.m_gameState[16][24] = 0;
        this.m_gameState[16][25] = 0;
        this.m_gameState[16][26] = 0;
        this.m_gameState[16][27] = 0;
        this.m_gameState[16][28] = 0;
        this.m_gameState[16][29] = 0;
        this.m_gameState[16][30] = 0;
        this.m_gameState[17][0] = 0;
        this.m_gameState[17][1] = 0;
        this.m_gameState[17][2] = 0;
        this.m_gameState[17][3] = 0;
        this.m_gameState[17][4] = 0;
        this.m_gameState[17][5] = 0;
        this.m_gameState[17][6] = 0;
        this.m_gameState[17][7] = 0;
        this.m_gameState[17][8] = 0;
        this.m_gameState[17][9] = 2;
        this.m_gameState[17][10] = 2;
        this.m_gameState[17][11] = 2;
        this.m_gameState[17][12] = 2;
        this.m_gameState[17][13] = 2;
        this.m_gameState[17][14] = 2;
        this.m_gameState[17][15] = 2;
        this.m_gameState[17][16] = 2;
        this.m_gameState[17][17] = 6;
        this.m_gameState[17][18] = 32778;
        this.m_gameState[17][19] = 5;
        this.m_gameState[17][20] = 32778;
        this.m_gameState[17][21] = 1;
        this.m_gameState[17][22] = 0;
        this.m_gameState[17][23] = 0;
        this.m_gameState[17][24] = 0;
        this.m_gameState[17][25] = 0;
        this.m_gameState[17][26] = 0;
        this.m_gameState[17][27] = 0;
        this.m_gameState[17][28] = 0;
        this.m_gameState[17][29] = 0;
        this.m_gameState[17][30] = 0;
        this.m_gameState[18][0] = 0;
        this.m_gameState[18][1] = 0;
        this.m_gameState[18][2] = 0;
        this.m_gameState[18][3] = 0;
        this.m_gameState[18][4] = 0;
        this.m_gameState[18][5] = 0;
        this.m_gameState[18][6] = 0;
        this.m_gameState[18][7] = 0;
        this.m_gameState[18][8] = 4;
        this.m_gameState[18][9] = 262;
        this.m_gameState[18][10] = 65541;
        this.m_gameState[18][11] = 775;
        this.m_gameState[18][12] = 65541;
        this.m_gameState[18][13] = 66311;
        this.m_gameState[18][14] = 65541;
        this.m_gameState[18][15] = 775;
        this.m_gameState[18][16] = 65541;
        this.m_gameState[18][17] = 519;
        this.m_gameState[18][18] = 32779;
        this.m_gameState[18][19] = 5;
        this.m_gameState[18][20] = 32778;
        this.m_gameState[18][21] = 1;
        this.m_gameState[18][22] = 0;
        this.m_gameState[18][23] = 0;
        this.m_gameState[18][24] = 0;
        this.m_gameState[18][25] = 0;
        this.m_gameState[18][26] = 0;
        this.m_gameState[18][27] = 0;
        this.m_gameState[18][28] = 0;
        this.m_gameState[18][29] = 0;
        this.m_gameState[18][30] = 0;
        this.m_gameState[19][0] = 0;
        this.m_gameState[19][1] = 0;
        this.m_gameState[19][2] = 0;
        this.m_gameState[19][3] = 0;
        this.m_gameState[19][4] = 0;
        this.m_gameState[19][5] = 0;
        this.m_gameState[19][6] = 0;
        this.m_gameState[19][7] = 0;
        this.m_gameState[19][8] = 4;
        this.m_gameState[19][9] = 32778;
        this.m_gameState[19][10] = 13;
        this.m_gameState[19][11] = 32778;
        this.m_gameState[19][12] = 13;
        this.m_gameState[19][13] = 32778;
        this.m_gameState[19][14] = 13;
        this.m_gameState[19][15] = 32778;
        this.m_gameState[19][16] = 13;
        this.m_gameState[19][17] = 32782;
        this.m_gameState[19][18] = 32779;
        this.m_gameState[19][19] = 5;
        this.m_gameState[19][20] = 32778;
        this.m_gameState[19][21] = 1;
        this.m_gameState[19][22] = 0;
        this.m_gameState[19][23] = 0;
        this.m_gameState[19][24] = 0;
        this.m_gameState[19][25] = 0;
        this.m_gameState[19][26] = 0;
        this.m_gameState[19][27] = 0;
        this.m_gameState[19][28] = 0;
        this.m_gameState[19][29] = 0;
        this.m_gameState[19][30] = 0;
        this.m_gameState[20][0] = 0;
        this.m_gameState[20][1] = 0;
        this.m_gameState[20][2] = 0;
        this.m_gameState[20][3] = 0;
        this.m_gameState[20][4] = 0;
        this.m_gameState[20][5] = 0;
        this.m_gameState[20][6] = 0;
        this.m_gameState[20][7] = 0;
        this.m_gameState[20][8] = 4;
        this.m_gameState[20][9] = 32778;
        this.m_gameState[20][10] = 5;
        this.m_gameState[20][11] = 32778;
        this.m_gameState[20][12] = 5;
        this.m_gameState[20][13] = 32778;
        this.m_gameState[20][14] = 5;
        this.m_gameState[20][15] = 32778;
        this.m_gameState[20][16] = 5;
        this.m_gameState[20][17] = 32782;
        this.m_gameState[20][18] = 32779;
        this.m_gameState[20][19] = 5;
        this.m_gameState[20][20] = 32778;
        this.m_gameState[20][21] = 1;
        this.m_gameState[20][22] = 0;
        this.m_gameState[20][23] = 0;
        this.m_gameState[20][24] = 0;
        this.m_gameState[20][25] = 0;
        this.m_gameState[20][26] = 0;
        this.m_gameState[20][27] = 0;
        this.m_gameState[20][28] = 0;
        this.m_gameState[20][29] = 0;
        this.m_gameState[20][30] = 0;
        this.m_gameState[21][0] = 0;
        this.m_gameState[21][1] = 0;
        this.m_gameState[21][2] = 0;
        this.m_gameState[21][3] = 0;
        this.m_gameState[21][4] = 0;
        this.m_gameState[21][5] = 0;
        this.m_gameState[21][6] = 0;
        this.m_gameState[21][7] = 0;
        this.m_gameState[21][8] = 4;
        this.m_gameState[21][9] = 32778;
        this.m_gameState[21][10] = 5;
        this.m_gameState[21][11] = 32778;
        this.m_gameState[21][12] = 5;
        this.m_gameState[21][13] = 32778;
        this.m_gameState[21][14] = 5;
        this.m_gameState[21][15] = 32778;
        this.m_gameState[21][16] = 5;
        this.m_gameState[21][17] = 32782;
        this.m_gameState[21][18] = 32779;
        this.m_gameState[21][19] = 5;
        this.m_gameState[21][20] = 32778;
        this.m_gameState[21][21] = 1;
        this.m_gameState[21][22] = 0;
        this.m_gameState[21][23] = 0;
        this.m_gameState[21][24] = 0;
        this.m_gameState[21][25] = 0;
        this.m_gameState[21][26] = 0;
        this.m_gameState[21][27] = 0;
        this.m_gameState[21][28] = 0;
        this.m_gameState[21][29] = 0;
        this.m_gameState[21][30] = 0;
        this.m_gameState[22][0] = 0;
        this.m_gameState[22][1] = 0;
        this.m_gameState[22][2] = 0;
        this.m_gameState[22][3] = 0;
        this.m_gameState[22][4] = 0;
        this.m_gameState[22][5] = 0;
        this.m_gameState[22][6] = 0;
        this.m_gameState[22][7] = 0;
        this.m_gameState[22][8] = 4;
        this.m_gameState[22][9] = 32778;
        this.m_gameState[22][10] = 5;
        this.m_gameState[22][11] = 32778;
        this.m_gameState[22][12] = 5;
        this.m_gameState[22][13] = 32778;
        this.m_gameState[22][14] = 5;
        this.m_gameState[22][15] = 32778;
        this.m_gameState[22][16] = 5;
        this.m_gameState[22][17] = 32782;
        this.m_gameState[22][18] = 32779;
        this.m_gameState[22][19] = 5;
        this.m_gameState[22][20] = 32778;
        this.m_gameState[22][21] = 1;
        this.m_gameState[22][22] = 0;
        this.m_gameState[22][23] = 0;
        this.m_gameState[22][24] = 0;
        this.m_gameState[22][25] = 0;
        this.m_gameState[22][26] = 0;
        this.m_gameState[22][27] = 0;
        this.m_gameState[22][28] = 0;
        this.m_gameState[22][29] = 0;
        this.m_gameState[22][30] = 0;
        this.m_gameState[23][0] = 0;
        this.m_gameState[23][1] = 0;
        this.m_gameState[23][2] = 0;
        this.m_gameState[23][3] = 0;
        this.m_gameState[23][4] = 0;
        this.m_gameState[23][5] = 0;
        this.m_gameState[23][6] = 0;
        this.m_gameState[23][7] = 0;
        this.m_gameState[23][8] = 4;
        this.m_gameState[23][9] = 32778;
        this.m_gameState[23][10] = 5;
        this.m_gameState[23][11] = 32778;
        this.m_gameState[23][12] = 5;
        this.m_gameState[23][13] = 32778;
        this.m_gameState[23][14] = 5;
        this.m_gameState[23][15] = 32778;
        this.m_gameState[23][16] = 5;
        this.m_gameState[23][17] = 32782;
        this.m_gameState[23][18] = 32779;
        this.m_gameState[23][19] = 5;
        this.m_gameState[23][20] = 32778;
        this.m_gameState[23][21] = 1;
        this.m_gameState[23][22] = 0;
        this.m_gameState[23][23] = 0;
        this.m_gameState[23][24] = 0;
        this.m_gameState[23][25] = 0;
        this.m_gameState[23][26] = 0;
        this.m_gameState[23][27] = 0;
        this.m_gameState[23][28] = 0;
        this.m_gameState[23][29] = 0;
        this.m_gameState[23][30] = 0;
        this.m_gameState[24][0] = 0;
        this.m_gameState[24][1] = 0;
        this.m_gameState[24][2] = 0;
        this.m_gameState[24][3] = 0;
        this.m_gameState[24][4] = 0;
        this.m_gameState[24][5] = 0;
        this.m_gameState[24][6] = 0;
        this.m_gameState[24][7] = 0;
        this.m_gameState[24][8] = 4;
        this.m_gameState[24][9] = 32778;
        this.m_gameState[24][10] = 5;
        this.m_gameState[24][11] = 32778;
        this.m_gameState[24][12] = 5;
        this.m_gameState[24][13] = 32778;
        this.m_gameState[24][14] = 5;
        this.m_gameState[24][15] = 32778;
        this.m_gameState[24][16] = 5;
        this.m_gameState[24][17] = 32782;
        this.m_gameState[24][18] = 32779;
        this.m_gameState[24][19] = 5;
        this.m_gameState[24][20] = 32778;
        this.m_gameState[24][21] = 1;
        this.m_gameState[24][22] = 0;
        this.m_gameState[24][23] = 0;
        this.m_gameState[24][24] = 0;
        this.m_gameState[24][25] = 0;
        this.m_gameState[24][26] = 0;
        this.m_gameState[24][27] = 0;
        this.m_gameState[24][28] = 0;
        this.m_gameState[24][29] = 0;
        this.m_gameState[24][30] = 0;
        this.m_gameState[25][0] = 0;
        this.m_gameState[25][1] = 0;
        this.m_gameState[25][2] = 0;
        this.m_gameState[25][3] = 0;
        this.m_gameState[25][4] = 0;
        this.m_gameState[25][5] = 0;
        this.m_gameState[25][6] = 0;
        this.m_gameState[25][7] = 0;
        this.m_gameState[25][8] = 4;
        this.m_gameState[25][9] = 32778;
        this.m_gameState[25][10] = 5;
        this.m_gameState[25][11] = 32778;
        this.m_gameState[25][12] = 5;
        this.m_gameState[25][13] = 32778;
        this.m_gameState[25][14] = 5;
        this.m_gameState[25][15] = 32778;
        this.m_gameState[25][16] = 5;
        this.m_gameState[25][17] = 32782;
        this.m_gameState[25][18] = 32779;
        this.m_gameState[25][19] = 5;
        this.m_gameState[25][20] = 32778;
        this.m_gameState[25][21] = 1;
        this.m_gameState[25][22] = 0;
        this.m_gameState[25][23] = 0;
        this.m_gameState[25][24] = 0;
        this.m_gameState[25][25] = 0;
        this.m_gameState[25][26] = 0;
        this.m_gameState[25][27] = 0;
        this.m_gameState[25][28] = 0;
        this.m_gameState[25][29] = 0;
        this.m_gameState[25][30] = 0;
        this.m_gameState[26][0] = 0;
        this.m_gameState[26][1] = 0;
        this.m_gameState[26][2] = 0;
        this.m_gameState[26][3] = 0;
        this.m_gameState[26][4] = 0;
        this.m_gameState[26][5] = 0;
        this.m_gameState[26][6] = 0;
        this.m_gameState[26][7] = 0;
        this.m_gameState[26][8] = 4;
        this.m_gameState[26][9] = 32778;
        this.m_gameState[26][10] = 7;
        this.m_gameState[26][11] = 32778;
        this.m_gameState[26][12] = 7;
        this.m_gameState[26][13] = 32778;
        this.m_gameState[26][14] = 7;
        this.m_gameState[26][15] = 32778;
        this.m_gameState[26][16] = 7;
        this.m_gameState[26][17] = 32782;
        this.m_gameState[26][18] = 32779;
        this.m_gameState[26][19] = 5;
        this.m_gameState[26][20] = 32778;
        this.m_gameState[26][21] = 1;
        this.m_gameState[26][22] = 0;
        this.m_gameState[26][23] = 0;
        this.m_gameState[26][24] = 0;
        this.m_gameState[26][25] = 0;
        this.m_gameState[26][26] = 0;
        this.m_gameState[26][27] = 0;
        this.m_gameState[26][28] = 0;
        this.m_gameState[26][29] = 0;
        this.m_gameState[26][30] = 0;
        this.m_gameState[27][0] = 0;
        this.m_gameState[27][1] = 0;
        this.m_gameState[27][2] = 0;
        this.m_gameState[27][3] = 0;
        this.m_gameState[27][4] = 0;
        this.m_gameState[27][5] = 0;
        this.m_gameState[27][6] = 0;
        this.m_gameState[27][7] = 0;
        this.m_gameState[27][8] = 4;
        this.m_gameState[27][9] = 140;
        this.m_gameState[27][10] = 65541;
        this.m_gameState[27][11] = 205;
        this.m_gameState[27][12] = 65541;
        this.m_gameState[27][13] = 205;
        this.m_gameState[27][14] = 65541;
        this.m_gameState[27][15] = 205;
        this.m_gameState[27][16] = 65541;
        this.m_gameState[27][17] = 77;
        this.m_gameState[27][18] = 32777;
        this.m_gameState[27][19] = 5;
        this.m_gameState[27][20] = 32776;
        this.m_gameState[27][21] = 1;
        this.m_gameState[27][22] = 0;
        this.m_gameState[27][23] = 0;
        this.m_gameState[27][24] = 0;
        this.m_gameState[27][25] = 0;
        this.m_gameState[27][26] = 0;
        this.m_gameState[27][27] = 0;
        this.m_gameState[27][28] = 0;
        this.m_gameState[27][29] = 0;
        this.m_gameState[27][30] = 0;
    }

    void loadMsPacManMaze1() {
        this.m_gameState[0][0] = 5382;
        this.m_gameState[0][1] = 69637;
        this.m_gameState[0][2] = 69637;
        this.m_gameState[0][3] = 69637;
        this.m_gameState[0][4] = 69637;
        this.m_gameState[0][5] = 12803;
        this.m_gameState[0][6] = 1;
        this.m_gameState[0][7] = 4;
        this.m_gameState[0][8] = 33794;
        this.m_gameState[0][9] = 5;
        this.m_gameState[0][10] = 40962;
        this.m_gameState[0][11] = 1;
        this.m_gameState[0][12] = 0;
        this.m_gameState[0][13] = 0;
        this.m_gameState[0][14] = 0;
        this.m_gameState[0][15] = 4;
        this.m_gameState[0][16] = 33794;
        this.m_gameState[0][17] = 5;
        this.m_gameState[0][18] = 40962;
        this.m_gameState[0][19] = 1;
        this.m_gameState[0][20] = 0;
        this.m_gameState[0][21] = 4;
        this.m_gameState[0][22] = 5382;
        this.m_gameState[0][23] = 69637;
        this.m_gameState[0][24] = 69637;
        this.m_gameState[0][25] = 69637;
        this.m_gameState[0][26] = 69637;
        this.m_gameState[0][27] = 69637;
        this.m_gameState[0][28] = 69637;
        this.m_gameState[0][29] = 69637;
        this.m_gameState[0][30] = 12803;
        this.m_gameState[1][0] = 33802;
        this.m_gameState[1][1] = 25;
        this.m_gameState[1][2] = 42;
        this.m_gameState[1][3] = 26;
        this.m_gameState[1][4] = 28;
        this.m_gameState[1][5] = 40970;
        this.m_gameState[1][6] = 3;
        this.m_gameState[1][7] = 6;
        this.m_gameState[1][8] = 33802;
        this.m_gameState[1][9] = 5;
        this.m_gameState[1][10] = 40970;
        this.m_gameState[1][11] = 3;
        this.m_gameState[1][12] = 2;
        this.m_gameState[1][13] = 2;
        this.m_gameState[1][14] = 2;
        this.m_gameState[1][15] = 6;
        this.m_gameState[1][16] = 33802;
        this.m_gameState[1][17] = 5;
        this.m_gameState[1][18] = 40970;
        this.m_gameState[1][19] = 3;
        this.m_gameState[1][20] = 2;
        this.m_gameState[1][21] = 6;
        this.m_gameState[1][22] = 33802;
        this.m_gameState[1][23] = 25;
        this.m_gameState[1][24] = 26;
        this.m_gameState[1][25] = 26;
        this.m_gameState[1][26] = 26;
        this.m_gameState[1][27] = 42;
        this.m_gameState[1][28] = 26;
        this.m_gameState[1][29] = 28;
        this.m_gameState[1][30] = 40970;
        this.m_gameState[2][0] = 33802;
        this.m_gameState[2][1] = 21;
        this.m_gameState[2][2] = 262;
        this.m_gameState[2][3] = 515;
        this.m_gameState[2][4] = 21;
        this.m_gameState[2][5] = 140;
        this.m_gameState[2][6] = 69637;
        this.m_gameState[2][7] = 69637;
        this.m_gameState[2][8] = 73;
        this.m_gameState[2][9] = 5;
        this.m_gameState[2][10] = 140;
        this.m_gameState[2][11] = 69637;
        this.m_gameState[2][12] = 69637;
        this.m_gameState[2][13] = 69637;
        this.m_gameState[2][14] = 69637;
        this.m_gameState[2][15] = 69637;
        this.m_gameState[2][16] = 73;
        this.m_gameState[2][17] = 5;
        this.m_gameState[2][18] = 140;
        this.m_gameState[2][19] = 69637;
        this.m_gameState[2][20] = 69637;
        this.m_gameState[2][21] = 69637;
        this.m_gameState[2][22] = 73;
        this.m_gameState[2][23] = 21;
        this.m_gameState[2][24] = 262;
        this.m_gameState[2][25] = 65541;
        this.m_gameState[2][26] = 65541;
        this.m_gameState[2][27] = 65541;
        this.m_gameState[2][28] = 515;
        this.m_gameState[2][29] = 21;
        this.m_gameState[2][30] = 40970;
        this.m_gameState[3][0] = 33802;
        this.m_gameState[3][1] = 21;
        this.m_gameState[3][2] = 32782;
        this.m_gameState[3][3] = 32779;
        this.m_gameState[3][4] = 17;
        this.m_gameState[3][5] = 26;
        this.m_gameState[3][6] = 26;
        this.m_gameState[3][7] = 26;
        this.m_gameState[3][8] = 26;
        this.m_gameState[3][9] = 18;
        this.m_gameState[3][10] = 26;
        this.m_gameState[3][11] = 24;
        this.m_gameState[3][12] = 26;
        this.m_gameState[3][13] = 26;
        this.m_gameState[3][14] = 26;
        this.m_gameState[3][15] = 26;
        this.m_gameState[3][16] = 26;
        this.m_gameState[3][17] = 16;
        this.m_gameState[3][18] = 26;
        this.m_gameState[3][19] = 26;
        this.m_gameState[3][20] = 24;
        this.m_gameState[3][21] = 26;
        this.m_gameState[3][22] = 26;
        this.m_gameState[3][23] = 20;
        this.m_gameState[3][24] = 32778;
        this.m_gameState[3][25] = 9;
        this.m_gameState[3][26] = 8;
        this.m_gameState[3][27] = 12;
        this.m_gameState[3][28] = 32778;
        this.m_gameState[3][29] = 21;
        this.m_gameState[3][30] = 40970;
        this.m_gameState[4][0] = 33802;
        this.m_gameState[4][1] = 21;
        this.m_gameState[4][2] = 32782;
        this.m_gameState[4][3] = 32779;
        this.m_gameState[4][4] = 21;
        this.m_gameState[4][5] = 262;
        this.m_gameState[4][6] = 65543;
        this.m_gameState[4][7] = 65543;
        this.m_gameState[4][8] = 65543;
        this.m_gameState[4][9] = 65543;
        this.m_gameState[4][10] = 515;
        this.m_gameState[4][11] = 5;
        this.m_gameState[4][12] = 262;
        this.m_gameState[4][13] = 65543;
        this.m_gameState[4][14] = 65543;
        this.m_gameState[4][15] = 65543;
        this.m_gameState[4][16] = 515;
        this.m_gameState[4][17] = 5;
        this.m_gameState[4][18] = 262;
        this.m_gameState[4][19] = 515;
        this.m_gameState[4][20] = 21;
        this.m_gameState[4][21] = 262;
        this.m_gameState[4][22] = 515;
        this.m_gameState[4][23] = 21;
        this.m_gameState[4][24] = 32778;
        this.m_gameState[4][25] = 3;
        this.m_gameState[4][26] = 2;
        this.m_gameState[4][27] = 6;
        this.m_gameState[4][28] = 32778;
        this.m_gameState[4][29] = 21;
        this.m_gameState[4][30] = 40970;
        this.m_gameState[5][0] = 33802;
        this.m_gameState[5][1] = 21;
        this.m_gameState[5][2] = 140;
        this.m_gameState[5][3] = 73;
        this.m_gameState[5][4] = 21;
        this.m_gameState[5][5] = 140;
        this.m_gameState[5][6] = 65549;
        this.m_gameState[5][7] = 65549;
        this.m_gameState[5][8] = 65549;
        this.m_gameState[5][9] = 527;
        this.m_gameState[5][10] = 32779;
        this.m_gameState[5][11] = 5;
        this.m_gameState[5][12] = 32782;
        this.m_gameState[5][13] = 271;
        this.m_gameState[5][14] = 65549;
        this.m_gameState[5][15] = 65549;
        this.m_gameState[5][16] = 73;
        this.m_gameState[5][17] = 5;
        this.m_gameState[5][18] = 32782;
        this.m_gameState[5][19] = 32779;
        this.m_gameState[5][20] = 21;
        this.m_gameState[5][21] = 32782;
        this.m_gameState[5][22] = 32779;
        this.m_gameState[5][23] = 21;
        this.m_gameState[5][24] = 140;
        this.m_gameState[5][25] = 65541;
        this.m_gameState[5][26] = 65541;
        this.m_gameState[5][27] = 65541;
        this.m_gameState[5][28] = 73;
        this.m_gameState[5][29] = 21;
        this.m_gameState[5][30] = 40970;
        this.m_gameState[6][0] = 33802;
        this.m_gameState[6][1] = 19;
        this.m_gameState[6][2] = 26;
        this.m_gameState[6][3] = 26;
        this.m_gameState[6][4] = 16;
        this.m_gameState[6][5] = 26;
        this.m_gameState[6][6] = 26;
        this.m_gameState[6][7] = 26;
        this.m_gameState[6][8] = 28;
        this.m_gameState[6][9] = 32782;
        this.m_gameState[6][10] = 32779;
        this.m_gameState[6][11] = 5;
        this.m_gameState[6][12] = 32782;
        this.m_gameState[6][13] = 32779;
        this.m_gameState[6][14] = 9;
        this.m_gameState[6][15] = 10;
        this.m_gameState[6][16] = 10;
        this.m_gameState[6][17] = 6;
        this.m_gameState[6][18] = 32782;
        this.m_gameState[6][19] = 32779;
        this.m_gameState[6][20] = 21;
        this.m_gameState[6][21] = 32782;
        this.m_gameState[6][22] = 32779;
        this.m_gameState[6][23] = 17;
        this.m_gameState[6][24] = 26;
        this.m_gameState[6][25] = 26;
        this.m_gameState[6][26] = 26;
        this.m_gameState[6][27] = 26;
        this.m_gameState[6][28] = 26;
        this.m_gameState[6][29] = 20;
        this.m_gameState[6][30] = 40970;
        this.m_gameState[7][0] = 1166;
        this.m_gameState[7][1] = 65543;
        this.m_gameState[7][2] = 65543;
        this.m_gameState[7][3] = 515;
        this.m_gameState[7][4] = 21;
        this.m_gameState[7][5] = 262;
        this.m_gameState[7][6] = 65541;
        this.m_gameState[7][7] = 515;
        this.m_gameState[7][8] = 21;
        this.m_gameState[7][9] = 32782;
        this.m_gameState[7][10] = 32779;
        this.m_gameState[7][11] = 5;
        this.m_gameState[7][12] = 32782;
        this.m_gameState[7][13] = 32779;
        this.m_gameState[7][14] = 5;
        this.m_gameState[7][15] = 262;
        this.m_gameState[7][16] = 65543;
        this.m_gameState[7][17] = 65543;
        this.m_gameState[7][18] = 79;
        this.m_gameState[7][19] = 32779;
        this.m_gameState[7][20] = 21;
        this.m_gameState[7][21] = 32782;
        this.m_gameState[7][22] = 32779;
        this.m_gameState[7][23] = 21;
        this.m_gameState[7][24] = 262;
        this.m_gameState[7][25] = 65543;
        this.m_gameState[7][26] = 65543;
        this.m_gameState[7][27] = 65543;
        this.m_gameState[7][28] = 515;
        this.m_gameState[7][29] = 21;
        this.m_gameState[7][30] = 40970;
        this.m_gameState[8][0] = 1294;
        this.m_gameState[8][1] = 65549;
        this.m_gameState[8][2] = 65549;
        this.m_gameState[8][3] = 73;
        this.m_gameState[8][4] = 21;
        this.m_gameState[8][5] = 32778;
        this.m_gameState[8][6] = 13;
        this.m_gameState[8][7] = 32778;
        this.m_gameState[8][8] = 21;
        this.m_gameState[8][9] = 140;
        this.m_gameState[8][10] = 73;
        this.m_gameState[8][11] = 5;
        this.m_gameState[8][12] = 140;
        this.m_gameState[8][13] = 73;
        this.m_gameState[8][14] = 5;
        this.m_gameState[8][15] = 140;
        this.m_gameState[8][16] = 65549;
        this.m_gameState[8][17] = 65549;
        this.m_gameState[8][18] = 527;
        this.m_gameState[8][19] = 32779;
        this.m_gameState[8][20] = 21;
        this.m_gameState[8][21] = 140;
        this.m_gameState[8][22] = 73;
        this.m_gameState[8][23] = 21;
        this.m_gameState[8][24] = 32782;
        this.m_gameState[8][25] = 271;
        this.m_gameState[8][26] = 65549;
        this.m_gameState[8][27] = 65549;
        this.m_gameState[8][28] = 73;
        this.m_gameState[8][29] = 21;
        this.m_gameState[8][30] = 40970;
        this.m_gameState[9][0] = 33802;
        this.m_gameState[9][1] = 25;
        this.m_gameState[9][2] = 26;
        this.m_gameState[9][3] = 26;
        this.m_gameState[9][4] = 20;
        this.m_gameState[9][5] = 32778;
        this.m_gameState[9][6] = 5;
        this.m_gameState[9][7] = 32778;
        this.m_gameState[9][8] = 17;
        this.m_gameState[9][9] = 10;
        this.m_gameState[9][10] = 10;
        this.m_gameState[9][11] = 0;
        this.m_gameState[9][12] = 10;
        this.m_gameState[9][13] = 10;
        this.m_gameState[9][14] = 2;
        this.m_gameState[9][15] = 10;
        this.m_gameState[9][16] = 10;
        this.m_gameState[9][17] = 12;
        this.m_gameState[9][18] = 32782;
        this.m_gameState[9][19] = 32779;
        this.m_gameState[9][20] = 17;
        this.m_gameState[9][21] = 26;
        this.m_gameState[9][22] = 26;
        this.m_gameState[9][23] = 20;
        this.m_gameState[9][24] = 32782;
        this.m_gameState[9][25] = 32779;
        this.m_gameState[9][26] = 25;
        this.m_gameState[9][27] = 26;
        this.m_gameState[9][28] = 26;
        this.m_gameState[9][29] = 20;
        this.m_gameState[9][30] = 40970;
        this.m_gameState[10][0] = 33802;
        this.m_gameState[10][1] = 21;
        this.m_gameState[10][2] = 262;
        this.m_gameState[10][3] = 515;
        this.m_gameState[10][4] = 21;
        this.m_gameState[10][5] = 32778;
        this.m_gameState[10][6] = 7;
        this.m_gameState[10][7] = 32778;
        this.m_gameState[10][8] = 21;
        this.m_gameState[10][9] = 262;
        this.m_gameState[10][10] = 515;
        this.m_gameState[10][11] = 5;
        this.m_gameState[10][12] = 262;
        this.m_gameState[10][13] = 81925;
        this.m_gameState[10][14] = 81925;
        this.m_gameState[10][15] = 81925;
        this.m_gameState[10][16] = 515;
        this.m_gameState[10][17] = 5;
        this.m_gameState[10][18] = 32782;
        this.m_gameState[10][19] = 32779;
        this.m_gameState[10][20] = 5;
        this.m_gameState[10][21] = 262;
        this.m_gameState[10][22] = 515;
        this.m_gameState[10][23] = 21;
        this.m_gameState[10][24] = 32782;
        this.m_gameState[10][25] = 32779;
        this.m_gameState[10][26] = 21;
        this.m_gameState[10][27] = 262;
        this.m_gameState[10][28] = 515;
        this.m_gameState[10][29] = 21;
        this.m_gameState[10][30] = 40970;
        this.m_gameState[11][0] = 33802;
        this.m_gameState[11][1] = 21;
        this.m_gameState[11][2] = 32782;
        this.m_gameState[11][3] = 32779;
        this.m_gameState[11][4] = 21;
        this.m_gameState[11][5] = 140;
        this.m_gameState[11][6] = 65541;
        this.m_gameState[11][7] = 73;
        this.m_gameState[11][8] = 21;
        this.m_gameState[11][9] = 32782;
        this.m_gameState[11][10] = 32779;
        this.m_gameState[11][11] = 5;
        this.m_gameState[11][12] = 40970;
        this.m_gameState[11][13] = 9;
        this.m_gameState[11][14] = 8;
        this.m_gameState[11][15] = 12;
        this.m_gameState[11][16] = 33802;
        this.m_gameState[11][17] = 5;
        this.m_gameState[11][18] = 140;
        this.m_gameState[11][19] = 73;
        this.m_gameState[11][20] = 5;
        this.m_gameState[11][21] = 32782;
        this.m_gameState[11][22] = 32779;
        this.m_gameState[11][23] = 21;
        this.m_gameState[11][24] = 140;
        this.m_gameState[11][25] = 73;
        this.m_gameState[11][26] = 21;
        this.m_gameState[11][27] = 32782;
        this.m_gameState[11][28] = 32779;
        this.m_gameState[11][29] = 21;
        this.m_gameState[11][30] = 40970;
        this.m_gameState[12][0] = 33802;
        this.m_gameState[12][1] = 21;
        this.m_gameState[12][2] = 32782;
        this.m_gameState[12][3] = 32779;
        this.m_gameState[12][4] = 17;
        this.m_gameState[12][5] = 26;
        this.m_gameState[12][6] = 26;
        this.m_gameState[12][7] = 26;
        this.m_gameState[12][8] = 22;
        this.m_gameState[12][9] = 32782;
        this.m_gameState[12][10] = 32779;
        this.m_gameState[12][11] = 5;
        this.m_gameState[12][12] = 40970;
        this.m_gameState[12][13] = 1;
        this.m_gameState[12][14] = 0;
        this.m_gameState[12][15] = 4;
        this.m_gameState[12][16] = 33802;
        this.m_gameState[12][17] = 1;
        this.m_gameState[12][18] = 10;
        this.m_gameState[12][19] = 10;
        this.m_gameState[12][20] = 6;
        this.m_gameState[12][21] = 32782;
        this.m_gameState[12][22] = 32779;
        this.m_gameState[12][23] = 17;
        this.m_gameState[12][24] = 26;
        this.m_gameState[12][25] = 26;
        this.m_gameState[12][26] = 22;
        this.m_gameState[12][27] = 32782;
        this.m_gameState[12][28] = 32779;
        this.m_gameState[12][29] = 21;
        this.m_gameState[12][30] = 40970;
        this.m_gameState[13][0] = 33802;
        this.m_gameState[13][1] = 21;
        this.m_gameState[13][2] = 32782;
        this.m_gameState[13][3] = 32779;
        this.m_gameState[13][4] = 21;
        this.m_gameState[13][5] = 262;
        this.m_gameState[13][6] = 65543;
        this.m_gameState[13][7] = 65543;
        this.m_gameState[13][8] = 65543;
        this.m_gameState[13][9] = 79;
        this.m_gameState[13][10] = 32779;
        this.m_gameState[13][11] = 5;
        this.m_gameState[13][12] = 40970;
        this.m_gameState[13][13] = 1;
        this.m_gameState[13][14] = 0;
        this.m_gameState[13][15] = 4;
        this.m_gameState[13][16] = 33802;
        this.m_gameState[13][17] = 5;
        this.m_gameState[13][18] = 262;
        this.m_gameState[13][19] = 65543;
        this.m_gameState[13][20] = 65543;
        this.m_gameState[13][21] = 79;
        this.m_gameState[13][22] = 32779;
        this.m_gameState[13][23] = 21;
        this.m_gameState[13][24] = 262;
        this.m_gameState[13][25] = 65543;
        this.m_gameState[13][26] = 65543;
        this.m_gameState[13][27] = 79;
        this.m_gameState[13][28] = 32779;
        this.m_gameState[13][29] = 21;
        this.m_gameState[13][30] = 40970;
        this.m_gameState[14][0] = 33802;
        this.m_gameState[14][1] = 21;
        this.m_gameState[14][2] = 32782;
        this.m_gameState[14][3] = 32779;
        this.m_gameState[14][4] = 21;
        this.m_gameState[14][5] = 140;
        this.m_gameState[14][6] = 65549;
        this.m_gameState[14][7] = 65549;
        this.m_gameState[14][8] = 65549;
        this.m_gameState[14][9] = 527;
        this.m_gameState[14][10] = 32779;
        this.m_gameState[14][11] = 5;
        this.m_gameState[14][12] = 40970;
        this.m_gameState[14][13] = 1;
        this.m_gameState[14][14] = 0;
        this.m_gameState[14][15] = 4;
        this.m_gameState[14][16] = 33802;
        this.m_gameState[14][17] = 5;
        this.m_gameState[14][18] = 140;
        this.m_gameState[14][19] = 65549;
        this.m_gameState[14][20] = 65549;
        this.m_gameState[14][21] = 527;
        this.m_gameState[14][22] = 32779;
        this.m_gameState[14][23] = 21;
        this.m_gameState[14][24] = 140;
        this.m_gameState[14][25] = 65549;
        this.m_gameState[14][26] = 65549;
        this.m_gameState[14][27] = 527;
        this.m_gameState[14][28] = 32779;
        this.m_gameState[14][29] = 21;
        this.m_gameState[14][30] = 40970;
        this.m_gameState[15][0] = 33802;
        this.m_gameState[15][1] = 21;
        this.m_gameState[15][2] = 32782;
        this.m_gameState[15][3] = 32779;
        this.m_gameState[15][4] = 17;
        this.m_gameState[15][5] = 26;
        this.m_gameState[15][6] = 26;
        this.m_gameState[15][7] = 26;
        this.m_gameState[15][8] = 28;
        this.m_gameState[15][9] = 32782;
        this.m_gameState[15][10] = 32779;
        this.m_gameState[15][11] = 5;
        this.m_gameState[15][12] = 40970;
        this.m_gameState[15][13] = 1;
        this.m_gameState[15][14] = 0;
        this.m_gameState[15][15] = 4;
        this.m_gameState[15][16] = 33802;
        this.m_gameState[15][17] = 1;
        this.m_gameState[15][18] = 10;
        this.m_gameState[15][19] = 10;
        this.m_gameState[15][20] = 12;
        this.m_gameState[15][21] = 32782;
        this.m_gameState[15][22] = 32779;
        this.m_gameState[15][23] = 17;
        this.m_gameState[15][24] = 26;
        this.m_gameState[15][25] = 26;
        this.m_gameState[15][26] = 28;
        this.m_gameState[15][27] = 32782;
        this.m_gameState[15][28] = 32779;
        this.m_gameState[15][29] = 21;
        this.m_gameState[15][30] = 40970;
        this.m_gameState[16][0] = 33802;
        this.m_gameState[16][1] = 21;
        this.m_gameState[16][2] = 32782;
        this.m_gameState[16][3] = 32779;
        this.m_gameState[16][4] = 21;
        this.m_gameState[16][5] = 262;
        this.m_gameState[16][6] = 65541;
        this.m_gameState[16][7] = 515;
        this.m_gameState[16][8] = 21;
        this.m_gameState[16][9] = 32782;
        this.m_gameState[16][10] = 32779;
        this.m_gameState[16][11] = 5;
        this.m_gameState[16][12] = 40970;
        this.m_gameState[16][13] = 3;
        this.m_gameState[16][14] = 2;
        this.m_gameState[16][15] = 6;
        this.m_gameState[16][16] = 33802;
        this.m_gameState[16][17] = 5;
        this.m_gameState[16][18] = 262;
        this.m_gameState[16][19] = 515;
        this.m_gameState[16][20] = 5;
        this.m_gameState[16][21] = 32782;
        this.m_gameState[16][22] = 32779;
        this.m_gameState[16][23] = 21;
        this.m_gameState[16][24] = 262;
        this.m_gameState[16][25] = 515;
        this.m_gameState[16][26] = 21;
        this.m_gameState[16][27] = 32782;
        this.m_gameState[16][28] = 32779;
        this.m_gameState[16][29] = 21;
        this.m_gameState[16][30] = 40970;
        this.m_gameState[17][0] = 33802;
        this.m_gameState[17][1] = 21;
        this.m_gameState[17][2] = 140;
        this.m_gameState[17][3] = 73;
        this.m_gameState[17][4] = 21;
        this.m_gameState[17][5] = 32778;
        this.m_gameState[17][6] = 13;
        this.m_gameState[17][7] = 32778;
        this.m_gameState[17][8] = 21;
        this.m_gameState[17][9] = 140;
        this.m_gameState[17][10] = 73;
        this.m_gameState[17][11] = 5;
        this.m_gameState[17][12] = 140;
        this.m_gameState[17][13] = 69637;
        this.m_gameState[17][14] = 69637;
        this.m_gameState[17][15] = 69637;
        this.m_gameState[17][16] = 73;
        this.m_gameState[17][17] = 5;
        this.m_gameState[17][18] = 32782;
        this.m_gameState[17][19] = 32779;
        this.m_gameState[17][20] = 5;
        this.m_gameState[17][21] = 140;
        this.m_gameState[17][22] = 73;
        this.m_gameState[17][23] = 21;
        this.m_gameState[17][24] = 32782;
        this.m_gameState[17][25] = 32779;
        this.m_gameState[17][26] = 21;
        this.m_gameState[17][27] = 140;
        this.m_gameState[17][28] = 73;
        this.m_gameState[17][29] = 21;
        this.m_gameState[17][30] = 40970;
        this.m_gameState[18][0] = 33802;
        this.m_gameState[18][1] = 19;
        this.m_gameState[18][2] = 26;
        this.m_gameState[18][3] = 26;
        this.m_gameState[18][4] = 20;
        this.m_gameState[18][5] = 32778;
        this.m_gameState[18][6] = 5;
        this.m_gameState[18][7] = 32778;
        this.m_gameState[18][8] = 17;
        this.m_gameState[18][9] = 10;
        this.m_gameState[18][10] = 10;
        this.m_gameState[18][11] = 0;
        this.m_gameState[18][12] = 10;
        this.m_gameState[18][13] = 10;
        this.m_gameState[18][14] = 8;
        this.m_gameState[18][15] = 10;
        this.m_gameState[18][16] = 10;
        this.m_gameState[18][17] = 6;
        this.m_gameState[18][18] = 32782;
        this.m_gameState[18][19] = 32779;
        this.m_gameState[18][20] = 17;
        this.m_gameState[18][21] = 26;
        this.m_gameState[18][22] = 26;
        this.m_gameState[18][23] = 20;
        this.m_gameState[18][24] = 32782;
        this.m_gameState[18][25] = 32779;
        this.m_gameState[18][26] = 19;
        this.m_gameState[18][27] = 26;
        this.m_gameState[18][28] = 26;
        this.m_gameState[18][29] = 20;
        this.m_gameState[18][30] = 40970;
        this.m_gameState[19][0] = 1166;
        this.m_gameState[19][1] = 65543;
        this.m_gameState[19][2] = 65543;
        this.m_gameState[19][3] = 515;
        this.m_gameState[19][4] = 21;
        this.m_gameState[19][5] = 32778;
        this.m_gameState[19][6] = 7;
        this.m_gameState[19][7] = 32778;
        this.m_gameState[19][8] = 21;
        this.m_gameState[19][9] = 262;
        this.m_gameState[19][10] = 515;
        this.m_gameState[19][11] = 5;
        this.m_gameState[19][12] = 262;
        this.m_gameState[19][13] = 515;
        this.m_gameState[19][14] = 5;
        this.m_gameState[19][15] = 262;
        this.m_gameState[19][16] = 65543;
        this.m_gameState[19][17] = 65543;
        this.m_gameState[19][18] = 79;
        this.m_gameState[19][19] = 32779;
        this.m_gameState[19][20] = 21;
        this.m_gameState[19][21] = 262;
        this.m_gameState[19][22] = 515;
        this.m_gameState[19][23] = 21;
        this.m_gameState[19][24] = 32782;
        this.m_gameState[19][25] = 143;
        this.m_gameState[19][26] = 65543;
        this.m_gameState[19][27] = 65543;
        this.m_gameState[19][28] = 515;
        this.m_gameState[19][29] = 21;
        this.m_gameState[19][30] = 40970;
        this.m_gameState[20][0] = 1294;
        this.m_gameState[20][1] = 65549;
        this.m_gameState[20][2] = 65549;
        this.m_gameState[20][3] = 73;
        this.m_gameState[20][4] = 21;
        this.m_gameState[20][5] = 140;
        this.m_gameState[20][6] = 65541;
        this.m_gameState[20][7] = 73;
        this.m_gameState[20][8] = 21;
        this.m_gameState[20][9] = 32782;
        this.m_gameState[20][10] = 32779;
        this.m_gameState[20][11] = 5;
        this.m_gameState[20][12] = 32782;
        this.m_gameState[20][13] = 32779;
        this.m_gameState[20][14] = 5;
        this.m_gameState[20][15] = 140;
        this.m_gameState[20][16] = 65549;
        this.m_gameState[20][17] = 65549;
        this.m_gameState[20][18] = 527;
        this.m_gameState[20][19] = 32779;
        this.m_gameState[20][20] = 21;
        this.m_gameState[20][21] = 32782;
        this.m_gameState[20][22] = 32779;
        this.m_gameState[20][23] = 21;
        this.m_gameState[20][24] = 140;
        this.m_gameState[20][25] = 65549;
        this.m_gameState[20][26] = 65549;
        this.m_gameState[20][27] = 65549;
        this.m_gameState[20][28] = 73;
        this.m_gameState[20][29] = 21;
        this.m_gameState[20][30] = 40970;
        this.m_gameState[21][0] = 33802;
        this.m_gameState[21][1] = 25;
        this.m_gameState[21][2] = 26;
        this.m_gameState[21][3] = 26;
        this.m_gameState[21][4] = 16;
        this.m_gameState[21][5] = 26;
        this.m_gameState[21][6] = 26;
        this.m_gameState[21][7] = 26;
        this.m_gameState[21][8] = 22;
        this.m_gameState[21][9] = 32782;
        this.m_gameState[21][10] = 32779;
        this.m_gameState[21][11] = 5;
        this.m_gameState[21][12] = 32782;
        this.m_gameState[21][13] = 32779;
        this.m_gameState[21][14] = 3;
        this.m_gameState[21][15] = 10;
        this.m_gameState[21][16] = 10;
        this.m_gameState[21][17] = 12;
        this.m_gameState[21][18] = 32782;
        this.m_gameState[21][19] = 32779;
        this.m_gameState[21][20] = 21;
        this.m_gameState[21][21] = 32782;
        this.m_gameState[21][22] = 32779;
        this.m_gameState[21][23] = 17;
        this.m_gameState[21][24] = 26;
        this.m_gameState[21][25] = 26;
        this.m_gameState[21][26] = 26;
        this.m_gameState[21][27] = 26;
        this.m_gameState[21][28] = 26;
        this.m_gameState[21][29] = 20;
        this.m_gameState[21][30] = 40970;
        this.m_gameState[22][0] = 33802;
        this.m_gameState[22][1] = 21;
        this.m_gameState[22][2] = 262;
        this.m_gameState[22][3] = 515;
        this.m_gameState[22][4] = 21;
        this.m_gameState[22][5] = 262;
        this.m_gameState[22][6] = 65543;
        this.m_gameState[22][7] = 65543;
        this.m_gameState[22][8] = 65543;
        this.m_gameState[22][9] = 79;
        this.m_gameState[22][10] = 32779;
        this.m_gameState[22][11] = 5;
        this.m_gameState[22][12] = 32782;
        this.m_gameState[22][13] = 143;
        this.m_gameState[22][14] = 65543;
        this.m_gameState[22][15] = 65543;
        this.m_gameState[22][16] = 515;
        this.m_gameState[22][17] = 5;
        this.m_gameState[22][18] = 32782;
        this.m_gameState[22][19] = 32779;
        this.m_gameState[22][20] = 21;
        this.m_gameState[22][21] = 32782;
        this.m_gameState[22][22] = 32779;
        this.m_gameState[22][23] = 21;
        this.m_gameState[22][24] = 262;
        this.m_gameState[22][25] = 65541;
        this.m_gameState[22][26] = 65541;
        this.m_gameState[22][27] = 65541;
        this.m_gameState[22][28] = 515;
        this.m_gameState[22][29] = 21;
        this.m_gameState[22][30] = 40970;
        this.m_gameState[23][0] = 33802;
        this.m_gameState[23][1] = 21;
        this.m_gameState[23][2] = 32782;
        this.m_gameState[23][3] = 32779;
        this.m_gameState[23][4] = 21;
        this.m_gameState[23][5] = 140;
        this.m_gameState[23][6] = 65549;
        this.m_gameState[23][7] = 65549;
        this.m_gameState[23][8] = 65549;
        this.m_gameState[23][9] = 65549;
        this.m_gameState[23][10] = 73;
        this.m_gameState[23][11] = 5;
        this.m_gameState[23][12] = 140;
        this.m_gameState[23][13] = 65549;
        this.m_gameState[23][14] = 65549;
        this.m_gameState[23][15] = 65549;
        this.m_gameState[23][16] = 73;
        this.m_gameState[23][17] = 5;
        this.m_gameState[23][18] = 140;
        this.m_gameState[23][19] = 73;
        this.m_gameState[23][20] = 21;
        this.m_gameState[23][21] = 140;
        this.m_gameState[23][22] = 73;
        this.m_gameState[23][23] = 21;
        this.m_gameState[23][24] = 32778;
        this.m_gameState[23][25] = 9;
        this.m_gameState[23][26] = 8;
        this.m_gameState[23][27] = 12;
        this.m_gameState[23][28] = 32778;
        this.m_gameState[23][29] = 21;
        this.m_gameState[23][30] = 40970;
        this.m_gameState[24][0] = 33802;
        this.m_gameState[24][1] = 21;
        this.m_gameState[24][2] = 32782;
        this.m_gameState[24][3] = 32779;
        this.m_gameState[24][4] = 17;
        this.m_gameState[24][5] = 26;
        this.m_gameState[24][6] = 26;
        this.m_gameState[24][7] = 26;
        this.m_gameState[24][8] = 26;
        this.m_gameState[24][9] = 24;
        this.m_gameState[24][10] = 26;
        this.m_gameState[24][11] = 18;
        this.m_gameState[24][12] = 26;
        this.m_gameState[24][13] = 26;
        this.m_gameState[24][14] = 26;
        this.m_gameState[24][15] = 26;
        this.m_gameState[24][16] = 26;
        this.m_gameState[24][17] = 16;
        this.m_gameState[24][18] = 26;
        this.m_gameState[24][19] = 26;
        this.m_gameState[24][20] = 18;
        this.m_gameState[24][21] = 26;
        this.m_gameState[24][22] = 26;
        this.m_gameState[24][23] = 20;
        this.m_gameState[24][24] = 32778;
        this.m_gameState[24][25] = 3;
        this.m_gameState[24][26] = 2;
        this.m_gameState[24][27] = 6;
        this.m_gameState[24][28] = 32778;
        this.m_gameState[24][29] = 21;
        this.m_gameState[24][30] = 40970;
        this.m_gameState[25][0] = 33802;
        this.m_gameState[25][1] = 21;
        this.m_gameState[25][2] = 140;
        this.m_gameState[25][3] = 73;
        this.m_gameState[25][4] = 21;
        this.m_gameState[25][5] = 262;
        this.m_gameState[25][6] = 81925;
        this.m_gameState[25][7] = 81925;
        this.m_gameState[25][8] = 515;
        this.m_gameState[25][9] = 5;
        this.m_gameState[25][10] = 262;
        this.m_gameState[25][11] = 81925;
        this.m_gameState[25][12] = 81925;
        this.m_gameState[25][13] = 81925;
        this.m_gameState[25][14] = 81925;
        this.m_gameState[25][15] = 81925;
        this.m_gameState[25][16] = 515;
        this.m_gameState[25][17] = 5;
        this.m_gameState[25][18] = 262;
        this.m_gameState[25][19] = 81925;
        this.m_gameState[25][20] = 81925;
        this.m_gameState[25][21] = 81925;
        this.m_gameState[25][22] = 515;
        this.m_gameState[25][23] = 21;
        this.m_gameState[25][24] = 140;
        this.m_gameState[25][25] = 65541;
        this.m_gameState[25][26] = 65541;
        this.m_gameState[25][27] = 65541;
        this.m_gameState[25][28] = 73;
        this.m_gameState[25][29] = 21;
        this.m_gameState[25][30] = 40970;
        this.m_gameState[26][0] = 33802;
        this.m_gameState[26][1] = 19;
        this.m_gameState[26][2] = 42;
        this.m_gameState[26][3] = 26;
        this.m_gameState[26][4] = 22;
        this.m_gameState[26][5] = 40970;
        this.m_gameState[26][6] = 9;
        this.m_gameState[26][7] = 12;
        this.m_gameState[26][8] = 33802;
        this.m_gameState[26][9] = 5;
        this.m_gameState[26][10] = 40970;
        this.m_gameState[26][11] = 9;
        this.m_gameState[26][12] = 8;
        this.m_gameState[26][13] = 8;
        this.m_gameState[26][14] = 8;
        this.m_gameState[26][15] = 12;
        this.m_gameState[26][16] = 33802;
        this.m_gameState[26][17] = 5;
        this.m_gameState[26][18] = 40970;
        this.m_gameState[26][19] = 9;
        this.m_gameState[26][20] = 8;
        this.m_gameState[26][21] = 12;
        this.m_gameState[26][22] = 33802;
        this.m_gameState[26][23] = 19;
        this.m_gameState[26][24] = 26;
        this.m_gameState[26][25] = 26;
        this.m_gameState[26][26] = 26;
        this.m_gameState[26][27] = 42;
        this.m_gameState[26][28] = 26;
        this.m_gameState[26][29] = 22;
        this.m_gameState[26][30] = 40970;
        this.m_gameState[27][0] = 17548;
        this.m_gameState[27][1] = 81925;
        this.m_gameState[27][2] = 81925;
        this.m_gameState[27][3] = 81925;
        this.m_gameState[27][4] = 81925;
        this.m_gameState[27][5] = 24649;
        this.m_gameState[27][6] = 1;
        this.m_gameState[27][7] = 4;
        this.m_gameState[27][8] = 33800;
        this.m_gameState[27][9] = 5;
        this.m_gameState[27][10] = 40968;
        this.m_gameState[27][11] = 1;
        this.m_gameState[27][12] = 0;
        this.m_gameState[27][13] = 0;
        this.m_gameState[27][14] = 0;
        this.m_gameState[27][15] = 4;
        this.m_gameState[27][16] = 33800;
        this.m_gameState[27][17] = 5;
        this.m_gameState[27][18] = 40968;
        this.m_gameState[27][19] = 1;
        this.m_gameState[27][20] = 0;
        this.m_gameState[27][21] = 4;
        this.m_gameState[27][22] = 17548;
        this.m_gameState[27][23] = 81925;
        this.m_gameState[27][24] = 81925;
        this.m_gameState[27][25] = 81925;
        this.m_gameState[27][26] = 81925;
        this.m_gameState[27][27] = 81925;
        this.m_gameState[27][28] = 81925;
        this.m_gameState[27][29] = 81925;
        this.m_gameState[27][30] = 24649;
    }

    void loadMsPacManMaze4() {
        this.m_gameState[0][0] = 5382;
        this.m_gameState[0][1] = 69637;
        this.m_gameState[0][2] = 69637;
        this.m_gameState[0][3] = 69637;
        this.m_gameState[0][4] = 69637;
        this.m_gameState[0][5] = 69637;
        this.m_gameState[0][6] = 69637;
        this.m_gameState[0][7] = 4615;
        this.m_gameState[0][8] = 32771;
        this.m_gameState[0][9] = 5;
        this.m_gameState[0][10] = 132;
        this.m_gameState[0][11] = 69637;
        this.m_gameState[0][12] = 69637;
        this.m_gameState[0][13] = 69637;
        this.m_gameState[0][14] = 69637;
        this.m_gameState[0][15] = 69637;
        this.m_gameState[0][16] = 69637;
        this.m_gameState[0][17] = 69637;
        this.m_gameState[0][18] = 69637;
        this.m_gameState[0][19] = 69637;
        this.m_gameState[0][20] = 69637;
        this.m_gameState[0][21] = 4615;
        this.m_gameState[0][22] = 4359;
        this.m_gameState[0][23] = 69637;
        this.m_gameState[0][24] = 69637;
        this.m_gameState[0][25] = 69637;
        this.m_gameState[0][26] = 69637;
        this.m_gameState[0][27] = 69637;
        this.m_gameState[0][28] = 69637;
        this.m_gameState[0][29] = 69637;
        this.m_gameState[0][30] = 12803;
        this.m_gameState[1][0] = 33802;
        this.m_gameState[1][1] = 25;
        this.m_gameState[1][2] = 26;
        this.m_gameState[1][3] = 42;
        this.m_gameState[1][4] = 26;
        this.m_gameState[1][5] = 26;
        this.m_gameState[1][6] = 28;
        this.m_gameState[1][7] = 32782;
        this.m_gameState[1][8] = 32779;
        this.m_gameState[1][9] = 17;
        this.m_gameState[1][10] = 26;
        this.m_gameState[1][11] = 26;
        this.m_gameState[1][12] = 26;
        this.m_gameState[1][13] = 26;
        this.m_gameState[1][14] = 24;
        this.m_gameState[1][15] = 26;
        this.m_gameState[1][16] = 26;
        this.m_gameState[1][17] = 26;
        this.m_gameState[1][18] = 26;
        this.m_gameState[1][19] = 26;
        this.m_gameState[1][20] = 28;
        this.m_gameState[1][21] = 32782;
        this.m_gameState[1][22] = 32779;
        this.m_gameState[1][23] = 41;
        this.m_gameState[1][24] = 26;
        this.m_gameState[1][25] = 26;
        this.m_gameState[1][26] = 24;
        this.m_gameState[1][27] = 26;
        this.m_gameState[1][28] = 26;
        this.m_gameState[1][29] = 28;
        this.m_gameState[1][30] = 40970;
        this.m_gameState[2][0] = 33802;
        this.m_gameState[2][1] = 21;
        this.m_gameState[2][2] = 262;
        this.m_gameState[2][3] = 65543;
        this.m_gameState[2][4] = 65543;
        this.m_gameState[2][5] = 515;
        this.m_gameState[2][6] = 21;
        this.m_gameState[2][7] = 32782;
        this.m_gameState[2][8] = 32779;
        this.m_gameState[2][9] = 21;
        this.m_gameState[2][10] = 262;
        this.m_gameState[2][11] = 65543;
        this.m_gameState[2][12] = 65543;
        this.m_gameState[2][13] = 515;
        this.m_gameState[2][14] = 5;
        this.m_gameState[2][15] = 262;
        this.m_gameState[2][16] = 65543;
        this.m_gameState[2][17] = 65543;
        this.m_gameState[2][18] = 65543;
        this.m_gameState[2][19] = 515;
        this.m_gameState[2][20] = 21;
        this.m_gameState[2][21] = 140;
        this.m_gameState[2][22] = 73;
        this.m_gameState[2][23] = 21;
        this.m_gameState[2][24] = 262;
        this.m_gameState[2][25] = 515;
        this.m_gameState[2][26] = 21;
        this.m_gameState[2][27] = 262;
        this.m_gameState[2][28] = 515;
        this.m_gameState[2][29] = 21;
        this.m_gameState[2][30] = 40970;
        this.m_gameState[3][0] = 33802;
        this.m_gameState[3][1] = 21;
        this.m_gameState[3][2] = 32782;
        this.m_gameState[3][3] = 271;
        this.m_gameState[3][4] = 65549;
        this.m_gameState[3][5] = 73;
        this.m_gameState[3][6] = 21;
        this.m_gameState[3][7] = 140;
        this.m_gameState[3][8] = 73;
        this.m_gameState[3][9] = 21;
        this.m_gameState[3][10] = 140;
        this.m_gameState[3][11] = 65549;
        this.m_gameState[3][12] = 527;
        this.m_gameState[3][13] = 32779;
        this.m_gameState[3][14] = 5;
        this.m_gameState[3][15] = 140;
        this.m_gameState[3][16] = 65549;
        this.m_gameState[3][17] = 65549;
        this.m_gameState[3][18] = 527;
        this.m_gameState[3][19] = 32779;
        this.m_gameState[3][20] = 17;
        this.m_gameState[3][21] = 26;
        this.m_gameState[3][22] = 26;
        this.m_gameState[3][23] = 22;
        this.m_gameState[3][24] = 32782;
        this.m_gameState[3][25] = 32779;
        this.m_gameState[3][26] = 21;
        this.m_gameState[3][27] = 32782;
        this.m_gameState[3][28] = 32779;
        this.m_gameState[3][29] = 21;
        this.m_gameState[3][30] = 40970;
        this.m_gameState[4][0] = 33802;
        this.m_gameState[4][1] = 21;
        this.m_gameState[4][2] = 32782;
        this.m_gameState[4][3] = 32779;
        this.m_gameState[4][4] = 25;
        this.m_gameState[4][5] = 26;
        this.m_gameState[4][6] = 18;
        this.m_gameState[4][7] = 26;
        this.m_gameState[4][8] = 26;
        this.m_gameState[4][9] = 18;
        this.m_gameState[4][10] = 10;
        this.m_gameState[4][11] = 12;
        this.m_gameState[4][12] = 32782;
        this.m_gameState[4][13] = 32779;
        this.m_gameState[4][14] = 1;
        this.m_gameState[4][15] = 10;
        this.m_gameState[4][16] = 10;
        this.m_gameState[4][17] = 12;
        this.m_gameState[4][18] = 32782;
        this.m_gameState[4][19] = 32779;
        this.m_gameState[4][20] = 21;
        this.m_gameState[4][21] = 262;
        this.m_gameState[4][22] = 65543;
        this.m_gameState[4][23] = 65543;
        this.m_gameState[4][24] = 79;
        this.m_gameState[4][25] = 32779;
        this.m_gameState[4][26] = 21;
        this.m_gameState[4][27] = 32782;
        this.m_gameState[4][28] = 32779;
        this.m_gameState[4][29] = 21;
        this.m_gameState[4][30] = 40970;
        this.m_gameState[5][0] = 33802;
        this.m_gameState[5][1] = 21;
        this.m_gameState[5][2] = 32782;
        this.m_gameState[5][3] = 32779;
        this.m_gameState[5][4] = 21;
        this.m_gameState[5][5] = 262;
        this.m_gameState[5][6] = 65543;
        this.m_gameState[5][7] = 65543;
        this.m_gameState[5][8] = 65543;
        this.m_gameState[5][9] = 65543;
        this.m_gameState[5][10] = 515;
        this.m_gameState[5][11] = 5;
        this.m_gameState[5][12] = 140;
        this.m_gameState[5][13] = 73;
        this.m_gameState[5][14] = 5;
        this.m_gameState[5][15] = 262;
        this.m_gameState[5][16] = 515;
        this.m_gameState[5][17] = 5;
        this.m_gameState[5][18] = 140;
        this.m_gameState[5][19] = 73;
        this.m_gameState[5][20] = 21;
        this.m_gameState[5][21] = 140;
        this.m_gameState[5][22] = 65549;
        this.m_gameState[5][23] = 65549;
        this.m_gameState[5][24] = 65549;
        this.m_gameState[5][25] = 73;
        this.m_gameState[5][26] = 21;
        this.m_gameState[5][27] = 140;
        this.m_gameState[5][28] = 73;
        this.m_gameState[5][29] = 21;
        this.m_gameState[5][30] = 40970;
        this.m_gameState[6][0] = 33802;
        this.m_gameState[6][1] = 21;
        this.m_gameState[6][2] = 32782;
        this.m_gameState[6][3] = 32779;
        this.m_gameState[6][4] = 21;
        this.m_gameState[6][5] = 140;
        this.m_gameState[6][6] = 65549;
        this.m_gameState[6][7] = 65549;
        this.m_gameState[6][8] = 65549;
        this.m_gameState[6][9] = 527;
        this.m_gameState[6][10] = 32779;
        this.m_gameState[6][11] = 1;
        this.m_gameState[6][12] = 10;
        this.m_gameState[6][13] = 10;
        this.m_gameState[6][14] = 6;
        this.m_gameState[6][15] = 32782;
        this.m_gameState[6][16] = 32779;
        this.m_gameState[6][17] = 1;
        this.m_gameState[6][18] = 10;
        this.m_gameState[6][19] = 10;
        this.m_gameState[6][20] = 18;
        this.m_gameState[6][21] = 26;
        this.m_gameState[6][22] = 26;
        this.m_gameState[6][23] = 24;
        this.m_gameState[6][24] = 26;
        this.m_gameState[6][25] = 26;
        this.m_gameState[6][26] = 18;
        this.m_gameState[6][27] = 26;
        this.m_gameState[6][28] = 26;
        this.m_gameState[6][29] = 22;
        this.m_gameState[6][30] = 40970;
        this.m_gameState[7][0] = 33802;
        this.m_gameState[7][1] = 21;
        this.m_gameState[7][2] = 32782;
        this.m_gameState[7][3] = 32779;
        this.m_gameState[7][4] = 17;
        this.m_gameState[7][5] = 26;
        this.m_gameState[7][6] = 26;
        this.m_gameState[7][7] = 26;
        this.m_gameState[7][8] = 28;
        this.m_gameState[7][9] = 32782;
        this.m_gameState[7][10] = 32779;
        this.m_gameState[7][11] = 5;
        this.m_gameState[7][12] = 262;
        this.m_gameState[7][13] = 65543;
        this.m_gameState[7][14] = 65543;
        this.m_gameState[7][15] = 79;
        this.m_gameState[7][16] = 32779;
        this.m_gameState[7][17] = 5;
        this.m_gameState[7][18] = 262;
        this.m_gameState[7][19] = 65543;
        this.m_gameState[7][20] = 65543;
        this.m_gameState[7][21] = 65543;
        this.m_gameState[7][22] = 515;
        this.m_gameState[7][23] = 21;
        this.m_gameState[7][24] = 262;
        this.m_gameState[7][25] = 65543;
        this.m_gameState[7][26] = 65543;
        this.m_gameState[7][27] = 65543;
        this.m_gameState[7][28] = 65543;
        this.m_gameState[7][29] = 65543;
        this.m_gameState[7][30] = 8267;
        this.m_gameState[8][0] = 33802;
        this.m_gameState[8][1] = 21;
        this.m_gameState[8][2] = 140;
        this.m_gameState[8][3] = 73;
        this.m_gameState[8][4] = 21;
        this.m_gameState[8][5] = 262;
        this.m_gameState[8][6] = 65541;
        this.m_gameState[8][7] = 515;
        this.m_gameState[8][8] = 21;
        this.m_gameState[8][9] = 140;
        this.m_gameState[8][10] = 73;
        this.m_gameState[8][11] = 5;
        this.m_gameState[8][12] = 140;
        this.m_gameState[8][13] = 65549;
        this.m_gameState[8][14] = 65549;
        this.m_gameState[8][15] = 65549;
        this.m_gameState[8][16] = 73;
        this.m_gameState[8][17] = 5;
        this.m_gameState[8][18] = 32782;
        this.m_gameState[8][19] = 271;
        this.m_gameState[8][20] = 65549;
        this.m_gameState[8][21] = 65549;
        this.m_gameState[8][22] = 73;
        this.m_gameState[8][23] = 21;
        this.m_gameState[8][24] = 32782;
        this.m_gameState[8][25] = 271;
        this.m_gameState[8][26] = 65549;
        this.m_gameState[8][27] = 65549;
        this.m_gameState[8][28] = 65549;
        this.m_gameState[8][29] = 65549;
        this.m_gameState[8][30] = 8715;
        this.m_gameState[9][0] = 33802;
        this.m_gameState[9][1] = 19;
        this.m_gameState[9][2] = 26;
        this.m_gameState[9][3] = 26;
        this.m_gameState[9][4] = 20;
        this.m_gameState[9][5] = 32778;
        this.m_gameState[9][6] = 13;
        this.m_gameState[9][7] = 32778;
        this.m_gameState[9][8] = 17;
        this.m_gameState[9][9] = 10;
        this.m_gameState[9][10] = 10;
        this.m_gameState[9][11] = 0;
        this.m_gameState[9][12] = 10;
        this.m_gameState[9][13] = 10;
        this.m_gameState[9][14] = 10;
        this.m_gameState[9][15] = 10;
        this.m_gameState[9][16] = 10;
        this.m_gameState[9][17] = 4;
        this.m_gameState[9][18] = 32782;
        this.m_gameState[9][19] = 32779;
        this.m_gameState[9][20] = 25;
        this.m_gameState[9][21] = 26;
        this.m_gameState[9][22] = 26;
        this.m_gameState[9][23] = 20;
        this.m_gameState[9][24] = 32782;
        this.m_gameState[9][25] = 32779;
        this.m_gameState[9][26] = 25;
        this.m_gameState[9][27] = 26;
        this.m_gameState[9][28] = 26;
        this.m_gameState[9][29] = 28;
        this.m_gameState[9][30] = 40970;
        this.m_gameState[10][0] = 1166;
        this.m_gameState[10][1] = 65543;
        this.m_gameState[10][2] = 65543;
        this.m_gameState[10][3] = 515;
        this.m_gameState[10][4] = 21;
        this.m_gameState[10][5] = 32778;
        this.m_gameState[10][6] = 7;
        this.m_gameState[10][7] = 32778;
        this.m_gameState[10][8] = 21;
        this.m_gameState[10][9] = 262;
        this.m_gameState[10][10] = 515;
        this.m_gameState[10][11] = 5;
        this.m_gameState[10][12] = 262;
        this.m_gameState[10][13] = 81925;
        this.m_gameState[10][14] = 81925;
        this.m_gameState[10][15] = 81925;
        this.m_gameState[10][16] = 515;
        this.m_gameState[10][17] = 5;
        this.m_gameState[10][18] = 32782;
        this.m_gameState[10][19] = 32779;
        this.m_gameState[10][20] = 21;
        this.m_gameState[10][21] = 262;
        this.m_gameState[10][22] = 515;
        this.m_gameState[10][23] = 21;
        this.m_gameState[10][24] = 32782;
        this.m_gameState[10][25] = 32779;
        this.m_gameState[10][26] = 21;
        this.m_gameState[10][27] = 262;
        this.m_gameState[10][28] = 515;
        this.m_gameState[10][29] = 21;
        this.m_gameState[10][30] = 40970;
        this.m_gameState[11][0] = 1294;
        this.m_gameState[11][1] = 65549;
        this.m_gameState[11][2] = 65549;
        this.m_gameState[11][3] = 73;
        this.m_gameState[11][4] = 21;
        this.m_gameState[11][5] = 140;
        this.m_gameState[11][6] = 65541;
        this.m_gameState[11][7] = 73;
        this.m_gameState[11][8] = 21;
        this.m_gameState[11][9] = 32782;
        this.m_gameState[11][10] = 32779;
        this.m_gameState[11][11] = 5;
        this.m_gameState[11][12] = 40970;
        this.m_gameState[11][13] = 9;
        this.m_gameState[11][14] = 8;
        this.m_gameState[11][15] = 12;
        this.m_gameState[11][16] = 33802;
        this.m_gameState[11][17] = 5;
        this.m_gameState[11][18] = 140;
        this.m_gameState[11][19] = 73;
        this.m_gameState[11][20] = 21;
        this.m_gameState[11][21] = 32782;
        this.m_gameState[11][22] = 32779;
        this.m_gameState[11][23] = 21;
        this.m_gameState[11][24] = 140;
        this.m_gameState[11][25] = 73;
        this.m_gameState[11][26] = 21;
        this.m_gameState[11][27] = 32782;
        this.m_gameState[11][28] = 32779;
        this.m_gameState[11][29] = 21;
        this.m_gameState[11][30] = 40970;
        this.m_gameState[12][0] = 33802;
        this.m_gameState[12][1] = 25;
        this.m_gameState[12][2] = 26;
        this.m_gameState[12][3] = 26;
        this.m_gameState[12][4] = 18;
        this.m_gameState[12][5] = 26;
        this.m_gameState[12][6] = 26;
        this.m_gameState[12][7] = 26;
        this.m_gameState[12][8] = 20;
        this.m_gameState[12][9] = 32782;
        this.m_gameState[12][10] = 32779;
        this.m_gameState[12][11] = 5;
        this.m_gameState[12][12] = 40970;
        this.m_gameState[12][13] = 1;
        this.m_gameState[12][14] = 0;
        this.m_gameState[12][15] = 4;
        this.m_gameState[12][16] = 33802;
        this.m_gameState[12][17] = 1;
        this.m_gameState[12][18] = 10;
        this.m_gameState[12][19] = 10;
        this.m_gameState[12][20] = 22;
        this.m_gameState[12][21] = 32782;
        this.m_gameState[12][22] = 32779;
        this.m_gameState[12][23] = 17;
        this.m_gameState[12][24] = 26;
        this.m_gameState[12][25] = 26;
        this.m_gameState[12][26] = 22;
        this.m_gameState[12][27] = 32782;
        this.m_gameState[12][28] = 32779;
        this.m_gameState[12][29] = 21;
        this.m_gameState[12][30] = 40970;
        this.m_gameState[13][0] = 33802;
        this.m_gameState[13][1] = 21;
        this.m_gameState[13][2] = 262;
        this.m_gameState[13][3] = 65543;
        this.m_gameState[13][4] = 65543;
        this.m_gameState[13][5] = 65543;
        this.m_gameState[13][6] = 65543;
        this.m_gameState[13][7] = 515;
        this.m_gameState[13][8] = 21;
        this.m_gameState[13][9] = 32782;
        this.m_gameState[13][10] = 32779;
        this.m_gameState[13][11] = 5;
        this.m_gameState[13][12] = 40970;
        this.m_gameState[13][13] = 1;
        this.m_gameState[13][14] = 0;
        this.m_gameState[13][15] = 4;
        this.m_gameState[13][16] = 33802;
        this.m_gameState[13][17] = 5;
        this.m_gameState[13][18] = 262;
        this.m_gameState[13][19] = 65543;
        this.m_gameState[13][20] = 65543;
        this.m_gameState[13][21] = 79;
        this.m_gameState[13][22] = 32779;
        this.m_gameState[13][23] = 21;
        this.m_gameState[13][24] = 262;
        this.m_gameState[13][25] = 65543;
        this.m_gameState[13][26] = 65543;
        this.m_gameState[13][27] = 79;
        this.m_gameState[13][28] = 32779;
        this.m_gameState[13][29] = 21;
        this.m_gameState[13][30] = 40970;
        this.m_gameState[14][0] = 33802;
        this.m_gameState[14][1] = 21;
        this.m_gameState[14][2] = 140;
        this.m_gameState[14][3] = 65549;
        this.m_gameState[14][4] = 65549;
        this.m_gameState[14][5] = 65549;
        this.m_gameState[14][6] = 65549;
        this.m_gameState[14][7] = 73;
        this.m_gameState[14][8] = 21;
        this.m_gameState[14][9] = 32782;
        this.m_gameState[14][10] = 32779;
        this.m_gameState[14][11] = 5;
        this.m_gameState[14][12] = 40970;
        this.m_gameState[14][13] = 1;
        this.m_gameState[14][14] = 0;
        this.m_gameState[14][15] = 4;
        this.m_gameState[14][16] = 33802;
        this.m_gameState[14][17] = 5;
        this.m_gameState[14][18] = 140;
        this.m_gameState[14][19] = 65549;
        this.m_gameState[14][20] = 65549;
        this.m_gameState[14][21] = 527;
        this.m_gameState[14][22] = 32779;
        this.m_gameState[14][23] = 21;
        this.m_gameState[14][24] = 140;
        this.m_gameState[14][25] = 65549;
        this.m_gameState[14][26] = 65549;
        this.m_gameState[14][27] = 527;
        this.m_gameState[14][28] = 32779;
        this.m_gameState[14][29] = 21;
        this.m_gameState[14][30] = 40970;
        this.m_gameState[15][0] = 33802;
        this.m_gameState[15][1] = 19;
        this.m_gameState[15][2] = 26;
        this.m_gameState[15][3] = 26;
        this.m_gameState[15][4] = 24;
        this.m_gameState[15][5] = 26;
        this.m_gameState[15][6] = 26;
        this.m_gameState[15][7] = 26;
        this.m_gameState[15][8] = 20;
        this.m_gameState[15][9] = 32782;
        this.m_gameState[15][10] = 32779;
        this.m_gameState[15][11] = 5;
        this.m_gameState[15][12] = 40970;
        this.m_gameState[15][13] = 1;
        this.m_gameState[15][14] = 0;
        this.m_gameState[15][15] = 4;
        this.m_gameState[15][16] = 33802;
        this.m_gameState[15][17] = 1;
        this.m_gameState[15][18] = 10;
        this.m_gameState[15][19] = 10;
        this.m_gameState[15][20] = 28;
        this.m_gameState[15][21] = 32782;
        this.m_gameState[15][22] = 32779;
        this.m_gameState[15][23] = 17;
        this.m_gameState[15][24] = 26;
        this.m_gameState[15][25] = 26;
        this.m_gameState[15][26] = 28;
        this.m_gameState[15][27] = 32782;
        this.m_gameState[15][28] = 32779;
        this.m_gameState[15][29] = 21;
        this.m_gameState[15][30] = 40970;
        this.m_gameState[16][0] = 1166;
        this.m_gameState[16][1] = 65543;
        this.m_gameState[16][2] = 65543;
        this.m_gameState[16][3] = 515;
        this.m_gameState[16][4] = 21;
        this.m_gameState[16][5] = 262;
        this.m_gameState[16][6] = 65541;
        this.m_gameState[16][7] = 515;
        this.m_gameState[16][8] = 21;
        this.m_gameState[16][9] = 32782;
        this.m_gameState[16][10] = 32779;
        this.m_gameState[16][11] = 5;
        this.m_gameState[16][12] = 40970;
        this.m_gameState[16][13] = 3;
        this.m_gameState[16][14] = 2;
        this.m_gameState[16][15] = 6;
        this.m_gameState[16][16] = 33802;
        this.m_gameState[16][17] = 5;
        this.m_gameState[16][18] = 262;
        this.m_gameState[16][19] = 515;
        this.m_gameState[16][20] = 21;
        this.m_gameState[16][21] = 32782;
        this.m_gameState[16][22] = 32779;
        this.m_gameState[16][23] = 21;
        this.m_gameState[16][24] = 262;
        this.m_gameState[16][25] = 515;
        this.m_gameState[16][26] = 21;
        this.m_gameState[16][27] = 32782;
        this.m_gameState[16][28] = 32779;
        this.m_gameState[16][29] = 21;
        this.m_gameState[16][30] = 40970;
        this.m_gameState[17][0] = 1294;
        this.m_gameState[17][1] = 65549;
        this.m_gameState[17][2] = 65549;
        this.m_gameState[17][3] = 73;
        this.m_gameState[17][4] = 21;
        this.m_gameState[17][5] = 32778;
        this.m_gameState[17][6] = 13;
        this.m_gameState[17][7] = 32778;
        this.m_gameState[17][8] = 21;
        this.m_gameState[17][9] = 140;
        this.m_gameState[17][10] = 73;
        this.m_gameState[17][11] = 5;
        this.m_gameState[17][12] = 140;
        this.m_gameState[17][13] = 69637;
        this.m_gameState[17][14] = 69637;
        this.m_gameState[17][15] = 69637;
        this.m_gameState[17][16] = 73;
        this.m_gameState[17][17] = 5;
        this.m_gameState[17][18] = 32782;
        this.m_gameState[17][19] = 32779;
        this.m_gameState[17][20] = 21;
        this.m_gameState[17][21] = 140;
        this.m_gameState[17][22] = 73;
        this.m_gameState[17][23] = 21;
        this.m_gameState[17][24] = 32782;
        this.m_gameState[17][25] = 32779;
        this.m_gameState[17][26] = 21;
        this.m_gameState[17][27] = 140;
        this.m_gameState[17][28] = 73;
        this.m_gameState[17][29] = 21;
        this.m_gameState[17][30] = 40970;
        this.m_gameState[18][0] = 33802;
        this.m_gameState[18][1] = 25;
        this.m_gameState[18][2] = 26;
        this.m_gameState[18][3] = 26;
        this.m_gameState[18][4] = 20;
        this.m_gameState[18][5] = 32778;
        this.m_gameState[18][6] = 7;
        this.m_gameState[18][7] = 32778;
        this.m_gameState[18][8] = 17;
        this.m_gameState[18][9] = 10;
        this.m_gameState[18][10] = 10;
        this.m_gameState[18][11] = 0;
        this.m_gameState[18][12] = 10;
        this.m_gameState[18][13] = 10;
        this.m_gameState[18][14] = 10;
        this.m_gameState[18][15] = 10;
        this.m_gameState[18][16] = 10;
        this.m_gameState[18][17] = 4;
        this.m_gameState[18][18] = 32782;
        this.m_gameState[18][19] = 32779;
        this.m_gameState[18][20] = 19;
        this.m_gameState[18][21] = 26;
        this.m_gameState[18][22] = 26;
        this.m_gameState[18][23] = 20;
        this.m_gameState[18][24] = 32782;
        this.m_gameState[18][25] = 32779;
        this.m_gameState[18][26] = 19;
        this.m_gameState[18][27] = 26;
        this.m_gameState[18][28] = 26;
        this.m_gameState[18][29] = 22;
        this.m_gameState[18][30] = 40970;
        this.m_gameState[19][0] = 33802;
        this.m_gameState[19][1] = 21;
        this.m_gameState[19][2] = 262;
        this.m_gameState[19][3] = 515;
        this.m_gameState[19][4] = 21;
        this.m_gameState[19][5] = 140;
        this.m_gameState[19][6] = 65541;
        this.m_gameState[19][7] = 73;
        this.m_gameState[19][8] = 21;
        this.m_gameState[19][9] = 262;
        this.m_gameState[19][10] = 515;
        this.m_gameState[19][11] = 5;
        this.m_gameState[19][12] = 262;
        this.m_gameState[19][13] = 65543;
        this.m_gameState[19][14] = 65543;
        this.m_gameState[19][15] = 65543;
        this.m_gameState[19][16] = 515;
        this.m_gameState[19][17] = 5;
        this.m_gameState[19][18] = 32782;
        this.m_gameState[19][19] = 143;
        this.m_gameState[19][20] = 65543;
        this.m_gameState[19][21] = 65543;
        this.m_gameState[19][22] = 515;
        this.m_gameState[19][23] = 21;
        this.m_gameState[19][24] = 32782;
        this.m_gameState[19][25] = 143;
        this.m_gameState[19][26] = 65543;
        this.m_gameState[19][27] = 65543;
        this.m_gameState[19][28] = 65543;
        this.m_gameState[19][29] = 65543;
        this.m_gameState[19][30] = 8267;
        this.m_gameState[20][0] = 33802;
        this.m_gameState[20][1] = 21;
        this.m_gameState[20][2] = 32782;
        this.m_gameState[20][3] = 32779;
        this.m_gameState[20][4] = 17;
        this.m_gameState[20][5] = 26;
        this.m_gameState[20][6] = 26;
        this.m_gameState[20][7] = 26;
        this.m_gameState[20][8] = 22;
        this.m_gameState[20][9] = 32782;
        this.m_gameState[20][10] = 32779;
        this.m_gameState[20][11] = 5;
        this.m_gameState[20][12] = 140;
        this.m_gameState[20][13] = 65549;
        this.m_gameState[20][14] = 65549;
        this.m_gameState[20][15] = 527;
        this.m_gameState[20][16] = 32779;
        this.m_gameState[20][17] = 5;
        this.m_gameState[20][18] = 140;
        this.m_gameState[20][19] = 65549;
        this.m_gameState[20][20] = 65549;
        this.m_gameState[20][21] = 65549;
        this.m_gameState[20][22] = 73;
        this.m_gameState[20][23] = 21;
        this.m_gameState[20][24] = 140;
        this.m_gameState[20][25] = 65549;
        this.m_gameState[20][26] = 65549;
        this.m_gameState[20][27] = 65549;
        this.m_gameState[20][28] = 65549;
        this.m_gameState[20][29] = 65549;
        this.m_gameState[20][30] = 8715;
        this.m_gameState[21][0] = 33802;
        this.m_gameState[21][1] = 21;
        this.m_gameState[21][2] = 32782;
        this.m_gameState[21][3] = 32779;
        this.m_gameState[21][4] = 21;
        this.m_gameState[21][5] = 262;
        this.m_gameState[21][6] = 65543;
        this.m_gameState[21][7] = 65543;
        this.m_gameState[21][8] = 65543;
        this.m_gameState[21][9] = 79;
        this.m_gameState[21][10] = 32779;
        this.m_gameState[21][11] = 1;
        this.m_gameState[21][12] = 10;
        this.m_gameState[21][13] = 10;
        this.m_gameState[21][14] = 12;
        this.m_gameState[21][15] = 32782;
        this.m_gameState[21][16] = 32779;
        this.m_gameState[21][17] = 1;
        this.m_gameState[21][18] = 10;
        this.m_gameState[21][19] = 10;
        this.m_gameState[21][20] = 24;
        this.m_gameState[21][21] = 26;
        this.m_gameState[21][22] = 26;
        this.m_gameState[21][23] = 18;
        this.m_gameState[21][24] = 26;
        this.m_gameState[21][25] = 26;
        this.m_gameState[21][26] = 24;
        this.m_gameState[21][27] = 26;
        this.m_gameState[21][28] = 26;
        this.m_gameState[21][29] = 28;
        this.m_gameState[21][30] = 40970;
        this.m_gameState[22][0] = 33802;
        this.m_gameState[22][1] = 21;
        this.m_gameState[22][2] = 32782;
        this.m_gameState[22][3] = 32779;
        this.m_gameState[22][4] = 21;
        this.m_gameState[22][5] = 140;
        this.m_gameState[22][6] = 65549;
        this.m_gameState[22][7] = 65549;
        this.m_gameState[22][8] = 65549;
        this.m_gameState[22][9] = 65549;
        this.m_gameState[22][10] = 73;
        this.m_gameState[22][11] = 5;
        this.m_gameState[22][12] = 262;
        this.m_gameState[22][13] = 515;
        this.m_gameState[22][14] = 5;
        this.m_gameState[22][15] = 140;
        this.m_gameState[22][16] = 73;
        this.m_gameState[22][17] = 5;
        this.m_gameState[22][18] = 262;
        this.m_gameState[22][19] = 515;
        this.m_gameState[22][20] = 21;
        this.m_gameState[22][21] = 262;
        this.m_gameState[22][22] = 65543;
        this.m_gameState[22][23] = 65543;
        this.m_gameState[22][24] = 65543;
        this.m_gameState[22][25] = 515;
        this.m_gameState[22][26] = 21;
        this.m_gameState[22][27] = 262;
        this.m_gameState[22][28] = 515;
        this.m_gameState[22][29] = 21;
        this.m_gameState[22][30] = 40970;
        this.m_gameState[23][0] = 33802;
        this.m_gameState[23][1] = 21;
        this.m_gameState[23][2] = 32782;
        this.m_gameState[23][3] = 32779;
        this.m_gameState[23][4] = 19;
        this.m_gameState[23][5] = 26;
        this.m_gameState[23][6] = 24;
        this.m_gameState[23][7] = 26;
        this.m_gameState[23][8] = 26;
        this.m_gameState[23][9] = 24;
        this.m_gameState[23][10] = 10;
        this.m_gameState[23][11] = 6;
        this.m_gameState[23][12] = 32782;
        this.m_gameState[23][13] = 32779;
        this.m_gameState[23][14] = 1;
        this.m_gameState[23][15] = 10;
        this.m_gameState[23][16] = 10;
        this.m_gameState[23][17] = 6;
        this.m_gameState[23][18] = 32782;
        this.m_gameState[23][19] = 32779;
        this.m_gameState[23][20] = 21;
        this.m_gameState[23][21] = 140;
        this.m_gameState[23][22] = 65549;
        this.m_gameState[23][23] = 65549;
        this.m_gameState[23][24] = 527;
        this.m_gameState[23][25] = 32779;
        this.m_gameState[23][26] = 21;
        this.m_gameState[23][27] = 32782;
        this.m_gameState[23][28] = 32779;
        this.m_gameState[23][29] = 21;
        this.m_gameState[23][30] = 40970;
        this.m_gameState[24][0] = 33802;
        this.m_gameState[24][1] = 21;
        this.m_gameState[24][2] = 32782;
        this.m_gameState[24][3] = 143;
        this.m_gameState[24][4] = 65543;
        this.m_gameState[24][5] = 515;
        this.m_gameState[24][6] = 21;
        this.m_gameState[24][7] = 262;
        this.m_gameState[24][8] = 515;
        this.m_gameState[24][9] = 21;
        this.m_gameState[24][10] = 262;
        this.m_gameState[24][11] = 65543;
        this.m_gameState[24][12] = 79;
        this.m_gameState[24][13] = 32779;
        this.m_gameState[24][14] = 5;
        this.m_gameState[24][15] = 262;
        this.m_gameState[24][16] = 65543;
        this.m_gameState[24][17] = 65543;
        this.m_gameState[24][18] = 79;
        this.m_gameState[24][19] = 32779;
        this.m_gameState[24][20] = 17;
        this.m_gameState[24][21] = 26;
        this.m_gameState[24][22] = 26;
        this.m_gameState[24][23] = 28;
        this.m_gameState[24][24] = 32782;
        this.m_gameState[24][25] = 32779;
        this.m_gameState[24][26] = 21;
        this.m_gameState[24][27] = 32782;
        this.m_gameState[24][28] = 32779;
        this.m_gameState[24][29] = 21;
        this.m_gameState[24][30] = 40970;
        this.m_gameState[25][0] = 33802;
        this.m_gameState[25][1] = 21;
        this.m_gameState[25][2] = 140;
        this.m_gameState[25][3] = 65549;
        this.m_gameState[25][4] = 65549;
        this.m_gameState[25][5] = 73;
        this.m_gameState[25][6] = 21;
        this.m_gameState[25][7] = 32782;
        this.m_gameState[25][8] = 32779;
        this.m_gameState[25][9] = 21;
        this.m_gameState[25][10] = 140;
        this.m_gameState[25][11] = 65549;
        this.m_gameState[25][12] = 65549;
        this.m_gameState[25][13] = 73;
        this.m_gameState[25][14] = 5;
        this.m_gameState[25][15] = 140;
        this.m_gameState[25][16] = 65549;
        this.m_gameState[25][17] = 65549;
        this.m_gameState[25][18] = 65549;
        this.m_gameState[25][19] = 73;
        this.m_gameState[25][20] = 21;
        this.m_gameState[25][21] = 262;
        this.m_gameState[25][22] = 515;
        this.m_gameState[25][23] = 21;
        this.m_gameState[25][24] = 140;
        this.m_gameState[25][25] = 73;
        this.m_gameState[25][26] = 21;
        this.m_gameState[25][27] = 140;
        this.m_gameState[25][28] = 73;
        this.m_gameState[25][29] = 21;
        this.m_gameState[25][30] = 40970;
        this.m_gameState[26][0] = 33802;
        this.m_gameState[26][1] = 19;
        this.m_gameState[26][2] = 26;
        this.m_gameState[26][3] = 42;
        this.m_gameState[26][4] = 26;
        this.m_gameState[26][5] = 26;
        this.m_gameState[26][6] = 22;
        this.m_gameState[26][7] = 32782;
        this.m_gameState[26][8] = 32779;
        this.m_gameState[26][9] = 17;
        this.m_gameState[26][10] = 26;
        this.m_gameState[26][11] = 26;
        this.m_gameState[26][12] = 26;
        this.m_gameState[26][13] = 26;
        this.m_gameState[26][14] = 18;
        this.m_gameState[26][15] = 26;
        this.m_gameState[26][16] = 26;
        this.m_gameState[26][17] = 26;
        this.m_gameState[26][18] = 26;
        this.m_gameState[26][19] = 26;
        this.m_gameState[26][20] = 22;
        this.m_gameState[26][21] = 32782;
        this.m_gameState[26][22] = 32779;
        this.m_gameState[26][23] = 35;
        this.m_gameState[26][24] = 26;
        this.m_gameState[26][25] = 26;
        this.m_gameState[26][26] = 18;
        this.m_gameState[26][27] = 26;
        this.m_gameState[26][28] = 26;
        this.m_gameState[26][29] = 22;
        this.m_gameState[26][30] = 40970;
        this.m_gameState[27][0] = 17548;
        this.m_gameState[27][1] = 81925;
        this.m_gameState[27][2] = 81925;
        this.m_gameState[27][3] = 81925;
        this.m_gameState[27][4] = 81925;
        this.m_gameState[27][5] = 81925;
        this.m_gameState[27][6] = 81925;
        this.m_gameState[27][7] = 16461;
        this.m_gameState[27][8] = 32777;
        this.m_gameState[27][9] = 5;
        this.m_gameState[27][10] = 260;
        this.m_gameState[27][11] = 81925;
        this.m_gameState[27][12] = 81925;
        this.m_gameState[27][13] = 81925;
        this.m_gameState[27][14] = 81925;
        this.m_gameState[27][15] = 81925;
        this.m_gameState[27][16] = 81925;
        this.m_gameState[27][17] = 81925;
        this.m_gameState[27][18] = 81925;
        this.m_gameState[27][19] = 81925;
        this.m_gameState[27][20] = 81925;
        this.m_gameState[27][21] = 16461;
        this.m_gameState[27][22] = 16525;
        this.m_gameState[27][23] = 81925;
        this.m_gameState[27][24] = 81925;
        this.m_gameState[27][25] = 81925;
        this.m_gameState[27][26] = 81925;
        this.m_gameState[27][27] = 81925;
        this.m_gameState[27][28] = 81925;
        this.m_gameState[27][29] = 81925;
        this.m_gameState[27][30] = 24649;
    }

    void loadMsPacManMaze3() {
        this.m_gameState[0][0] = 33794;
        this.m_gameState[0][1] = 5;
        this.m_gameState[0][2] = 32774;
        this.m_gameState[0][3] = 4359;
        this.m_gameState[0][4] = 69637;
        this.m_gameState[0][5] = 69637;
        this.m_gameState[0][6] = 69637;
        this.m_gameState[0][7] = 69637;
        this.m_gameState[0][8] = 69637;
        this.m_gameState[0][9] = 69637;
        this.m_gameState[0][10] = 69637;
        this.m_gameState[0][11] = 4615;
        this.m_gameState[0][12] = 4359;
        this.m_gameState[0][13] = 69637;
        this.m_gameState[0][14] = 69637;
        this.m_gameState[0][15] = 69637;
        this.m_gameState[0][16] = 69637;
        this.m_gameState[0][17] = 12803;
        this.m_gameState[0][18] = 1;
        this.m_gameState[0][19] = 0;
        this.m_gameState[0][20] = 0;
        this.m_gameState[0][21] = 4;
        this.m_gameState[0][22] = 33794;
        this.m_gameState[0][23] = 5;
        this.m_gameState[0][24] = 32774;
        this.m_gameState[0][25] = 4359;
        this.m_gameState[0][26] = 69637;
        this.m_gameState[0][27] = 69637;
        this.m_gameState[0][28] = 69637;
        this.m_gameState[0][29] = 69637;
        this.m_gameState[0][30] = 12803;
        this.m_gameState[1][0] = 33802;
        this.m_gameState[1][1] = 5;
        this.m_gameState[1][2] = 32782;
        this.m_gameState[1][3] = 32779;
        this.m_gameState[1][4] = 41;
        this.m_gameState[1][5] = 26;
        this.m_gameState[1][6] = 26;
        this.m_gameState[1][7] = 26;
        this.m_gameState[1][8] = 26;
        this.m_gameState[1][9] = 26;
        this.m_gameState[1][10] = 28;
        this.m_gameState[1][11] = 32782;
        this.m_gameState[1][12] = 32779;
        this.m_gameState[1][13] = 25;
        this.m_gameState[1][14] = 26;
        this.m_gameState[1][15] = 26;
        this.m_gameState[1][16] = 28;
        this.m_gameState[1][17] = 40970;
        this.m_gameState[1][18] = 3;
        this.m_gameState[1][19] = 2;
        this.m_gameState[1][20] = 2;
        this.m_gameState[1][21] = 6;
        this.m_gameState[1][22] = 33802;
        this.m_gameState[1][23] = 5;
        this.m_gameState[1][24] = 32782;
        this.m_gameState[1][25] = 32779;
        this.m_gameState[1][26] = 41;
        this.m_gameState[1][27] = 26;
        this.m_gameState[1][28] = 26;
        this.m_gameState[1][29] = 28;
        this.m_gameState[1][30] = 40970;
        this.m_gameState[2][0] = 33802;
        this.m_gameState[2][1] = 5;
        this.m_gameState[2][2] = 32782;
        this.m_gameState[2][3] = 32779;
        this.m_gameState[2][4] = 21;
        this.m_gameState[2][5] = 262;
        this.m_gameState[2][6] = 65543;
        this.m_gameState[2][7] = 65543;
        this.m_gameState[2][8] = 65543;
        this.m_gameState[2][9] = 515;
        this.m_gameState[2][10] = 21;
        this.m_gameState[2][11] = 32782;
        this.m_gameState[2][12] = 32779;
        this.m_gameState[2][13] = 21;
        this.m_gameState[2][14] = 262;
        this.m_gameState[2][15] = 515;
        this.m_gameState[2][16] = 21;
        this.m_gameState[2][17] = 140;
        this.m_gameState[2][18] = 69637;
        this.m_gameState[2][19] = 69637;
        this.m_gameState[2][20] = 69637;
        this.m_gameState[2][21] = 69637;
        this.m_gameState[2][22] = 73;
        this.m_gameState[2][23] = 5;
        this.m_gameState[2][24] = 140;
        this.m_gameState[2][25] = 73;
        this.m_gameState[2][26] = 21;
        this.m_gameState[2][27] = 262;
        this.m_gameState[2][28] = 515;
        this.m_gameState[2][29] = 21;
        this.m_gameState[2][30] = 40970;
        this.m_gameState[3][0] = 33802;
        this.m_gameState[3][1] = 5;
        this.m_gameState[3][2] = 32782;
        this.m_gameState[3][3] = 32779;
        this.m_gameState[3][4] = 21;
        this.m_gameState[3][5] = 32782;
        this.m_gameState[3][6] = 271;
        this.m_gameState[3][7] = 65549;
        this.m_gameState[3][8] = 65549;
        this.m_gameState[3][9] = 73;
        this.m_gameState[3][10] = 21;
        this.m_gameState[3][11] = 32782;
        this.m_gameState[3][12] = 32779;
        this.m_gameState[3][13] = 21;
        this.m_gameState[3][14] = 32782;
        this.m_gameState[3][15] = 32779;
        this.m_gameState[3][16] = 19;
        this.m_gameState[3][17] = 26;
        this.m_gameState[3][18] = 26;
        this.m_gameState[3][19] = 26;
        this.m_gameState[3][20] = 24;
        this.m_gameState[3][21] = 26;
        this.m_gameState[3][22] = 26;
        this.m_gameState[3][23] = 16;
        this.m_gameState[3][24] = 26;
        this.m_gameState[3][25] = 26;
        this.m_gameState[3][26] = 22;
        this.m_gameState[3][27] = 32782;
        this.m_gameState[3][28] = 32779;
        this.m_gameState[3][29] = 21;
        this.m_gameState[3][30] = 40970;
        this.m_gameState[4][0] = 33802;
        this.m_gameState[4][1] = 5;
        this.m_gameState[4][2] = 32782;
        this.m_gameState[4][3] = 32779;
        this.m_gameState[4][4] = 21;
        this.m_gameState[4][5] = 32782;
        this.m_gameState[4][6] = 32779;
        this.m_gameState[4][7] = 25;
        this.m_gameState[4][8] = 26;
        this.m_gameState[4][9] = 26;
        this.m_gameState[4][10] = 20;
        this.m_gameState[4][11] = 32782;
        this.m_gameState[4][12] = 32779;
        this.m_gameState[4][13] = 21;
        this.m_gameState[4][14] = 32782;
        this.m_gameState[4][15] = 143;
        this.m_gameState[4][16] = 65543;
        this.m_gameState[4][17] = 65543;
        this.m_gameState[4][18] = 65543;
        this.m_gameState[4][19] = 515;
        this.m_gameState[4][20] = 21;
        this.m_gameState[4][21] = 262;
        this.m_gameState[4][22] = 515;
        this.m_gameState[4][23] = 21;
        this.m_gameState[4][24] = 262;
        this.m_gameState[4][25] = 65543;
        this.m_gameState[4][26] = 65543;
        this.m_gameState[4][27] = 79;
        this.m_gameState[4][28] = 32779;
        this.m_gameState[4][29] = 21;
        this.m_gameState[4][30] = 40970;
        this.m_gameState[5][0] = 33802;
        this.m_gameState[5][1] = 5;
        this.m_gameState[5][2] = 140;
        this.m_gameState[5][3] = 73;
        this.m_gameState[5][4] = 21;
        this.m_gameState[5][5] = 32782;
        this.m_gameState[5][6] = 32779;
        this.m_gameState[5][7] = 21;
        this.m_gameState[5][8] = 262;
        this.m_gameState[5][9] = 515;
        this.m_gameState[5][10] = 21;
        this.m_gameState[5][11] = 140;
        this.m_gameState[5][12] = 73;
        this.m_gameState[5][13] = 21;
        this.m_gameState[5][14] = 140;
        this.m_gameState[5][15] = 65549;
        this.m_gameState[5][16] = 65549;
        this.m_gameState[5][17] = 65549;
        this.m_gameState[5][18] = 65549;
        this.m_gameState[5][19] = 73;
        this.m_gameState[5][20] = 21;
        this.m_gameState[5][21] = 32782;
        this.m_gameState[5][22] = 32779;
        this.m_gameState[5][23] = 21;
        this.m_gameState[5][24] = 140;
        this.m_gameState[5][25] = 65549;
        this.m_gameState[5][26] = 65549;
        this.m_gameState[5][27] = 65549;
        this.m_gameState[5][28] = 73;
        this.m_gameState[5][29] = 21;
        this.m_gameState[5][30] = 40970;
        this.m_gameState[6][0] = 33802;
        this.m_gameState[6][1] = 3;
        this.m_gameState[6][2] = 10;
        this.m_gameState[6][3] = 10;
        this.m_gameState[6][4] = 20;
        this.m_gameState[6][5] = 32782;
        this.m_gameState[6][6] = 32779;
        this.m_gameState[6][7] = 21;
        this.m_gameState[6][8] = 32782;
        this.m_gameState[6][9] = 32779;
        this.m_gameState[6][10] = 19;
        this.m_gameState[6][11] = 26;
        this.m_gameState[6][12] = 26;
        this.m_gameState[6][13] = 18;
        this.m_gameState[6][14] = 26;
        this.m_gameState[6][15] = 24;
        this.m_gameState[6][16] = 26;
        this.m_gameState[6][17] = 26;
        this.m_gameState[6][18] = 26;
        this.m_gameState[6][19] = 26;
        this.m_gameState[6][20] = 20;
        this.m_gameState[6][21] = 32782;
        this.m_gameState[6][22] = 32779;
        this.m_gameState[6][23] = 19;
        this.m_gameState[6][24] = 26;
        this.m_gameState[6][25] = 26;
        this.m_gameState[6][26] = 24;
        this.m_gameState[6][27] = 26;
        this.m_gameState[6][28] = 26;
        this.m_gameState[6][29] = 20;
        this.m_gameState[6][30] = 40970;
        this.m_gameState[7][0] = 1166;
        this.m_gameState[7][1] = 65543;
        this.m_gameState[7][2] = 65543;
        this.m_gameState[7][3] = 515;
        this.m_gameState[7][4] = 21;
        this.m_gameState[7][5] = 32782;
        this.m_gameState[7][6] = 32779;
        this.m_gameState[7][7] = 21;
        this.m_gameState[7][8] = 32782;
        this.m_gameState[7][9] = 143;
        this.m_gameState[7][10] = 65543;
        this.m_gameState[7][11] = 65543;
        this.m_gameState[7][12] = 65543;
        this.m_gameState[7][13] = 65543;
        this.m_gameState[7][14] = 515;
        this.m_gameState[7][15] = 5;
        this.m_gameState[7][16] = 262;
        this.m_gameState[7][17] = 65543;
        this.m_gameState[7][18] = 65543;
        this.m_gameState[7][19] = 515;
        this.m_gameState[7][20] = 21;
        this.m_gameState[7][21] = 32782;
        this.m_gameState[7][22] = 143;
        this.m_gameState[7][23] = 65543;
        this.m_gameState[7][24] = 65543;
        this.m_gameState[7][25] = 515;
        this.m_gameState[7][26] = 21;
        this.m_gameState[7][27] = 262;
        this.m_gameState[7][28] = 515;
        this.m_gameState[7][29] = 21;
        this.m_gameState[7][30] = 40970;
        this.m_gameState[8][0] = 1294;
        this.m_gameState[8][1] = 65549;
        this.m_gameState[8][2] = 65549;
        this.m_gameState[8][3] = 73;
        this.m_gameState[8][4] = 21;
        this.m_gameState[8][5] = 140;
        this.m_gameState[8][6] = 73;
        this.m_gameState[8][7] = 21;
        this.m_gameState[8][8] = 140;
        this.m_gameState[8][9] = 65549;
        this.m_gameState[8][10] = 65549;
        this.m_gameState[8][11] = 65549;
        this.m_gameState[8][12] = 65549;
        this.m_gameState[8][13] = 65549;
        this.m_gameState[8][14] = 73;
        this.m_gameState[8][15] = 5;
        this.m_gameState[8][16] = 140;
        this.m_gameState[8][17] = 65549;
        this.m_gameState[8][18] = 527;
        this.m_gameState[8][19] = 32779;
        this.m_gameState[8][20] = 21;
        this.m_gameState[8][21] = 32782;
        this.m_gameState[8][22] = 271;
        this.m_gameState[8][23] = 65549;
        this.m_gameState[8][24] = 65549;
        this.m_gameState[8][25] = 73;
        this.m_gameState[8][26] = 21;
        this.m_gameState[8][27] = 32782;
        this.m_gameState[8][28] = 32779;
        this.m_gameState[8][29] = 21;
        this.m_gameState[8][30] = 40970;
        this.m_gameState[9][0] = 33802;
        this.m_gameState[9][1] = 25;
        this.m_gameState[9][2] = 26;
        this.m_gameState[9][3] = 26;
        this.m_gameState[9][4] = 16;
        this.m_gameState[9][5] = 26;
        this.m_gameState[9][6] = 26;
        this.m_gameState[9][7] = 18;
        this.m_gameState[9][8] = 10;
        this.m_gameState[9][9] = 10;
        this.m_gameState[9][10] = 10;
        this.m_gameState[9][11] = 8;
        this.m_gameState[9][12] = 10;
        this.m_gameState[9][13] = 10;
        this.m_gameState[9][14] = 10;
        this.m_gameState[9][15] = 2;
        this.m_gameState[9][16] = 10;
        this.m_gameState[9][17] = 12;
        this.m_gameState[9][18] = 32782;
        this.m_gameState[9][19] = 32779;
        this.m_gameState[9][20] = 21;
        this.m_gameState[9][21] = 32782;
        this.m_gameState[9][22] = 32779;
        this.m_gameState[9][23] = 25;
        this.m_gameState[9][24] = 26;
        this.m_gameState[9][25] = 26;
        this.m_gameState[9][26] = 20;
        this.m_gameState[9][27] = 32782;
        this.m_gameState[9][28] = 32779;
        this.m_gameState[9][29] = 21;
        this.m_gameState[9][30] = 40970;
        this.m_gameState[10][0] = 33802;
        this.m_gameState[10][1] = 21;
        this.m_gameState[10][2] = 262;
        this.m_gameState[10][3] = 515;
        this.m_gameState[10][4] = 21;
        this.m_gameState[10][5] = 262;
        this.m_gameState[10][6] = 65543;
        this.m_gameState[10][7] = 65543;
        this.m_gameState[10][8] = 65543;
        this.m_gameState[10][9] = 65543;
        this.m_gameState[10][10] = 515;
        this.m_gameState[10][11] = 5;
        this.m_gameState[10][12] = 262;
        this.m_gameState[10][13] = 81925;
        this.m_gameState[10][14] = 81925;
        this.m_gameState[10][15] = 81925;
        this.m_gameState[10][16] = 515;
        this.m_gameState[10][17] = 5;
        this.m_gameState[10][18] = 140;
        this.m_gameState[10][19] = 73;
        this.m_gameState[10][20] = 21;
        this.m_gameState[10][21] = 140;
        this.m_gameState[10][22] = 73;
        this.m_gameState[10][23] = 21;
        this.m_gameState[10][24] = 262;
        this.m_gameState[10][25] = 515;
        this.m_gameState[10][26] = 21;
        this.m_gameState[10][27] = 32782;
        this.m_gameState[10][28] = 32779;
        this.m_gameState[10][29] = 21;
        this.m_gameState[10][30] = 40970;
        this.m_gameState[11][0] = 33802;
        this.m_gameState[11][1] = 21;
        this.m_gameState[11][2] = 32782;
        this.m_gameState[11][3] = 32779;
        this.m_gameState[11][4] = 21;
        this.m_gameState[11][5] = 140;
        this.m_gameState[11][6] = 65549;
        this.m_gameState[11][7] = 65549;
        this.m_gameState[11][8] = 65549;
        this.m_gameState[11][9] = 527;
        this.m_gameState[11][10] = 32779;
        this.m_gameState[11][11] = 5;
        this.m_gameState[11][12] = 40970;
        this.m_gameState[11][13] = 9;
        this.m_gameState[11][14] = 8;
        this.m_gameState[11][15] = 12;
        this.m_gameState[11][16] = 33802;
        this.m_gameState[11][17] = 1;
        this.m_gameState[11][18] = 10;
        this.m_gameState[11][19] = 10;
        this.m_gameState[11][20] = 18;
        this.m_gameState[11][21] = 26;
        this.m_gameState[11][22] = 26;
        this.m_gameState[11][23] = 20;
        this.m_gameState[11][24] = 32782;
        this.m_gameState[11][25] = 32779;
        this.m_gameState[11][26] = 21;
        this.m_gameState[11][27] = 140;
        this.m_gameState[11][28] = 73;
        this.m_gameState[11][29] = 21;
        this.m_gameState[11][30] = 40970;
        this.m_gameState[12][0] = 33802;
        this.m_gameState[12][1] = 21;
        this.m_gameState[12][2] = 32782;
        this.m_gameState[12][3] = 32779;
        this.m_gameState[12][4] = 19;
        this.m_gameState[12][5] = 26;
        this.m_gameState[12][6] = 26;
        this.m_gameState[12][7] = 26;
        this.m_gameState[12][8] = 28;
        this.m_gameState[12][9] = 32782;
        this.m_gameState[12][10] = 32779;
        this.m_gameState[12][11] = 5;
        this.m_gameState[12][12] = 40970;
        this.m_gameState[12][13] = 1;
        this.m_gameState[12][14] = 0;
        this.m_gameState[12][15] = 4;
        this.m_gameState[12][16] = 33802;
        this.m_gameState[12][17] = 5;
        this.m_gameState[12][18] = 262;
        this.m_gameState[12][19] = 65541;
        this.m_gameState[12][20] = 65541;
        this.m_gameState[12][21] = 65541;
        this.m_gameState[12][22] = 515;
        this.m_gameState[12][23] = 21;
        this.m_gameState[12][24] = 32782;
        this.m_gameState[12][25] = 32779;
        this.m_gameState[12][26] = 19;
        this.m_gameState[12][27] = 26;
        this.m_gameState[12][28] = 26;
        this.m_gameState[12][29] = 20;
        this.m_gameState[12][30] = 40970;
        this.m_gameState[13][0] = 33802;
        this.m_gameState[13][1] = 21;
        this.m_gameState[13][2] = 32782;
        this.m_gameState[13][3] = 143;
        this.m_gameState[13][4] = 65543;
        this.m_gameState[13][5] = 65543;
        this.m_gameState[13][6] = 65543;
        this.m_gameState[13][7] = 515;
        this.m_gameState[13][8] = 21;
        this.m_gameState[13][9] = 32782;
        this.m_gameState[13][10] = 32779;
        this.m_gameState[13][11] = 5;
        this.m_gameState[13][12] = 40970;
        this.m_gameState[13][13] = 1;
        this.m_gameState[13][14] = 0;
        this.m_gameState[13][15] = 4;
        this.m_gameState[13][16] = 33802;
        this.m_gameState[13][17] = 5;
        this.m_gameState[13][18] = 32778;
        this.m_gameState[13][19] = 9;
        this.m_gameState[13][20] = 8;
        this.m_gameState[13][21] = 12;
        this.m_gameState[13][22] = 32778;
        this.m_gameState[13][23] = 21;
        this.m_gameState[13][24] = 32782;
        this.m_gameState[13][25] = 143;
        this.m_gameState[13][26] = 65543;
        this.m_gameState[13][27] = 65543;
        this.m_gameState[13][28] = 515;
        this.m_gameState[13][29] = 21;
        this.m_gameState[13][30] = 40970;
        this.m_gameState[14][0] = 33802;
        this.m_gameState[14][1] = 21;
        this.m_gameState[14][2] = 32782;
        this.m_gameState[14][3] = 271;
        this.m_gameState[14][4] = 65549;
        this.m_gameState[14][5] = 65549;
        this.m_gameState[14][6] = 65549;
        this.m_gameState[14][7] = 73;
        this.m_gameState[14][8] = 21;
        this.m_gameState[14][9] = 32782;
        this.m_gameState[14][10] = 32779;
        this.m_gameState[14][11] = 5;
        this.m_gameState[14][12] = 40970;
        this.m_gameState[14][13] = 1;
        this.m_gameState[14][14] = 0;
        this.m_gameState[14][15] = 4;
        this.m_gameState[14][16] = 33802;
        this.m_gameState[14][17] = 5;
        this.m_gameState[14][18] = 32778;
        this.m_gameState[14][19] = 3;
        this.m_gameState[14][20] = 2;
        this.m_gameState[14][21] = 6;
        this.m_gameState[14][22] = 32778;
        this.m_gameState[14][23] = 21;
        this.m_gameState[14][24] = 32782;
        this.m_gameState[14][25] = 271;
        this.m_gameState[14][26] = 65549;
        this.m_gameState[14][27] = 65549;
        this.m_gameState[14][28] = 73;
        this.m_gameState[14][29] = 21;
        this.m_gameState[14][30] = 40970;
        this.m_gameState[15][0] = 33802;
        this.m_gameState[15][1] = 21;
        this.m_gameState[15][2] = 32782;
        this.m_gameState[15][3] = 32779;
        this.m_gameState[15][4] = 25;
        this.m_gameState[15][5] = 26;
        this.m_gameState[15][6] = 26;
        this.m_gameState[15][7] = 26;
        this.m_gameState[15][8] = 22;
        this.m_gameState[15][9] = 32782;
        this.m_gameState[15][10] = 32779;
        this.m_gameState[15][11] = 5;
        this.m_gameState[15][12] = 40970;
        this.m_gameState[15][13] = 1;
        this.m_gameState[15][14] = 0;
        this.m_gameState[15][15] = 4;
        this.m_gameState[15][16] = 33802;
        this.m_gameState[15][17] = 5;
        this.m_gameState[15][18] = 140;
        this.m_gameState[15][19] = 65541;
        this.m_gameState[15][20] = 65541;
        this.m_gameState[15][21] = 65541;
        this.m_gameState[15][22] = 73;
        this.m_gameState[15][23] = 21;
        this.m_gameState[15][24] = 32782;
        this.m_gameState[15][25] = 32779;
        this.m_gameState[15][26] = 25;
        this.m_gameState[15][27] = 26;
        this.m_gameState[15][28] = 26;
        this.m_gameState[15][29] = 20;
        this.m_gameState[15][30] = 40970;
        this.m_gameState[16][0] = 33802;
        this.m_gameState[16][1] = 21;
        this.m_gameState[16][2] = 32782;
        this.m_gameState[16][3] = 32779;
        this.m_gameState[16][4] = 21;
        this.m_gameState[16][5] = 262;
        this.m_gameState[16][6] = 65543;
        this.m_gameState[16][7] = 65543;
        this.m_gameState[16][8] = 65543;
        this.m_gameState[16][9] = 79;
        this.m_gameState[16][10] = 32779;
        this.m_gameState[16][11] = 5;
        this.m_gameState[16][12] = 40970;
        this.m_gameState[16][13] = 3;
        this.m_gameState[16][14] = 2;
        this.m_gameState[16][15] = 6;
        this.m_gameState[16][16] = 33802;
        this.m_gameState[16][17] = 1;
        this.m_gameState[16][18] = 10;
        this.m_gameState[16][19] = 10;
        this.m_gameState[16][20] = 24;
        this.m_gameState[16][21] = 26;
        this.m_gameState[16][22] = 26;
        this.m_gameState[16][23] = 20;
        this.m_gameState[16][24] = 32782;
        this.m_gameState[16][25] = 32779;
        this.m_gameState[16][26] = 21;
        this.m_gameState[16][27] = 262;
        this.m_gameState[16][28] = 515;
        this.m_gameState[16][29] = 21;
        this.m_gameState[16][30] = 40970;
        this.m_gameState[17][0] = 33802;
        this.m_gameState[17][1] = 21;
        this.m_gameState[17][2] = 140;
        this.m_gameState[17][3] = 73;
        this.m_gameState[17][4] = 21;
        this.m_gameState[17][5] = 140;
        this.m_gameState[17][6] = 65549;
        this.m_gameState[17][7] = 65549;
        this.m_gameState[17][8] = 65549;
        this.m_gameState[17][9] = 65549;
        this.m_gameState[17][10] = 73;
        this.m_gameState[17][11] = 5;
        this.m_gameState[17][12] = 140;
        this.m_gameState[17][13] = 69637;
        this.m_gameState[17][14] = 69637;
        this.m_gameState[17][15] = 69637;
        this.m_gameState[17][16] = 73;
        this.m_gameState[17][17] = 5;
        this.m_gameState[17][18] = 262;
        this.m_gameState[17][19] = 515;
        this.m_gameState[17][20] = 21;
        this.m_gameState[17][21] = 262;
        this.m_gameState[17][22] = 515;
        this.m_gameState[17][23] = 21;
        this.m_gameState[17][24] = 140;
        this.m_gameState[17][25] = 73;
        this.m_gameState[17][26] = 21;
        this.m_gameState[17][27] = 32782;
        this.m_gameState[17][28] = 32779;
        this.m_gameState[17][29] = 21;
        this.m_gameState[17][30] = 40970;
        this.m_gameState[18][0] = 33802;
        this.m_gameState[18][1] = 19;
        this.m_gameState[18][2] = 26;
        this.m_gameState[18][3] = 26;
        this.m_gameState[18][4] = 16;
        this.m_gameState[18][5] = 26;
        this.m_gameState[18][6] = 26;
        this.m_gameState[18][7] = 24;
        this.m_gameState[18][8] = 10;
        this.m_gameState[18][9] = 10;
        this.m_gameState[18][10] = 10;
        this.m_gameState[18][11] = 2;
        this.m_gameState[18][12] = 10;
        this.m_gameState[18][13] = 10;
        this.m_gameState[18][14] = 10;
        this.m_gameState[18][15] = 8;
        this.m_gameState[18][16] = 10;
        this.m_gameState[18][17] = 6;
        this.m_gameState[18][18] = 32782;
        this.m_gameState[18][19] = 32779;
        this.m_gameState[18][20] = 21;
        this.m_gameState[18][21] = 32782;
        this.m_gameState[18][22] = 32779;
        this.m_gameState[18][23] = 19;
        this.m_gameState[18][24] = 26;
        this.m_gameState[18][25] = 26;
        this.m_gameState[18][26] = 20;
        this.m_gameState[18][27] = 32782;
        this.m_gameState[18][28] = 32779;
        this.m_gameState[18][29] = 21;
        this.m_gameState[18][30] = 40970;
        this.m_gameState[19][0] = 1166;
        this.m_gameState[19][1] = 65543;
        this.m_gameState[19][2] = 65543;
        this.m_gameState[19][3] = 515;
        this.m_gameState[19][4] = 21;
        this.m_gameState[19][5] = 262;
        this.m_gameState[19][6] = 515;
        this.m_gameState[19][7] = 21;
        this.m_gameState[19][8] = 262;
        this.m_gameState[19][9] = 65543;
        this.m_gameState[19][10] = 65543;
        this.m_gameState[19][11] = 65543;
        this.m_gameState[19][12] = 65543;
        this.m_gameState[19][13] = 65543;
        this.m_gameState[19][14] = 515;
        this.m_gameState[19][15] = 5;
        this.m_gameState[19][16] = 262;
        this.m_gameState[19][17] = 65543;
        this.m_gameState[19][18] = 79;
        this.m_gameState[19][19] = 32779;
        this.m_gameState[19][20] = 21;
        this.m_gameState[19][21] = 32782;
        this.m_gameState[19][22] = 143;
        this.m_gameState[19][23] = 65543;
        this.m_gameState[19][24] = 65543;
        this.m_gameState[19][25] = 515;
        this.m_gameState[19][26] = 21;
        this.m_gameState[19][27] = 32782;
        this.m_gameState[19][28] = 32779;
        this.m_gameState[19][29] = 21;
        this.m_gameState[19][30] = 40970;
        this.m_gameState[20][0] = 1294;
        this.m_gameState[20][1] = 65549;
        this.m_gameState[20][2] = 65549;
        this.m_gameState[20][3] = 73;
        this.m_gameState[20][4] = 21;
        this.m_gameState[20][5] = 32782;
        this.m_gameState[20][6] = 32779;
        this.m_gameState[20][7] = 21;
        this.m_gameState[20][8] = 32782;
        this.m_gameState[20][9] = 271;
        this.m_gameState[20][10] = 65549;
        this.m_gameState[20][11] = 65549;
        this.m_gameState[20][12] = 65549;
        this.m_gameState[20][13] = 65549;
        this.m_gameState[20][14] = 73;
        this.m_gameState[20][15] = 5;
        this.m_gameState[20][16] = 140;
        this.m_gameState[20][17] = 65549;
        this.m_gameState[20][18] = 65549;
        this.m_gameState[20][19] = 73;
        this.m_gameState[20][20] = 21;
        this.m_gameState[20][21] = 32782;
        this.m_gameState[20][22] = 271;
        this.m_gameState[20][23] = 65549;
        this.m_gameState[20][24] = 65549;
        this.m_gameState[20][25] = 73;
        this.m_gameState[20][26] = 21;
        this.m_gameState[20][27] = 140;
        this.m_gameState[20][28] = 73;
        this.m_gameState[20][29] = 21;
        this.m_gameState[20][30] = 40970;
        this.m_gameState[21][0] = 33802;
        this.m_gameState[21][1] = 9;
        this.m_gameState[21][2] = 10;
        this.m_gameState[21][3] = 10;
        this.m_gameState[21][4] = 20;
        this.m_gameState[21][5] = 32782;
        this.m_gameState[21][6] = 32779;
        this.m_gameState[21][7] = 21;
        this.m_gameState[21][8] = 32782;
        this.m_gameState[21][9] = 32779;
        this.m_gameState[21][10] = 25;
        this.m_gameState[21][11] = 26;
        this.m_gameState[21][12] = 26;
        this.m_gameState[21][13] = 24;
        this.m_gameState[21][14] = 26;
        this.m_gameState[21][15] = 18;
        this.m_gameState[21][16] = 26;
        this.m_gameState[21][17] = 26;
        this.m_gameState[21][18] = 26;
        this.m_gameState[21][19] = 26;
        this.m_gameState[21][20] = 20;
        this.m_gameState[21][21] = 32782;
        this.m_gameState[21][22] = 32779;
        this.m_gameState[21][23] = 25;
        this.m_gameState[21][24] = 26;
        this.m_gameState[21][25] = 26;
        this.m_gameState[21][26] = 18;
        this.m_gameState[21][27] = 26;
        this.m_gameState[21][28] = 26;
        this.m_gameState[21][29] = 20;
        this.m_gameState[21][30] = 40970;
        this.m_gameState[22][0] = 33802;
        this.m_gameState[22][1] = 5;
        this.m_gameState[22][2] = 262;
        this.m_gameState[22][3] = 515;
        this.m_gameState[22][4] = 21;
        this.m_gameState[22][5] = 32782;
        this.m_gameState[22][6] = 32779;
        this.m_gameState[22][7] = 21;
        this.m_gameState[22][8] = 140;
        this.m_gameState[22][9] = 73;
        this.m_gameState[22][10] = 21;
        this.m_gameState[22][11] = 262;
        this.m_gameState[22][12] = 515;
        this.m_gameState[22][13] = 21;
        this.m_gameState[22][14] = 262;
        this.m_gameState[22][15] = 65543;
        this.m_gameState[22][16] = 65543;
        this.m_gameState[22][17] = 65543;
        this.m_gameState[22][18] = 65543;
        this.m_gameState[22][19] = 515;
        this.m_gameState[22][20] = 21;
        this.m_gameState[22][21] = 32782;
        this.m_gameState[22][22] = 32779;
        this.m_gameState[22][23] = 21;
        this.m_gameState[22][24] = 262;
        this.m_gameState[22][25] = 65543;
        this.m_gameState[22][26] = 65543;
        this.m_gameState[22][27] = 65543;
        this.m_gameState[22][28] = 515;
        this.m_gameState[22][29] = 21;
        this.m_gameState[22][30] = 40970;
        this.m_gameState[23][0] = 33802;
        this.m_gameState[23][1] = 5;
        this.m_gameState[23][2] = 32782;
        this.m_gameState[23][3] = 32779;
        this.m_gameState[23][4] = 21;
        this.m_gameState[23][5] = 32782;
        this.m_gameState[23][6] = 32779;
        this.m_gameState[23][7] = 19;
        this.m_gameState[23][8] = 26;
        this.m_gameState[23][9] = 26;
        this.m_gameState[23][10] = 20;
        this.m_gameState[23][11] = 32782;
        this.m_gameState[23][12] = 32779;
        this.m_gameState[23][13] = 21;
        this.m_gameState[23][14] = 32782;
        this.m_gameState[23][15] = 271;
        this.m_gameState[23][16] = 65549;
        this.m_gameState[23][17] = 65549;
        this.m_gameState[23][18] = 65549;
        this.m_gameState[23][19] = 73;
        this.m_gameState[23][20] = 21;
        this.m_gameState[23][21] = 140;
        this.m_gameState[23][22] = 73;
        this.m_gameState[23][23] = 21;
        this.m_gameState[23][24] = 140;
        this.m_gameState[23][25] = 65549;
        this.m_gameState[23][26] = 65549;
        this.m_gameState[23][27] = 527;
        this.m_gameState[23][28] = 32779;
        this.m_gameState[23][29] = 21;
        this.m_gameState[23][30] = 40970;
        this.m_gameState[24][0] = 33802;
        this.m_gameState[24][1] = 5;
        this.m_gameState[24][2] = 32782;
        this.m_gameState[24][3] = 32779;
        this.m_gameState[24][4] = 21;
        this.m_gameState[24][5] = 32782;
        this.m_gameState[24][6] = 143;
        this.m_gameState[24][7] = 65543;
        this.m_gameState[24][8] = 65543;
        this.m_gameState[24][9] = 515;
        this.m_gameState[24][10] = 21;
        this.m_gameState[24][11] = 32782;
        this.m_gameState[24][12] = 32779;
        this.m_gameState[24][13] = 21;
        this.m_gameState[24][14] = 32782;
        this.m_gameState[24][15] = 32779;
        this.m_gameState[24][16] = 25;
        this.m_gameState[24][17] = 26;
        this.m_gameState[24][18] = 26;
        this.m_gameState[24][19] = 26;
        this.m_gameState[24][20] = 18;
        this.m_gameState[24][21] = 26;
        this.m_gameState[24][22] = 26;
        this.m_gameState[24][23] = 16;
        this.m_gameState[24][24] = 26;
        this.m_gameState[24][25] = 26;
        this.m_gameState[24][26] = 28;
        this.m_gameState[24][27] = 32782;
        this.m_gameState[24][28] = 32779;
        this.m_gameState[24][29] = 21;
        this.m_gameState[24][30] = 40970;
        this.m_gameState[25][0] = 33802;
        this.m_gameState[25][1] = 5;
        this.m_gameState[25][2] = 32782;
        this.m_gameState[25][3] = 32779;
        this.m_gameState[25][4] = 21;
        this.m_gameState[25][5] = 140;
        this.m_gameState[25][6] = 65549;
        this.m_gameState[25][7] = 65549;
        this.m_gameState[25][8] = 65549;
        this.m_gameState[25][9] = 73;
        this.m_gameState[25][10] = 21;
        this.m_gameState[25][11] = 32782;
        this.m_gameState[25][12] = 32779;
        this.m_gameState[25][13] = 21;
        this.m_gameState[25][14] = 140;
        this.m_gameState[25][15] = 73;
        this.m_gameState[25][16] = 21;
        this.m_gameState[25][17] = 262;
        this.m_gameState[25][18] = 81925;
        this.m_gameState[25][19] = 81925;
        this.m_gameState[25][20] = 81925;
        this.m_gameState[25][21] = 81925;
        this.m_gameState[25][22] = 515;
        this.m_gameState[25][23] = 5;
        this.m_gameState[25][24] = 262;
        this.m_gameState[25][25] = 515;
        this.m_gameState[25][26] = 21;
        this.m_gameState[25][27] = 140;
        this.m_gameState[25][28] = 73;
        this.m_gameState[25][29] = 21;
        this.m_gameState[25][30] = 40970;
        this.m_gameState[26][0] = 33802;
        this.m_gameState[26][1] = 5;
        this.m_gameState[26][2] = 32782;
        this.m_gameState[26][3] = 32779;
        this.m_gameState[26][4] = 35;
        this.m_gameState[26][5] = 26;
        this.m_gameState[26][6] = 26;
        this.m_gameState[26][7] = 26;
        this.m_gameState[26][8] = 26;
        this.m_gameState[26][9] = 26;
        this.m_gameState[26][10] = 22;
        this.m_gameState[26][11] = 32782;
        this.m_gameState[26][12] = 32779;
        this.m_gameState[26][13] = 19;
        this.m_gameState[26][14] = 26;
        this.m_gameState[26][15] = 26;
        this.m_gameState[26][16] = 22;
        this.m_gameState[26][17] = 40970;
        this.m_gameState[26][18] = 9;
        this.m_gameState[26][19] = 8;
        this.m_gameState[26][20] = 8;
        this.m_gameState[26][21] = 12;
        this.m_gameState[26][22] = 33802;
        this.m_gameState[26][23] = 5;
        this.m_gameState[26][24] = 32782;
        this.m_gameState[26][25] = 32779;
        this.m_gameState[26][26] = 35;
        this.m_gameState[26][27] = 26;
        this.m_gameState[26][28] = 26;
        this.m_gameState[26][29] = 22;
        this.m_gameState[26][30] = 40970;
        this.m_gameState[27][0] = 33800;
        this.m_gameState[27][1] = 5;
        this.m_gameState[27][2] = 32780;
        this.m_gameState[27][3] = 16525;
        this.m_gameState[27][4] = 81925;
        this.m_gameState[27][5] = 81925;
        this.m_gameState[27][6] = 81925;
        this.m_gameState[27][7] = 81925;
        this.m_gameState[27][8] = 81925;
        this.m_gameState[27][9] = 81925;
        this.m_gameState[27][10] = 81925;
        this.m_gameState[27][11] = 16461;
        this.m_gameState[27][12] = 16525;
        this.m_gameState[27][13] = 81925;
        this.m_gameState[27][14] = 81925;
        this.m_gameState[27][15] = 81925;
        this.m_gameState[27][16] = 81925;
        this.m_gameState[27][17] = 24649;
        this.m_gameState[27][18] = 1;
        this.m_gameState[27][19] = 0;
        this.m_gameState[27][20] = 0;
        this.m_gameState[27][21] = 4;
        this.m_gameState[27][22] = 33800;
        this.m_gameState[27][23] = 5;
        this.m_gameState[27][24] = 32780;
        this.m_gameState[27][25] = 16525;
        this.m_gameState[27][26] = 81925;
        this.m_gameState[27][27] = 81925;
        this.m_gameState[27][28] = 81925;
        this.m_gameState[27][29] = 81925;
        this.m_gameState[27][30] = 24649;
    }

    public void enteringJail(Ghost ghost) {
    }

    public void leavingJail(Ghost g) {
    }

    public int getFruitScore() {
        return this.m_stage * 750;
    }

    public void gameOver() {
        this.m_state = 2;
    }

    public int getHighScore() {
        return this.m_highScore;
    }

    public void setHighScore(int score) {
        this.m_highScore = score;
    }

    public void levelComplete() {
        this.m_state = 3;
        this.m_nTicks2LevelComp = 0;
    }

    public void pacmanWasEaten() {
        this.m_state = 6;
        this.m_nTicks2DeadPlay = 0;
    }

    public int getGhostScore() {
        return this.m_eatGhostPoints;
    }

    public void doubleGhostScore() {
        this.m_eatGhostPoints *= 2;
    }

    public void pacmanAtePowerup() {
    }

    static {
        Factory factory = new Factory("GameModel.java", Class.forName("pacman.classes.GameModel"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "resetGhostPoints", "pacman.classes.GameModel", "", "", "", "void"), 232);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "setVisibleThings", "pacman.classes.GameModel", "boolean:", "bVisible:", "", "void"), 322);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "loadNextLevel", "pacman.classes.GameModel", "", "", "", "void"), 345);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "setVisibleThings", "pacman.classes.GameModel", "boolean:", "bVisible:", "", "void"), 346);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "setVisibleThings", "pacman.classes.GameModel", "boolean:", "bVisible:", "", "void"), 402);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "setPausedGame", "pacman.classes.GameModel", "boolean:", "bPaused:", "", "void"), 403);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "setVisibleThings", "pacman.classes.GameModel", "boolean:", "bVisible:", "", "void"), 416);
    }
}

