/*
 * Decompiled with CFR 0.152.
 */
package pacman.classes;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import pacman.classes.GameControl;
import pacman.classes.GameModel;
import pacman.classes.Thing;

public class GameUI
extends Canvas {
    int CELL_LENGTH;
    int WALL0;
    int WALL1;
    int WALL2;
    int WALL3;
    int WALL4;
    int WALL5;
    int WALL6;
    Hashtable m_redrawHash;
    GameModel m_gameModel;
    GameControl m_pacMan;
    Image m_offImage;
    Graphics m_offGraphics;
    Dimension m_offDim;
    Color m_wallColor;
    Color m_wallAltColor;
    Font m_font;
    Font m_readyFont;
    Font m_readyFontItalic;
    public boolean m_bRedrawAll = false;
    boolean m_bDrawReady = false;
    int m_gridInset;
    boolean m_bFlipWallColor = false;
    boolean m_bDrawGameOver = false;
    boolean m_bDrawPaused = false;
    boolean m_bShowAbout = false;
    Image m_imagePacman;
    boolean m_bShowIntro = true;

    GameUI(GameControl pacMan, GameModel gameModel, int width, int height) {
        this.setSize(width, height);
        this.m_gameModel = gameModel;
        this.m_pacMan = pacMan;
        this.CELL_LENGTH = height / (this.m_gameModel.m_gameSizeY + 1);
        this.m_gridInset = this.CELL_LENGTH / 2;
        this.WALL0 = 0;
        this.WALL1 = this.CELL_LENGTH / 4;
        this.WALL3 = this.CELL_LENGTH / 2;
        this.WALL2 = this.WALL3 - this.CELL_LENGTH / 8;
        this.WALL4 = this.WALL3 + this.CELL_LENGTH / 8;
        this.WALL5 = this.CELL_LENGTH - this.WALL1;
        this.WALL6 = this.CELL_LENGTH - 1;
        this.m_redrawHash = new Hashtable();
        this.refreshRedrawHash();
        this.m_font = new Font("Helvetica", 1, 14);
        this.m_readyFont = new Font("Helvetica", 1, 20);
        this.m_readyFontItalic = new Font("Helvetica", 3, 20);
    }

    void refreshRedrawHash() {
        this.m_redrawHash.clear();
        int x = 0;
        while (x < this.m_gameModel.m_gameSizeX) {
            int y = 0;
            while (y < this.m_gameModel.m_gameSizeY) {
                if ((this.m_gameModel.m_gameState[x][y] & 0x20) != 0) {
                    this.m_redrawHash.put(String.valueOf(Integer.toString(x)) + " " + Integer.toString(y), new Point(x, y));
                }
                ++y;
            }
            ++x;
        }
    }

    public void setClip(Graphics g) {
        g.setClip(this.m_gridInset, this.m_gridInset, this.CELL_LENGTH * this.m_gameModel.m_gameSizeX, this.CELL_LENGTH * this.m_gameModel.m_gameSizeY);
    }

    @Override
    public void update(Graphics g) {
        if (this.m_bRedrawAll) {
            this.m_bRedrawAll = false;
            this.paint(g);
            return;
        }
        if (this.m_bShowIntro) {
            this.updateIntro(g);
            return;
        }
        int i = 0;
        while (i < this.m_gameModel.m_things.length) {
            this.redrawLastLocation(this.m_offGraphics, this.m_gameModel.m_things[i]);
            ++i;
        }
        Enumeration e = this.m_redrawHash.elements();
        while (e.hasMoreElements()) {
            Point p = ((Point)e.nextElement()).getLocation();
            this.drawGameCell(this.m_offGraphics, p.x, p.y, false);
        }
        this.drawHideoutDoor(this.m_offGraphics);
        i = 0;
        while (i < this.m_gameModel.m_things.length) {
            this.m_gameModel.m_things[i].draw(this, this.m_offGraphics);
            ++i;
        }
        if (this.m_bDrawReady) {
            this.drawReadyString(this.m_offGraphics);
        }
        g.drawImage(this.m_offImage, 0, 0, this);
    }

    @Override
    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        if (this.m_offImage == null || this.m_offDim.width != dim.width || this.m_offDim.height != dim.height) {
            this.m_offDim = dim;
            this.m_offImage = this.createImage(this.m_offDim.width, this.m_offDim.height);
            this.m_offGraphics = this.m_offImage.getGraphics();
        }
        this.m_offGraphics.setColor(Color.black);
        this.m_offGraphics.fillRect(0, 0, this.m_offDim.width, this.m_offDim.height);
        if (this.m_bShowIntro) {
            this.paintIntro(g);
            return;
        }
        if (this.m_bShowAbout) {
            this.paintAbout(g);
            return;
        }
        this.m_offGraphics.setColor(Color.blue);
        int x = 0;
        while (x < this.m_gameModel.m_gameSizeX) {
            int y = 0;
            while (y < this.m_gameModel.m_gameSizeY) {
                this.drawGameCell(this.m_offGraphics, x, y, false);
                ++y;
            }
            ++x;
        }
        this.setClip(this.m_offGraphics);
        this.drawHideoutDoor(this.m_offGraphics);
        int i = 0;
        while (i < this.m_gameModel.m_things.length) {
            this.m_gameModel.m_things[i].draw(this, this.m_offGraphics);
            ++i;
        }
        if (this.m_bDrawReady) {
            this.drawReadyString(this.m_offGraphics);
        }
        if (this.m_bDrawGameOver) {
            this.drawGameOverString(this.m_offGraphics);
        }
        if (this.m_bDrawPaused) {
            this.drawPausedString(this.m_offGraphics);
        }
        g.drawImage(this.m_offImage, 0, 0, this);
    }

    public void paintAbout(Graphics g) {
        int x = 0;
        int y = 0;
        boolean width = false;
        boolean stringLength = false;
        this.m_offGraphics.setColor(Color.black);
        this.m_offGraphics.fillRect(0, 0, this.m_offDim.width, this.m_offDim.height);
        if (this.m_imagePacman == null) {
            this.m_imagePacman = this.m_gameModel.m_pacMan.getImage(this.m_gameModel.m_pacMan.getCodeBase(), "pacman.jpg");
        }
        y = 50;
        x = (this.m_offDim.width - this.m_imagePacman.getWidth(this)) / 2;
        this.m_offGraphics.drawImage(this.m_imagePacman, x, y, this);
        this.m_offGraphics.setFont(this.m_font);
        this.m_offGraphics.setColor(Color.white);
        FontMetrics fm = this.m_offGraphics.getFontMetrics();
        this.m_offGraphics.setColor(Color.white);
        x = 10;
        y = this.m_gridInset + 10 * this.CELL_LENGTH + this.CELL_LENGTH / 2 + fm.getAscent() / 2;
        this.m_offGraphics.drawString("Welcome to PAC-MAN in Java!", x, y);
        y += fm.getAscent() + fm.getDescent();
        this.m_offGraphics.drawString("This game contains the original Pacman maze and all", x, y += fm.getAscent() + fm.getDescent());
        this.m_offGraphics.drawString("four Ms.Pacman mazes.  You have to finish each maze", x, y += fm.getAscent() + fm.getDescent());
        this.m_offGraphics.drawString("twice before advancing to the next.", x, y += fm.getAscent() + fm.getDescent());
        this.m_offGraphics.drawString("After every 10,000 points, you get an extra life.", x, y += fm.getAscent() + fm.getDescent());
        this.m_offGraphics.drawString("Have fun and watch out for the bonus items!", x, y += fm.getAscent() + fm.getDescent());
        y += fm.getAscent() + fm.getDescent();
        this.m_offGraphics.drawString("Question, Comments or Bugs?", x, y += fm.getAscent() + fm.getDescent());
        y += fm.getAscent() + fm.getDescent();
        this.m_offGraphics.drawString("Please e-mail me at:", x, y += fm.getAscent() + fm.getDescent());
        this.m_offGraphics.drawString("benny_chow@hotmail.com", x, y += fm.getAscent() + fm.getDescent());
        y += fm.getAscent() + fm.getDescent();
        this.m_offGraphics.drawString("Or visit my site at:", x, y += fm.getAscent() + fm.getDescent());
        this.m_offGraphics.drawString("http://www.bennychow.com", x, y += fm.getAscent() + fm.getDescent());
        g.drawImage(this.m_offImage, 0, 0, this);
    }

    public void updateIntro(Graphics g) {
        int x;
        if (this.m_imagePacman != null) {
            int y = 50;
            x = (this.m_offDim.width - this.m_imagePacman.getWidth(this)) / 2;
            this.m_offGraphics.drawImage(this.m_imagePacman, x, y, this);
        }
        int i = 0;
        while (i < this.m_gameModel.m_ghosts.length) {
            this.redrawLastLocation(this.m_offGraphics, this.m_gameModel.m_ghosts[i]);
            ++i;
        }
        this.redrawLastLocation(this.m_offGraphics, this.m_gameModel.m_player);
        i = 0;
        while (i < this.m_gameModel.m_ghosts.length) {
            this.m_gameModel.m_ghosts[i].draw(this, this.m_offGraphics);
            ++i;
        }
        this.m_gameModel.m_player.draw(this, this.m_offGraphics);
        x = 250;
        this.m_offGraphics.setColor(Color.pink);
        this.m_offGraphics.fillOval(this.m_gridInset + 12 * this.CELL_LENGTH + this.WALL2, this.m_gridInset + 22 * this.CELL_LENGTH + this.WALL2, this.WALL1, this.WALL1);
        if (this.m_gameModel.m_pacMan.m_globalTickCount % (1000 / this.m_pacMan.m_delay) > 200 / this.m_pacMan.m_delay) {
            this.m_offGraphics.setColor(Color.pink);
        } else {
            this.m_offGraphics.setColor(Color.black);
        }
        this.m_offGraphics.fillOval(this.m_gridInset + 12 * this.CELL_LENGTH, this.m_gridInset + 24 * this.CELL_LENGTH, this.CELL_LENGTH, this.CELL_LENGTH);
        g.drawImage(this.m_offImage, 0, 0, this);
    }

    public void paintIntro(Graphics g) {
        int x = 0;
        int y = 0;
        int width = 0;
        int stringLength = 0;
        this.m_offGraphics.setColor(Color.black);
        this.m_offGraphics.fillRect(0, 0, this.m_offDim.width, this.m_offDim.height);
        if (this.m_imagePacman == null) {
            this.m_imagePacman = this.m_gameModel.m_pacMan.getImage(this.m_gameModel.m_pacMan.getCodeBase(), "pacman.jpg");
        }
        y = 50;
        x = (this.m_offDim.width - this.m_imagePacman.getWidth(this)) / 2;
        this.m_offGraphics.drawImage(this.m_imagePacman, x, y, this);
        int i = 0;
        while (i < this.m_gameModel.m_ghosts.length) {
            this.m_gameModel.m_ghosts[i].draw(this, this.m_offGraphics);
            ++i;
        }
        this.m_gameModel.m_player.draw(this, this.m_offGraphics);
        this.m_offGraphics.setFont(this.m_readyFont);
        this.m_offGraphics.setColor(Color.white);
        FontMetrics fm = this.m_offGraphics.getFontMetrics();
        x = 150;
        stringLength = this.m_gridInset + 18 * this.CELL_LENGTH - x;
        y = this.m_gridInset + 10 * this.CELL_LENGTH + this.CELL_LENGTH / 2 + fm.getAscent() / 2;
        this.m_offGraphics.setColor(Color.red);
        this.m_offGraphics.drawString(this.padString(this.m_offGraphics, "\"BLINKY\" ", stringLength), x, y);
        y = this.m_gridInset + 12 * this.CELL_LENGTH + this.CELL_LENGTH / 2 + fm.getAscent() / 2;
        this.m_offGraphics.setColor(Color.pink);
        this.m_offGraphics.drawString(this.padString(this.m_offGraphics, "\"PINKY\" ", stringLength), x, y);
        y = this.m_gridInset + 14 * this.CELL_LENGTH + this.CELL_LENGTH / 2 + fm.getAscent() / 2;
        this.m_offGraphics.setColor(Color.cyan);
        this.m_offGraphics.drawString(this.padString(this.m_offGraphics, "\"INKY\" ", stringLength), x, y);
        y = this.m_gridInset + 16 * this.CELL_LENGTH + this.CELL_LENGTH / 2 + fm.getAscent() / 2;
        this.m_offGraphics.setColor(Color.orange);
        this.m_offGraphics.drawString(this.padString(this.m_offGraphics, "\"CLYDE\" ", stringLength), x, y);
        this.m_offGraphics.setFont(this.m_font);
        x = 210;
        this.m_offGraphics.setColor(Color.pink);
        this.m_offGraphics.fillOval(this.m_gridInset + 12 * this.CELL_LENGTH + this.WALL2, this.m_gridInset + 22 * this.CELL_LENGTH + this.WALL2, this.WALL1, this.WALL1);
        this.m_offGraphics.drawString("= 10 Points", x, this.m_gridInset + 22 * this.CELL_LENGTH + fm.getAscent() / 2);
        this.m_offGraphics.drawString("= 50 Points", x, this.m_gridInset + 24 * this.CELL_LENGTH + fm.getAscent() / 2);
        if (this.m_gameModel.m_pacMan.m_globalTickCount % (1000 / this.m_pacMan.m_delay) > 200 / this.m_pacMan.m_delay) {
            this.m_offGraphics.setColor(Color.pink);
        } else {
            this.m_offGraphics.setColor(Color.black);
        }
        this.m_offGraphics.fillOval(this.m_gridInset + 12 * this.CELL_LENGTH, this.m_gridInset + 24 * this.CELL_LENGTH, this.CELL_LENGTH, this.CELL_LENGTH);
        fm = this.m_offGraphics.getFontMetrics();
        width = fm.stringWidth("Written by Benny Chow, 2001");
        x = (this.m_offDim.width - width) / 2;
        y = 500;
        this.m_offGraphics.setColor(Color.white);
        this.m_offGraphics.drawString("Written by Benny Chow, 2001", x, y);
        g.drawImage(this.m_offImage, 0, 0, this);
    }

    public String padString(Graphics g, String stuff, int length) {
        FontMetrics fm = g.getFontMetrics();
        while (fm.stringWidth(stuff) < length) {
            stuff = String.valueOf(stuff) + ".";
        }
        return stuff;
    }

    public void drawPausedString(Graphics g) {
        Dimension dim = this.getSize();
        g.setFont(this.m_readyFont);
        FontMetrics fm = g.getFontMetrics();
        int width = fm.stringWidth("PAUSED");
        g.setColor(Color.black);
        int x = (dim.width - width) / 2;
        int y = this.m_gridInset + (this.m_gameModel.m_doorLocY + 1) * this.CELL_LENGTH;
        g.fillRoundRect(x, y, width, 3 * this.CELL_LENGTH, this.CELL_LENGTH, this.CELL_LENGTH);
        g.setColor(Color.white);
        x = (dim.width - width) / 2;
        y = this.m_gridInset + (this.m_gameModel.m_doorLocY + 2) * this.CELL_LENGTH + this.CELL_LENGTH / 2 + fm.getAscent() / 2;
        g.drawString("PAUSED", x, y);
    }

    public void drawGameOverString(Graphics g) {
        Dimension dim = this.getSize();
        g.setFont(this.m_readyFont);
        FontMetrics fm = g.getFontMetrics();
        int width = fm.stringWidth("GAME OVER");
        g.setColor(Color.black);
        int x = (dim.width - width) / 2;
        int y = this.m_gridInset + (this.m_gameModel.m_doorLocY + 1) * this.CELL_LENGTH;
        g.fillRoundRect(x, y, width, 3 * this.CELL_LENGTH, this.CELL_LENGTH, this.CELL_LENGTH);
        g.setColor(Color.white);
        x = (dim.width - width) / 2;
        y = this.m_gridInset + (this.m_gameModel.m_doorLocY + 2) * this.CELL_LENGTH + this.CELL_LENGTH / 2 + fm.getAscent() / 2;
        g.drawString("GAME OVER", x, y);
    }

    public void drawReadyString(Graphics g) {
        Dimension dim = this.getSize();
        g.setColor(Color.yellow);
        g.setFont(this.m_readyFont);
        FontMetrics fm = g.getFontMetrics();
        int width1 = fm.stringWidth("READY");
        g.setFont(this.m_readyFontItalic);
        FontMetrics fm2 = g.getFontMetrics();
        int width2 = fm2.stringWidth(" !!!");
        g.setFont(this.m_readyFont);
        int x = (dim.width - (width1 + width2)) / 2;
        int y = this.m_gridInset + this.m_gameModel.m_readyY * this.CELL_LENGTH + this.CELL_LENGTH / 2 + fm.getAscent() / 2;
        g.drawString("READY ", x, y);
        g.setFont(this.m_readyFontItalic);
        g.drawString(" !!!", x += width1, y);
    }

    public void drawHideoutDoor(Graphics g) {
        g.setColor(Color.pink);
        g.fillRect(this.m_gridInset + (this.m_gameModel.m_doorLocX - 1) * this.CELL_LENGTH, this.m_gridInset + this.m_gameModel.m_doorLocY * this.CELL_LENGTH + this.WALL2 + this.WALL2 / 2, this.CELL_LENGTH * 4, this.WALL4 - this.WALL2);
    }

    public void drawGameCell(Graphics g, int x, int y, boolean bClearExtra) {
        int x1 = this.m_gridInset + x * this.CELL_LENGTH;
        int y1 = this.m_gridInset + y * this.CELL_LENGTH;
        Color wallColor = !this.m_bFlipWallColor ? this.m_wallColor : this.m_wallAltColor;
        g.setColor(Color.black);
        if (!bClearExtra) {
            g.fillRect(x1, y1, this.CELL_LENGTH, this.CELL_LENGTH);
        } else {
            g.fillRect(x1 - this.WALL1, y1 - this.WALL1, this.CELL_LENGTH + this.WALL1 * 2, this.CELL_LENGTH + this.WALL1 * 2);
        }
        g.setColor(wallColor);
        int gameCell = this.m_gameModel.m_gameState[x][y];
        if (y == this.m_gameModel.m_doorLocY && x >= this.m_gameModel.m_doorLocX - 1 && x <= this.m_gameModel.m_doorLocX + 2) {
            return;
        }
        if (this.m_bShowIntro) {
            return;
        }
        if ((gameCell & 0x400) != 0) {
            g.fillRect(x1, y1, this.CELL_LENGTH, this.WALL1);
        }
        if ((gameCell & 0x1000) != 0) {
            if (y != 0 && (this.m_gameModel.m_gameState[x][y - 1] & 0x8000) != 0) {
                g.fillArc(x1 - this.WALL1, y1 + this.CELL_LENGTH - this.WALL1, this.WALL1 * 2, this.WALL1 * 2, 0, 90);
            } else if (y != this.m_gameModel.m_gameSizeY - 1 && (this.m_gameModel.m_gameState[x][y + 1] & 0x8000) != 0) {
                g.fillArc(x1 - this.WALL1, y1 - this.WALL1, this.WALL1 * 2, this.WALL1 * 2, 0, -90);
            } else {
                g.fillRect(x1, y1, this.WALL1, this.CELL_LENGTH);
            }
        }
        if ((gameCell & 0x2000) != 0) {
            g.fillRect(x1, y1 + this.CELL_LENGTH - this.WALL1, this.CELL_LENGTH, this.WALL1);
        }
        if ((gameCell & 0x4000) != 0) {
            if (y != 0 && (this.m_gameModel.m_gameState[x][y - 1] & 0x8000) != 0) {
                g.fillArc(x1 + this.CELL_LENGTH - this.WALL1, y1 + this.CELL_LENGTH - this.WALL1, this.WALL1 * 2, this.WALL1 * 2, 180, -90);
            } else if (y != this.m_gameModel.m_gameSizeY - 1 && (this.m_gameModel.m_gameState[x][y + 1] & 0x8000) != 0) {
                g.fillArc(x1 + this.CELL_LENGTH - this.WALL1, y1 - this.WALL1, this.WALL1 * 2, this.WALL1 * 2, 180, 90);
            } else {
                g.fillRect(x1 + this.CELL_LENGTH - this.WALL1, y1, this.WALL1, this.CELL_LENGTH);
            }
        }
        if ((gameCell & 0x8000) != 0) {
            g.fillRect(x1, y1 + this.WALL2, this.CELL_LENGTH, this.WALL4 - this.WALL2);
        }
        if ((gameCell & 0x10000) != 0) {
            g.fillRect(x1 + this.WALL2, y1, this.WALL4 - this.WALL2, this.CELL_LENGTH);
        }
        if ((gameCell & 0x40) != 0) {
            if ((gameCell & 0x2000) != 0 && (gameCell & 0x4000) != 0) {
                g.setColor(Color.black);
                g.fillRect(x1, y1 + this.CELL_LENGTH - this.WALL1, this.CELL_LENGTH, this.WALL1);
                g.fillRect(x1 + this.CELL_LENGTH - this.WALL1, y1, this.WALL1, this.CELL_LENGTH);
                g.setColor(wallColor);
                g.fillArc(x1 - this.CELL_LENGTH, y1 - this.CELL_LENGTH, this.CELL_LENGTH * 2, this.CELL_LENGTH * 2, 0, -90);
                g.setColor(Color.black);
                g.fillArc(x1 - this.CELL_LENGTH + this.WALL1, y1 - this.CELL_LENGTH + this.WALL1, this.WALL5 * 2, this.WALL5 * 2, 0, -90);
                g.setColor(wallColor);
            }
            g.fillArc(x1 - this.WALL4, y1 - this.WALL4, this.WALL4 * 2, this.WALL4 * 2, 0, -90);
            g.setColor(Color.black);
            g.fillArc(x1 - this.WALL2, y1 - this.WALL2, this.WALL2 * 2, this.WALL2 * 2, 0, -90);
            g.setColor(wallColor);
            if (x != 0 && y != 0 && (this.m_gameModel.m_gameState[x - 1][y] & 0x400) != 0 && (this.m_gameModel.m_gameState[x][y - 1] & 0x1000) != 0) {
                g.fillArc(x1 - this.WALL1, y1 - this.WALL1, this.WALL1 * 2, this.WALL1 * 2, 0, -90);
            }
            if (x == 0 && y != 0 && (this.m_gameModel.m_gameState[x][y - 1] & 0x1000) != 0) {
                g.fillArc(x1 - this.WALL1, y1 - this.WALL1, this.WALL1 * 2, this.WALL1 * 2, 0, -90);
            }
        }
        if ((gameCell & 0x80) != 0) {
            if ((gameCell & 0x400) != 0 && (gameCell & 0x4000) != 0) {
                g.setColor(Color.black);
                g.fillRect(x1, y1, this.CELL_LENGTH, this.WALL1);
                g.fillRect(x1 + this.CELL_LENGTH - this.WALL1, y1, this.WALL1, this.CELL_LENGTH);
                g.setColor(wallColor);
                g.fillArc(x1 - this.CELL_LENGTH, y1, this.CELL_LENGTH * 2, this.CELL_LENGTH * 2, 0, 90);
                g.setColor(Color.black);
                g.fillArc(x1 - this.CELL_LENGTH + this.WALL1, y1 + this.WALL1, this.WALL5 * 2, this.WALL5 * 2, 0, 90);
                g.setColor(wallColor);
            }
            g.fillArc(x1 - this.WALL4, y1 + this.CELL_LENGTH - this.WALL4, this.WALL4 * 2, this.WALL4 * 2, 0, 90);
            g.setColor(Color.black);
            g.fillArc(x1 - this.WALL2, y1 + this.CELL_LENGTH - this.WALL2, this.WALL2 * 2, this.WALL2 * 2, 0, 90);
            g.setColor(wallColor);
            if (x != 0 && y != this.m_gameModel.m_gameSizeY - 1 && (this.m_gameModel.m_gameState[x - 1][y] & 0x2000) != 0 && (this.m_gameModel.m_gameState[x][y + 1] & 0x1000) != 0) {
                g.fillArc(x1 - this.WALL1, y1 + this.CELL_LENGTH - this.WALL1, this.WALL1 * 2, this.WALL1 * 2, 0, 90);
            }
            if (x == 0 && y != this.m_gameModel.m_gameSizeY - 1 && (this.m_gameModel.m_gameState[x][y + 1] & 0x1000) != 0) {
                g.fillArc(x1 - this.WALL1, y1 + this.CELL_LENGTH - this.WALL1, this.WALL1 * 2, this.WALL1 * 2, 0, 90);
            }
        }
        if ((gameCell & 0x100) != 0) {
            if ((gameCell & 0x400) != 0 && (gameCell & 0x1000) != 0) {
                g.setColor(Color.black);
                g.fillRect(x1, y1, this.CELL_LENGTH, this.WALL1);
                g.fillRect(x1, y1, this.WALL1, this.CELL_LENGTH);
                g.setColor(wallColor);
                g.fillArc(x1, y1, this.CELL_LENGTH * 2, this.CELL_LENGTH * 2, 90, 90);
                g.setColor(Color.black);
                g.fillArc(x1 + this.WALL1, y1 + this.WALL1, this.WALL5 * 2, this.WALL5 * 2, 90, 90);
                g.setColor(wallColor);
            }
            g.fillArc(x1 + this.CELL_LENGTH - this.WALL4, y1 + this.CELL_LENGTH - this.WALL4, this.WALL4 * 2, this.WALL4 * 2, -180, -90);
            g.setColor(Color.black);
            g.fillArc(x1 + this.CELL_LENGTH - this.WALL2, y1 + this.CELL_LENGTH - this.WALL2, this.WALL2 * 2, this.WALL2 * 2, -180, -90);
            g.setColor(wallColor);
            if (x != this.m_gameModel.m_gameSizeX - 1 && y != this.m_gameModel.m_gameSizeY - 1 && (this.m_gameModel.m_gameState[x][y + 1] & 0x4000) != 0 && (this.m_gameModel.m_gameState[x + 1][y] & 0x2000) != 0) {
                g.fillArc(x1 + this.CELL_LENGTH - this.WALL1, y1 + this.CELL_LENGTH - this.WALL1, this.WALL1 * 2, this.WALL1 * 2, 90, 90);
            }
            if (x == this.m_gameModel.m_gameSizeX - 1 && y != this.m_gameModel.m_gameSizeY - 1 && (this.m_gameModel.m_gameState[x][y + 1] & 0x4000) != 0) {
                g.fillArc(x1 + this.CELL_LENGTH - this.WALL1, y1 + this.CELL_LENGTH - this.WALL1, this.WALL1 * 2, this.WALL1 * 2, 90, 90);
            }
        }
        if ((gameCell & 0x200) != 0) {
            if ((gameCell & 0x2000) != 0 && (gameCell & 0x1000) != 0) {
                g.setColor(Color.black);
                g.fillRect(x1, y1 + this.CELL_LENGTH - this.WALL1, this.CELL_LENGTH, this.WALL1);
                g.fillRect(x1, y1, this.WALL1, this.CELL_LENGTH);
                g.setColor(wallColor);
                g.fillArc(x1, y1 - this.CELL_LENGTH, this.CELL_LENGTH * 2, this.CELL_LENGTH * 2, 180, 90);
                g.setColor(Color.black);
                g.fillArc(x1 + this.WALL1, y1 - this.CELL_LENGTH + this.WALL1, this.WALL5 * 2, this.WALL5 * 2, 180, 90);
                g.setColor(wallColor);
            }
            g.fillArc(x1 + this.CELL_LENGTH - this.WALL4, y1 - this.WALL4, this.WALL4 * 2, this.WALL4 * 2, -180, 90);
            g.setColor(Color.black);
            g.fillArc(x1 + this.CELL_LENGTH - this.WALL2, y1 - this.WALL2, this.WALL2 * 2, this.WALL2 * 2, -180, 90);
            g.setColor(wallColor);
            if (x != this.m_gameModel.m_gameSizeX - 1 && y != 0 && (this.m_gameModel.m_gameState[x + 1][y] & 0x400) != 0 && (this.m_gameModel.m_gameState[x][y - 1] & 0x4000) != 0) {
                g.fillArc(x1 + this.CELL_LENGTH - this.WALL1, y1 - this.WALL1, this.WALL1 * 2, this.WALL1 * 2, 180, 90);
            }
            if (x == this.m_gameModel.m_gameSizeX - 1 && y != 0 && (this.m_gameModel.m_gameState[x][y - 1] & 0x4000) != 0) {
                g.fillArc(x1 + this.CELL_LENGTH - this.WALL1, y1 - this.WALL1, this.WALL1 * 2, this.WALL1 * 2, 180, 90);
            }
        }
        if ((gameCell & 0x10) != 0) {
            g.setColor(Color.pink);
            g.fillOval(x1 + this.WALL2, y1 + this.WALL2, this.WALL1, this.WALL1);
            g.setColor(wallColor);
        }
        if ((gameCell & 0x20) != 0) {
            if (this.m_gameModel.m_pacMan.m_globalTickCount % (1000 / this.m_pacMan.m_delay) > 200 / this.m_pacMan.m_delay) {
                g.setColor(Color.pink);
            } else {
                g.setColor(Color.black);
            }
            g.fillOval(x1, y1, this.CELL_LENGTH, this.CELL_LENGTH);
            g.setColor(wallColor);
        }
    }

    public void redrawLastLocation(Graphics g, Thing thing) {
        if (thing.m_lastLocX < 0 && thing.m_lastLocY < 0) {
            return;
        }
        if (thing.m_lastDeltaLocX < 0 && thing.m_lastLocX != 0) {
            this.drawGameCell(g, thing.m_lastLocX - 1, thing.m_lastLocY, true);
        } else if (thing.m_lastDeltaLocX > 0 && thing.m_lastLocX != this.m_gameModel.m_gameSizeX - 1) {
            this.drawGameCell(g, thing.m_lastLocX + 1, thing.m_lastLocY, true);
        } else if (thing.m_lastDeltaLocY < 0 && thing.m_lastLocY != 0) {
            this.drawGameCell(g, thing.m_lastLocX, thing.m_lastLocY - 1, true);
        } else if (thing.m_lastDeltaLocY > 0 && thing.m_lastLocY != this.m_gameModel.m_gameSizeY - 1) {
            this.drawGameCell(g, thing.m_lastLocX, thing.m_lastLocY + 1, true);
        }
        this.drawGameCell(g, thing.m_lastLocX, thing.m_lastLocY, true);
    }

    public void setRedraw(boolean b) {
        this.m_bRedrawAll = b;
    }
}

