/*
 * Decompiled with CFR 0.152.
 */
package pacman.classes;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pacman.aspects.MSDAspectGhostEaten;
import pacman.aspects.MSDAspectGhostEatsPacman;
import pacman.aspects.MSDAspectGhostFleeing;
import pacman.aspects.MSDAspectGhostStopsFleeing;
import pacman.aspects.MSDAspectPacmanEatsGhost;
import pacman.aspects.MSDCoordinatorAspect;
import pacman.classes.GameControl;
import pacman.classes.GameModel;
import pacman.classes.GameUI;
import pacman.classes.Player;
import pacman.classes.Thing;

public class Ghost
extends Thing {
    int[] m_ghostMouthX;
    int[] m_ghostMouthY;
    Polygon m_ghostPolygon;
    Polygon m_ghostPolygon2;
    boolean m_bOtherPolygon = false;
    int m_lastDirection;
    int m_destinationX;
    int m_destinationY;
    Color m_color;
    int m_nTicks2Exit;
    int m_nExitMilliSec;
    int m_nTicks2Flee = 0;
    boolean m_bEaten = false;
    int m_ghostDeltaMax = 4;
    int m_eatenPoints;
    int m_nTicks2Popup;
    boolean m_bEnteringDoor = false;
    boolean m_bCanFollow = false;
    boolean m_bCanPredict = true;
    boolean m_bCanBackTrack = false;
    boolean m_bCanUseNextBest = true;
    boolean m_bInsaneAI = false;
    private Rectangle intersectRect;
    public int state = -1;
    public static final int EATEN = 0;
    public static final int FREE = 1;
    public static final int JAIL = 2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;

    Ghost(GameModel gameModel, byte type, int startX, int startY, boolean bMiddle, Color color, int nExitMilliSec) {
        super(gameModel, type, startX, startY, bMiddle);
        this.m_deltaMax = this.m_ghostDeltaMax;
        this.m_destinationX = -1;
        this.m_destinationY = -1;
        this.m_color = color;
        this.m_bInsideRoom = true;
        this.m_nExitMilliSec = nExitMilliSec;
        this.m_nTicks2Exit = this.m_nExitMilliSec / gameModel.m_pacMan.m_delay;
    }

    @Override
    public void draw(GameUI gameUI, Graphics g2) {
        if (!this.m_bVisible) {
            return;
        }
        int ghostHeadDiameter = gameUI.CELL_LENGTH + gameUI.WALL1 + gameUI.WALL1;
        int ghostLegHalf = ghostHeadDiameter / 2;
        int ghostLegQuarter = ghostHeadDiameter / 4;
        int ghostLegUnit = ghostLegQuarter / 4;
        int ghostLegHeight = ghostLegQuarter * 3 / 4;
        if (this.m_ghostPolygon == null) {
            int[] nArray = new int[14];
            nArray[2] = ghostLegUnit;
            nArray[3] = ghostLegQuarter - ghostLegUnit;
            nArray[4] = ghostLegQuarter + ghostLegUnit;
            nArray[5] = ghostLegHalf - ghostLegUnit - ghostLegUnit;
            nArray[6] = ghostLegHalf - ghostLegUnit - ghostLegUnit;
            nArray[7] = ghostLegHalf + ghostLegUnit + ghostLegUnit;
            nArray[8] = ghostLegHalf + ghostLegUnit + ghostLegUnit;
            nArray[9] = ghostLegHalf + ghostLegQuarter - ghostLegUnit;
            nArray[10] = ghostLegHalf + ghostLegQuarter + ghostLegUnit;
            nArray[11] = ghostHeadDiameter - ghostLegUnit;
            nArray[12] = ghostHeadDiameter;
            nArray[13] = ghostHeadDiameter;
            int[] xPoints = nArray;
            int[] yPoints = new int[]{ghostHeadDiameter / 2, ghostHeadDiameter, ghostHeadDiameter, ghostHeadDiameter - ghostLegHeight, ghostHeadDiameter, ghostHeadDiameter, ghostHeadDiameter - ghostLegHeight, ghostHeadDiameter - ghostLegHeight, ghostHeadDiameter, ghostHeadDiameter, ghostHeadDiameter - ghostLegHeight, ghostHeadDiameter, ghostHeadDiameter, ghostHeadDiameter / 2};
            int[] nArray2 = new int[12];
            nArray2[2] = ghostLegUnit;
            nArray2[3] = ghostLegQuarter - ghostLegUnit;
            nArray2[4] = ghostLegQuarter;
            nArray2[5] = ghostLegHalf - ghostLegUnit - ghostLegUnit;
            nArray2[6] = ghostLegHalf + ghostLegUnit + ghostLegUnit;
            nArray2[7] = ghostLegHalf + ghostLegQuarter;
            nArray2[8] = ghostHeadDiameter - ghostLegQuarter + ghostLegUnit;
            nArray2[9] = ghostHeadDiameter - ghostLegUnit;
            nArray2[10] = ghostHeadDiameter;
            nArray2[11] = ghostHeadDiameter;
            int[] xPoints2 = nArray2;
            int[] yPoints2 = new int[]{ghostHeadDiameter / 2, ghostHeadDiameter - ghostLegHeight, ghostHeadDiameter, ghostHeadDiameter, ghostHeadDiameter - ghostLegHeight, ghostHeadDiameter, ghostHeadDiameter, ghostHeadDiameter - ghostLegHeight, ghostHeadDiameter, ghostHeadDiameter, ghostHeadDiameter - ghostLegHeight, ghostHeadDiameter / 2};
            this.m_ghostPolygon = new Polygon(xPoints, yPoints, xPoints.length);
            this.m_ghostPolygon2 = new Polygon(xPoints2, yPoints2, xPoints2.length);
            int ghostMouthHalf = ghostHeadDiameter / 2;
            int ghostMouthQuarter = ghostMouthHalf / 2;
            int ghostMouthTeeth = ghostMouthQuarter / 2;
            int ghostMouthY1 = ghostHeadDiameter / 2 + ghostHeadDiameter / 4;
            int ghostMouthY2 = ghostHeadDiameter / 2 + ghostHeadDiameter / 7;
            this.m_ghostMouthX = new int[7];
            this.m_ghostMouthX[0] = ghostMouthTeeth;
            this.m_ghostMouthX[1] = ghostMouthQuarter;
            this.m_ghostMouthX[2] = ghostMouthQuarter + ghostMouthTeeth;
            this.m_ghostMouthX[3] = ghostMouthHalf;
            this.m_ghostMouthX[4] = ghostMouthHalf + ghostMouthTeeth;
            this.m_ghostMouthX[5] = ghostMouthHalf + ghostMouthQuarter;
            this.m_ghostMouthX[6] = ghostMouthHalf + ghostMouthQuarter + ghostMouthTeeth;
            this.m_ghostMouthY = new int[7];
            this.m_ghostMouthY[0] = ghostMouthY1;
            this.m_ghostMouthY[1] = ghostMouthY2;
            this.m_ghostMouthY[2] = ghostMouthY1;
            this.m_ghostMouthY[3] = ghostMouthY2;
            this.m_ghostMouthY[4] = ghostMouthY1;
            this.m_ghostMouthY[5] = ghostMouthY2;
            this.m_ghostMouthY[6] = ghostMouthY1;
        }
        int ghostX = gameUI.m_gridInset + (int)((double)(this.m_locX * gameUI.CELL_LENGTH) - (double)ghostHeadDiameter / 2.0 + (double)gameUI.CELL_LENGTH / 2.0 + (double)this.m_deltaLocX * ((double)gameUI.CELL_LENGTH / ((double)this.m_deltaMax * 2.0 - 1.0)));
        int ghostY = gameUI.m_gridInset + (int)((double)(this.m_locY * gameUI.CELL_LENGTH) - (double)ghostHeadDiameter / 2.0 + (double)gameUI.CELL_LENGTH / 2.0 + (double)this.m_deltaLocY * ((double)gameUI.CELL_LENGTH / ((double)this.m_deltaMax * 2.0 - 1.0)));
        if (this.m_nTicks2Popup > 0) {
            g2.setColor(Color.cyan);
            g2.setFont(this.m_gameModel.m_pacMan.m_gameUI.m_font);
            FontMetrics fm = g2.getFontMetrics();
            g2.drawString(Integer.toString(this.m_eatenPoints), ghostX, ghostY + fm.getAscent());
            this.m_gameModel.m_pacMan.m_gameUI.m_bRedrawAll = true;
            return;
        }
        if (this.m_nTicks2Flee == 0) {
            g2.setColor(this.m_color);
        } else if (this.m_nTicks2Flee < 2000 / this.m_gameModel.m_pacMan.m_delay && this.m_nTicks2Flee % (200 / this.m_gameModel.m_pacMan.m_delay) < 100 / this.m_gameModel.m_pacMan.m_delay) {
            g2.setColor(Color.white);
        } else {
            g2.setColor(Color.blue);
        }
        if (!this.m_bEaten) {
            Polygon polygon;
            g2.fillArc(ghostX, ghostY, ghostHeadDiameter, ghostHeadDiameter, 0, 180);
            if (!this.m_bOtherPolygon) {
                polygon = new Polygon(this.m_ghostPolygon.xpoints, this.m_ghostPolygon.ypoints, this.m_ghostPolygon.npoints);
                polygon.translate(ghostX, ghostY);
            } else {
                polygon = new Polygon(this.m_ghostPolygon2.xpoints, this.m_ghostPolygon2.ypoints, this.m_ghostPolygon2.npoints);
                polygon.translate(ghostX, ghostY);
            }
            if (this.m_gameModel.m_pacMan.m_globalTickCount % (this.m_ghostDeltaMax * 2) == 0) {
                this.m_bOtherPolygon = !this.m_bOtherPolygon;
            }
            g2.fillPolygon(polygon);
        }
        double crossEyeDelta = 1.0;
        double ghostEyeWidth = (double)ghostHeadDiameter / 2.7;
        double ghostEyeHeight = (double)ghostHeadDiameter / 2.0;
        double ghostEyeX = 0.0;
        double ghostEyeY = 0.0;
        double ghostEyeDiameter = (double)ghostHeadDiameter / 5.0;
        double ghostEyeBallX = 0.0;
        double ghostEyeBallY = 0.0;
        if (this.m_nTicks2Flee > 0 && !this.m_bEaten) {
            crossEyeDelta = 2.0;
            ghostEyeX = (double)ghostX + (double)ghostHeadDiameter / 4.0 - ghostEyeWidth / 2.0;
            ghostEyeY = (double)ghostY + (double)ghostHeadDiameter / 7.0;
            ghostEyeBallX = ghostEyeX + ghostEyeWidth / 2.0 - ghostEyeDiameter / 2.0;
            ghostEyeBallY = ghostEyeY + ghostEyeHeight / 2.0 - ghostEyeDiameter / 2.0;
        } else if (this.m_direction == 0) {
            ghostEyeX = (double)ghostX + (double)ghostHeadDiameter / 4.0 - ghostEyeWidth / 2.0;
            ghostEyeY = (double)ghostY + (double)ghostHeadDiameter / 5.0;
            ghostEyeBallX = ghostEyeX + ghostEyeWidth - ghostEyeDiameter;
            ghostEyeBallY = ghostEyeY + ghostEyeHeight / 2.0 - ghostEyeDiameter / 2.0;
        } else if (this.m_direction == 1) {
            if (!this.m_bEaten) {
                ghostEyeHeight = (double)ghostHeadDiameter / 3.0;
            }
            ghostEyeX = (double)ghostX + (double)ghostHeadDiameter / 4.0 - ghostEyeWidth / 2.0;
            ghostEyeY = (double)ghostY + (double)ghostHeadDiameter / 7.0;
            ghostEyeBallX = ghostEyeX + ghostEyeWidth / 2.0 - ghostEyeDiameter / 2.0;
            ghostEyeBallY = ghostEyeY;
        } else if (this.m_direction == 3) {
            ghostEyeX = (double)ghostX + (double)ghostHeadDiameter / 4.0 - ghostEyeWidth / 2.0;
            ghostEyeY = (double)ghostY + (double)ghostHeadDiameter / 5.0;
            ghostEyeBallX = ghostEyeX;
            ghostEyeBallY = ghostEyeY + ghostEyeHeight / 2.0 - ghostEyeDiameter / 2.0;
        } else if (this.m_direction == 4) {
            ghostEyeX = (double)ghostX + (double)ghostHeadDiameter / 4.0 - ghostEyeWidth / 2.0;
            ghostEyeY = (double)ghostY + (double)ghostHeadDiameter / 5.0;
            ghostEyeBallX = ghostEyeX + ghostEyeWidth - ghostEyeDiameter;
            ghostEyeBallY = ghostEyeY + ghostEyeHeight / 2.0 - ghostEyeDiameter / 2.0;
        } else if (this.m_direction == 2) {
            ghostEyeX = (double)ghostX + (double)ghostHeadDiameter / 4.0 - ghostEyeWidth / 2.0;
            ghostEyeY = (double)ghostY + (double)ghostHeadDiameter / 4.0;
            ghostEyeBallX = ghostEyeX + ghostEyeWidth / 2.0 - ghostEyeDiameter / 2.0;
            ghostEyeBallY = ghostEyeY + ghostEyeHeight - ghostEyeDiameter;
        }
        if (this.m_nTicks2Flee == 0 && !this.m_bEaten) {
            g2.setColor(Color.white);
            g2.fillOval((int)(ghostEyeX + crossEyeDelta), (int)ghostEyeY, (int)ghostEyeWidth, (int)ghostEyeHeight);
            g2.fillOval((int)(ghostEyeX + (double)ghostHeadDiameter / 2.0 - crossEyeDelta), (int)ghostEyeY, (int)ghostEyeWidth, (int)ghostEyeHeight);
            if (this.m_bInsaneAI) {
                g2.setColor(Color.red);
            } else {
                g2.setColor(Color.blue);
            }
            g2.fillRoundRect((int)(ghostEyeBallX + crossEyeDelta), (int)ghostEyeBallY, (int)ghostEyeDiameter, (int)ghostEyeDiameter, (int)ghostEyeDiameter, (int)ghostEyeDiameter);
            g2.fillRoundRect((int)(ghostEyeBallX + (double)ghostHeadDiameter / 2.0 - crossEyeDelta), (int)ghostEyeBallY, (int)ghostEyeDiameter, (int)ghostEyeDiameter, (int)ghostEyeDiameter, (int)ghostEyeDiameter);
        } else if (this.m_nTicks2Flee > 0 && !this.m_bEaten) {
            g2.setColor(Color.lightGray);
            g2.fillRoundRect((int)(ghostEyeBallX + crossEyeDelta), (int)ghostEyeBallY, (int)ghostEyeDiameter, (int)ghostEyeDiameter, (int)ghostEyeDiameter, (int)ghostEyeDiameter);
            g2.fillRoundRect((int)(ghostEyeBallX + (double)ghostHeadDiameter / 2.0 - crossEyeDelta), (int)ghostEyeBallY, (int)ghostEyeDiameter, (int)ghostEyeDiameter, (int)ghostEyeDiameter, (int)ghostEyeDiameter);
            int i = 0;
            while (i < this.m_ghostMouthX.length - 1) {
                g2.drawLine(ghostX + this.m_ghostMouthX[i], ghostY + this.m_ghostMouthY[i], ghostX + this.m_ghostMouthX[i + 1], ghostY + this.m_ghostMouthY[i + 1]);
                g2.drawLine(ghostX + this.m_ghostMouthX[i] - 1, ghostY + this.m_ghostMouthY[i], ghostX + this.m_ghostMouthX[i + 1] - 1, ghostY + this.m_ghostMouthY[i + 1]);
                ++i;
            }
        } else {
            g2.setColor(Color.lightGray);
            g2.fillOval((int)(ghostEyeX + crossEyeDelta), (int)ghostEyeY, (int)ghostEyeWidth, (int)ghostEyeHeight);
            g2.fillOval((int)(ghostEyeX + (double)ghostHeadDiameter / 2.0 - crossEyeDelta), (int)ghostEyeY, (int)ghostEyeWidth, (int)ghostEyeHeight);
            g2.setColor(Color.blue);
            g2.fillRoundRect((int)(ghostEyeBallX + crossEyeDelta), (int)ghostEyeBallY, (int)ghostEyeDiameter, (int)ghostEyeDiameter, (int)ghostEyeDiameter, (int)ghostEyeDiameter);
            g2.fillRoundRect((int)(ghostEyeBallX + (double)ghostHeadDiameter / 2.0 - crossEyeDelta), (int)ghostEyeBallY, (int)ghostEyeDiameter, (int)ghostEyeDiameter, (int)ghostEyeDiameter, (int)ghostEyeDiameter);
        }
        this.m_boundingBox.setBounds(ghostX, ghostY, ghostHeadDiameter, ghostHeadDiameter);
        this.m_boundingBox.grow(-ghostHeadDiameter / 4, -ghostHeadDiameter / 4);
    }

    @Override
    public void tickThing() {
        boolean bBackoff = false;
        byte prevDirection = 0;
        if (this.m_nTicks2Popup > 0) {
            --this.m_nTicks2Popup;
            if (this.m_nTicks2Popup == 0) {
                boolean bl = false;
                GameModel gameModel = this.m_gameModel;
                JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, (Object)this, (Object)gameModel, Conversions.booleanObject(bl));
                try {
                    gameModel.setPausedGame(bl);
                }
                finally {
                    MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
                }
                this.m_gameModel.m_player.setVisible(true);
                this.m_gameModel.m_pacMan.m_soundMgr.playSound(4);
            }
        }
        if (this.m_nTicks2Exit > 0) {
            --this.m_nTicks2Exit;
            if (this.m_nTicks2Exit == 0) {
                this.m_destinationX = -1;
                this.m_destinationY = -1;
            }
        }
        if (this.m_nTicks2Flee > 0) {
            --this.m_nTicks2Flee;
            if (this.m_nTicks2Flee == 0 && !this.m_bEaten) {
                this.stopFleeing();
                this.speedUp();
                Ghost ghost = this;
                GameControl gameControl = this.m_gameModel.m_pacMan;
                JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)gameControl, ghost);
                try {
                    try {
                        try {
                            gameControl.ghostStoppedFleeing(ghost);
                        }
                        finally {
                            MSDAspectGhostStopsFleeing.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostStopsFleeing$5$80858b13(this, gameControl);
                        }
                    }
                    finally {
                        MSDAspectGhostFleeing.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostFleeing$4$80858b13(this, gameControl);
                    }
                }
                finally {
                    MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
                }
                this.setNormalShape(true);
            }
        }
        if (this.m_bEaten && this.m_locX == this.m_gameModel.m_doorLocX && this.m_locY == this.m_gameModel.m_doorLocY - 1 && this.m_deltaLocX == 0 && this.m_deltaLocY == 0) {
            this.goToJail();
            Ghost ghost = this;
            GameModel gameModel = this.m_gameModel;
            JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, (Object)this, (Object)gameModel, ghost);
            try {
                try {
                    try {
                        gameModel.enteringJail(ghost);
                    }
                    finally {
                        MSDAspectGhostEaten.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostEaten$2$cfbfb1a9(this, gameModel);
                    }
                }
                finally {
                    MSDAspectPacmanEatsGhost.aspectOf().ajc$after$pacman_aspects_MSDAspectPacmanEatsGhost$1$cfbfb1a9(this, gameModel);
                }
            }
            finally {
                MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
            }
            this.setEyesOnly(false);
            return;
        }
        if (this.m_bEaten && this.m_locX == this.m_gameModel.m_doorLocX && this.m_locY == this.m_gameModel.m_doorLocY + 2 && this.m_deltaLocX == 0 && this.m_deltaLocY == 0) {
            this.m_destinationX = -1;
            this.m_destinationY = -1;
            this.m_direction = 0;
            this.m_nTicks2Exit = 3000 / this.m_gameModel.m_pacMan.m_delay;
            this.m_bEnteringDoor = false;
            this.m_bEaten = false;
            return;
        }
        if (this.m_bEnteringDoor) {
            this.m_destinationX = this.m_gameModel.m_doorLocX;
            this.m_destinationY = this.m_gameModel.m_doorLocY + 2;
            this.m_direction = (byte)2;
        }
        if (this.m_bInsideRoom && this.m_locX == this.m_gameModel.m_doorLocX && this.m_locY == this.m_gameModel.m_doorLocY + 2 && this.m_deltaLocX == 0 && this.m_deltaLocY == 0 && this.m_nTicks2Exit == 0) {
            this.leaveJail();
            Ghost ghost = this;
            GameModel gameModel = this.m_gameModel;
            JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)gameModel, ghost);
            try {
                try {
                    gameModel.leavingJail(ghost);
                }
                finally {
                    MSDAspectPacmanEatsGhost.aspectOf().ajc$after$pacman_aspects_MSDAspectPacmanEatsGhost$2$3c948523(this, gameModel);
                }
            }
            finally {
                MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
            }
            return;
        }
        if (!(this.m_gameModel.m_state != 4 || this.m_bInsideRoom || this.m_bEnteringDoor || this.m_bEaten || this.m_destinationX == this.m_gameModel.m_doorLocX || this.m_destinationY == this.m_gameModel.m_doorLocY - 1 || this.m_gameModel.m_pacMan.m_globalTickCount % this.m_gameModel.m_nTicks2Backoff != 0 || this.m_bInsaneAI)) {
            this.m_destinationX = -1;
            this.m_destinationY = -1;
            bBackoff = true;
        }
        if (this.m_destinationX >= 0 && this.m_destinationY >= 0) {
            if (this.m_destinationX == this.m_locX && this.m_destinationY == this.m_locY && this.m_deltaLocX == 0 && this.m_deltaLocY == 0) {
                this.m_destinationX = -1;
                this.m_destinationY = -1;
                prevDirection = this.m_direction;
            } else {
                return;
            }
        }
        if (bBackoff || !this.m_bEaten && this.m_bCanBackTrack) {
            prevDirection = 0;
        }
        this.setNextDirection(prevDirection, bBackoff);
    }

    private void setNormalShape(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        try {
            try {
            }
            finally {
                MSDAspectGhostStopsFleeing.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostStopsFleeing$6$e343fb07(this, bl2);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    private void speedUp() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, this, this);
        try {
            try {
                this.m_deltaMax = this.m_ghostDeltaMax;
            }
            finally {
                MSDAspectGhostStopsFleeing.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostStopsFleeing$2$ed40b9c0(this);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    private void stopFleeing() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, this, this);
        try {
            try {
                try {
                    this.m_bEaten = false;
                    this.state = 1;
                    this.m_destinationX = -1;
                    this.m_destinationY = -1;
                }
                finally {
                    MSDAspectGhostStopsFleeing.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostStopsFleeing$3$2267b428(this);
                }
            }
            finally {
                MSDAspectGhostFleeing.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostFleeing$2$2267b428(this);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    private void goToJail() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, this, this);
        try {
            try {
                try {
                    this.m_destinationX = this.m_gameModel.m_doorLocX;
                    this.m_destinationY = this.m_gameModel.m_doorLocY + 2;
                    this.m_direction = (byte)2;
                    this.m_deltaLocY = 1;
                    this.m_bInsideRoom = true;
                    this.state = 2;
                    this.m_nTicks2Flee = 0;
                    this.m_bEnteringDoor = true;
                    this.m_deltaMax = this.m_ghostDeltaMax;
                    this.stopFleeing();
                    this.speedUp();
                    Ghost ghost = this;
                    GameControl gameControl = this.m_gameModel.m_pacMan;
                    JoinPoint joinPoint2 = Factory.makeJP(ajc$tjp_7, (Object)this, (Object)gameControl, ghost);
                    try {
                        try {
                            try {
                                gameControl.ghostStoppedFleeing(ghost);
                            }
                            finally {
                                MSDAspectGhostStopsFleeing.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostStopsFleeing$5$80858b13(this, gameControl);
                            }
                        }
                        finally {
                            MSDAspectGhostFleeing.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostFleeing$4$80858b13(this, gameControl);
                        }
                    }
                    finally {
                        MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint2);
                    }
                    this.setNormalShape(true);
                }
                finally {
                    MSDAspectPacmanEatsGhost.aspectOf().ajc$after$pacman_aspects_MSDAspectPacmanEatsGhost$6$f052eaa5(this);
                }
            }
            finally {
                MSDAspectGhostEaten.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostEaten$5$f052eaa5(this);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    private void leaveJail() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, this, this);
        try {
            try {
                this.m_destinationX = this.m_locX;
                this.m_destinationY = this.m_gameModel.m_doorLocY - 1;
                this.m_direction = 1;
                this.m_deltaLocY = -1;
                this.m_bInsideRoom = false;
                this.m_bEnteringDoor = false;
                this.m_bEaten = false;
                this.state = 1;
                System.out.println("Going  OUT of JAIL!" + this);
            }
            finally {
                MSDAspectPacmanEatsGhost.aspectOf().ajc$after$pacman_aspects_MSDAspectPacmanEatsGhost$5$9e4f9c31(this);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    void setNextDirection(byte prevDirection, boolean bBackoff) {
        byte temp;
        int targetY;
        int targetX;
        Point nextLocation = new Point();
        byte[] bestDirection = new byte[4];
        if (this.m_bInsideRoom) {
            targetX = this.m_gameModel.m_doorLocX;
            targetY = this.m_gameModel.m_doorLocY;
        } else if (this.m_bEaten) {
            targetX = this.m_gameModel.m_doorLocX;
            targetY = this.m_gameModel.m_doorLocY - 1;
        } else if (!this.m_bInsaneAI && this.m_bCanPredict) {
            this.getDestination(this.m_gameModel.m_player.m_direction, this.m_gameModel.m_player.m_locX, this.m_gameModel.m_player.m_locY, nextLocation);
            targetX = nextLocation.x;
            targetY = nextLocation.y;
        } else {
            targetX = this.m_gameModel.m_player.m_locX;
            targetY = this.m_gameModel.m_player.m_locY;
        }
        int deltaX = this.m_locX - targetX;
        int deltaY = this.m_locY - targetY;
        if (Math.abs(deltaX) > Math.abs(deltaY)) {
            if (deltaX > 0) {
                bestDirection[0] = 3;
                bestDirection[3] = 4;
                if (deltaY > 0) {
                    bestDirection[1] = 1;
                    bestDirection[2] = 2;
                } else {
                    bestDirection[1] = 2;
                    bestDirection[2] = 1;
                }
            } else {
                bestDirection[0] = 4;
                bestDirection[3] = 3;
                if (deltaY > 0) {
                    bestDirection[1] = 1;
                    bestDirection[2] = 2;
                } else {
                    bestDirection[1] = 2;
                    bestDirection[2] = 1;
                }
            }
        } else if (deltaY > 0) {
            bestDirection[0] = 1;
            bestDirection[3] = 2;
            if (deltaX > 0) {
                bestDirection[1] = 3;
                bestDirection[2] = 4;
            } else {
                bestDirection[1] = 4;
                bestDirection[2] = 3;
            }
        } else {
            bestDirection[0] = 2;
            bestDirection[3] = 1;
            if (deltaX > 0) {
                bestDirection[1] = 3;
                bestDirection[2] = 4;
            } else {
                bestDirection[1] = 4;
                bestDirection[2] = 3;
            }
        }
        if (!this.m_bInsaneAI && this.m_bCanUseNextBest && Math.random() < 0.5) {
            temp = bestDirection[0];
            bestDirection[0] = bestDirection[1];
            bestDirection[1] = temp;
        }
        if (bBackoff || this.m_nTicks2Flee > 0 && !this.m_bEaten) {
            temp = bestDirection[0];
            bestDirection[0] = bestDirection[3];
            bestDirection[3] = temp;
            temp = bestDirection[1];
            bestDirection[1] = bestDirection[2];
            bestDirection[2] = temp;
        }
        int i = 0;
        while (i < 4) {
            if (bestDirection[i] == 1 && (this.m_gameModel.m_gameState[this.m_locX][this.m_locY] & 1) == 0 && this.m_deltaLocX == 0 && prevDirection != 2) {
                if (this.getDestination(1, this.m_locX, this.m_locY, nextLocation)) {
                    this.m_destinationX = nextLocation.x;
                    this.m_destinationY = nextLocation.y;
                    this.m_direction = 1;
                    if (this.m_bCanFollow || !this.isFollowing()) {
                        break;
                    }
                }
            } else if (bestDirection[i] == 2 && (this.m_gameModel.m_gameState[this.m_locX][this.m_locY] & 4) == 0 && this.m_deltaLocX == 0 && prevDirection != 1) {
                if (this.getDestination(2, this.m_locX, this.m_locY, nextLocation)) {
                    this.m_destinationX = nextLocation.x;
                    this.m_destinationY = nextLocation.y;
                    this.m_direction = (byte)2;
                    if (this.m_bCanFollow || !this.isFollowing()) {
                        break;
                    }
                }
            } else if (bestDirection[i] == 4 && (this.m_gameModel.m_gameState[this.m_locX][this.m_locY] & 2) == 0 && this.m_deltaLocY == 0 && prevDirection != 3) {
                if (this.getDestination(4, this.m_locX, this.m_locY, nextLocation)) {
                    this.m_destinationX = nextLocation.x;
                    this.m_destinationY = nextLocation.y;
                    this.m_direction = (byte)4;
                    if (this.m_bCanFollow || !this.isFollowing()) {
                        break;
                    }
                }
            } else if (bestDirection[i] == 3 && (this.m_gameModel.m_gameState[this.m_locX][this.m_locY] & 8) == 0 && this.m_deltaLocY == 0 && prevDirection != 4 && this.getDestination(3, this.m_locX, this.m_locY, nextLocation)) {
                this.m_destinationX = nextLocation.x;
                this.m_destinationY = nextLocation.y;
                this.m_direction = (byte)3;
                if (this.m_bCanFollow || !this.isFollowing()) break;
            }
            ++i;
        }
    }

    boolean isFollowing() {
        boolean bFollowing = false;
        int i = 0;
        while (i < this.m_gameModel.m_ghosts.length) {
            if (this != this.m_gameModel.m_ghosts[i] && this.m_gameModel.m_ghosts[i].m_locX == this.m_locX && this.m_gameModel.m_ghosts[i].m_locY == this.m_locY && this.m_gameModel.m_ghosts[i].m_direction == this.m_direction) {
                return true;
            }
            ++i;
        }
        double dRandom = Math.random();
        if (!this.m_bInsaneAI && dRandom < 0.9) {
            return false;
        }
        i = 0;
        while (i < this.m_gameModel.m_ghosts.length) {
            if (this != this.m_gameModel.m_ghosts[i] && this.m_gameModel.m_ghosts[i].m_destinationX == this.m_destinationX && this.m_gameModel.m_ghosts[i].m_destinationY == this.m_destinationY && this.m_gameModel.m_ghosts[i].m_direction == this.m_direction) {
                bFollowing = true;
                break;
            }
            ++i;
        }
        return bFollowing;
    }

    @Override
    public int checkCollision(Player player) {
        return this.checkGhostCollision(player);
    }

    public int checkGhostCollision(Player player) {
        this.intersectRect = this.m_boundingBox.intersection(player.m_boundingBox);
        if (!this.intersectRect.isEmpty()) {
            if (this.m_nTicks2Flee == 0 && !this.m_bEaten) {
                player.m_direction = 0;
                return 2;
            }
            if (this.m_nTicks2Flee > 0 && !this.m_bEaten) {
                return 1;
            }
        }
        return 0;
    }

    public boolean isEaten() {
        return !this.intersectRect.isEmpty() && this.m_nTicks2Flee > 0 && !this.m_bEaten;
    }

    public boolean isEatingPacman() {
        return !this.intersectRect.isEmpty() && this.m_nTicks2Flee == 0 && !this.m_bEaten;
    }

    public void eatenByPacman(Player player) {
        this.m_eatenPoints = this.m_gameModel.m_eatGhostPoints;
        this.m_bEaten = true;
        this.state = 0;
        this.m_destinationX = -1;
        this.m_destinationY = -1;
        this.m_deltaMax = 2;
        boolean bl = true;
        GameModel gameModel = this.m_gameModel;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, (Object)this, (Object)gameModel, Conversions.booleanObject(bl));
        try {
            gameModel.setPausedGame(bl);
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
        this.m_nTicks2Popup = 500 / this.m_gameModel.m_pacMan.m_delay;
        player.setVisible(false);
    }

    public void eatenByPacman1(Player player) {
        int score;
        int n;
        GameModel gameModel = this.m_gameModel;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_11, this, gameModel);
        try {
            try {
                n = gameModel.getGhostScore();
            }
            finally {
                MSDAspectGhostEaten.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostEaten$3$68cd3f2e(this, gameModel);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
        int n2 = score = n;
        Player player2 = player;
        JoinPoint joinPoint2 = Factory.makeJP(ajc$tjp_12, (Object)this, (Object)player2, Conversions.intObject(n2));
        try {
            try {
                player2.increaseScore(n2);
            }
            finally {
                MSDAspectGhostEaten.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostEaten$4$f2b8052b(this, player2);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint2);
        }
        GameModel gameModel2 = this.m_gameModel;
        JoinPoint joinPoint3 = Factory.makeJP(ajc$tjp_13, this, gameModel2);
        try {
            try {
                gameModel2.doubleGhostScore();
            }
            finally {
                MSDAspectGhostEaten.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostEaten$6$e020fbd9(this, gameModel2);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint3);
        }
        this.setEyesOnly(true);
    }

    private void setEyesOnly(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_14, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        try {
            try {
            }
            finally {
                MSDAspectGhostEaten.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostEaten$1$9b57c804(this, bl2);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    @Override
    public void returnToStart() {
        super.returnToStart();
        this.m_destinationX = -1;
        this.m_destinationY = -1;
        this.m_bInsideRoom = this.m_gameModel.m_ghosts[0] != this;
        this.m_nTicks2Exit = this.m_nExitMilliSec / this.m_gameModel.m_pacMan.m_delay;
        this.m_deltaMax = this.m_ghostDeltaMax;
        this.m_nTicks2Flee = 0;
        this.m_bEaten = false;
        this.m_nTicks2Popup = 0;
        this.m_bEnteringDoor = false;
    }

    public void collidedWithPacman() {
    }

    public void eatPacman() {
    }

    public void eatPacman2(Player player, GameControl control) {
        Ghost ghost = this;
        Player player2 = player;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_15, (Object)this, (Object)player2, ghost);
        try {
            try {
                player2.eatenByGhost(ghost);
            }
            finally {
                MSDAspectGhostEatsPacman.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostEatsPacman$2$18757168(this, player2);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
        player.updateControl(control);
    }

    public void pacmanAtePowerup() {
        if (this.m_bEaten) {
            this.state = 0;
        }
    }

    public void pacmanAtePowerup1() {
        if (this.state != 0) {
            this.slowDown();
            Ghost ghost = this;
            GameControl gameControl = this.m_gameModel.m_pacMan;
            JoinPoint joinPoint = Factory.makeJP(ajc$tjp_16, (Object)this, (Object)gameControl, ghost);
            try {
                try {
                    try {
                        gameControl.ghostSlowedDown(ghost);
                    }
                    finally {
                        MSDAspectGhostStopsFleeing.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostStopsFleeing$1$a20c3886(this, gameControl);
                    }
                }
                finally {
                    MSDAspectGhostFleeing.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostFleeing$1$a20c3886(this, gameControl);
                }
            }
            finally {
                MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
            }
        }
    }

    private void slowDown() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_17, this, this);
        try {
            try {
                try {
                    System.out.println(this + " starts fleeing");
                    this.m_deltaMax = this.m_ghostDeltaMax + 2;
                }
                finally {
                    MSDAspectGhostStopsFleeing.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostStopsFleeing$4$b089ce5f(this);
                }
            }
            finally {
                MSDAspectGhostFleeing.aspectOf().ajc$after$pacman_aspects_MSDAspectGhostFleeing$3$b089ce5f(this);
            }
        }
        finally {
            MSDCoordinatorAspect.aspectOf().ajc$after$pacman_aspects_MSDCoordinatorAspect$1$9bb3fd8a(joinPoint);
        }
    }

    static {
        Factory factory = new Factory("Ghost.java", Class.forName("pacman.classes.Ghost"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "setPausedGame", "pacman.classes.GameModel", "boolean:", "bPaused:", "", "void"), 329);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "ghostStoppedFleeing", "pacman.classes.GameControl", "pacman.classes.Ghost:", "ghost:", "", "void"), 354);
        ajc$tjp_10 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "setPausedGame", "pacman.classes.GameModel", "boolean:", "bPaused:", "", "void"), 792);
        ajc$tjp_11 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getGhostScore", "pacman.classes.GameModel", "", "", "", "int"), 799);
        ajc$tjp_12 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "increaseScore", "pacman.classes.Player", "int:", "points:", "", "void"), 800);
        ajc$tjp_13 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "doubleGhostScore", "pacman.classes.GameModel", "", "", "", "void"), 801);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setEyesOnly", "pacman.classes.Ghost", "boolean:", "b:", "", "void"), 806);
        ajc$tjp_15 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "eatenByGhost", "pacman.classes.Player", "pacman.classes.Ghost:", "ghost:", "", "void"), 843);
        ajc$tjp_16 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "ghostSlowedDown", "pacman.classes.GameControl", "pacman.classes.Ghost:", "ghost:", "", "void"), 858);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "slowDown", "pacman.classes.Ghost", "", "", "", "void"), 863);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "enteringJail", "pacman.classes.GameModel", "pacman.classes.Ghost:", "ghost:", "", "void"), 369);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "leavingJail", "pacman.classes.GameModel", "pacman.classes.Ghost:", "g:", "", "void"), 412);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setNormalShape", "pacman.classes.Ghost", "boolean:", "b:", "", "void"), 465);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "speedUp", "pacman.classes.Ghost", "", "", "", "void"), 470);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "stopFleeing", "pacman.classes.Ghost", "", "", "", "void"), 475);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "ghostStoppedFleeing", "pacman.classes.GameControl", "pacman.classes.Ghost:", "ghost:", "", "void"), 496);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "goToJail", "pacman.classes.Ghost", "", "", "", "void"), 483);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "leaveJail", "pacman.classes.Ghost", "", "", "", "void"), 500);
    }
}

