/*
 * Decompiled with CFR 0.152.
 */
package pacman.classes;

import java.applet.AudioClip;
import java.net.URL;
import pacman.classes.GameControl;

class SoundManager {
    AudioClip m_chompClip;
    AudioClip m_eatGhostClip;
    AudioClip m_pacmanDiesClip;
    AudioClip m_returnGhostClip;
    AudioClip m_sirenClip;
    AudioClip m_startClip;
    AudioClip m_ghostBlueClip;
    AudioClip m_extraPacClip;
    AudioClip m_eatFruitClip;
    static final int SOUND_PACMANDIES_LENGTH = 1605;
    static final int SOUND_CHOMP_LENGTH = 243;
    static final int SOUND_RETURNGHOST_LENGTH = 705;
    static final int SOUND_START_LENGTH = 4630;
    static final int SOUND_CHOMP = 1;
    static final int SOUND_EATGHOST = 2;
    static final int SOUND_PACMANDIES = 3;
    static final int SOUND_RETURNGHOST = 4;
    static final int SOUND_SIREN = 5;
    static final int SOUND_START = 6;
    static final int SOUND_GHOSTBLUE = 7;
    static final int SOUND_EXTRAPAC = 8;
    static final int SOUND_EATFRUIT = 9;
    GameControl m_pacMan;
    URL m_baseURL;
    boolean m_bLoaded = false;
    int m_nChompTicks = 0;
    boolean m_bChompLooping = false;
    boolean m_bSirenLooping = false;
    int m_nReturnGhostTicks = 0;
    boolean m_bEnabled = true;

    public SoundManager(GameControl pacMan, URL baseURL) {
        this.m_pacMan = pacMan;
        this.m_baseURL = baseURL;
    }

    public void loadSoundClips() {
        long beginLoadTime = System.currentTimeMillis();
        this.m_chompClip = this.m_pacMan.getAudioClip(this.m_baseURL, "gs_chomp.au");
        this.m_eatGhostClip = this.m_pacMan.getAudioClip(this.m_baseURL, "gs_eatghost.au");
        this.m_pacmanDiesClip = this.m_pacMan.getAudioClip(this.m_baseURL, "gs_pacmandies.au");
        this.m_returnGhostClip = this.m_pacMan.getAudioClip(this.m_baseURL, "gs_returnghost.au");
        this.m_sirenClip = this.m_pacMan.getAudioClip(this.m_baseURL, "gs_siren_soft.au");
        this.m_startClip = this.m_pacMan.getAudioClip(this.m_baseURL, "gs_start.au");
        this.m_ghostBlueClip = this.m_pacMan.getAudioClip(this.m_baseURL, "gs_ghostblue.au");
        this.m_extraPacClip = this.m_pacMan.getAudioClip(this.m_baseURL, "gs_extrapac.au");
        this.m_eatFruitClip = this.m_pacMan.getAudioClip(this.m_baseURL, "gs_eatfruit.au");
        this.m_bLoaded = true;
        long endLoadTime = System.currentTimeMillis();
        System.out.println(endLoadTime - beginLoadTime);
    }

    public void tickSound() {
        if (this.m_nChompTicks > 0) {
            --this.m_nChompTicks;
            if (this.m_nChompTicks == 0) {
                this.m_bChompLooping = false;
                this.stopSound(1);
            }
        }
        if (this.m_nReturnGhostTicks > 0) {
            --this.m_nReturnGhostTicks;
            if (this.m_nReturnGhostTicks == 0) {
                this.stopSound(4);
            }
        }
    }

    public void playSound(int soundEnum) {
        if (!this.m_bLoaded || !this.m_bEnabled) {
            return;
        }
        switch (soundEnum) {
            case 1: {
                this.m_nChompTicks = 243 / this.m_pacMan.m_delay;
                if (this.m_bChompLooping) break;
                this.m_chompClip.loop();
                this.m_bChompLooping = true;
                break;
            }
            case 2: {
                this.m_eatGhostClip.play();
                break;
            }
            case 3: {
                this.m_pacmanDiesClip.play();
                break;
            }
            case 4: {
                this.m_nReturnGhostTicks = 705 / this.m_pacMan.m_delay * 2;
                this.m_returnGhostClip.loop();
                break;
            }
            case 5: {
                if (this.m_bSirenLooping) break;
                this.m_sirenClip.loop();
                this.m_bSirenLooping = true;
                break;
            }
            case 6: {
                this.m_startClip.play();
                break;
            }
            case 7: {
                this.m_ghostBlueClip.loop();
                break;
            }
            case 8: {
                this.m_extraPacClip.play();
                break;
            }
            case 9: {
                this.m_eatFruitClip.play();
            }
        }
    }

    public void stopSound(int soundEnum) {
        if (!this.m_bLoaded) {
            return;
        }
        switch (soundEnum) {
            case 1: {
                this.m_chompClip.stop();
                this.m_nChompTicks = 0;
                this.m_bChompLooping = false;
                break;
            }
            case 2: {
                this.m_eatGhostClip.stop();
                break;
            }
            case 3: {
                this.m_pacmanDiesClip.stop();
                break;
            }
            case 4: {
                this.m_returnGhostClip.stop();
                this.m_nReturnGhostTicks = 0;
                break;
            }
            case 5: {
                this.m_sirenClip.stop();
                this.m_bSirenLooping = false;
                break;
            }
            case 6: {
                this.m_startClip.stop();
                break;
            }
            case 7: {
                this.m_ghostBlueClip.stop();
                break;
            }
            case 8: {
                this.m_extraPacClip.stop();
                break;
            }
            case 9: {
                this.m_eatFruitClip.stop();
            }
        }
    }

    public void stop() {
        if (!this.m_bLoaded) {
            return;
        }
        this.m_chompClip.stop();
        this.m_eatGhostClip.stop();
        this.m_pacmanDiesClip.stop();
        this.m_returnGhostClip.stop();
        this.m_sirenClip.stop();
        this.m_startClip.stop();
        this.m_ghostBlueClip.stop();
        this.m_extraPacClip.stop();
        this.m_eatFruitClip.stop();
        this.m_nChompTicks = 0;
        this.m_bChompLooping = false;
        this.m_bSirenLooping = false;
        this.m_nReturnGhostTicks = 0;
    }
}

