/*
 * Decompiled with CFR 0.152.
 */
package pacman.classes;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import pacman.classes.GameModel;
import pacman.classes.GameUI;
import pacman.classes.Player;

public class Thing {
    public static final byte STILL = 0;
    static final byte UP = 1;
    static final byte DOWN = 2;
    static final byte LEFT = 3;
    static final byte RIGHT = 4;
    int m_deltaMax = 3;
    static final byte PACMAN = 0;
    static final byte GHOST = 1;
    static final byte FRUIT = 2;
    boolean m_bInsideRoom;
    int m_locX;
    int m_locY;
    int m_deltaLocX = 0;
    int m_deltaLocY = 0;
    int m_lastLocX;
    int m_lastLocY;
    int m_lastDeltaLocX = 0;
    int m_lastDeltaLocY = 0;
    public byte m_direction;
    int m_startX;
    int m_startY;
    int m_deltaStartX;
    GameModel m_gameModel;
    Rectangle m_boundingBox;
    boolean m_bPaused = false;
    public boolean m_bVisible = false;

    Thing(GameModel gameModel, byte type, int startX, int startY, boolean bMiddleX) {
        this.m_startX = startX;
        this.m_startY = startY;
        this.m_deltaStartX = 0;
        this.m_locX = -1;
        this.m_locY = -1;
        this.m_lastLocX = this.m_startX;
        this.m_lastLocY = this.m_startY;
        this.m_direction = 0;
        this.m_gameModel = gameModel;
        this.m_bInsideRoom = false;
        this.m_boundingBox = new Rectangle();
        if (bMiddleX) {
            this.m_lastDeltaLocX = this.m_deltaLocX = this.m_deltaMax - 1;
            this.m_deltaStartX = this.m_deltaLocX;
        }
    }

    public void eatItem(int itemType) {
    }

    public void draw(GameUI gameUI, Graphics g2) {
    }

    public void tickThing() {
    }

    public int checkCollision(Player player) {
        return 0;
    }

    public void returnToStart() {
        this.m_locX = this.m_startX;
        this.m_locY = this.m_startY;
        this.m_lastLocX = this.m_startX;
        this.m_lastLocY = this.m_startY;
        this.m_deltaLocX = this.m_deltaStartX;
        this.m_deltaLocY = 0;
        this.m_lastDeltaLocX = this.m_deltaStartX;
        this.m_lastDeltaLocY = 0;
        this.m_bPaused = false;
        this.m_direction = 0;
        this.m_boundingBox.setBounds(0, 0, 0, 0);
    }

    public boolean canMove() {
        return !this.m_bPaused;
    }

    public void setVisible(boolean bVisible) {
        this.m_bVisible = bVisible;
    }

    public void setPaused(boolean bPaused) {
        this.m_bPaused = bPaused;
    }

    boolean getDestination(int direction, int locX, int locY, Point point) {
        if (direction == 1 && (this.m_gameModel.m_gameState[locX][locY] & 1) != 0 || direction == 3 && (this.m_gameModel.m_gameState[locX][locY] & 8) != 0 || direction == 2 && (this.m_gameModel.m_gameState[locX][locY] & 4) != 0 || direction == 4 && (this.m_gameModel.m_gameState[locX][locY] & 2) != 0) {
            point.setLocation(locX, locY);
            return false;
        }
        switch (direction) {
            case 1: {
                --locY;
                break;
            }
            case 2: {
                ++locY;
                break;
            }
            case 3: {
                --locX;
                break;
            }
            case 4: {
                ++locX;
            }
        }
        if (locY < 0 || locX < 0 || locY >= this.m_gameModel.m_gameSizeY || locX >= this.m_gameModel.m_gameSizeX) {
            return false;
        }
        while (true) {
            if (direction == 1 || direction == 2) {
                if ((this.m_gameModel.m_gameState[locX][locY] & 2) == 0 || (this.m_gameModel.m_gameState[locX][locY] & 8) == 0 || (this.m_gameModel.m_gameState[locX][locY] & 1) != 0 || (this.m_gameModel.m_gameState[locX][locY] & 4) != 0) {
                    point.setLocation(locX, locY);
                    break;
                }
                if (direction == 1) {
                    if (locY == 0) {
                        point.setLocation(locX, this.m_gameModel.m_gameSizeY - 1);
                        break;
                    }
                    --locY;
                    continue;
                }
                if (locY == this.m_gameModel.m_gameSizeY - 1) {
                    point.setLocation(locX, 0);
                    break;
                }
                ++locY;
                continue;
            }
            if ((this.m_gameModel.m_gameState[locX][locY] & 1) == 0 || (this.m_gameModel.m_gameState[locX][locY] & 4) == 0 || (this.m_gameModel.m_gameState[locX][locY] & 2) != 0 || (this.m_gameModel.m_gameState[locX][locY] & 8) != 0) {
                point.setLocation(locX, locY);
                break;
            }
            if (direction == 3) {
                if (locX == 0) {
                    point.setLocation(this.m_gameModel.m_gameSizeX - 1, locY);
                    break;
                }
                --locX;
                continue;
            }
            if (locX == this.m_gameModel.m_gameSizeX - 1) {
                point.setLocation(0, locY);
                break;
            }
            ++locX;
        }
        return true;
    }
}

