/*
 * Decompiled with CFR 0.152.
 */
package pacman.classes;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import pacman.classes.GameModel;

class TopCanvas
extends Canvas {
    Font m_font;
    GameModel m_gameModel;
    Image m_offImage;
    Graphics m_offGraphics;
    Dimension m_offDim;

    public TopCanvas(GameModel gameModel, int width, int height) {
        this.setSize(width, height);
        this.m_gameModel = gameModel;
        this.m_font = new Font("Helvetica", 1, 18);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        if (this.m_offImage == null || this.m_offDim.width != dim.width || this.m_offDim.height != dim.height) {
            this.m_offDim = dim;
            this.m_offImage = this.createImage(this.m_offDim.width, this.m_offDim.height);
            this.m_offGraphics = this.m_offImage.getGraphics();
        }
        this.m_offGraphics.setColor(Color.black);
        this.m_offGraphics.fillRect(0, 0, this.m_offDim.width, this.m_offDim.height);
        this.m_offGraphics.setColor(Color.white);
        this.m_offGraphics.setFont(this.m_font);
        FontMetrics fm = this.m_offGraphics.getFontMetrics();
        int y = 20 + fm.getAscent() + fm.getDescent();
        int x = 0;
        this.m_offGraphics.drawString("HIGH SCORE", x, y);
        x = fm.stringWidth("HIGH SCORE") - fm.stringWidth(Integer.toString(this.m_gameModel.m_highScore));
        this.m_offGraphics.drawString(Integer.toString(this.m_gameModel.m_highScore), x, y += fm.getAscent() + fm.getDescent());
        x = fm.stringWidth("HIGH SCORE") - fm.stringWidth("SCORE");
        this.m_offGraphics.drawString("SCORE", x, y += 10 + fm.getAscent() + fm.getDescent());
        x = fm.stringWidth("HIGH SCORE") - fm.stringWidth(Integer.toString(this.m_gameModel.m_player.m_score));
        this.m_offGraphics.drawString(Integer.toString(this.m_gameModel.m_player.m_score), x, y += fm.getAscent() + fm.getDescent());
        g.drawImage(this.m_offImage, 0, 0, this);
    }
}

