package il.ac.wis.cs.s2a.examples.phonebook;

import il.ac.wis.cs.s2a.examples.phonebook.model.PhoneBookModel;
import il.ac.wis.cs.s2a.examples.phonebook.view.extended.ButtonPanel;
import il.ac.wis.cs.s2a.examples.phonebook.view.extended.ExtendedInputPane;
import il.ac.wis.cs.s2a.examples.phonebook.view.extended.PhoneBookExtendedGUIView;
import il.ac.wis.cs.s2a.examples.phonebook.view.extended.ResultPane;
import il.ac.wis.cs.s2a.examples.phonebook.view.simple.MessagePane;

import javax.swing.JButton;


/**
 * Used by the MSDCompiler runtime. Provides references for system objects, or singeltons. 
 * @author asafk
 */
public class MSDEnv
{
	static PhoneBookView view = null;
	static PhoneBookModel model = null;
	static PhoneBookController controller = null;
	static MessagePane messagePane = null;
	static ButtonPanel buttonPanel = null;
	static ExtendedInputPane inputPane = null;
	static ResultPane resultPane  = null;
	static JButton addButton,quitButton,searchButton,startButton;


	static void setView(PhoneBookView view)
	{
		MSDEnv.messagePane = ((PhoneBookExtendedGUIView)view).getMessagePane();
		MSDEnv.buttonPanel = (ButtonPanel)((PhoneBookExtendedGUIView)view).getPart("ButtonPanel");
		MSDEnv.inputPane = (ExtendedInputPane)((PhoneBookExtendedGUIView)view).getPart("ExtendedInputPane");
		MSDEnv.resultPane = (ResultPane)((PhoneBookExtendedGUIView)view).getPart("ResultPane");
	}

	static void setModel(PhoneBookModel model)
	{
		MSDEnv.model = model;
	}

	static void setController(PhoneBookController control)
	{
		MSDEnv.controller = control;
	}

	public static Object getLifeLineInstance(String lineType)
	{
		if(lineType.equals("PhoneBookView"))
			return view;
		if (lineType.equals("PhoneBookModel"))
			return model;
		if (lineType.equals("IView"))
			return view;
		if (lineType.equals("PhoneBookController"))
			return controller;
		if(lineType.equals("IController"))
			return controller;
		if(lineType.equals("MessagePane"))
			return messagePane;
		if(lineType.equals("IModel"))
			return model;
		if(lineType.equals("DBConnector"))
			return model.getDBConnector();
		if(lineType.equals("ButtonPanel"))
			return MSDEnv.buttonPanel;
		if(lineType.equals("ExtendedInputPane"))
			return MSDEnv.inputPane;
		if(lineType.equals("ResultPane"))
			return MSDEnv.resultPane;
		if(lineType.equals("PanelControl"))
			return MSDEnv.buttonPanel.getPart("PanelControl");
		if(lineType.equals("JButton"))
			return MSDEnv.buttonPanel.getPart("JButton");
		return null;
	}

}
