package il.ac.wis.cs.s2a.examples.phonebook.view.extended;

import il.ac.wis.cs.s2a.examples.mvc.interfaces.IView;
import il.ac.wis.cs.s2a.examples.phonebook.PhoneBookConstants;
import il.ac.wis.cs.s2a.runtime.lib.IOwner;
import il.ac.wis.cs.s2a.runtime.lib.IPart;

import javax.swing.JButton;
import javax.swing.JPanel;



/**
 * A panel containning all the button needed for the PhoneBook Extended Gui.
 * Part-of the {@link PhoneBookExtendedGUIView} class
 * The panel it self is composed of four buttons of type {@link JButton} and
 * a {@link PanelControl}.  
 * @author asafk
 */
public class ButtonPanel extends JPanel implements IPart,IOwner
{
	private static final long serialVersionUID = 1L;
	private IView owner;
	JButton addButton,searchButton, quitButton, startButton; 
	private PanelControl panelControl;
	
	public ButtonPanel(PhoneBookExtendedGUIView view)
	{
		super();
		owner = view;
		panelControl = new PanelControl(this);
		addButton = new JButton("Add");
		searchButton = new JButton("Search");
		quitButton = new JButton("Quit");
		startButton = new JButton("Start");
		addButton.addActionListener(view);
		searchButton.addActionListener(view);
		quitButton.addActionListener(view);
		startButton.addActionListener(view);
		addButton.setActionCommand("add");
		searchButton.setActionCommand("search");
		quitButton.setActionCommand("quit");
		startButton.setActionCommand("start");
		add(addButton);
		add(searchButton);
		add(quitButton);
		add(startButton);
	}

	public Object getOwner() 
	{
		return owner;
	}
	
	public void arrangeEnabledButtons(int state)
	{
		addButton.setEnabled(state == PhoneBookConstants.STATE_IDLE);
		searchButton.setEnabled(state == PhoneBookConstants.STATE_IDLE);
		quitButton.setEnabled(state!= PhoneBookConstants.STATE_ADD_NAME &&
				state != PhoneBookConstants.STATE_ADD_NUMBER 
				&& state!= PhoneBookConstants.STATE_SEARCH
				&& state!= PhoneBookConstants.STATE_EXIT);
		startButton.setEnabled(state == PhoneBookConstants.STATE_ERROR ||
				state == PhoneBookConstants.STATE_SEARCH_RESULT);
	}

	public Object getPart(String name) 
	{
		if(name.equals("PanelControl"))
			return panelControl;
		if(name.equals("JButton"))
			return addButton;
		return null;
	}

	public void disableAll()
	{
		panelControl.disableAll();
		
	}
}
