package il.ac.wis.cs.s2a.examples.phonebook.view.extended;

import il.ac.wis.cs.s2a.examples.phonebook.PhoneBookController;
import il.ac.wis.cs.s2a.examples.phonebook.PhoneBookView;
import il.ac.wis.cs.s2a.examples.phonebook.model.PhoneBookModel;
import il.ac.wis.cs.s2a.examples.phonebook.view.simple.MessagePane;
import il.ac.wis.cs.s2a.runtime.lib.IOwner;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * An extended GUI for the Phone-Book Application.
 * Composed of five parts: {@link ExtendedViewController},{@link ExtendedInputPane},
 * {@link ResultPane},{@link MessagePane}, and {@link ButtonPanel}.
 * @author asafk
 */
public class PhoneBookExtendedGUIView extends PhoneBookView implements IOwner,ActionListener
{
	private static final String INPUT_LABEL = " Input Line:";
	private static final String INSTRUCTION_LABLEL = " Instructions:";
		
	PhoneBookModel model;
	ExtendedInputPane inputPane;
	MessagePane messagePane;
	ButtonPanel buttonPanel;
	ResultPane resultPanel;
	ExtendedViewController extendedViewControll;	
	private JPanel panel;
	
	public PhoneBookExtendedGUIView(PhoneBookController controller) 
	{
		super(controller);
		model = controller.getModel();
		panel = new JPanel(new GridBagLayout());
		inputPane = new ExtendedInputPane(20);
		messagePane = new MessagePane(4, 22,this);
		extendedViewControll = new ExtendedViewController(this);
		inputPane.setViewControll(this);		
		buttonPanel = new ButtonPanel(this);
		resultPanel = new ResultPane(this);	
		buildGui();	
	}
	
	private void buildGui()
	{ 
		GridBagConstraints c = new GridBagConstraints();
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.fill = GridBagConstraints.BOTH;
		panel.add(new JLabel(INSTRUCTION_LABLEL), c);
		panel.add(messagePane, c);
		panel.add(new JLabel(INPUT_LABEL), c);
		panel.add(inputPane, c);
		panel.add(buttonPanel,c);
		panel.add(resultPanel,c);
	}
	
	
		
	public void stateHasChanged(int newState) 
	{
		extendedViewControll.stateHasChanged(newState);	
	}

	protected void getUserInput(String question) 
	{
		extendedViewControll.getUserInput(question);
	}

	public JPanel getPanel() 
	{
		return panel;
	}

	public ExtendedInputPane getInputPane() 
	{
		return inputPane;
	}

	public MessagePane getMessagePane() 
	{
		return messagePane;
	}

	public PhoneBookController getController() 
	{
		return phonebookcontroller;
	}
	
	
	
	
	/**
	 * Create the GUI and show it.  For thread safety,
	 * this method should be invoked from the
	 * event-dispatching thread.
	 */
	private static void createAndShowGUI(PhoneBookExtendedGUIView view) 
	{
		JFrame frame = new JFrame("Phone Book MVC Extended GUI");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setResizable(false);
		view.getPanel().setOpaque(true); //content panes must be opaque
		frame.setContentPane(view.getPanel());
		frame.pack();
		frame.setVisible(true);
	}
	

	public static PhoneBookExtendedGUIView doView(PhoneBookController c)
	{
		final PhoneBookExtendedGUIView v = new PhoneBookExtendedGUIView(c);
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI(v);
			}
		});
		return v;
	}

	public Object getPart(String name) 
	{
		if(name.equals("ButtonPanel"))
				return buttonPanel;
		if(name.equals("ExtendedInputPane"))
			return inputPane;
		if(name.equals("ResultPane"))
			return resultPanel;
		return null;
	}

	public void actionPerformed(ActionEvent e) 
	{
		extendedViewControll.actionPerformed(e);
		buttonPanel.disableAll();
		extendedViewControll.handleInput();
		
	}

	public PhoneBookModel getModel() 
	{
		return model;
	}

	
}
