package il.ac.wis.cs.s2a.examples.phonebook.view.extended;

import il.ac.wis.cs.s2a.examples.phonebook.PhoneBookConstants;
import il.ac.wis.cs.s2a.runtime.lib.IPart;

import java.awt.Color;
import java.awt.GridLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * Part-of the {@link PhoneBookExtendedGUIView} class
 * Used to display search results if any.
 * @author asafk
 *
 */
public class ResultPane extends JPanel implements IPart
{
	private static final long serialVersionUID = 1L;
	private static final String HEADER = " Search Results:";
	private static final String NO_RESULTS = " ------ ";
	private final static String SEARCH_RESULT = "The phone number is: ";
	private final static String NEG_SEARCH_RESULT = "Person's phone number not found.";
	private final static String PENDING = "Pending...";
	private JLabel result;
	private PhoneBookExtendedGUIView owner;
	
	public ResultPane(PhoneBookExtendedGUIView view)
	{
		JLabel header = new JLabel(HEADER);
		setLayout(new GridLayout(3,1));
		result = new JLabel(NO_RESULTS);
		add(header);
		add(result);
		setBackground(Color.white);
		owner = view;
	}
	
	public void clear()
	{
		remove(this.result);
		this.result = new JLabel(PENDING);
		this.result.setForeground(Color.green);
		add(this.result);
	}
	
	public Object getOwner()
	{
		return owner;
	}
	
	public void printResults(int state)
	{
		if(state==PhoneBookConstants.STATE_SEARCH_RESULT)
		{
			String result = owner.getModel().getSearchResult();
			if(result !=null && result != "")
			{	
				remove(this.result);
				this.result = new JLabel(SEARCH_RESULT + result);
				this.result.setForeground(Color.blue);
				add(this.result);
			}
			else
			{
				remove(this.result);
				this.result = new JLabel(NEG_SEARCH_RESULT);
				this.result.setForeground(Color.red);
				add(this.result);
			}
		}
		else
		{
			remove(this.result);
			this.result = new JLabel(NO_RESULTS);
			add(this.result);
		}
	}
	
}
