package il.ac.wis.cs.s2a.examples.phonebook.view.simple;

import il.ac.wis.cs.s2a.examples.mvc.interfaces.IView;
import il.ac.wis.cs.s2a.examples.phonebook.view.extended.PhoneBookExtendedGUIView;
import il.ac.wis.cs.s2a.runtime.lib.IPart;

import javax.swing.JTextArea;



/**
 * Might be Part-of the {@link PhoneBookSimpleGUIView} class
 * or the {@link PhoneBookExtendedGUIView} class.  
 * Displays messages to the user 
 * @author asafk
 */
public class MessagePane extends JTextArea implements IPart
{
	private static final long serialVersionUID = 1L;
	Object owner;

	public MessagePane(int i,int j,Object owner)
	{
		super(i,j);
		this.owner = owner;
		setEditable(false);
	}
	
	public void clear()
	{
		super.removeAll();
		out("Pending...");
	}
	
	public void changeView(Integer state)
	{
		((IView)owner).changeView(state);
	}

	public Object getOwner() 
	{
		return owner;
	}
	
	public void out(String s)
	{
		int len = getDocument().getLength();
		try
		{
			getDocument().remove(0, len);
		}
		catch (Exception e)	{}
		append(s);
	}
}
