package il.ac.wis.cs.s2a.runtime.lib;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

import org.aspectj.lang.JoinPoint;

/**
 * Superclass for generated scenario aspects.
 * 
 * @author Asaf Kleinbort
 * @author Shahar Maoz
 * 
 */
public abstract aspect MSDAspect
{
	protected int numberOfLifeLines;
	protected int numberOfInstances;
	protected int numberOfVariables;

	private ArrayList<ActiveMSDAspect> activeMSDArray;
	private HashSet<ActiveMSDAspect> completedActiveMSDs;
	private ArrayList<ArrayList<Integer>> hotCuts;
	private ArrayList<Integer> lastCut;
	private ArrayList<Integer> minimalEvents;
	private ArrayList<Integer> constantLoopsLimits;
	private long idCounter =0;
	
	private boolean isUpToDate = false;
	private MSDMethodSet lastME = new MSDMethodSet();
	private MSDMethodSet lastEE = new MSDMethodSet();
	private MSDMethodSet lastCV = new MSDMethodSet();
	private MSDMethodSet lastHV = new MSDMethodSet();
	
	abstract protected void  changeActiveMSDCutState(int musdMethod, Object sourceObject,
			Object targetObject,ActiveMSDAspect activeAspect,ArrayList args);
	
	abstract protected void getActiveMSDCutState(MSDMethodSet ME,MSDMethodSet EE,
			MSDMethodSet CV,MSDMethodSet HV,ActiveMSDAspect activeMSD);
	
	abstract protected void doBindings(ActiveMSDAspect activeAspect);

	
	protected MSDAspect()
	{
		activeMSDArray = new ArrayList<ActiveMSDAspect>();
		completedActiveMSDs= new HashSet<ActiveMSDAspect>();
		hotCuts = new ArrayList<ArrayList<Integer>>();
		minimalEvents = new ArrayList<Integer>();
		constantLoopsLimits = new ArrayList<Integer>();
	}
	
	protected void addMinimalEvent(int constant)
	{
		minimalEvents.add(new Integer(constant));
	}
	
	protected void addConstantLoop(int loopsNumber)
	{
		constantLoopsLimits.add(loopsNumber);
	}
			
	/**
	 * Loops on all active copies.
	 */
	protected void changeCutState(int musdMethod, Object sourceObject, Object targetObject,
			ArrayList args)
	{
		completedActiveMSDs.clear();
		
		if ((activeMSDArray.size()==0) && (!minimalEvents.contains(new Integer(musdMethod))))
			return; //optimization: no active copies and new event is not minimal
		
		if (minimalEvents.contains(new Integer(musdMethod))) // create a new copy
		{
			ActiveMSDAspect newCopy = new ActiveMSDAspect(numberOfLifeLines, numberOfInstances,
					numberOfVariables,idCounter++,this);
			activeMSDArray.add(newCopy);
		}
		for(ActiveMSDAspect curCopy: activeMSDArray) // loop on all active copies
		{
			doBindings(curCopy);
			changeActiveMSDCutState(musdMethod, sourceObject, targetObject, curCopy,args);
		}
		for(ActiveMSDAspect deadCopy:completedActiveMSDs)
			activeMSDArray.remove(deadCopy);
		
		isUpToDate = false;
	}
	
	/**
	 * Loops on all active copies without new copy creation.  
	 * Used for constructors second call.
	 */
	protected void changeCutStateConstructor(int musdMethod, Object sourceObject, Object targetObject,
			ArrayList args)
	{
		completedActiveMSDs.clear();
		for(ActiveMSDAspect curCopy: activeMSDArray)
		{
			doBindings(curCopy);
			changeActiveMSDCutState(musdMethod, sourceObject, targetObject, curCopy,args);
		}
		for(ActiveMSDAspect deadCopy:completedActiveMSDs)
			activeMSDArray.remove(deadCopy);
		
		isUpToDate = false;
	}
	
	/**
	 * Recursive function to check lifeline possible binding including in the context of object composition.
	 * Chack whether obj or one of obj's ancestors is an instance of c.
	 * If so return this instance of c. (i.e return obj or one of its ancestors)
	 * We first go up in the hierarachy and then down. We do not mix!
	 */
	protected Object getUnifiable(Object obj,Class c)
	{
		if(obj==null)
			return null;
		Object res  = checkUpUnification(obj,c);
		if(res==null)
			res = checkDownUnification(obj,c);		
		return res;
		
	}
	
	/**
	 * Goes up in the class hierarchy. Including the node itself.
	 */
	private Object checkUpUnification(Object obj,Class c)
	{
		if(c.isInstance(obj))//Runtime version of instance of...
			return obj;
		if(obj instanceof IPart)
		{
			Object owner = ((IPart)obj).getOwner();
			return checkUpUnification(owner, c);
		}
		return null;
	}
	/**
	 * Goes down in the class hierarchy. Including the node itself.
	 */
	private Object checkDownUnification(Object obj,Class c)
	{
		if(c.isInstance(obj)) //Runtime version of instance of...
			return obj;
		if(obj instanceof IOwner)
		{
			Object part = ((IOwner)obj).getPart(c.getName()); 
			//Note: if the owner has more than one part of the same type
			//we have a possible bug
			return checkDownUnification(part, c);
		}
		return null;
	}

	
	public void getCutState(MSDMethodSet ME, MSDMethodSet EE,MSDMethodSet CV, MSDMethodSet HV)
	{
		if (!isUpToDate) {
			lastME.clear(); 
			lastEE.clear();
			lastCV.clear();
			lastHV.clear();
			for(ActiveMSDAspect curCopy: activeMSDArray)
				getActiveMSDCutState(lastME, lastEE, lastCV, lastHV, curCopy);
			ME.addAll(lastME);
			EE.addAll(lastEE);
			CV.addAll(lastCV);
			HV.addAll(lastHV);
			isUpToDate = true;
		} else {
			ME.addAll(lastME);
			EE.addAll(lastEE);
			CV.addAll(lastCV);
			HV.addAll(lastHV);
		}
	}	
	
	protected ArrayList<Object> getArgsList(Object o1)
	{
		ArrayList<Object> arr = new ArrayList<Object>();
		arr.add(o1);
		return arr;
	}
	
	protected ArrayList<Object> getArgsList(Object o1,Object o2)
	{
		ArrayList<Object> arr = new ArrayList<Object>();
		arr.add(o1);arr.add(o2);
		return arr;
	}
	
	protected ArrayList<Object> getArgsList(Object o1,Object o2,Object o3)
	{
		ArrayList<Object> arr = new ArrayList<Object>();
		arr.add(o1);arr.add(o2);arr.add(o3);
		return arr;
	}
	
	protected ArrayList<Object> getArgsList(Object o1,Object o2,Object o3,Object o4)
	{
		ArrayList<Object> arr = new ArrayList<Object>();
		arr.add(o1);arr.add(o2);arr.add(o3);arr.add(o4);
		return arr;
	}
	
	protected ArrayList<Object> getArgsList(Object o1,Object o2,Object o3,Object o4,Object o5)
	{
		ArrayList<Object> arr = new ArrayList<Object>();
		arr.add(o1);	arr.add(o2);	arr.add(o3);
		arr.add(o4);	arr.add(o5);
		return arr;
	}
	
	protected ArrayList<Object> getArgsList(Object o1,Object o2,Object o3,Object o4,Object o5,Object o6)
	{
		ArrayList<Object> arr = new ArrayList<Object>();
		arr.add(o1);	arr.add(o2);	arr.add(o3);
		arr.add(o4);	arr.add(o5);	arr.add(o6);
		return arr;
	}
	
	protected ArrayList<Object> getArgsList(Object o1,Object o2,Object o3,Object o4,Object o5,Object o6,Object o7)
	{
		ArrayList<Object> arr = new ArrayList<Object>();
		arr.add(o1);	arr.add(o2);	arr.add(o3);
		arr.add(o4);	arr.add(o5);	arr.add(o6);
		arr.add(o7);
		return arr;
	}
	
	protected ArrayList<Object> getArgsList(Object o1,Object o2,Object o3,Object o4,Object o5,Object o6,Object o7,Object o8)
	{
		ArrayList<Object> arr = new ArrayList<Object>();
		arr.add(o1);	arr.add(o2);	arr.add(o3);
		arr.add(o4);	arr.add(o5);	arr.add(o6);
		arr.add(o7); 	arr.add(o8);
		
		return arr;
	}
	
	protected void setHotCut(int loc)
	{
		hotCuts.add(getCut(loc));
	}
	protected void setHotCut(int loc,int loc2)
	{
		hotCuts.add(getCut(loc,loc2));
	}
	
	protected void setHotCut(int loc,int loc2,int loc3)
	{
		hotCuts.add(getCut(loc,loc2,loc3));
	}
	
	protected void setHotCut(int loc,int loc2,int loc3,int loc4)
	{
		hotCuts.add(getCut(loc,loc2,loc3,loc4));
	}
	
	protected void setHotCut(int loc, int loc2, int loc3, int loc4, int loc5)
	{
		hotCuts.add(getCut(loc,loc2,loc3,loc4,loc5));
	}
	protected void setHotCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6)
	{
		hotCuts.add(getCut(loc,loc2,loc3,loc4,loc5,loc6));
	}
	protected void setHotCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7)
	{
		hotCuts.add(getCut(loc,loc2,loc3,loc4,loc5,loc6,loc7));
	}
	protected void setHotCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7,int loc8)
	{
		hotCuts.add(getCut(loc,loc2,loc3,loc4,loc5,loc6,loc7,loc8));
	}
	protected void setHotCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7,int loc8,int loc9)
	{
		hotCuts.add(getCut(loc,loc2,loc3,loc4,loc5,loc6,loc7,loc8,loc9));
	}
	protected void setHotCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7,int loc8,int loc9,int loc10)
	{
		hotCuts.add(getCut(loc,loc2,loc3,loc4,loc5,loc6,loc7,loc8,loc9,loc10));
	}
	
	protected void setLastCut(int loc)
	{
		lastCut = getCut(loc);
	}
	protected void setLastCut(int loc,int loc2)
	{
		lastCut = getCut(loc,loc2);
	}
	
	protected void setLastCut(int loc,int loc2,int loc3)
	{
		lastCut = getCut(loc,loc2,loc3);
	}
	
	protected void setLastCut(int loc,int loc2,int loc3,int loc4)
	{
		lastCut = getCut(loc,loc2,loc3,loc4);
	}
	
	protected void setLastCut(int loc, int loc2, int loc3, int loc4, int loc5)
	{
		lastCut = getCut(loc,loc2,loc3,loc4,loc5);
	}
	protected void setLastCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6)
	{
		lastCut = getCut(loc,loc2,loc3,loc4,loc5,loc6);
	}
	protected void setLastCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7)
	{
		lastCut = getCut(loc,loc2,loc3,loc4,loc5,loc6,loc7);
	}
	protected void setLastCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7,int loc8)
	{
		lastCut = getCut(loc,loc2,loc3,loc4,loc5,loc6,loc7,loc8);
	}
	protected void setLastCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7,int loc8,int loc9)
	{
		lastCut = getCut(loc,loc2,loc3,loc4,loc5,loc6,loc7,loc8,loc9);
	}
	protected void setLastCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7,int loc8,int loc9,int loc10)
	{
		lastCut = getCut(loc,loc2,loc3,loc4,loc5,loc6,loc7,loc8,loc9,loc10);
	}
	
	private ArrayList<Integer> getCut(int loc)
	{
		ArrayList<Integer> arr = new ArrayList<Integer>(1);
		arr.add(new Integer(loc));
		return arr;
	}

	private ArrayList<Integer> getCut(int loc, int loc2)
	{
		ArrayList<Integer> arr = new ArrayList<Integer>(1);
		arr.add(new Integer(loc));
		arr.add(new Integer(loc2));
		return arr;
	}

	private ArrayList<Integer> getCut(int loc, int loc2, int loc3)
	{
		ArrayList<Integer> arr = new ArrayList<Integer>(1);
		arr.add(new Integer(loc));
		arr.add(new Integer(loc2));
		arr.add(new Integer(loc3));
		return arr;
	}

	private ArrayList<Integer> getCut(int loc, int loc2, int loc3, int loc4)
	{
		ArrayList<Integer> arr = new ArrayList<Integer>(1);
		arr.add(new Integer(loc));
		arr.add(new Integer(loc2));
		arr.add(new Integer(loc3));
		arr.add(new Integer(loc4));
		return arr;
	}

	private ArrayList<Integer> getCut(int loc, int loc2, int loc3, int loc4, int loc5)
	{
		ArrayList<Integer> arr = new ArrayList<Integer>(1);
		arr.add(new Integer(loc));
		arr.add(new Integer(loc2));
		arr.add(new Integer(loc3));
		arr.add(new Integer(loc4));
		arr.add(new Integer(loc5));
		return arr;
	}

	private ArrayList<Integer> getCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6)
	{
		ArrayList<Integer> arr = new ArrayList<Integer>(1);
		arr.add(new Integer(loc));
		arr.add(new Integer(loc2));
		arr.add(new Integer(loc3));
		arr.add(new Integer(loc4));
		arr.add(new Integer(loc5));
		arr.add(new Integer(loc6));
		return arr;
	}

	private ArrayList<Integer> getCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7)
	{
		ArrayList<Integer> arr = new ArrayList<Integer>(1);
		arr.add(new Integer(loc));
		arr.add(new Integer(loc2));
		arr.add(new Integer(loc3));
		arr.add(new Integer(loc4));
		arr.add(new Integer(loc5));
		arr.add(new Integer(loc6));
		arr.add(new Integer(loc7));
		return arr;
	}	
	
	private ArrayList<Integer> getCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6,
			int loc7,int loc8)
	{
		ArrayList<Integer> arr = new ArrayList<Integer>(1);
		arr.add(new Integer(loc));
		arr.add(new Integer(loc2));
		arr.add(new Integer(loc3));
		arr.add(new Integer(loc4));
		arr.add(new Integer(loc5));
		arr.add(new Integer(loc6));
		arr.add(new Integer(loc7));
		arr.add(new Integer(loc8));
		return arr;
	}	
	
	private ArrayList<Integer> getCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, 
			int loc7,int loc8,int loc9)
	{
		ArrayList<Integer> arr = new ArrayList<Integer>(1);
		arr.add(new Integer(loc));
		arr.add(new Integer(loc2));
		arr.add(new Integer(loc3));
		arr.add(new Integer(loc4));
		arr.add(new Integer(loc5));
		arr.add(new Integer(loc6));
		arr.add(new Integer(loc7));
		arr.add(new Integer(loc8));
		arr.add(new Integer(loc9));
		return arr;
	}	
	
	private ArrayList<Integer> getCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, 
			int loc7,int loc8,int loc9,int loc10)
	{
		ArrayList<Integer> arr = new ArrayList<Integer>(1);
		arr.add(new Integer(loc));
		arr.add(new Integer(loc2));
		arr.add(new Integer(loc3));
		arr.add(new Integer(loc4));
		arr.add(new Integer(loc5));
		arr.add(new Integer(loc6));
		arr.add(new Integer(loc7));
		arr.add(new Integer(loc8));
		arr.add(new Integer(loc9));
		arr.add(new Integer(loc10));
		return arr;
	}	
	
	/**
	 * Special method to be cought by the monitoring aspect.
	 */
	public static void handlingEvent(JoinPoint joinPoint)
	{

	}
	
	private void handleHotViolation()
	{
		System.out.println("Hot violation occured.");
		//Throw new hotViolation();
	}
	
	public boolean  isHotCut(ArrayList<Integer> cut)
	{
		if(cut.size()!=numberOfLifeLines)
			return false;
		for(ArrayList<Integer> arr:hotCuts)
		{
			boolean found=true;
			int i=0;
			for(int j: arr)
				if(j!=cut.get(i++))
				{
					found=false;
					break;
				}
			if(found)
				return true;
		}
		return false;
	}
	
	public boolean isLastCut(ArrayList<Integer> cut)
	{
		if(cut.size()!=numberOfLifeLines)
			return false;
		int i=0;
		for(int j:lastCut)
			if(j!=cut.get(i++))
				return false;
		return true;
	}
	
	
	/**
	 * Inner class represents active LSC copy.
	 */
	protected class ActiveMSDAspect
	{
		private ArrayList<Integer> linesLocations;
		private ArrayList<Object> linesInstances;
		private ArrayList<Object> privateVariables;
		private ArrayList<Integer> loopsCounter;
		private long id;
		private MSDAspect owner;		

		ActiveMSDAspect(int numberOfLifeLines,	int numberOfInstances,
				int numberOfPrivateVaraibles,long id,MSDAspect owner)
		{
			linesLocations = initializeLinesLocations(numberOfLifeLines);
			linesInstances = initializeLinesInstances(numberOfInstances);
			privateVariables = initializePrivateVariables(numberOfPrivateVaraibles);
			loopsCounter = initializeLoop();
			this.id = id;
			this.owner = owner;
		}
		
		/**
		 * Checks if owners are equal.  Both source and target cannot be null.
		 */
		public boolean checkEqualOwners(Object source, Object target)
		{
			if(source instanceof IPart && target instanceof IPart)
			{
				IPart sourcePart = (IPart) source;
				IPart targetPart = (IPart) target;
				return sourcePart.getOwner().equals(targetPart.getOwner());
			}
			return false;
		}
		
		public boolean checkOwnerType(Object part,Class c)
		{
			if(part instanceof IPart)
			{
				IPart ipart;
				ipart = (IPart) part;
				return c.isInstance(ipart.getOwner()); 
			}
			return false;
		}
		
		/**
		 * Check if obj's owner is equal to the instance in the 'OwnerConstant'
		 * location. Also if obj is not an instanceof IPart false will be returned.
		 */
		public boolean ownerInstanceEqual(Object obj,int OwnerConstant)
		{
			if(obj instanceof IPart)
			{
				IPart part = (IPart) obj;
				return instancesEquals(OwnerConstant, part.getOwner());
			}
			return false;
		}

		public boolean isCurrentCutHot()
		{
			return isHotCut(linesLocations);
		}
		
		public boolean isCurrentCutLast()
		{
			return isLastCut(linesLocations);
		}
		
		public boolean countLoop(int loopNumber)
		{
			if(loopNumber >= constantLoopsLimits.size())
				return false;
			int max = constantLoopsLimits.get(loopNumber);
			int cur = loopsCounter.get(loopNumber);
			if(cur == max)
			{
				loopsCounter.set(loopNumber,0);
				return false;
			}
			loopsCounter.set(loopNumber,++cur);
			return true;
		}
		
		/**
		 * @return true is there is the current state is not Hot.
		 */
		public boolean checkViolation()
		{
			Iterator<ArrayList<Integer>> it = hotCuts.iterator();
			ArrayList<Integer> hotCut;
			
			while(it.hasNext())
			{
				hotCut = it.next();
				if(currentCutEquals(hotCut))
					handleHotViolation();
			}
			return true;
		}
				
		public void setLineInstance(int index,Object obj)
		{
			linesInstances.set(index, obj);
		}
		
		public Object getLineInstance(int index)
		{
			return linesInstances.get(index);
		}
		
		public void setPrivateVariable(int index,Object obj)
		{
			privateVariables.set(index,obj);
		}
		
		public Object getPrivateVariable(int index)
		{
			return privateVariables.get(index);
		}
		
		public boolean instancesEquals(int instanceConstant,Object obj)
		{
			if(obj==null && getLineInstance(instanceConstant)==null)
				return true;//If both are null its ok
			if(obj==null || getLineInstance(instanceConstant)==null)
				return false;//If only one is null its not ok
			//Both are not null, check equality:
			return obj.equals(getLineInstance(instanceConstant));
		}
		
		public boolean variableEquals(int varConst,Object obj)
		{
			return obj.equals(privateVariables.get(varConst));
		}
		
		private boolean  currentCutEquals(ArrayList<Integer>cut)
		{
			Iterator<Integer> it = linesLocations.iterator();
			Iterator<Integer> it2 = cut.iterator();
			while(it.hasNext())
			{
				if(it.next().intValue() != it2.next().intValue())
					return false;
			}
			return true;
		}
		
		private ArrayList<Integer> initializeLinesLocations(int num)
		{
			ArrayList<Integer> arr = new ArrayList<Integer>(num);
			for (int i = 0; i < num; i++)
				arr.add(new Integer(0));
			return arr;
		}

		private ArrayList<Object> initializeLinesInstances(int num)
		{
			if (num == 0)
				return null;
			ArrayList<Object> arr = new ArrayList<Object>(num);
			for (int i = 0; i < num; i++)
				arr.add(null);
			return arr;
		}

		private ArrayList<Object> initializePrivateVariables(int num)
		{
			return initializeLinesInstances(num);
		}
		
		private ArrayList<Integer> initializeLoop()
		{ 
			int num = constantLoopsLimits.size();
			ArrayList<Integer> arr= new ArrayList<Integer>(num);
			for (int i = 0; i < num; i++)
				arr.add(0);
			return arr;
		}

		private boolean _isInCut(ArrayList queryLocations)
		{
			Integer loc1, loc2;
			if (queryLocations == null || linesLocations == null
					|| (queryLocations.size() != linesLocations.size()))
			{
				System.out.println("isInCut Failed!");
				return false;
			}
			Iterator it = linesLocations.iterator();
			Iterator it2 = queryLocations.iterator();
			while (it.hasNext())
			{
				loc1 = ((Integer) it.next());
				loc2 = ((Integer) it2.next());
				if (loc1.intValue() != loc2.intValue())
					return false;
			}
			return true;
		}

		private void _setCut(ArrayList<Integer> setLocations)
		{
			if (setLocations == null || linesLocations == null
					|| (setLocations.size() != linesLocations.size()))
			{
				System.out.println("setCut Failed!");
				return;
			}
			for (int i = 0; i < linesLocations.size(); i++)
				linesLocations.set(i, setLocations.get(i));
		}

		/**
		 * Clears all lists of the current active aspect
		 * And adds it to the completed list
		 */
		public void completion()
		{
			completedActiveMSDs.add(this);
		}

		/**
		 * @return true if this ActiveMSD is in the given cut
		 * Utility functions for up to 10 tuple cut exist
		 */
		public boolean isInCut(int loc)
		{
			ArrayList<Integer> arr = new ArrayList<Integer>(1);
			arr.add(new Integer(loc));
			return _isInCut(arr);
		}

		public boolean isInCut(int loc, int loc2)
		{
			ArrayList<Integer> arr = new ArrayList<Integer>(2);
			arr.add(new Integer(loc));
			arr.add(new Integer(loc2));
			return _isInCut(arr);
		}

		public boolean isInCut(int loc, int loc2, int loc3)
		{
			ArrayList<Integer> arr = new ArrayList<Integer>(3);
			arr.add(new Integer(loc));
			arr.add(new Integer(loc2));
			arr.add(new Integer(loc3));
			return _isInCut(arr);
		}

		public boolean isInCut(int loc, int loc2, int loc3, int loc4)
		{
			ArrayList<Integer> arr = new ArrayList<Integer>(4);
			arr.add(new Integer(loc));
			arr.add(new Integer(loc2));
			arr.add(new Integer(loc3));
			arr.add(new Integer(loc4));
			return _isInCut(arr);
		}

		public boolean isInCut(int loc, int loc2, int loc3, int loc4, int loc5)
		{
			ArrayList<Integer> arr = new ArrayList<Integer>(5);
			arr.add(new Integer(loc));
			arr.add(new Integer(loc2));
			arr.add(new Integer(loc3));
			arr.add(new Integer(loc4));
			arr.add(new Integer(loc5));
			return _isInCut(arr);
		}

		public boolean isInCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6)
		{
			ArrayList<Integer> arr = new ArrayList<Integer>(6);
			arr.add(new Integer(loc));
			arr.add(new Integer(loc2));
			arr.add(new Integer(loc3));
			arr.add(new Integer(loc4));
			arr.add(new Integer(loc5));
			arr.add(new Integer(loc6));
			return _isInCut(arr);
		}

		public boolean isInCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7)
		{
			ArrayList<Integer> arr = new ArrayList<Integer>(7);
			arr.add(new Integer(loc));
			arr.add(new Integer(loc2));
			arr.add(new Integer(loc3));
			arr.add(new Integer(loc4));
			arr.add(new Integer(loc5));
			arr.add(new Integer(loc6));
			arr.add(new Integer(loc7));
			return _isInCut(arr);
		}		
		
		public boolean isInCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7,int loc8)
		{
			ArrayList<Integer> arr = new ArrayList<Integer>(7);
			arr.add(new Integer(loc));
			arr.add(new Integer(loc2));
			arr.add(new Integer(loc3));
			arr.add(new Integer(loc4));
			arr.add(new Integer(loc5));
			arr.add(new Integer(loc6));
			arr.add(new Integer(loc7));
			arr.add(new Integer(loc8));
			return _isInCut(arr);
		}		
		
		public boolean isInCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7,int loc8,
				int loc9)
		{
			ArrayList<Integer> arr = new ArrayList<Integer>(7);
			arr.add(new Integer(loc));
			arr.add(new Integer(loc2));
			arr.add(new Integer(loc3));
			arr.add(new Integer(loc4));
			arr.add(new Integer(loc5));
			arr.add(new Integer(loc6));
			arr.add(new Integer(loc7));
			arr.add(new Integer(loc8));
			arr.add(new Integer(loc9));
			return _isInCut(arr);
		}		
		
		public boolean isInCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7,int loc8,
				int loc9,int loc10)
		{
			ArrayList<Integer> arr = new ArrayList<Integer>(7);
			arr.add(new Integer(loc));
			arr.add(new Integer(loc2));
			arr.add(new Integer(loc3));
			arr.add(new Integer(loc4));
			arr.add(new Integer(loc5));
			arr.add(new Integer(loc6));
			arr.add(new Integer(loc7));
			arr.add(new Integer(loc8));
			arr.add(new Integer(loc9));
			arr.add(new Integer(loc10));
			return _isInCut(arr);
		}		
		
		
		
		public void setCut(int loc)
		{
			_setCut(getCut(loc));
		}

		public void setCut(int loc, int loc2)
		{
			_setCut(getCut(loc,loc2));
		}

		public void setCut(int loc, int loc2, int loc3)
		{
			_setCut(getCut(loc,loc2,loc3));
		}

		public void setCut(int loc, int loc2, int loc3, int loc4)
		{
			_setCut(getCut(loc,loc2,loc3,loc4));
		}

		public void setCut(int loc, int loc2, int loc3, int loc4, int loc5)
		{
			_setCut(getCut(loc,loc2,loc3,loc4,loc5));
		}

		public void setCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6)
		{
			_setCut(getCut(loc,loc2,loc3,loc4,loc5,loc6));
		}

		public void setCut(int loc, int loc2, int loc3, int loc4, int loc5, int loc6, int loc7)
		{
			_setCut(getCut(loc,loc2,loc3,loc4,loc5,loc6,loc7));
		}
		
		public void setCut(int loc, int loc2, int loc3,
				int loc4, int loc5, int loc6, int loc7,int loc8)
		{
			_setCut(getCut(loc,loc2,loc3,loc4,loc5,loc6,loc7,loc8));
		}
		
		public void setCut(int loc, int loc2, int loc3,
				int loc4, int loc5, int loc6, int loc7,int loc8,int loc9)
		{
			_setCut(getCut(loc,loc2,loc3,loc4,loc5,loc6,loc7,loc8,loc9));
		}
		
		public void setCut(int loc, int loc2, int loc3,
				int loc4, int loc5, int loc6, int loc7,int loc8,
				int loc9,int loc10)
		{
			_setCut(getCut(loc,loc2,loc3,loc4,loc5,loc6,loc7,loc8,loc9,loc10));
		}

		public long getId() {
			return id;
		}

		public MSDAspect getOwner() {
			return owner;
		}		
		
		public ArrayList<Integer> getCurrentCut()
		{
			return linesLocations;
		}

	}
}
