package il.ac.wis.cs.s2a.examples.rssnewsticker;
import il.ac.wis.cs.s2a.examples.rssnewsticker.rssutils.RSSList;
import il.ac.wis.cs.s2a.examples.rssnewsticker.rssutils.RSSParser;

import java.io.FileInputStream;
import java.util.Properties;


public class NewsTickerApp 
{	
//	private static final String DEFAULT_RSS_ADDRESS = 
//    		"file:///D:/AsafK/RSA7 Workspaces/ws2/NewsTickerJava/edition_travel.rss.xml";//"http://newsrss.bbc.co.uk/rss/newsonline_world_edition/technology/rss.xml";

	private static final String DEFAULT_RSS_ADDRESS = 
		"file:///E:/workspaces/wisdomAAA/NewsTickerJava/resources/edition_travel.rss.xml";
	
	private static final String PROPERTIES_FILE_NAME = "newsticker.properties";
	private static final String PROXY_HOST = "http.proxyHost";
	private static final String PROXY_PORT = "http.proxyPort";
	private static final String RSS_ADDRESS = "rssAddress";
	private static final String BROWSER_PATH = "browserPath";
	
	private static String initialRSSAddress=null;
	static String browserPath = "C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE";
	
	public static void main(String[] args)
	{
		Properties properties = new Properties();
		FileInputStream in;
		String rssAddress = null;
		try {
			in = new FileInputStream(PROPERTIES_FILE_NAME);
			properties.load(in);
			String proxyHost = properties.getProperty(PROXY_HOST);
			String proxyPort = properties.getProperty(PROXY_PORT);
			String browser = properties.getProperty(BROWSER_PATH);  
			rssAddress = properties.getProperty(RSS_ADDRESS);
			Properties systemProperties = System.getProperties();
			if(proxyHost!=null && proxyHost!="")
				systemProperties.put(PROXY_HOST, proxyHost);
			if(proxyPort!=null && proxyPort!="")
				systemProperties.put(PROXY_PORT, proxyPort);
			if(browser!=null && browser!="")
				browserPath = browser;
		} catch (Exception e) {}
		if(rssAddress==null || rssAddress=="")
			initialRSSAddress = DEFAULT_RSS_ADDRESS;
		else
			initialRSSAddress = rssAddress;
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});	
	}
	
	private static RSSList readRSS(String rssAddress)
	{
		RSSList itemList = RSSParser.getRSSItemList(rssAddress);
		return itemList; 
	}
	
	private static void createAndShowGUI()
	{
		new NewsTickerApp();
	}
	
	NewsTickerApp()
	{
		RSSList list = readRSS(initialRSSAddress);
		MSDEnv.setDisplayFrame(new RSSDisplayFrame(list,initialRSSAddress));
	//	frame.start();//Executes by the coordinator
	}
}


